
CREATE TABLE `tipo_tarea` (
  `id` int(3) NOT NULL COMMENT 'Id',
  `tipo` varchar(255) NOT NULL COMMENT 'Tipo',
  `color` varchar(10) NOT NULL COMMENT 'Color',
  `descripcion` longtext COMMENT 'Descripción',
  `creado_el` datetime DEFAULT NULL COMMENT 'Creado El',
  `creado_por` int(5) DEFAULT NULL COMMENT 'Creado Por',
  `actualizado_el` datetime DEFAULT NULL COMMENT 'Actualizado El',
  `actualizado_por` int(5) DEFAULT NULL COMMENT 'Actualizado Por',
  `estado` int(1) NOT NULL DEFAULT '1' COMMENT 'Estado'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO `tipo_tarea` (`id`, `tipo`, `color`, `descripcion`, `creado_el`, `creado_por`, `actualizado_el`, `actualizado_por`, `estado`) VALUES
(1, 'Tareas de Práctica', '#E80E16', 'Son aquellas que refuerzan aquello que ya se ha trabajado en clase, sean procedimientos o conceptos. Estas son las que se utilizan en las metodologías más tradicionales, como la resolución de ejercicios, elaboración de resúmenes, creación de esquemas, siempre repitiendo el que se ha hecho de forma presencial.','2016-04-30 12:11:02', 1, '2016-04-30 12:11:02', 1, 1),
(2, 'Tareas de Preparación', '#f8ac59', 'Son aquellas que se piden para construir esquemas mentales previos de aquello que se trabajará de manera presencial en la próxima clase. Aquí se incluyen tareas utilizadas en diferentes metodologías como podrían ser la tradicional lectura previa o la más novedosa aula invertida.', '2016-04-30 12:11:25', 1, '2016-04-30 12:11:25', 1, 1),
(3, 'Tareas de Extensión', '#1385D1', 'son aquellas que consisten en aplicar los conocimientos que ya posee el alumnado en situaciones distintas. Aquí se incluyen los proyectos de investigación o los trabajos o créditos de síntesis.', '2016-04-30 12:11:44', 1, '2016-04-30 12:11:44', 1, 1);

ALTER TABLE `tipo_tarea`
  ADD PRIMARY KEY (`id`);

ALTER TABLE `tipo_tarea`
  MODIFY `id` int(3) NOT NULL AUTO_INCREMENT COMMENT 'Id', AUTO_INCREMENT=4;




CREATE TABLE `tarea` (
  `id` int(5) NOT NULL COMMENT 'Id',
  `aid` varchar(20) DEFAULT NULL,
  `docente` int(5) DEFAULT NULL COMMENT 'Docente',
  `estudiante` int(5) NOT NULL COMMENT 'Estudiante',
  `asignatura` int(3) NOT NULL COMMENT 'Asignatura',
  `grupo` int(3) NOT NULL COMMENT 'Grupo',
  `periodo` int(1) NOT NULL COMMENT 'Periodo',
  `tarea` varchar(255) DEFAULT NULL COMMENT 'Tarea',
  `tipo` int(3) DEFAULT NULL COMMENT 'Tipo',
  `descripcion` longtext COMMENT 'Descripción',
  `adjunto` longtext COMMENT 'Adjunto',
  `disponible_desde` datetime DEFAULT NULL COMMENT 'Disponible Desde',
  `disponible_hasta` datetime DEFAULT NULL COMMENT 'Disponible Hasta',
  `disponible_desde_2` datetime DEFAULT NULL COMMENT 'Disponible Desde',
  `disponible_hasta_2` datetime DEFAULT NULL COMMENT 'Disponible Hasta',
  `creado_el` datetime DEFAULT NULL COMMENT 'Creado El',
  `creado_por` int(5) DEFAULT NULL COMMENT 'Creado Por',
  `actualizado_el` datetime DEFAULT NULL COMMENT 'Actualizado El',
  `actualizado_por` int(5) DEFAULT NULL COMMENT 'Actualizado Por',
  `eliminado_el` datetime DEFAULT NULL COMMENT 'Eliminado El',
  `eliminado_por` int(3) DEFAULT '0' COMMENT 'Eliminado Por',
  `estado` int(1) DEFAULT '0' COMMENT 'Estado'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;


ALTER TABLE `tarea`
  ADD PRIMARY KEY (`id`),
  ADD KEY `docente` (`docente`),
  ADD KEY `estudiante` (`estudiante`),
  ADD KEY `asignatura` (`asignatura`),
  ADD KEY `grupo` (`grupo`),
  ADD KEY `periodo` (`periodo`),
  ADD KEY `tipo` (`tipo`);


ALTER TABLE `tarea`
  MODIFY `id` int(5) NOT NULL AUTO_INCREMENT COMMENT 'Id';


ALTER TABLE `tarea`
  ADD CONSTRAINT `tarea_ibfk_1` FOREIGN KEY (`docente`) REFERENCES `tercero` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `tarea_ibfk_2` FOREIGN KEY (`asignatura`) REFERENCES `asignatura` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `tarea_ibfk_3` FOREIGN KEY (`grupo`) REFERENCES `grupo` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `tarea_ibfk_4` FOREIGN KEY (`periodo`) REFERENCES `periodo` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `tarea_ibfk_5` FOREIGN KEY (`tipo`) REFERENCES `tipo_tarea` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;




CREATE TABLE `tarea_desarrollo` (
  `id` int(5) NOT NULL COMMENT 'Id',
  `tarea` int(5) NOT NULL COMMENT 'Tarea',
  `estudiante` int(5) NOT NULL COMMENT 'Estudiante',
  `desarrollo_1` longtext COMMENT 'Desarrollo',
  `adjunto_1` longtext COMMENT 'Adjunto',
  `desarrollo_2` longtext COMMENT 'Desarrollo',
  `adjunto_2` longtext COMMENT 'Adjunto',
  `visto` int(3) DEFAULT '0' COMMENT 'Visto',
  `visto_el` datetime DEFAULT NULL COMMENT 'Visto El',
  `creado_el` datetime DEFAULT NULL COMMENT 'Creado El',
  `creado_por` int(5) DEFAULT NULL COMMENT 'Creado Por',
  `actualizado_el` datetime DEFAULT NULL COMMENT 'Actualizado El',
  `actualizado_por` int(5) DEFAULT NULL COMMENT 'Actualizado Por',
  `eliminado_el` datetime DEFAULT NULL COMMENT 'Eliminado El',
  `eliminado_por` int(3) DEFAULT '0' COMMENT 'Eliminado Por',
  `estado` int(1) DEFAULT '0' COMMENT 'Estado'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;


ALTER TABLE `tarea_desarrollo`
  ADD PRIMARY KEY (`id`),
  ADD KEY `tarea` (`tarea`);


ALTER TABLE `tarea_desarrollo`
  MODIFY `id` int(5) NOT NULL AUTO_INCREMENT COMMENT 'Id';


ALTER TABLE `tarea_desarrollo`
  ADD CONSTRAINT `tarea_desarrollo_ibfk_1` FOREIGN KEY (`tarea`) REFERENCES `tarea` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;