<?php

namespace backend\controllers;

use Yii;
use backend\models\Tercero;
use backend\models\Sede;
use backend\models\Grupo;
use backend\models\Periodo;
use backend\models\Academico;
use backend\models\Asistencia;
use backend\models\Matricula;
use backend\models\Calificacion;
use backend\models\Calificacioncalificaciones;
use backend\models\Calificacionfrd;
use backend\models\Calificacionobservacionesgenerales;
use backend\models\Calificacioncompromisos;
use backend\models\AcademicoSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;

/**
 * AcademicoController implements the CRUD actions for academico model.
 */
class AcademicoController extends Controller
{
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['post'],
                ],
            ],
        ];
    }

    /**
     * Lists all academico models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new AcademicoSearch();

        //$searchModel = $searchModel->search(['eliminado_por' => '0']); 
        
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single academico model.
     * @param integer $id
     * @return mixed
     */
    public function actionView($id)
    {
        $model = $this->findModel($id);
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    
    public function actionCreate($tercero = NULL)
    {
        //$sede = Sede::find()->where(['principal' => '1'])->one();
        $periodo = new Periodo();
        
        $model = new Academico();
        $model->scenario = 'academico';
        
        if(isset($tercero))
        {
            $tercero = Tercero::findOne(Yii::$app->request->get('tercero'));
        }
        else 
        {
            $tercero = new Tercero();
        }    

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            
            $matricula = new Matricula();
            $matricula->estudiante = $model->estudiante;
            $matricula->grupo = $model->grupo;
            $matricula->especialidad = $model->especialidad;
            $matricula->fecha_matricula = $model->fecha_matricula;
            $matricula->estado = '1';
            $matricula->save(false);
            
            
            if($model->fecha_retiro !='')
            {
                $tercero = Tercero::findOne($model->estudiante);
                $tercero->estado = $model->motivo;    
                $tercero->update();
            }
            else
            {
                $tercero = Tercero::findOne($model->estudiante);
                $tercero->estado = '1';
                $tercero->update();
            } 


            /*if($periodo->actual->id > 1)
            {
                return $this->redirect(['calificacion/traslado', 'tercero' => $model->estudiante]);  
            }
            else
            {
                //return $this->redirect(['view', 'id' => $model->id]);      
            }*/
            return $this->redirect(['view', 'id' => $model->id]);      
            
            
        } else {
            return $this->render('create', [
                'model' => $model,
                'tercero' => $tercero,
            ]);
        }
    

    }

    public function actionGrupoxestudiante($id = NULL)
    {
        $academico = Academico::find()->where(['estudiante' => Yii::$app->request->get('tercero')])->one();
        return $academico->grupos->grupo;
    }

    public function actionGrupo($id = NULL)
    {
        $grupo = Grupo::findOne(Yii::$app->request->get('id'));
        return $grupo->grupo;
    }
    
    public function actionUpdate($id = NULL, $tercero = NULL)
    {
        if(!isset($id))
        {
            $sede = Sede::find()->where(['principal' => '1'])->one();

            if($sede->activar_matriculas  == 1)
            {
                return $this->redirect(['matricula/update', 'tercero' => Yii::$app->request->get('tercero')]);
            }
            else
            {
                if (($academico = Academico::find()->where(['estudiante' => Yii::$app->request->get('tercero')])->one()) !== null) {
                    $id = $academico->id;
                } else {
                    return $this->redirect(['create', 'tercero' => $tercero]);
                }
            }
            
        }

        $model = $this->findModel($id);
        $model->grupo_old = $model->grupo;
        $model->scenario = 'academico';
        $periodo = new Periodo();

        if ($model->load(Yii::$app->request->post())) {

            try {

                
                $model->save();

                if((!$model->isNewRecord) && ($model->grupo != $model->grupo_old))
                {
                    Asistencia::updateAll(['grupo' => $model->grupo],['estudiante' => $model->estudiante]);
                    Calificacion::updateAll(['grupo' => $model->grupo],['estudiante' => $model->estudiante]);
                    Calificacioncalificaciones::updateAll(['grupo' => $model->grupo],['estudiante' => $model->estudiante]);
                    Calificacionfrd::updateAll(['grupo' => $model->grupo],['estudiante' => $model->estudiante]);
                    Calificacionobservacionesgenerales::updateAll(['grupo' => $model->grupo],['estudiante' => $model->estudiante]);
                    Calificacioncompromisos::updateAll(['grupo' => $model->grupo],['estudiante' => $model->estudiante]);
                    
                    //promedio
                    //promedio_area

                    Yii::$app->session->addFlash('mensaje', [
                        'tipo' => 'success',
                        'titulo' => 'Traslado de Grupo',
                        'icono' => 'fa fa-check-square-o',
                        'mensaje' => 'El estudiante <b>'.$model->estudiantes->nombre.'</b> se cambio del grupo <b>'.$model->grupoold->grupo.'</b> al  <b>'.$model->grupos->grupo.'</b> con éxito.',
                    ]);
                }
                
                if($model->fecha_retiro !='')
                {
                    $tercero = Tercero::findOne($model->estudiante);
                    $tercero->estado = $model->motivo;    
                    $tercero->update();
                }
                else
                {
                    $tercero = Tercero::findOne($model->estudiante);
                    $tercero->estado = '1';
                    $tercero->update();
                }


            } catch (\yii\db\IntegrityException $e) {
                    return $model->error_reporting();
            } 

            return $this->redirect(['view', 'id' => $model->id]);      
            

        } else {
            return $this->render('update', [
                'model' => $model,
            ]);
        }
    }

    public function actionCambiar()
    {
        if (Yii::$app->request->isAjax) 
        {
            $id = Yii::$app->request->get('periodo');
            Periodo::updateAll(['habilitado' => 0], ['<', 'id', '6']);
        
            if($id <= 4)
            {   
                $model = $this->findModel($id);
                $model->habilitado = 1;
                $model->update(false);    
            }
            return $model->periodo;
        }
        else
        {
            $model = new Academico(['scenario'=>'cambiar']);

            //$model = Academico::find()->where(['eliminado_por' => 0])->andWhere(['is', 'fecha_retiro', new \yii\db\Expression('null')])->all();
                
            return $this->render('cambiar', [
                'model' => $model,
            ]);    
        }
    }


    public function actionDelete($id)
    {
        //$this->findModel($id)->deleteWithRelated();

        $model = $this->findModel($id);
        $model->eliminado_por = \Yii::$app->user->id;
        $model->eliminado_el = new \yii\db\Expression('NOW()');
        $model->update();

        return $this->redirect(['index']);
    }

    public function actionRestore($id)
    {
        $this->findModel($id)->restoreWithRelated();

        return $this->redirect(['index']);
    }

    
    /**
     * Finds the academico model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return academico the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = academico::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }
}
