<?php

namespace backend\controllers;

use Yii;
use backend\models\Acudiente;
use backend\models\AcudienteSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\web\Response;
use yii\helpers\Json;
use yii\widgets\ActiveForm;

/**
 * AcudienteController implements the CRUD actions for Acudiente model.
 */
class AcudienteController extends Controller
{
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['post'],
                ],
            ],
        ];
    }

    /**
     * Lists all Acudiente models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new AcudienteSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single Acudiente model.
     * @param integer $id
     * @return mixed
     */
    public function actionView($id)
    {
        $model = $this->findModel($id);
        return $this->renderAjax('view', [
            'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new Acudiente model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new Acudiente();

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->id]);
        } else {
            return $this->render('create', [
                'model' => $model,
            ]);
        }
    }


    public function actionAdd($tercero = NULL)
    {
        $model = new Acudiente();
        $model->estudiante = Yii::$app->request->get('tercero');

        return $this->renderAjax('_formAjax', [
                    'model' => $model,
        ]);
    }


    public function actionUpdate($id)
    {
        $model = $this->findModel($id);
/*
        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->id]);
        } else {
            return $this->render('update', [
                'model' => $model,
            ]);
        }
*/
        return $this->renderAjax('_formAjax', [
                    'model' => $model,
        ]);

    }


    public function actionSave($id = NULL)
    {
        
        if(Yii::$app->request->post('id'))
        {
            $model = $this->findModel(Yii::$app->request->post('id'));
        }
        else
        {
            $model = new Acudiente();    
        }

        if (Yii::$app->request->isAjax && $model->load(Yii::$app->request->post())) {
            Yii::$app->response->format = Response::FORMAT_JSON;
            return ActiveForm::validate($model);
        }

        if (Yii::$app->request->isAjax) 
        {
            $model->estudiante = Yii::$app->request->post('estudiante');
            $model->identificacion = Yii::$app->request->post('identificacion');
            $model->tipo = Yii::$app->request->post('tipo');
            $model->primer_nombre = Yii::$app->request->post('primer_nombre');
            $model->segundo_nombre = Yii::$app->request->post('segundo_nombre');
            $model->primer_apellido = Yii::$app->request->post('primer_apellido');
            $model->segundo_apellido = Yii::$app->request->post('segundo_apellido');
            $model->genero = Yii::$app->request->post('genero');
            $model->parentesco = Yii::$app->request->post('parentesco');
            $model->principal = Yii::$app->request->post('principal');
            $model->rh = Yii::$app->request->post('rh');
            $model->direccion = Yii::$app->request->post('direccion');
            $model->fijo = Yii::$app->request->post('fijo');
            $model->movil = Yii::$app->request->post('movil');
            $model->email = Yii::$app->request->post('email');
            $model->save();
            
            return $model->id;
        }


    }


    public function actionDelete($id = NULL)
    {
        if (Yii::$app->request->isAjax){
            //$this->findModel(Yii::$app->request->post('id'))->deleteWithRelated();
            $model = $this->findModel(Yii::$app->request->post('id'));
            $model->eliminado_por = \Yii::$app->user->id;
            $model->eliminado_el = new \yii\db\Expression('NOW()');
            $model->update();
            return Yii::$app->request->post('id');
        }
        else
        {
            //$this->findModel($id)->deleteWithRelated();

        $model = $this->findModel($id);
        $model->eliminado_por = \Yii::$app->user->id;
        $model->eliminado_el = new \yii\db\Expression('NOW()');
        $model->update();
            return $this->redirect(['index']);    
        }
    }



    public function actionRestore($id)
    {
        $this->findModel($id)->restoreWithRelated();

        return $this->redirect(['index']);
    }
    
    /**
     * 
     * for export pdf at actionView
     *  
     * @param type $id
     * @return type
     */
    public function actionPdf($id) {
        $model = $this->findModel($id);

        $content = $this->renderAjax('_pdf', [
            'model' => $model,
        ]);

        $pdf = new \kartik\mpdf\Pdf([
            'mode' => \kartik\mpdf\Pdf::MODE_CORE,
            'format' => \kartik\mpdf\Pdf::FORMAT_A4,
            'orientation' => \kartik\mpdf\Pdf::ORIENT_PORTRAIT,
            'destination' => \kartik\mpdf\Pdf::DEST_BROWSER,
            'content' => $content,
            'cssFile' => '@vendor/kartik-v/yii2-mpdf/assets/kv-mpdf-bootstrap.min.css',
            'cssInline' => '.kv-heading-1{font-size:18px}',
            'options' => ['title' => \Yii::$app->name],
            'methods' => [
                'SetHeader' => [\Yii::$app->name],
                'SetFooter' => ['{PAGENO}'],
            ]
        ]);

        return $pdf->render();
    }
    
    /**
     * Finds the Acudiente model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Acudiente the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Acudiente::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }
}
