<?php

namespace backend\controllers;

use Yii;
use backend\models\Agenda;
use backend\models\Grupo;
use backend\models\Grado;

use backend\models\AgendaSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;

use edofre\fullcalendarscheduler\models\Event;
use edofre\fullcalendarscheduler\models\Resource;

/**
 * AgendaController implements the CRUD actions for Agenda model.
 */
class AgendaController extends Controller
{


    /**
     * Lists all Agenda models.
     * @return mixed
     */
    public function actionIndex()
    {

        return $this->render('index');
    }

    public function actionResources()
    {
        \Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;

            $datos = [];
            $childs = [];

            $dato = new Resource();
            $dato->id = 0;
            $dato->title = 'TODOS';
            $datos[] = $dato;

            $grados = Grado::find()->orderBy(['id' => SORT_ASC])->all();

            foreach ($grados as $grado) 
            {
                
                $dato = new Resource();

                $dato->id = $grado->id;
                $dato->title = $grado->grado;
                
                $grupos = Grupo::find()->where(['grado' => $grado->id])->orderBy(['id' => SORT_ASC])->all();

                    foreach($grupos as $grupo)
                    {
                        $child = new Resource();
                        $child->id = "G".$grupo->id;
                        $child->title = $grupo->grupo;
                        $childs[] = $child;
                        $child = [];
                    } 

                $dato->children = $childs;
                $childs = []; 

                $datos[] = $dato;
            }

         return $datos;      
    }

    public function actionEvents()
    {
        \Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;

            $eventos = [];

            $agendas = Agenda::find()->all();

            if(!empty($agendas))
            {
                foreach ($agendas as $agenda) 
                {                    
                           
                    $grupos = ($agenda->grupo == NULL) ? [0] : explode(',', $agenda->grupo);
                    
                    foreach ($grupos as $grupo) 
                    {
                    
                        
                        $evento = new Event();
                        $evento->id = $agenda->id;
                        $evento->resourceId = $grupo == 0 ? 0 : "G".$grupo;
                        $evento->title = $agenda->evento;
                        $evento->color = $agenda->color;
                        //$evento->start = date('Y-m-d\TH:i:s',strtotime($agenda->fecha_inicio));

                        if(substr($agenda->fecha_inicio, 11, 8) == '00:00:00')
                        {
                            $evento->start = date('Y-m-d',strtotime($agenda->fecha_inicio)); 
                        }
                        else
                        {
                            $evento->start = date('Y-m-d\TH:i:s',strtotime($agenda->fecha_inicio)); 
                        }

                        if(substr($agenda->fecha_fin, 11, 8) == '00:00:00')
                        {
                            $evento->end = date('Y-m-d',strtotime($agenda->fecha_fin)); 
                        }
                        else
                        {
                            $evento->end = date('Y-m-d\TH:i:s',strtotime($agenda->fecha_fin)); 
                        }
                        
                        $eventos[] = $evento;
                    }
                }
            }

        return $eventos;            
    }

    public function actionEventos()
    {
        $searchModel = new AgendaSearch();

        if(Yii::$app->session->get('__tipo') == 2)
        {
            $searchModel->creado_por = Yii::$app->session->get('__id');
        }


        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('eventos', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single Agenda model.
     * @param integer $id
     * @return mixed
     */
    public function actionView($id)
    {
        $model = $this->findModel($id);
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new Agenda model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new Agenda();

        if ($model->load(Yii::$app->request->post())) {
            
            $model->grupo = ($model->grupo == '') ? NULL : implode(",", $model->grupo);
            $model->tipo_tercero = ($model->tipo_tercero == '') ? NULL : implode(",", $model->tipo_tercero);
            $model->save();

            return $this->redirect('index');
            //return $this->redirect(['view', 'id' => $model->id]);
        } else {
            return $this->render('create', [
                'model' => $model,
            ]);
        }


    }

    /**
     * Updates an existing Agenda model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->id]);
        } else {
            return $this->render('update', [
                'model' => $model,
            ]);
        }
    }

    /**
     * Deletes an existing Agenda model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     */
    public function actionDelete($id)
    {
        //$this->findModel($id)->deleteWithRelated();

        $model = $this->findModel($id);
        $model->eliminado_por = \Yii::$app->user->id;
        $model->eliminado_el = new \yii\db\Expression('NOW()');
        $model->update();

        return $this->redirect(['index']);
    }

    public function actionRestore($id)
    {
        $this->findModel($id)->restoreWithRelated();

        return $this->redirect(['index']);
    }
    
    public function actionPdf() {

        $content = $this->renderPartial('index');

        $pdf = new \kartik\mpdf\Pdf([
            'mode' => \kartik\mpdf\Pdf::MODE_CORE,
            'format' => \kartik\mpdf\Pdf::FORMAT_A4,
            'orientation' => \kartik\mpdf\Pdf::ORIENT_PORTRAIT,
            'destination' => \kartik\mpdf\Pdf::DEST_BROWSER,
            'content' => $content,
            'cssFile' => '@vendor/kartik-v/yii2-mpdf/assets/kv-mpdf-bootstrap.min.css',
            'cssInline' => '.kv-heading-1{font-size:18px}',
            'options' => ['title' => \Yii::$app->name],
            'methods' => [
                'SetHeader' => [\Yii::$app->name],
                'SetFooter' => ['{PAGENO}'],
            ]
        ]);

        return $pdf->render();
    }    
    /**
     * Finds the Agenda model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Agenda the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Agenda::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }
}
