<?php

namespace backend\controllers;

use Yii;
use backend\models\Asistencia;
use backend\models\Academico;
use backend\models\Periodo;
use backend\models\Grupo;
use backend\models\Asignatura;
use backend\models\Tipoinasistencia;
use backend\models\AsistenciaSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\data\ActiveDataProvider;
use yii\base\Model;

/**
 * AsistenciaController implements the CRUD actions for Asistencia model.
 */
class AsistenciaController extends Controller
{
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['post'],
                ],
            ],
        ];
    }

    /**
     * Lists all Asistencia models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new AsistenciaSearch();

        if(Yii::$app->session->get('__tipo') == 2)
        {
            $searchModel->creado_por = Yii::$app->session->get('__id');
        }


        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }


    public function actionAsistencia()
    {

        //return "<br>Session 1 :".Yii::$app->session->getId(); 

        $dataProvider = new ActiveDataProvider([
            'query' => Academico::find()->select(['tercero.id', 'academico.estudiante', 'academico.grupo'])->joinWith(['estudiantes'])->where(['<', 'tercero.estado', 3])->andWhere(['academico.grupo' => Yii::$app->request->get('grupo')])->orderBy(['primer_apellido' => SORT_ASC, 'segundo_apellido' => SORT_ASC]),
            'pagination' => [
                'pageSize' => 50,
            ],
        ]);

        $periodo = new Periodo();
        $grupo = Grupo::find()->where(['id' => Yii::$app->request->get('grupo')])->one();
        $asignatura = Asignatura::find()->where(['id' => Yii::$app->request->get('asignatura')])->one(); 

       // $registros = Asistencia::find()->where(['grupo' => Yii::$app->request->get('grupo')])->andWhere(['asignatura' => Yii::$app->request->get('asignatura'), 'periodo' => $periodo->actual->id])->count();

        $count = count(Yii::$app->request->post('Asistencia', []));
        

        $asistencias = [new Asistencia()];

        for($i = 1; $i < $count; $i++) {
            $asistencias[] = new Asistencia();
        }

        if (Model::loadMultiple($asistencias, Yii::$app->request->post()) 
            && Model::validateMultiple($asistencias)) 
        {

            $contar = 0;

            foreach ($asistencias as $model) {
                
                if ($model->asistio==1) {
                    $model->docente = Yii::$app->session->get('__tercero');
                    $model->fecha = new \yii\db\Expression('NOW()');
                    $model->save();

                    $contar++;
                }

            }

            Yii::$app->session->addFlash('db', [
                            'tipo' => 'info',
                            'titulo' => 'Asistencias',
                            'icono' => 'fa fa-user',
                            'mensaje' => 'Se almacenaron '.$contar.' inasistencias al sistema.']); 

            return $this->redirect(['docente/index']); // redirect to your next desired page
        } else {
            return $this->render('asistencia', [
                'dataProvider'=>$dataProvider,
                'asistencias' => $asistencias,
                'periodo' => $periodo,
                'grupo' => $grupo,
            ]);
        }

        //echo "<br>Session 2 :".Yii::$app->session->getId(); 
    }    


     public function actionFindfallas() 
     {    

        if (Yii::$app->request->isAjax) 
        {
            //return "<br>Session 1 :".Yii::$app->session->getId(); 
            
            $out = [];
            if (isset($_POST['depdrop_parents'])) {
                $parents = $_POST['depdrop_parents'];
                if ($parents != null) {
                    $fallas_id = $parents[0];
                    $out= ($fallas_id ==0) ? NULL : [['id' => 1, 'name' => '1 Hora'], ['id' => 2, 'name' => '2 Horas'], ['id' => 3, 'name' => '3 Horas'], ['id' => 4, 'name' => '4 Horas'], ['id' => 5, 'name' => '5 Horas']];
                    
                    return json_encode(['output'=>$out, 'selected'=>'']);
                }
            }
            return json_encode(['output'=>'', 'selected'=>'']);
            
        }
        else
        {
            throw new NotFoundHttpException('Solicitud no valida');
        }
    }


     public function actionFindtiposfallas() {
    
        
        if (Yii::$app->request->isAjax) 
        {
            //return "<br>Session 2 :".Yii::$app->session->getId(); 
            
            $out = [];
            if (isset($_POST['depdrop_parents'])) {
                $parents = $_POST['depdrop_parents'];
                if ($parents != null) {
                    $asistio_id = $parents[0];
                    $out=Tipoinasistencia::getTipoinasistencia($asistio_id);
                    
                    return json_encode(['output'=>$out, 'selected'=>'']);
                }
            }
            return json_encode(['output'=>'', 'selected'=>'']);

            //return json_encode("<br>Session 2 :".Yii::$app->session->getId()); 
        }
        else
        {
            throw new NotFoundHttpException('Solicitud no valida');
        }
    }

    public function actionView($id)
    {
        $model = $this->findModel($id);
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new Asistencia model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new Asistencia();

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->id]);
        } else {
            return $this->render('create', [
                'model' => $model,
            ]);
        }
    }

    /**
     * Updates an existing Asistencia model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->id]);
        } else {
            return $this->render('update', [
                'model' => $model,
            ]);
        }
    }

    
    public function actionAusentismohoy() {
    
        $out = [];
        $out= Asistencia::getAusentismoHoy();
        return json_encode($out);
        
    }

    public function actionPdf($id) {
        $model = $this->findModel($id);

        $content = $this->renderAjax('_pdf', [
            'model' => $model,
        ]);

        $pdf = new \kartik\mpdf\Pdf([
            'mode' => \kartik\mpdf\Pdf::MODE_CORE,
            'format' => \kartik\mpdf\Pdf::FORMAT_A4,
            'orientation' => \kartik\mpdf\Pdf::ORIENT_PORTRAIT,
            'destination' => \kartik\mpdf\Pdf::DEST_BROWSER,
            'content' => $content,
            'cssFile' => '@vendor/kartik-v/yii2-mpdf/assets/kv-mpdf-bootstrap.min.css',
            'cssInline' => '.kv-heading-1{font-size:18px}',
            'options' => ['title' => \Yii::$app->name],
            'methods' => [
                'SetHeader' => [\Yii::$app->name],
                'SetFooter' => ['{PAGENO}'],
            ]
        ]);

        return $pdf->render();
    }
    

    public function actionDelete($id)
    {
        //$this->findModel($id)->deleteWithRelated();

        $model = $this->findModel($id);
        $model->eliminado_por = \Yii::$app->user->id;
        $model->eliminado_el = new \yii\db\Expression('NOW()');
        $model->update();

        return $this->redirect(['index']);
    }

    public function actionRestore($id)
    {
        $this->findModel($id)->restoreWithRelated();

        return $this->redirect(['index']);
    }

    
    protected function findModel($id)
    {
        if (($model = Asistencia::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }
}
