<?php

namespace backend\controllers;

use Yii;
use backend\models\Blog;
use backend\models\BlogSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;

use yii\web\UploadedFile;
use yii\imagine\Image;
use Imagine\Image\Box;  

use yii\web\Response;
use yii\widgets\ActiveForm;

/**
 * BlogController implements the CRUD actions for Blog model.
 */
class BlogController extends Controller
{
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['post'],
                ],
            ],
        ];
    }

    /**
     * Lists all Blog models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new BlogSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single Blog model.
     * @param integer $id
     * @return mixed
     */
    public function actionView($id)
    {
        $model = $this->findModel($id);
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new Blog model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new Blog();

        if (Yii::$app->request->isAjax && $model->load(Yii::$app->request->post())) {
            Yii::$app->response->format = Response::FORMAT_JSON;
            return ActiveForm::validate($model);
        }

        elseif ($model->loadAll(Yii::$app->request->post()))
        {

            if($foto = UploadedFile::getInstance($model,'imagen'))
            {
                $file = rand(10,100).'-'.str_replace(' ','-',$foto);
                $foto->saveAs( 'uploads/'.$file);
                //Image::thumbnail('uploads/'.$foto->name, 120, 120)->save('uploads/'.$foto->name, ['quality' => 80]);

                Image::getImagine()->open('uploads/'.$file)->thumbnail(new Box(120, 120))->save('uploads/blog/sm-'.$file , ['quality' => 80]);
                Image::getImagine()->open('uploads/'.$file)->thumbnail(new Box(500, 500))->save('uploads/blog/md-'.$file , ['quality' => 80]);
                Image::getImagine()->open('uploads/'.$file)->thumbnail(new Box(1000, 1000))->save('uploads/blog/lg-'.$file , ['quality' => 80]);

                //save the path in DB..
                $model->imagen = $file;
                unlink('uploads/'.$file);
            }

            $archivos = [];
                
            foreach (UploadedFile::getInstances($model, 'adjuntos') as $adjunto) {
                list($drive) = Yii::$app->createController('drive');
                $archivos[] =  serialize($drive->actionSubir($adjunto));
            }

            $model->adjuntos = implode(',',$archivos);   


            if ($model->saveAll()) 
            {
                \Yii::$app->session->addFlash('mensaje1', [
                                'tipo' => 'success',
                                'titulo' => 'Creación de Artículo',
                                'icono' => 'fa fa-check',
                                'mensaje' => 'Se creo el artículo '.$model->titulo.' éxitosamente.',
                            ]);
                
                return $this->redirect(['index']);
            }
            else
            {
                    throw new HttpException($model->getErrors());
            }  

        } else {
            return $this->render('create', [
                'model' => $model,
            ]);
        }
    }

    /**
     * Updates an existing Blog model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     */
    public function actionUpdate($id)
    {
        if (Yii::$app->request->post('_asnew') == '1') {
            $model = new Blog();
        }else{
            $model = $this->findModel($id);
        }

        if ($model->loadAll(Yii::$app->request->post())) {

            if($foto = UploadedFile::getInstance($model,'imagen'))
            {
                $file = rand(10,100).'-'.str_replace(' ','-',$foto);
                $foto->saveAs( 'uploads/'.$file);
                //Image::thumbnail('uploads/'.$foto->name, 120, 120)->save('uploads/'.$foto->name, ['quality' => 80]);

                Image::getImagine()->open('uploads/'.$file)->thumbnail(new Box(120, 120))->save('uploads/blog/sm-'.$file , ['quality' => 80]);
                Image::getImagine()->open('uploads/'.$file)->thumbnail(new Box(500, 500))->save('uploads/blog/md-'.$file , ['quality' => 80]);
                Image::getImagine()->open('uploads/'.$file)->thumbnail(new Box(1000, 1000))->save('uploads/blog/lg-'.$file , ['quality' => 80]);

                //save the path in DB..
                $model->imagen = $file;
                unlink('uploads/'.$file);
            }

            $archivos = [];
                
            foreach (UploadedFile::getInstances($model, 'adjuntos') as $adjunto) {
                list($drive) = Yii::$app->createController('drive');
                $archivos[] =  serialize($drive->actionSubir($adjunto));
            }

            $model->adjuntos = implode(',',$archivos);   


            if ($model->saveAll()) 
            {
                \Yii::$app->session->addFlash('mensaje1', [
                                'tipo' => 'info',
                                'titulo' => 'Actualización de Artículo',
                                'icono' => 'fa fa-check',
                                'mensaje' => 'Se actualizo el artículo '.$model->titulo.' éxitosamente.',
                            ]);
                
                return $this->redirect(['index']);

                //return $this->redirect(['view', 'id' => $model->id]);
            }
            else
            {
                    throw new HttpException($model->getErrors());
            } 
            
        } else {
            return $this->render('update', [
                'model' => $model,
            ]);
        }
    }

    /**
     * Deletes an existing Blog model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     */
    public function actionDelete($id)
    {
        $this->findModel($id)->deleteWithRelated();

        return $this->redirect(['index']);
    }

    public function actionRestore($id)
    {
        $this->findModel($id)->restoreWithRelated();

        return $this->redirect(['index']);
    }
    
    /**
     * 
     * Export Blog information into PDF format.
     * @param integer $id
     * @return mixed
     */
    public function actionPdf($id) {
        $model = $this->findModel($id);

        $content = $this->renderAjax('_pdf', [
            'model' => $model,
        ]);

        $pdf = new \kartik\mpdf\Pdf([
            'mode' => \kartik\mpdf\Pdf::MODE_CORE,
            'format' => \kartik\mpdf\Pdf::FORMAT_A4,
            'orientation' => \kartik\mpdf\Pdf::ORIENT_PORTRAIT,
            'destination' => \kartik\mpdf\Pdf::DEST_BROWSER,
            'content' => $content,
            'cssFile' => '@vendor/kartik-v/yii2-mpdf/assets/kv-mpdf-bootstrap.min.css',
            'cssInline' => '.kv-heading-1{font-size:18px}',
            'options' => ['title' => \Yii::$app->name],
            'methods' => [
                'SetHeader' => [\Yii::$app->name],
                'SetFooter' => ['{PAGENO}'],
            ]
        ]);

        return $pdf->render();
    }

    /**
    * Creates a new Blog model by another data,
    * so user don't need to input all field from scratch.
    * If creation is successful, the browser will be redirected to the 'view' page.
    *
    * @param mixed $id
    * @return mixed
    */
    public function actionSaveAsNew($id) {
        $model = new Blog();

        if (Yii::$app->request->post('_asnew') != '1') {
            $model = $this->findModel($id);
        }
    
        if ($model->loadAll(Yii::$app->request->post()) && $model->saveAll()) {
            return $this->redirect(['view', 'id' => $model->id]);
        } else {
            return $this->render('saveAsNew', [
                'model' => $model,
            ]);
        }
    }
    
    /**
     * Finds the Blog model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Blog the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Blog::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }
}
