<?php

namespace backend\controllers;

use Yii;
use backend\models\Sede;
use backend\models\Calificacion;
use backend\models\Calificacioncalificaciones;
use backend\models\Calificacionfrd;
use backend\models\Calificacionobservacionesgenerales;
use backend\models\Seleccionmultiple;
use backend\models\Periodo;
use backend\models\Academico;
use backend\models\Grupo;
use backend\models\Asignatura;
use backend\models\Tercero;
use backend\models\Competencia;
use backend\models\CalificacionSearch;
use backend\models\Frd;
use backend\models\Area;
use backend\models\Desempeno;
use backend\models\Promedio;
use backend\models\Promedioarea;
use backend\models\Observaciongeneral;
use backend\models\TerceroForm;

use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\data\ActiveDataProvider;
use yii\base\Model;
use yii\helpers\Html;
use yii\web\Response;
use yii\widgets\ActiveForm;
use yii\helpers\ArrayHelper;




/**
 * CalificacionController implements the CRUD actions for Calificacion model.
 */
class CalificacionController extends Controller
{
    public $actions;

    public function actionIndex()
    {
        return $this->redirect(['docente/index']);
    }

    public function actionCalificaciones()
    {

        if(Yii::$app->request->get('periodo'))
        {
            $periodo = Periodo::find()->where(['id' => Yii::$app->request->get('periodo')])->one();    
        }
        else
        {
            $periodo = new Periodo();  
            $periodo = Periodo::find()->where(['id' => $periodo->actual->id])->one();      
        }
        
        $grupo = Grupo::find()->where(['id' => Yii::$app->request->get('grupo')])->one();
        $asignatura = Asignatura::find()->where(['id' => Yii::$app->request->get('asignatura')])->one(); 
        $psi = $grupo->sedes->psi;
        $entrada = $grupo->sedes->entrada;
        $fallas = $grupo->sedes->fallas;
        $observacion_general = $grupo->sedes->observaciones_generales;
        $observacion_especifica = $grupo->sedes->observaciones_especificas;

        $definitiva_psi = 0;
            

        if(Yii::$app->session->get('__tipo') < 3)
        {
            if($grupo->sedes->autorizar_calificaciones == 0) {
                throw new NotFoundHttpException('Las calificaciones están inactivas por la sede <b>'.$grupo->sedes->sede.'</b> en este momento.');
            }

            if($periodo->autorizar_calificaciones == 0){
                throw new NotFoundHttpException('Las calificaciones están inactivas para el periodo <b>'.$periodo->id.'</b>.');
            }
        }

        if($asignatura->especialidad == 1)
        {
            $query = Academico::find()->select(['tercero.id', 'academico.estudiante', 'academico.grupo'])->joinWith(['estudiantes'])->where(['<', 'tercero.estado', 3])->andWhere(['academico.grupo' => Yii::$app->request->get('grupo')])->andWhere(['academico.eliminado_por' => '0'])->orderBy('primer_apellido');  
        }
        else
        {
            $query = Academico::find()->select(['tercero.id', 'academico.estudiante', 'academico.grupo'])->joinWith(['estudiantes'])->where(['<', 'tercero.estado', 3])->andWhere(['academico.grupo' => Yii::$app->request->get('grupo')])->andWhere(['academico.especialidad' => $asignatura->especialidad])->andWhere(['academico.eliminado_por' => '0'])->orderBy('primer_apellido');     
        }    
        

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
            'pagination' => [
                'pageSize' => 500,
            ],
        ]);
        

        $registros = Calificacion::find()->where(['grupo' => Yii::$app->request->get('grupo')])->andWhere(['asignatura' => Yii::$app->request->get('asignatura'), 'periodo' => $periodo->id])->andWhere(['eliminado_por' => '0'])->count();

        $count = count(Yii::$app->request->post('Calificacion', []));
        
        
        $tipo_calificacion = $grupo->grados->tipo_calificacion;
        $calificacionxcompetencia = $grupo->grados->calificacionxcompetencia;
        
        $frd_sede = $grupo->sedes->frd;

        $num_competencias = Competencia::find()->where(['asignatura' => Yii::$app->request->get('asignatura')])->andWhere(['periodo' => $periodo->id])->andWhere(['eliminado_por' => '0'])->count(); 

        $num_calificaciones_saber = $calificacionxcompetencia == 1 ? $asignatura->num_calificaciones_saber : $num_competencias;
        $num_calificaciones_ser = $asignatura->num_calificaciones_ser;
        $por_calificaciones_saber = $asignatura->por_calificaciones_saber;
        $por_calificaciones_ser = $asignatura->por_calificaciones_ser; 
        $por_calificaciones_psi = $asignatura->por_calificaciones_psi; 
        $num_calificaciones_psi = $grupo->sedes->num_calificaciones_psi;

        $total_calificaciones = $num_calificaciones_saber + $num_calificaciones_ser + $num_calificaciones_psi;

        $competencias = [];

        if($periodo->id != '5')
        {
            if ($num_competencias == 0)
            {
                $error =  '<b>No hay competencias cargadas en la asignatura para el '.$periodo->periodo.'</b>, debes cargar las competencias primero para poder realizar el cargue de las calificaciones. ';
                $error .= Html::a('<i class="far fa-plus" aria-hidden="true"></i> Agregar Competencias', ['competencia/create', 'grado' => $grupo->grados->id, 'asignatura' => Yii::$app->request->get('asignatura')],['class' => 'btn btn-block btn-success', 'style' => 'margin-top: 20px;']);

                throw new NotFoundHttpException($error);
            } 
            else
            {
                $competencias = Competencia::find()->where(['asignatura' => Yii::$app->request->get('asignatura')])->andWhere(['periodo' => $periodo->id])->andWhere(['eliminado_por' => '0'])->all(); 
            }   
        }
        

        $calificaciones = [new Calificacion()]; 

        $seleccionmultiple = new Seleccionmultiple();


        for($i = 1; $i < $count; $i++) {

            $calificaciones[] = new Calificacion();
        }

        if (Yii::$app->request->isAjax && Model::loadMultiple($calificaciones, Yii::$app->request->post())) {
            Yii::$app->response->format = Response::FORMAT_JSON;
            return ActiveForm::validateMultiple($calificaciones);
        }

        elseif (Model::loadMultiple($calificaciones, Yii::$app->request->post())) 
            //&& Model::validateMultiple($calificaciones))  // LA VALIDACION EN EL CONTROLLER DE CALIFICACION Y COEVALUACION GENERA CONFLICTO, SOLO EN LA VISTA LA VALIDACION   
        {

            foreach ($calificaciones as $calificacion) 
            {
                //echo "<pre>";
                //print_r($calificacion);
                //echo "</pre>";

                $reg = Calificacion::find()->select(['id'])->where(['estudiante' => $calificacion->estudiante])->andWhere(['grupo' => $calificacion->grupo, 'asignatura' => $calificacion->asignatura, 'periodo' => $periodo->id])->andWhere(['eliminado_por' => '0'])->one();
                
                $estudiante = Tercero::find()->where(['id' => $calificacion->estudiante])->one();

                $count_reg = Calificacion::find()->select(['id'])->where(['estudiante' => $calificacion->estudiante])->andWhere(['grupo' => $calificacion->grupo, 'asignatura' => $calificacion->asignatura, 'periodo' => $periodo->id])->andWhere(['eliminado_por' => '0'])->count();



                /////////////////    NUEVO REGISTRO DE CALIFICACIONES    ////////////////////////


                if(!isset($reg)) 
                {                       
                    $model= new Calificacion;
                    
                    //echo "184: ".$calificacion->saber;

                    if($num_competencias > 0)
                    {
                        $model->saber = implode(",", (array) $calificacion->saber);
                        //$model->saber = $calificacion->saber;
                        
                        if($tipo_calificacion != 1)
                        {   
                            $model->promedio_saber = $model->promedio($calificacion->saber, $num_competencias);
                            $model->definitiva_saber = $model->definitiva($calificacion->saber, $num_competencias, $por_calificaciones_saber);
                        }
                        else
                        {
                            $model->definitiva_saber = $calificacion->saber;
                        }                       
                    }
                    

                    if($num_calificaciones_ser > 0)
                    {
                        $model->ser = implode(",", $calificacion->ser);    
                        if($tipo_calificacion != 1)
                        {   
                            $model->promedio_ser = $model->promedio($calificacion->ser, $num_calificaciones_ser);
                        }
                        $model->definitiva_ser = $model->definitiva($calificacion->ser, $num_calificaciones_ser, $por_calificaciones_ser);
                    }    
                    
                    
                    if($psi == 1)
                    {
                        $model->psi = implode(",", $calificacion->psi);
                        $definitiva_psi = $model->definitiva($calificacion->psi, 1, $por_calificaciones_psi);
                    }


                    if($tipo_calificacion == 2) // TIPO CALIFICACION NUMEROS
                    {
                        if($num_calificaciones_saber > 0)
                        {
                            $model->promedio_saber = $model->promedio($calificacion->saber, $num_calificaciones_saber);
                            $model->definitiva_saber = $model->definitiva($calificacion->saber, $num_calificaciones_saber, $por_calificaciones_saber);
                        }

                        if($num_calificaciones_ser > 0)
                        {
                            $model->promedio_ser = $model->promedio($calificacion->ser, $num_calificaciones_ser);
                            $model->definitiva_ser = $model->definitiva($calificacion->ser, $num_calificaciones_ser, $por_calificaciones_ser);
                        }

                        $model->definitiva_periodo = $model->definitiva_saber + $model->definitiva_ser + $definitiva_psi;

                    }
                    else
                    {
                        if($num_calificaciones_saber = 1 OR $num_competencias = 1)
                        {
                            $model->definitiva_periodo =  $calificacion->saber; 
                        }
                    }


                    if($model->nivelacion == NULL)
                    {
                        $model->definitiva_final_periodo = $model->definitiva_periodo;    
                    }
                    else
                    {
                        
                        $model->definitiva_final_periodo = $model->nivelacion;
                    }


                    if($periodo->id == '5')
                    {
                        $model->definitiva_periodo = $calificacion->definitiva_periodo;
                        $model->definitiva_final_periodo = $calificacion->definitiva_periodo;
                    }     
                    

                    $model->docente = $calificacion->docente;
                    $model->estudiante = $calificacion->estudiante;
                    $model->asignatura = $calificacion->asignatura;
                    $model->grupo = $calificacion->grupo;
                    $model->periodo = $calificacion->periodo;
                    
                    if(($frd_sede == 0) && ($model->periodo != '5'))
                    {
                        $model->frd = implode(",", $calificacion->frd);    
                    }    
                    
                    $observacion = new Observaciongeneral();

                    $model->observacion_general = $observacion->ValidarExistentes($calificacion->observacion_general);
                    $model->observacion_especifica = $calificacion->observacion_especifica;

                    
                    if($fallas == 0)
                    {
                        $model->fallas = $calificacion->fallas;    
                    }    
                    
                    $transaction = Yii::$app->db->beginTransaction();

                    try  
                    {
                        if ($model->save(false)) 
                        {
                            
                            $i = 1;
                            
                            foreach ((array) $calificacion->saber as $c_saber) 
                            {

                                $saber = new Calificacioncalificaciones();
                                $saber->calificacion_id = $model->id;
                                $saber->tipo = 'saber';
                                $saber->docente = Yii::$app->session->get('__doc') == 'admin' ? NULL : $calificacion->docente;
                                $saber->estudiante = $calificacion->estudiante;
                                $saber->grupo = $calificacion->grupo;
                                $saber->asignatura = $calificacion->asignatura;
                                $saber->periodo = $calificacion->periodo;
                                
                                if ($calificacionxcompetencia == "1") /// CALIFICACION POR ASIGANTURA 
                                {
                                    $saber->calificacion_numero = $i;
                                }
                                else // CALIFICACION POR COMPETENCIA
                                {
                                    $saber->competencia = $calificacion->competencia[($i-1)];  
                                }
                                

                                if($tipo_calificacion == 1)
                                {
                                    $total = Desempeno::find()->where(['nota' => $c_saber])
                                            ->andWhere(['tipo_calificacion' => $tipo_calificacion])
                                            ->count();
                            
                                    if($total > 0)
                                    {
                                        $saber->calificacion = $c_saber;
                                    }    
                                    else
                                    {
                                        if($c_saber != '')
                                        {

                                            Yii::$app->session->addFlash('mensaje', [
                                                'tipo' => 'danger',
                                                'titulo' => 'Error en la Nota',
                                                'icono' => 'far info',
                                                'mensaje' => 'La Nota <b>('.$c_saber.')</b> del estudiante <b>'.$estudiante->nombre.'</b> no exite.',
                                            ]);    
                                        }
                                    }
                                }
                                else
                                {
                                    $saber->calificacion = $c_saber;
                                }
                                

                                $saber->save(false);
                                $i++;
                            }
                        
                            $i = 1;
                            foreach ((array) $calificacion->frd as $c_frd) 
                            {

                                //Calificacionfrd::deleteAll(['calificacion' => $model->id, 'estudiante' => $calificacion->estudiante, 'grupo' => $calificacion->grupo, 'asignatura' => $calificacion->asignatura, 'periodo' => $calificacion->periodo, 'competencia' => $calificacion->competencia[$i]]);
                                Calificacionfrd::deleteAll(['calificacion' => $model->id, 'estudiante' => $calificacion->estudiante, 'grupo' => $calificacion->grupo, 'asignatura' => $calificacion->asignatura, 'periodo' => $calificacion->periodo]);

                                $registros = explode(",", $c_frd);

                                foreach ($registros as $registro) {
                                    
                                    if ($calificacionxcompetencia == "1") /// CALIFICACION POR ASIGANTURA 
                                    {
                                        $total = Frd::find()->where(['id' => $registro])->count();    
                                    }
                                    else // CALIFICACION POR COMPETENCIA
                                    {
                                        $total = Frd::find()->where(['id' => $registro])->andWhere(['competencia' => $calificacion->competencia[$i]])->count();      
                                    }
                                    
                                    

                                    if($total > 0)
                                    {

                                        $frd = new Calificacionfrd();
                                        $frd->calificacion = $model->id;
                                        $frd->frd = $registro;
                                        $frd->docente = Yii::$app->session->get('__doc') == 'admin' ? NULL : $calificacion->docente;
                                        $frd->estudiante = $model->estudiante;
                                        $frd->grupo = $model->grupo;
                                        $frd->asignatura = $model->asignatura;
                                        $frd->periodo = $model->periodo;
                                        $frd->competencia = $calificacion->competencia[$i];
                                        
                                        $frd->save(false);
                                        
                                    }
                                    else
                                    {
                                        if($registro != '')
                                        {
                                            Yii::$app->session->addFlash('mensaje', [
                                                'tipo' => 'danger',
                                                'titulo' => 'FRD Error',
                                                'icono' => 'far info',
                                                'mensaje' => 'El código de FRD <b>('.$registro.')</b> no existe o no corrresponde a la competencia del estudiante <b>'.$estudiante->nombre.'</b>.',
                                            ]);       
                                        }    
                                        
                                    }    
                                        
                                    
                                }

                                $i++;

                            }
                                
                            
                            /////////////     CALIFICACIONES DEL SER   ///////////////////

                            if($num_calificaciones_ser > 0)
                            {
                                if ($calificacionxcompetencia == 1) // POR ASIGNATURA
                                {
                                    $calificacion->ser = explode(",",$calificacion->ser);
                                }

                                $i = 1;
                                foreach ((array) $calificacion->ser as $c_ser) {
                                    
                                    $ser = new Calificacioncalificaciones();
                                    $ser->tipo = 'ser';
                                    $ser->calificacion_id = $model->id;
                                    $ser->calificacion_numero = $i;

                                    if($tipo_calificacion == 1)
                                    {
                                        $total = Desempeno::find()->where(['nota' => $c_ser])
                                                ->andWhere(['tipo_calificacion' => $tipo_calificacion])
                                                ->count();
                                
                                        if($total > 0)
                                        {
                                            $ser->calificacion = $c_ser;
                                        }    
                                        else
                                        {
                                            if($c_ser != '')
                                            {

                                                Yii::$app->session->addFlash('mensaje', [
                                                    'tipo' => 'danger',
                                                    'titulo' => 'Error en la Nota',
                                                    'icono' => 'far info',
                                                    'mensaje' => 'La Nota <b>('.$c_ser.')</b> del estudiante <b>'.$estudiante->nombre.'</b> no exite.',
                                                ]);    
                                            }
                                        }
                                    }
                                    else
                                    {
                                        $ser->calificacion = $c_ser;
                                    }    
                                    

                                    $ser->docente = $model->docente;
                                    $ser->estudiante = $model->estudiante;
                                    $ser->grupo = $model->grupo;
                                    $ser->asignatura = $model->asignatura;
                                    $ser->periodo = $model->periodo;
                                    $ser->save();

                                    $i++;

                                }
                            }

                            ///////////// FIN DE SER ///////////////////


                            /////////////     CALIFICACIONES PSI   ///////////////////

                            if($psi == 1)
                            {
                                if ($calificacionxcompetencia == 1) // POR ASIGNATURA
                                {
                                    $calificacion->psi = explode(",",$calificacion->psi);
                                }

                                $i = 1;
                                foreach ((array) $calificacion->psi as $c_psi) {
                                        
                                    $r_psi = new Calificacioncalificaciones();
                                    $r_psi->tipo = 'psi';
                                    $r_psi->calificacion_id = $model->id;
                                    $r_psi->calificacion_numero = $i;

                                    if($tipo_calificacion == 1)
                                    {
                                        $total = Desempeno::find()->where(['nota' => $c_psi])
                                                ->andWhere(['tipo_calificacion' => $tipo_calificacion])
                                                ->count();
                                
                                        if($total > 0)
                                        {
                                            $r_psi->calificacion = $c_psi;
                                        }    
                                        else
                                        {
                                            if($c_psi != '')
                                            {

                                                Yii::$app->session->addFlash('mensaje', [
                                                    'tipo' => 'danger',
                                                    'titulo' => 'Error en la Nota',
                                                    'icono' => 'far info',
                                                    'mensaje' => 'La Nota <b>('.$c_psi.')</b> del estudiante <b>'.$estudiante->nombre.'</b> no exite.',
                                                ]);    
                                            }
                                        }
                                    }
                                    else
                                    {
                                        $r_psi->calificacion = $c_psi;
                                    }    
                                    

                                    $r_psi->docente = $model->docente;
                                    $r_psi->estudiante = $model->estudiante;
                                    $r_psi->grupo = $model->grupo;
                                    $r_psi->asignatura = $model->asignatura;
                                    $r_psi->periodo = $model->periodo;
                                    $r_psi->save();

                                    $i++;

                                }
                            
                            }

                            ///////////// FIN DE PSI ///////////////////

                            $transaction->commit();

                            Yii::$app->session->addFlash('mensaje', [
                                'tipo' => 'success',
                                'titulo' => 'Calificaciones Almacenadas',
                                'icono' => 'fa fa-check-square-o',
                                'mensaje' => 'Las calificaciones de <b>'.$estudiante->nombre.'</b> se almacenaron con éxito en el sistema',
                            ]);

                        } else {
                            $transaction->rollBack();

                            Yii::$app->session->addFlash('mensaje', [
                                'tipo' => 'danger',
                                'titulo' => 'Calificaciones No Almacenadas',
                                'icono' => 'fa fa-check-square-o',
                                'mensaje' => 'Las calificaciones de <b>'.$estudiante->nombre.'</b> no se almacenaron en el sistema',
                            ]);
                        }
                    } catch (Exception $e) {
                        $transaction->rollBack();
                    }
                }
                else //Actualizar Calificaciones 
                {  
                    $model = Calificacion::find()->where(['id' => $reg->id])->one();

                    if($num_calificaciones_saber > 0 OR $num_competencias > 0)
                    {
                        $model->saber = implode(",", (array) $calificacion->saber);
                        if($tipo_calificacion != 1)
                        {   
                            $model->promedio_saber = $model->promedio($calificacion->saber, $num_competencias);
                            $model->definitiva_saber = $model->definitiva($calificacion->saber, $num_competencias, $por_calificaciones_saber);
                        }
                        else
                        {
                            $model->definitiva_saber = $calificacion->saber;
                        }
                    }  

                    if($num_calificaciones_ser > 0)
                    {
                        $model->ser = implode(",", $calificacion->ser);    
                        $model->promedio_ser = $model->promedio($calificacion->ser, $num_calificaciones_ser);
                        $model->definitiva_ser = $model->definitiva($calificacion->ser, $num_calificaciones_ser, $por_calificaciones_ser);
                    } 

                    if($psi == 1)
                    {
                        $model->psi = implode(",", $calificacion->psi);
                        $definitiva_psi = $model->definitiva($calificacion->psi, 1, $por_calificaciones_psi);
                    }

                    if($tipo_calificacion == 2) // TIPO CALIFICACION NUMEROS
                    {
                        if($num_calificaciones_saber > 0)
                        {
                            $model->promedio_saber = $model->promedio($calificacion->saber, $num_calificaciones_saber);
                            $model->definitiva_saber = $model->definitiva($calificacion->saber, $num_calificaciones_saber, $por_calificaciones_saber);
                        }

                        if($num_calificaciones_ser > 0)
                        {
                            $model->promedio_ser = $model->promedio($calificacion->ser, $num_calificaciones_ser);
                            $model->definitiva_ser = $model->definitiva($calificacion->ser, $num_calificaciones_ser, $por_calificaciones_ser);
                        }

                        $model->definitiva_periodo = $model->definitiva_saber + $model->definitiva_ser + $definitiva_psi;

                    }
                    else
                    {
                        if($num_calificaciones_saber = 1 OR $num_competencias = 1)
                        {
                            $model->definitiva_periodo =  $calificacion->saber; 
                        }
                    }


                    if($model->nivelacion == NULL)
                    {
                        $model->definitiva_final_periodo = $model->definitiva_periodo;    
                    }
                    else
                    {
                        
                        $model->definitiva_final_periodo = $model->nivelacion;
                    }

                    $model->docente = $calificacion->docente;
                    $model->estudiante = $calificacion->estudiante;
                    $model->asignatura = $calificacion->asignatura;
                    $model->grupo = $calificacion->grupo;
                    $model->periodo = $calificacion->periodo;
                    
                    if($frd_sede == 0 && $periodo->id != 5)
                    {
                        $model->frd = implode(",", $calificacion->frd);    
                    } 

                    if($periodo->id == '5')
                    {
                        $model->definitiva_periodo = $calificacion->definitiva_periodo;
                        $model->definitiva_final_periodo = $calificacion->definitiva_periodo;
                    }


                    //////  AGREGA LA EL PROMEDIO DEL AREA DEL ESTUDIANTE CUANDO EXISTE UNA SOLA ASIGNATURA EN EL AREA  ///////

                    if($tipo_calificacion == 2)
                    {
                        $total_asignaturasxarea = Asignatura::find()->where(['area' => $model->asignaturas->area])->andWhere(['grado' => $model->grupos->grado])->andWhere(['eliminado_por' => '0'])->count();
                        
                        if($total_asignaturasxarea == '1' AND $tipo_calificacion == 2)
                        {
                            //$promedio = new Promedio;
                            //$promedio->getPromedioxEstudiante($calificacion->tipo_calificacion, $model->estudiante, $model->definitiva_final_periodo, $grupo->grados->id, $grupo->id, $model->asignaturas->area, $model->asignatura, $model->periodo); 

                            //echo"<br>".$model->estudiante;
                        }   
                    }   


                    $observacion = new Observaciongeneral();

                    $model->observacion_general = $observacion->ValidarExistentes($calificacion->observacion_general);
                    $model->observacion_especifica = $calificacion->observacion_especifica;

                    
                    if($fallas == 0)
                    {
                        $model->fallas = $calificacion->fallas;    
                    } 

                    $transaction = Yii::$app->db->beginTransaction();

                    try {
                            if ($model->update(false)) 
                            {
                                
                                $i = 1;
                                
                                foreach ((array) $calificacion->saber as $c_saber) 
                                {

                                        $saber = Calificacioncalificaciones::find()
                                            ->where(['calificacion_id' => $reg->id])
                                            ->andWhere(['tipo' => 'saber'])
                                            ->andWhere(['estudiante' => $calificacion->estudiante])
                                            ->andWhere(['grupo' => $calificacion->grupo])
                                            ->andWhere(['asignatura' => $calificacion->asignatura])
                                            ->andWhere(['periodo' => $calificacion->periodo])
                                            ->one();
                                    
                                        if(!isset($saber))
                                        {
                                        
                                            $saber = new Calificacioncalificaciones();
                                            $saber->calificacion_id = $reg->id;
                                            $saber->tipo = 'saber';
                                            $saber->docente = Yii::$app->session->get('__doc') == 'admin' ? NULL : $calificacion->docente;
                                            $saber->estudiante = $calificacion->estudiante;
                                            $saber->grupo = $calificacion->grupo;
                                            $saber->asignatura = $calificacion->asignatura;
                                            $saber->periodo = $calificacion->periodo;

                                            if ($calificacionxcompetencia == "1") /// CALIFICACION POR ASIGANTURA 
                                            {
                                                $saber->calificacion_numero = $i;
                                            }
                                            else // CALIFICACION POR COMPETENCIA
                                            {
                                                $saber->competencia = $calificacion->competencia[($i-1)];  
                                            }
                                            
                                            $saber->save(false);

                                            Yii::$app->session->addFlash('mensaje', [
                                                'tipo' => 'success',
                                                'titulo' => 'Calificaciones Almacenadas',
                                                'icono' => 'fa fa-check-square-o',
                                                'mensaje' => 'Las calificaciones de <b>'.$estudiante->nombre.'</b> se almacenaron con éxito en el sistema',
                                            ]);

                                            $saber = Calificacioncalificaciones::find()
                                            ->where(['calificacion_id' => $reg->id])
                                            ->andWhere(['tipo' => 'saber'])
                                            ->andWhere(['estudiante' => $calificacion->estudiante])
                                            ->andWhere(['grupo' => $calificacion->grupo])
                                            ->andWhere(['asignatura' => $calificacion->asignatura])
                                            ->andWhere(['periodo' => $calificacion->periodo])
                                            ->andWhere(['competencia' => $calificacion->competencia[$i]])
                                            ->one();

                                        }   

                                        if($tipo_calificacion == 1)
                                        {
                                            $total = Desempeno::find()->where(['nota' => $c_saber])
                                                    ->andWhere(['tipo_calificacion' => $tipo_calificacion])
                                                    ->count();
                                    
                                            if($total > 0)
                                            {
                                                $saber->calificacion = $c_saber;
                                            }    
                                            else
                                            {
                                                if($c_saber != '')
                                                {

                                                    Yii::$app->session->addFlash('mensaje', [
                                                        'tipo' => 'danger',
                                                        'titulo' => 'Error en la Nota',
                                                        'icono' => 'far info',
                                                        'mensaje' => 'La Nota <b>('.$c_saber.')</b> del estudiante <b>'.$estudiante->nombre.'</b> no exite.',
                                                    ]);    
                                                }
                                            }
                                        }
                                        else
                                        {
                                            $saber->calificacion = $c_saber;
                                        }
                                        

                                        $saber->update(false);
                                    $i++;
                                }
                                
                                $i = 1;
                                foreach ((array) $calificacion->frd as $c_frd) 
                                {
                                    if ($calificacionxcompetencia == "1") /// CALIFICACION POR ASIGANTURA 
                                    {
                                        Calificacionfrd::deleteAll(['calificacion' => $reg->id, 'estudiante' => $calificacion->estudiante, 'grupo' => $calificacion->grupo, 'asignatura' => $calificacion->asignatura, 'periodo' => $calificacion->periodo]);
                                    }
                                    else // CALIFICACION POR COMPETENCIA
                                    {
                                        Calificacionfrd::deleteAll(['calificacion' => $reg->id, 'estudiante' => $calificacion->estudiante, 'grupo' => $calificacion->grupo, 'asignatura' => $calificacion->asignatura, 'periodo' => $calificacion->periodo, 'competencia' => $calificacion->competencia[$i]]); 
                                    }
                                    

                                    $registros = explode(",", $c_frd);

                                    foreach ($registros as $registro) {
                                        
                                        //$total = Frd::find()->where(['id' => $registro])->andWhere(['competencia' => $calificacion->competencia[$i]])->count();    
                                        $total = Frd::find()->where(['id' => $registro])->count();    
                                        

                                        if($total > 0)
                                        {

                                            $frd = new Calificacionfrd();
                                            $frd->calificacion = $model->id;
                                            $frd->frd = $registro;
                                            $frd->docente = Yii::$app->session->get('__doc') == 'admin' ? NULL : $calificacion->docente;
                                            $frd->estudiante = $model->estudiante;
                                            $frd->grupo = $model->grupo;
                                            $frd->asignatura = $model->asignatura;
                                            $frd->periodo = $model->periodo;
                                            $frd->competencia = $calificacion->competencia[$i];
                                            
                                            $frd->save(false);
                                            
                                        }
                                        else
                                        {
                                            if($registro != '')
                                            {
                                                Yii::$app->session->addFlash('mensaje', [
                                                    'tipo' => 'danger',
                                                    'titulo' => 'FRD Error',
                                                    'icono' => 'far info',
                                                    'mensaje' => 'El código de FRD <b>('.$registro.')</b> no existe o no corrresponde a la competencia del estudiante <b>'.$estudiante->nombre.'</b>.',
                                                ]);       
                                            }    
                                            
                                        }    
                                            
                                        
                                    }

                                    $i++;

                                }                         

                                if($num_calificaciones_ser > 0)
                                {
                                    $i = 1;
                                    foreach ((array) $calificacion->ser as $c_ser) {
                                        
                                        $ser = Calificacioncalificaciones::find()
                                                ->where(['calificacion_id' => $reg->id])
                                                ->andWhere(['tipo' => 'ser'])
                                                ->andWhere(['estudiante' => $calificacion->estudiante])
                                                ->andWhere(['grupo' => $calificacion->grupo])
                                                ->andWhere(['asignatura' => $calificacion->asignatura])
                                                ->andWhere(['periodo' => $calificacion->periodo])
                                                ->andWhere(['calificacion_numero' => $i])
                                                ->one();

                                        if($tipo_calificacion == 1)
                                        {
                                            $total = Desempeno::find()->where(['nota' => $c_ser])
                                                    ->andWhere(['tipo_calificacion' => $tipo_calificacion])
                                                    ->count();
                                    
                                            if($total > 0)
                                            {
                                                $ser->calificacion = $c_ser;
                                            }    
                                            else
                                            {
                                                if($c_ser != '')
                                                {

                                                    Yii::$app->session->addFlash('mensaje', [
                                                        'tipo' => 'danger',
                                                        'titulo' => 'Error en la Nota',
                                                        'icono' => 'far info',
                                                        'mensaje' => 'La Nota <b>('.$c_ser.')</b> del estudiante <b>'.$estudiante->nombre.'</b> no exite.',
                                                    ]);    
                                                }
                                            }
                                        }
                                        else
                                        {
                                            $ser->calificacion = $c_ser;
                                        }    
                                        
                                        $ser->update(false);

                                        $i++;

                                    }
                                }

                                ///////////// FIN DE SER ///////////////////


                                /////////////     CALIFICACIONES PSI   ///////////////////

                                if($psi == 1 && $periodo->id != 5)
                                {
                                    $i = 1;
                                    foreach ((array) $calificacion->psi as $c_psi) {
                                            
                                        $r_psi = Calificacioncalificaciones::find()
                                                ->where(['calificacion_id' => $reg->id])
                                                ->andWhere(['tipo' => 'psi'])
                                                ->andWhere(['estudiante' => $calificacion->estudiante])
                                                ->andWhere(['grupo' => $calificacion->grupo])
                                                ->andWhere(['asignatura' => $calificacion->asignatura])
                                                ->andWhere(['periodo' => $calificacion->periodo])
                                                ->andWhere(['calificacion_numero' => $i])
                                                ->one();

                                        if($tipo_calificacion == 1)
                                        {
                                            $total = Desempeno::find()->where(['nota' => $c_psi])
                                                    ->andWhere(['tipo_calificacion' => $tipo_calificacion])
                                                    ->count();
                                    
                                            if($total > 0)
                                            {
                                                $r_psi->calificacion = $c_psi;
                                            }    
                                            else
                                            {
                                                if($c_psi != '')
                                                {

                                                    Yii::$app->session->addFlash('mensaje', [
                                                        'tipo' => 'danger',
                                                        'titulo' => 'Error en la Nota',
                                                        'icono' => 'far info',
                                                        'mensaje' => 'La Nota <b>('.$c_psi.')</b> del estudiante <b>'.$estudiante->nombre.'</b> no exite.',
                                                    ]);    
                                                }
                                            }
                                        }
                                        else
                                        {
                                            $r_psi->calificacion = $c_psi;
                                        }    
                                        
                                        $r_psi->update(false);

                                        $i++;

                                    }
                                
                                }

                                ///////////// FIN DE PSI ///////////////////    
                                $transaction->commit();

                                Yii::$app->session->addFlash('mensaje', [
                                    'tipo' => 'info',
                                    'titulo' => 'Calificaciones Actualizadas',
                                    'icono' => 'fa info',
                                    'mensaje' => 'Las calificaciones de <b>'.$estudiante->nombre.'</b> se actualizaron correctamente.',
                                ]); 
                                

                            } else {

                                var_dump($model->errors);

                                $transaction->rollBack();
                            }


                        } catch (Exception $e) {
                    $transaction->rollBack();
                    }  
                }    
            }

            //////////////////////////////////////////////////////////////////////////////////
            ////////////////                                                  //////////////// 
            ////////////////               PROMEDIOS Y PUESTOS                ////////////////
            ////////////////                                                  ////////////////
            //////////////////////////////////////////////////////////////////////////////////            



            
            //echo "Total: ".$total_calificaciones." calificacion por ".$calificacionxcompetencia." Competencias: ".$num_competencias;
            /*
            if($total_calificaciones == '1' && $calificacionxcompetencia== '1')
            {
                $model->definitiva_periodo = $calificacion->saber;
                $model->definitiva_final_periodo = $calificacion->saber;
            }
            */


            if ($periodo->id != '5' && $calificacion->tipo_calificacion != '1')
            {
                $promedio = new Promedio;
                $promedio->getPuestoxGrupo($calificacion->tipo_calificacion, $grupo->grados->id, $grupo->id, $calificacion->asignatura, $calificacion->periodo);
                $promedio->getPromedios($calificacion->tipo_calificacion, $grupo->grados->id, $grupo->id, $calificacion->asignatura, $calificacion->periodo);

             
                //echo "1107<br>Tipo Cali: ".$calificacion->tipo_calificacion." Estudiante: ".$calificacion->estudiante." Definitiva: ".$calificacion->definitiva_periodo."Grado : ".$grupo->grados->id." Grupo ".$grupo->id." Area: ".$calificacion->asignaturas->area." Periodo: ".$calificacion->periodo;
                //exit;

                //echo "<br>".$model->estudiantes->nombre." Calificacion: ".$model->definitiva_final_periodo;
                $promedio = new Promedio;
                // DEVUELVE LA CALIFICACION DEL AREA EN CALIFICACIONES DE LETRAS
                $calificacion_area = $promedio->getPromedioxAreaxEstudiante($calificacion->tipo_calificacion, $calificacion->estudiante, $grupo->grados->id, $grupo->id, $calificacion->asignaturas->area, $calificacion->periodo);


            }
            

            if ($periodo->id == '5' && $calificacion->tipo_calificacion != '1')
            {
                //echo "1107<br>Tipo Cali: ".$calificacion->tipo_calificacion." Estudiante: ".$calificacion->estudiante." Definitiva: ".$calificacion->definitiva_periodo."Grado : ".$grupo->grados->id." Grupo ".$grupo->id." Area: ".$calificacion->asignaturas->area." Periodo: ".$calificacion->periodo;
                //exit;

                //echo "<br>1143-Calificacion: ".$calificacion->definitiva_final_periodo;
                //$promedio = new Promedio;
                // DEVUELVE LA CALIFICACION DEL AREA EN CALIFICACIONES DE LETRAS
                //$calificacion_area = $promedio->getPromedioxAreaxEstudiante($calificacion->tipo_calificacion, $calificacion->estudiante, $grupo->grados->id, $grupo->id, $calificacion->asignaturas->area, $calificacion->periodo);

                //echo "<br>1114-Área: <br>".$calificacion_area;

                //exit;
            }            


            if((Yii::$app->session->get('__tipo') != 2) && (Yii::$app->request->get('tercero')))
            {
                return $this->redirect(['calificacion/traslado', 'tercero' => Yii::$app->request->get('tercero')]);  

                if($periodo->actual->id > 1)
                {
                    return $this->redirect(['calificacion/traslado', 'tercero' => Yii::$app->request->get('tercero')]);  
                }
                else
                {
                    return $this->redirect(['site/index']);    
                }
            }
            else
            {
                return $this->redirect(['docente/index']);    
            }
            
            
        }
        else
        {

            return $this->render('calificaciones', [
                'dataProvider' => $dataProvider,
                'periodo' => $periodo,
                'calificaciones' => $calificaciones,
                'competencias' => $competencias,
                'seleccionmultiple' => $seleccionmultiple,
                'registros' => $registros,
                'grupo' => $grupo,
                'fallas' => $fallas,
                'entrada' => $entrada,
                'frd' => $frd_sede,
                'calificacionxcompetencia' => $calificacionxcompetencia,
                'tipo_calificacion' => $tipo_calificacion,
                'num_competencias' => $num_competencias,
                'num_calificaciones_saber' => $num_calificaciones_saber,
                'num_calificaciones_ser' => $num_calificaciones_ser, 
                'por_calificaciones_saber' => $por_calificaciones_saber,
                'por_calificaciones_ser' => $por_calificaciones_ser,
                'psi' => $psi,
                'num_calificaciones_psi' => $num_calificaciones_psi,
                'por_calificaciones_psi' => $por_calificaciones_psi,
                'observacion_general' => $observacion_general,
                'observacion_especifica' => $observacion_especifica,
            ]);

        }
    } 

    public function actionNivelaciones()
    {
        $sede = Sede::find()->where(['principal' => '1'])->one();

        $periodo = new Periodo();
        
        $periodos_nivelacion = Periodo::find()->select(['id'])->where(['autorizar_nivelaciones' => 1]);

        $periodos = $periodos_nivelacion->all();

        $grupo = Grupo::find()->where(['id' => Yii::$app->request->get('grupo')])->one();
        $asignatura = Asignatura::find()->where(['id' => Yii::$app->request->get('asignatura')])->one(); 
        $entrada = $sede->entrada;

        if($grupo->sedes->autorizar_nivelaciones == 0) {
            throw new NotFoundHttpException('Las nivelaciones están inactivas por el momento.');
        }    

        
        //echo $query->createCommand()->sql;

        //echo $query->createCommand()->getRawSql(); // Mostrar SQL   

        $tipo_calificacion = $grupo->grados->tipo_calificacion;
        //$calificacionxcompetencia = $grupo->grados->calificacionxcompetencia;
        //$frd_sede = $grupo->sedes->frd;

        //$num_competencias = Competencia::find()->where(['asignatura' => Yii::$app->request->get('asignatura')])->andWhere(['periodo' => $periodo->actual->id])->count(); 

        //$num_calificaciones_saber = $calificacionxcompetencia == 1 ? $asignatura->num_calificaciones_saber : $num_competencias;
        //$num_calificaciones_ser = $asignatura->num_calificaciones_ser;
        //$por_calificaciones_saber = $asignatura->por_calificaciones_saber;
        //$por_calificaciones_ser = $asignatura->por_calificaciones_ser; 
        //$por_calificaciones_psi = $asignatura->por_calificaciones_psi; 
        //$num_calificaciones_psi = $grupo->sedes->num_calificaciones_psi;


        if($asignatura->especialidad == 1)
        {
            $academicos = Academico::find()->select(['tercero.id'])->joinWith(['estudiantes'])->where(['<', 'tercero.estado', 3])->andWhere(['academico.grupo' => Yii::$app->request->get('grupo')])->all();  
        }
        else
        {
            $academicos = Academico::find()->select(['tercero.id'])->joinWith(['estudiantes'])->where(['<', 'tercero.estado', 3])->andWhere(['academico.grupo' => Yii::$app->request->get('grupo')])->andWhere(['academico.especialidad' => $asignatura->especialidad])->all();     
        } 

        foreach ($academicos as $estudiante) {
            foreach ($periodos as $p) 
            {
                $calificacion = Calificacion::find()
                ->where(['estudiante' => $estudiante->id])
                ->andWhere(['grupo' => Yii::$app->request->get('grupo')])
                ->andWhere(['asignatura' => Yii::$app->request->get('asignatura')])
                ->andWhere(['periodo' => $p->id])
                ->one();

                if(!isset($calificacion))  /// NUEVO REGISTRO
                {                     
                    $model= new Calificacion;
                    $model->docente = Yii::$app->session->get('__tercero');
                    $model->estudiante = $estudiante->id;
                    $model->asignatura = Yii::$app->request->get('asignatura');
                    $model->grupo = Yii::$app->request->get('grupo');
                    $model->periodo = $p->id;
                    $model->save();
                }

                
            }
        }
        
        if($tipo_calificacion == 1) // TIPO CALIFICACION LETRAS
        { 
            //$desempeno = explode(",", "S,A,B");

            $desempeno = Desempeno::find()->select(['nota'])->where(['tipo_calificacion' =>$tipo_calificacion])->andWhere(['perdido' => '0'])->asArray();
            

            $query = Calificacion::find()->joinWith(['estudiantes'])
                ->where(['<', 'tercero.estado', 3])
                ->andWhere(['grupo' => Yii::$app->request->get('grupo')])
                ->andWhere(['asignatura' => Yii::$app->request->get('asignatura')])
                ->andWhere(['IN', 'periodo', $periodos_nivelacion])
                //->andWhere(['NOT IN', 'definitiva_periodo', ["A","S","B"]])
                ->andWhere(['NOT IN', 'definitiva_periodo', $desempeno])

                
                ->groupBy(['estudiante'])
                ->orderBy('tercero.primer_apellido'); 

            //echo $query->createCommand()->getRawSql(); // Mostrar SQL   

        }
        else  // TIPO CALIFICACION NÚMEROS
        {

            /*
            $desempeno = Desempeno::find()->select(['nota'])->where(['tipo_calificacion' =>$tipo_calificacion])->andWhere(['perdido' => '0'])->asArray();

            $query = Calificacion::find()->joinWith(['estudiantes'])
                ->where(['<', 'tercero.estado', 3])
                ->andWhere(['grupo' => Yii::$app->request->get('grupo')])
                ->andWhere(['asignatura' => Yii::$app->request->get('asignatura')])
                ->andWhere(['IN', 'periodo', $periodos_nivelacion])
                ->andWhere(['<', 'definitiva_periodo','3'])
                ->groupBy(['estudiante'])
                ->orderBy('tercero.primer_apellido');  
                */

            
            $superior = Desempeno::find()->where(['tipo_calificacion' => '2'])->andWhere(['perdido' => '1'])->max('limite_superior');    

            $query = Calificacion::find()->joinWith(['estudiantes'])
                ->where(['<', 'tercero.estado', 3])
                ->andWhere(['grupo' => Yii::$app->request->get('grupo')])
                ->andWhere(['asignatura' => Yii::$app->request->get('asignatura')])
                ->andWhere(['IN', 'periodo', $periodos_nivelacion])
                ->andWhere(['<', 'definitiva_periodo', $superior])
                ->groupBy(['estudiante'])
                ->orderBy('tercero.primer_apellido'); 
        }

        //echo $query->createCommand()->getRawSql(); // Mostrar SQL   


        $dataProvider = new ActiveDataProvider([
            'query' => $query,
            'pagination' => [
                'pageSize' => 500,
            ],
        ]);
        
        $registros = Calificacion::find()->where(['grupo' => Yii::$app->request->get('grupo')])->andWhere(['asignatura' => Yii::$app->request->get('asignatura')])->andWhere(['IN', 'periodo', $periodos_nivelacion])->andWhere(['NOT IN', 'definitiva_periodo', ["A","S","B"]])->count();


        $count = count(Yii::$app->request->post('Calificacion', []));

       
        $seleccionmultiple = new Seleccionmultiple();

        if($tipo_calificacion == 1) // TIPO CALIFICACION LETRAS
        { 
            $desempeno = Desempeno::find()->select(['nota'])->where(['tipo_calificacion' =>$tipo_calificacion])->andWhere(['perdido' => '0'])->asArray();
            

            $calificaciones = Calificacion::find()->joinWith(['estudiantes'])
                ->where(['<', 'tercero.estado', 3])
                ->andWhere(['grupo' => Yii::$app->request->get('grupo')])
                ->andWhere(['asignatura' => Yii::$app->request->get('asignatura')])
                ->andWhere(['IN', 'periodo', $periodos_nivelacion])
                //->andWhere(['NOT IN', 'definitiva_periodo', ["A","S","B"]])
                ->andWhere(['NOT IN', 'definitiva_periodo', $desempeno])
                ->groupBy(['estudiante'])
                ->orderBy('tercero.primer_apellido')
                ->all();
        }
        else  // TIPO CALIFICACION NÚMEROS
        {
             $calificaciones = Calificacion::find()->joinWith(['estudiantes'])
                ->where(['<', 'tercero.estado', 3])
                ->andWhere(['grupo' => Yii::$app->request->get('grupo')])
                ->andWhere(['asignatura' => Yii::$app->request->get('asignatura')])
                ->andWhere(['IN', 'periodo', $periodos_nivelacion])
                ->andWhere(['<', 'definitiva_periodo','3'])
                ->groupBy(['estudiante'])
                ->orderBy('tercero.primer_apellido')
                ->all();  
        }

        
        if (Model::loadMultiple($calificaciones, Yii::$app->request->post()))  // LA VALIDACION EN EL CONTROLLER DE CALIFICACION Y COEVALUACION GENERA CONFLICTO, SOLO EN LA VISTA LA VALIDACION   
        {

            foreach($calificaciones as $calificacion) 
            {                
                 
                foreach ($periodos as $p)     
                {   
                    
                    $nivelacion = Calificacion::find()->where(['id' => $calificacion->nota_id[$p->id]])->one();
                    $nivelacion->nivelacion = $calificacion->nivelacion[$p->id];
                    
                    if(($nivelacion->nivelacion == '') && ($sede->nivelacion_no_nivelado == 1))
                    {
                        $nivelacion->definitiva_final_periodo = $calificacion->nivelacion[$p->id];
                    }
                    else
                    {
                        $nivelacion->definitiva_final_periodo = $nivelacion->nivelacion;   
                    }


                    if($tipo_calificacion == 1) // TIPO CALIFICACION LETRAS
                    {
                        if($sede->nivelacion_mayor_calificacion == 1)
                        {
                            $desempeno_def_periodo = Desempeno::find()->where(['nota' => $nivelacion->definitiva_periodo ? $nivelacion->definitiva_periodo : 'NE'])->andWhere(['tipo_calificacion' => $tipo_calificacion])->one();
                            $desempeno_nivelacion = Desempeno::find()->where(['nota' => $nivelacion->nivelacion ? $nivelacion->nivelacion : 'NE'])->andWhere(['tipo_calificacion' => $tipo_calificacion])->one();

                            if($desempeno_nivelacion->id <= $desempeno_def_periodo->id)
                            {
                                $nivelacion->definitiva_final_periodo = $nivelacion->definitiva_periodo;   
                            }
                            else
                            {
                                $nivelacion->definitiva_final_periodo = $nivelacion->nivelacion;   
                            }
                            
                        }
                        else
                        {
                           $nivelacion->definitiva_final_periodo = $nivelacion->nivelacion;    
                        }     
                    }
                    else // TIPO CALIFICACION NUMEROS
                    {
                        if($sede->nivelacion_mayor_calificacion == 1)
                        {
                            if($nivelacion->nivelacion <= $nivelacion->definitiva_periodo)
                            {
                                $nivelacion->definitiva_final_periodo = $nivelacion->definitiva_periodo;   
                            }
                            else
                            {
                                $nivelacion->definitiva_final_periodo = $nivelacion->nivelacion;   
                            }
                            
                        }
                        else
                        {
                           $nivelacion->definitiva_final_periodo = $nivelacion->nivelacion;    
                        }
                    }

                    $nivelacion->update();
                
            
                    Yii::$app->session->addFlash('mensaje', [
                        'tipo' => 'success',
                        'titulo' => 'Nivelaciones Almacenadas',
                        'icono' => 'fa fa-check-square-o',
                        'mensaje' => 'La nivelación de '.$calificacion->estudiantes->nombre.' se almacenó con éxito en el sistema',
                    ]);
                    
                }  
            }

            ////////////  PROMEDIOS X GRUPO & GRADO  /////////////
            
            if($tipo_calificacion != 1)
            {
                try {

                    /// PROMEDIO POR GRUPO ///

                    $promedio_grupo = Promedio::find()
                                    ->select(['ROUND(AVG(promedio_estudiante),1) as promedio_estudiante'])
                                    ->where(['grupo' => Yii::$app->request->get('grupo')])
                                    ->andWhere(['periodo' => $periodo->actual->id])
                                    ->groupBy(['grupo'])
                                    ->one();

                    $promedios = Promedio::find()
                                    ->andWhere(['grupo' => Yii::$app->request->get('grupo')])
                                    ->andWhere(['periodo' => $periodo->actual->id])
                                    ->orderBy(['promedio_estudiante' => SORT_DESC])
                                    ->all();

                    $puesto = 0;
                    $promedio_anterior = 0;
                    foreach ($promedios as $promedio) {

                        if($promedio->promedio_estudiante != $promedio_anterior)
                        {
                            $puesto++;
                        }

                        $promedio->puesto_grupo = $puesto;
                        $promedio->promedio_grupo = $promedio_grupo->promedio_estudiante;
                        $promedio_anterior = $promedio->promedio_estudiante;

                        $promedio->update(false);   
                        
                    }

                    /// PROMEDIO POR GRADO ///
                    $grupo = Grupo::find()->where(['id' =>Yii::$app->request->get('grupo')])->one();

                    $promedio_grado = Promedio::find()
                                    ->select(['ROUND(AVG(promedio_estudiante),1) as promedio_estudiante'])
                                    ->where(['grado' => $grupo->grado])
                                    ->andWhere(['periodo' => $periodo->actual->id])
                                    ->groupBy(['grado'])
                                    ->one();

                    $promedios = Promedio::find()
                                    ->where(['grado' => $grupo->grado])
                                    ->andWhere(['periodo' => $periodo->actual->id])
                                    ->orderBy(['promedio_estudiante' => SORT_DESC])
                                    ->all();

                    $puesto = 0;
                    $promedio_anterior = 0;
                    foreach ($promedios as $promedio) {

                        if($promedio->promedio_estudiante != $promedio_anterior)
                        {
                            $puesto++;
                        }

                        $promedio->puesto_grado = $puesto;
                        $promedio->promedio_grado = $promedio_grado->promedio_estudiante;
                        $promedio_anterior = $promedio->promedio_estudiante;

                        $promedio->update(false);   
                        
                    }

                    ////////  PROMEDIOS POR AREAS  ///////////

                    ///  PROMEDIO DEL AREA POR GRUPO  ///

                    $promedio_grupo = Promedioarea::find()
                                    ->select(['ROUND(AVG(promedio_estudiante),1) as promedio_estudiante'])
                                    ->where(['grupo' => $grupo->id])
                                    ->andWhere(['periodo' => $periodo->actual->id])
                                    ->andWhere(['area' => $asignatura->area])
                                    ->groupBy(['grupo'])
                                    ->one();

                    Promedioarea::updateAll(['promedio_grupo' => round($promedio_grupo->promedio_estudiante,1)], ['grupo' => $grupo->id, 'periodo' => $periodo->actual->id, 'area' => $asignatura->area]);

                    /// PROMEDIO DEL AREA POR GRADO ///


                    $suma_grado = Promedioarea::find()
                                    ->select(['ROUND(SUM(DISTINCT promedio_grupo),1) as promedio_grupo'])
                                    ->where(['grado' => $grupo->grado])
                                    ->andWhere(['periodo' => $periodo->actual->id])
                                    ->groupBy(['grado'])
                                    ->one();

                    //echo $suma_grado->createCommand()->getRawSql(); // Mostrar SQL   
                                        
                    $total_grado = (float)$suma_grado->promedio_grupo / count($asignatura->grados->grupos);

                    Promedioarea::updateAll(['promedio_grado' => round($total_grado,1)], ['grado' => $grupo->grado, 'periodo' => $periodo->actual->id]);
                    

                    /// PROMEDIO POR AREA DEL COLEGIO /// 

                    $asignatura = Asignatura::find()->where(['id' =>Yii::$app->request->get('asignatura')])->one();

                    $suma_area = Promedioarea::find()
                                    ->select(['ROUND(SUM(DISTINCT promedio_grado),1) as promedio_grado'])
                                    ->where(['area' => $asignatura->area])
                                    ->andWhere(['periodo' => $periodo->actual->id])
                                    ->groupBy(['area'])
                                    ->one();

                    $total_grados = Asignatura::find()->where(['area' => $asignatura->area])->count();                                   

                    $total_area = (float)$suma_area->promedio_grado / $total_grados;

                    Promedioarea::updateAll(['promedio_area' => round($total_area,1)], ['area' => $asignatura->area, 'periodo' => $periodo->actual->id]);
                    


                } catch (\yii\db\IntegrityException $e) {
                    return $promedio->error_reporting();

                }      
            }

            return $this->redirect(['docente/index']);
        } 
        else
        {
            
            return $this->render('nivelaciones', [
                'dataProvider' => $dataProvider,
                'periodo' => $periodo,
                'periodos' => $periodos,
                'calificaciones' => $calificaciones,
                //'competencias' => $competencias,
                'seleccionmultiple' => $seleccionmultiple,
                'registros' => $registros,
                'grupo' => $grupo,
                //'fallas' => $fallas,
                'entrada' => $entrada,
                //'frd' => $frd_sede,
                //'calificacionxcompetencia' => $calificacionxcompetencia,
                'tipo_calificacion' => $tipo_calificacion,
                //'num_competencias' => $num_competencias,
                //'num_calificaciones_saber' => $num_calificaciones_saber,
                //'num_calificaciones_ser' => $num_calificaciones_ser, 
                //'por_calificaciones_saber' => $por_calificaciones_saber,
                //'por_calificaciones_ser' => $por_calificaciones_ser,
                //'psi' => $psi,
                //'num_calificaciones_psi' => $num_calificaciones_psi,
                //'por_calificaciones_psi' => $por_calificaciones_psi,
            ]);
            
        }
    } 

    public function actionArea()
    {
        $sede = Sede::find()->where(['principal' => '1'])->one();

        $periodo = new Periodo();
        
        $periodos_calificacion = Periodo::find()->select(['id'])->where(['autorizar_calificaciones' => 1]);

        $periodos = Periodo::find()->all();

        $grupo = Grupo::find()->where(['id' => Yii::$app->request->get('grupo')])->one();
        $area = Area::find()->where(['id' => Yii::$app->request->get('area')])->one(); 
        
        $entrada = $sede->entrada;

        if($grupo->sedes->autorizar_calificaciones == 0) {
            throw new NotFoundHttpException('Las calificaciones están inactivas por el momento.');
        }    

        
        //echo $query->createCommand()->sql;

        //echo $query->createCommand()->getRawSql(); // Mostrar SQL   

        $tipo_calificacion = $grupo->grados->tipo_calificacion;
        //$calificacionxcompetencia = $grupo->grados->calificacionxcompetencia;
        //$frd_sede = $grupo->sedes->frd;

        //$num_competencias = Competencia::find()->where(['asignatura' => Yii::$app->request->get('asignatura')])->andWhere(['periodo' => $periodo->actual->id])->count(); 

        //$num_calificaciones_saber = $calificacionxcompetencia == 1 ? $asignatura->num_calificaciones_saber : $num_competencias;
        //$num_calificaciones_ser = $asignatura->num_calificaciones_ser;
        //$por_calificaciones_saber = $asignatura->por_calificaciones_saber;
        //$por_calificaciones_ser = $asignatura->por_calificaciones_ser; 
        //$por_calificaciones_psi = $asignatura->por_calificaciones_psi; 
        //$num_calificaciones_psi = $grupo->sedes->num_calificaciones_psi;


        /*if($asignatura->especialidad == 1)
        {*/
            $academicos = Academico::find()->select(['tercero.id'])->joinWith(['estudiantes'])->where(['<', 'tercero.estado', 3])->andWhere(['academico.grupo' => Yii::$app->request->get('grupo')])->all();  
       /* }
        else
        {
            $academicos = Academico::find()->select(['tercero.id'])->joinWith(['estudiantes'])->where(['<', 'tercero.estado', 3])->andWhere(['academico.grupo' => Yii::$app->request->get('grupo')])->andWhere(['academico.especialidad' => $asignatura->especialidad])->all();     
        } */

        foreach ($academicos as $estudiante) {
            foreach ($periodos as $p) 
            {
                $promedio = Promedioarea::find()
                ->where(['estudiante' => $estudiante->id])
                ->andWhere(['grupo' => $grupo->id])
                ->andWhere(['grado' => $grupo->grado])
                ->andWhere(['area' => $area->id])
                ->andWhere(['periodo' => $p->id])
                ->one();

                if(!isset($promedio))  /// NUEVO REGISTRO
                {                     
                    //$model= new Calificacion;
                    $model = new Promedioarea();
                    $model->estudiante = $estudiante->id;
                    $model->area = $area->id;
                    $model->grado = $grupo->grado;
                    $model->grupo = $grupo->id;
                    $model->periodo = $p->id;
                    $model->save();
                }

                
            }
        }
        
        if($tipo_calificacion == 1) // TIPO CALIFICACION LETRAS
        { 
            //$desempeno = explode(",", "S,A,B");

            $desempeno = Desempeno::find()->select(['nota'])->where(['tipo_calificacion' =>$tipo_calificacion])->andWhere(['perdido' => '0'])->asArray();
            

            $query = Promedioarea::find()->joinWith(['estudiantes'])
                ->where(['<', 'tercero.estado', 3])
                ->andWhere(['grupo' => $grupo->id])
                ->andWhere(['area' => $area->id])
                ->andWhere(['IN', 'periodo', $periodos_calificacion])
                //->andWhere(['NOT IN', 'definitiva_periodo', ["A","S","B"]])
                //->andWhere(['NOT IN', 'definitiva_periodo', $desempeno])
                ->groupBy(['estudiante'])
                ->orderBy('tercero.primer_apellido'); 

            //echo $query->createCommand()->getRawSql(); // Mostrar SQL   

        }

        //echo $query->createCommand()->getRawSql(); // Mostrar SQL   


        $dataProvider = new ActiveDataProvider([
            'query' => $query,
            'pagination' => [
                'pageSize' => 500,
            ],
        ]);
        
        $registros = Promedioarea::find()->where(['grupo' => $grupo->id])->andWhere(['area' => $area->id])->andWhere(['IN', 'periodo', $periodos_calificacion])->count();


        $count = count(Yii::$app->request->post('Calificacion', []));

       
        $seleccionmultiple = new Seleccionmultiple();
        
        if($tipo_calificacion == 1) // TIPO CALIFICACION LETRAS
        { 
            $calificaciones = Promedioarea::find()->joinWith(['estudiantes'])
                ->where(['<', 'tercero.estado', 3])
                ->andWhere(['grupo' => $grupo->id])
                ->andWhere(['area' => $area->id])
                ->andWhere(['IN', 'periodo', $periodos_calificacion->select(['id'])])
                ->groupBy(['estudiante'])
                ->orderBy('tercero.primer_apellido')
                ->all(); 
        }
        
        if (Model::loadMultiple($calificaciones, Yii::$app->request->post()))  // LA VALIDACION EN EL CONTROLLER DE CALIFICACION Y COEVALUACION GENERA CONFLICTO, SOLO EN LA VISTA LA VALIDACION   
        {

            foreach($calificaciones as $calificacion) 
            {                
                foreach ($periodos as $p)     
                {   
                    $promedioarea = Promedioarea::find()->where(['id' => $calificacion->nota_id[$p->id]])->one();
                    $promedioarea->promedio_estudiante = $calificacion->promedio_estudiante[$p->id];
                    $promedioarea->update();
            
                    Yii::$app->session->addFlash('mensaje', [
                        'tipo' => 'success',
                        'titulo' => 'Calificación de Áreas Almacenadas',
                        'icono' => 'fa fa-check-square-o',
                        'mensaje' => 'La nivelación de '.$calificacion->estudiantes->nombre.' se almacenó con éxito en el sistema',
                    ]);
                    
                }  
            }

            return $this->redirect(['docente/index']);
        } 
        else
        {
            
            return $this->render('areas', [
                'dataProvider' => $dataProvider,
                'periodo' => $periodo,
                'periodos' => $periodos,
                'calificaciones' => $calificaciones,
                //'competencias' => $competencias,
                'seleccionmultiple' => $seleccionmultiple,
                'registros' => $registros,
                'grupo' => $grupo,
                'grado' => $grupo->grado,
                'area' => $area->id,
                //'fallas' => $fallas,
                'entrada' => $entrada,
                //'frd' => $frd_sede,
                //'calificacionxcompetencia' => $calificacionxcompetencia,
                'tipo_calificacion' => $tipo_calificacion,
                //'num_competencias' => $num_competencias,
                //'num_calificaciones_saber' => $num_calificaciones_saber,
                //'num_calificaciones_ser' => $num_calificaciones_ser, 
                //'por_calificaciones_saber' => $por_calificaciones_saber,
                //'por_calificaciones_ser' => $por_calificaciones_ser,
                //'psi' => $psi,
                //'num_calificaciones_psi' => $num_calificaciones_psi,
                //'por_calificaciones_psi' => $por_calificaciones_psi,
            ]);
            
        }
    } 

    

    public function actionCambiargrupo($tercero, $grupo_new, $grupo_old)
    {
        if(Calificacion::updateAll(['grupo' => $grupo_new], ['grupo' => $grupo_old, 'estudiante' => $tercero]))
        {
            return true;
        }
        else
        {
            return false;
        }    
    }

    public function actionTraslado($tercero = null)
    {
        
        if($tercero == null)
        {
            $tercero = new TerceroForm();
            $model = new Tercero();
            
            if ($model->load(Yii::$app->request->post())) {
                
                $model = Tercero::findOne($model->primer_nombre);
                $periodo = new Periodo();

                $dataProvider = new ActiveDataProvider([
                    'query' => Asignatura::find()->where(['grado' => $model->academico->grupos->grado])->andWhere(['especialidad' => $model->academico->especialidad])->andWhere(['eliminado_por' => '0']),
                    'pagination' => [
                        'pageSize' => 30,
                    ],
                ]);

                return $this->render('traslado', [
                    'dataProvider' => $dataProvider,
                    'model' => $model,
                    'periodo' => $periodo,
                ]);
            }
            else
            {
                return $this->render('lanzador', [
                    'model' => $model,
                    'tercero' => $tercero,
                ]);
            }
        }
        else
        {
            $model = Tercero::findOne($tercero);
            $periodo = new Periodo();

            $dataProvider = new ActiveDataProvider([
                'query' => Asignatura::find()->where(['grado' => $model->academico->grupos->grado])->andWhere(['especialidad' => $model->academico->especialidad])->andWhere(['eliminado_por' => '0']),
                'pagination' => [
                    'pageSize' => 30,
                ],
            ]);

            return $this->render('traslado', [
                'dataProvider' => $dataProvider,
                'model' => $model,
                'periodo' => $periodo,
            ]);
        }

    }

    protected function findModel($id)
    {
        if (($model = Calificacion::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }
}
