<?php

namespace backend\controllers;

use Yii;
use backend\models\Calificacion;
use backend\models\Calificacioncompromisos;
use backend\models\Compromisosacudiente;
use backend\models\Seleccionmultiple;
use backend\models\Periodo;
use backend\models\Academico;
use backend\models\Grupo;
use backend\models\Tercero;
use backend\models\Sede;


use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\data\ActiveDataProvider;
use yii\base\Model;


/**
 * CalificacionController implements the CRUD actions for Calificacion model.
 */
class CalificacioncompromisosController extends Controller
{
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['post'],
                ],
            ],
        ];
    }

    /**
     * Lists all Calificacioncompromisos models.
     * @return mixed
     */
    public function actionIndex()
    {
        
        $sede = Sede::findOne(1);

        if ($sede->compromiso_acudiente == '') 
        {
        
            return $this->redirect(['/compromisosacudiente/activar', 'id' => $sede->id]);
        }
        else
        {
            return $this->redirect(['/docente/index']); 
        }    
        
    }

    public function actionCalificaciones()
    {
        if(!Yii::$app->request->get('periodo'))
        {
            $periodo = new Periodo();
            $periodo = $periodo->actual->id;    
        }
        else
        {
            $periodo = Yii::$app->request->get('periodo');
        }  

        $total_compromisos = Compromisosacudiente::find()->count();   

        $grupo = Grupo::find()->where(['id' => Yii::$app->request->get('grupo')])->one();
        
        $query = Academico::find()->select(['tercero.id', 'academico.estudiante', 'academico.grupo'])->joinWith(['estudiantes'])->where(['<', 'tercero.estado', 3])->andWhere(['academico.grupo' => Yii::$app->request->get('grupo')])->orderBy('primer_apellido');  

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
            'pagination' => [
                'pageSize' => 500,
            ],
        ]);
        

        $registros = Calificacioncompromisos::find()->where(['grupo' => Yii::$app->request->get('grupo')])->andWhere(['periodo' => $periodo])->count();
        
        $count = count(Yii::$app->request->post('Calificacioncompromisos', []));
        
        $tipo_calificacion = $grupo->grados->tipo_calificacion;
        $calificacionxcompetencia = $grupo->grados->calificacionxcompetencia;
        

        $calificacioncompromisos = [new Calificacioncompromisos()]; 

        $seleccionmultiple = new Seleccionmultiple();


        for($i = 1; $i < $count; $i++) {

            $calificacioncompromisos[] = new Calificacioncompromisos();
        }

        if (Model::loadMultiple($calificacioncompromisos, Yii::$app->request->post())) 
            //&& Model::validateMultiple($calificacioncompromisos))  // LA VALIDACION EN EL CONTROLLER DE CALIFICACION Y COEVALUACION GENERA CONFLICTO, SOLO EN LA VISTA LA VALIDACION   
        {

            foreach ($calificacioncompromisos as $calificacion) {
                

                $reg = Calificacioncompromisos::find()->select(['id'])->where(['estudiante' => $calificacion->estudiante])->andWhere(['grupo' => $calificacion->grupo, 'periodo' => $periodo])->one();
                $estudiante = Tercero::find()->where(['id' => $calificacion->estudiante])->one();


                if(!isset($reg))
                {   
                    
                    $model= new Calificacioncompromisos;
                    
                    $model->valoracion = implode(",", $calificacion->valoracion);
                    $model->docente = $calificacion->docente;
                    $model->estudiante = $calificacion->estudiante;
                    $model->grupo = $calificacion->grupo;
                    $model->periodo = $calificacion->periodo;
                        
                        if($model->save(false))
                        {
                            Yii::$app->session->addFlash('mensaje', [
                                'tipo' => 'success',
                                'titulo' => 'Calificaciones Almacenadas',
                                'icono' => 'fa fa-check-square-o',
                                'mensaje' => 'Las calificaciones de '.$estudiante->nombre.' se almacenaron con éxito en el sistema',
                            ]);  
                        } 
                        else
                        {
                            Yii::$app->session->addFlash('mensaje', [
                                'tipo' => 'danger',
                                'titulo' => 'Calificaciones Almacenadas',
                                'icono' => 'fa fa-check-square-o',
                                'mensaje' => 'Las calificaciones de '.$estudiante->nombre.' no se almacenaron en el sistema',
                            ]);
                        }
                }
                else
                {  
                    $model= Calificacioncompromisos::find()->where(['id' => $reg->id])->one();
                    $model->valoracion = implode(",", $calificacion->valoracion);
                    
                        if($model->update(false))
                        {
                            Yii::$app->session->addFlash('mensaje', [
                                'tipo' => 'success',
                                'titulo' => 'Calificaciones Almacenadas',
                                'icono' => 'fa fa-check-square-o',
                                'mensaje' => 'Las calificaciones de '.$estudiante->nombre.' se almacenaron con éxito en el sistema',
                            ]);  
                        } 
                        else
                        {
                            Yii::$app->session->addFlash('mensaje', [
                                'tipo' => 'info',
                                'titulo' => 'No hubo cambios!',
                                'icono' => 'fa fa-check-square-o',
                                'mensaje' => 'No hubo cambios en las calificaciones de '.$estudiante->nombre.' por eso no se actualizaron en el sistema',
                            ]);
                        }
                    
                }    
            }
            return $this->redirect(['docente/index']);
            
        }
        else
        {

            return $this->render('calificaciones', [
                'dataProvider' => $dataProvider,
                'periodo' => $periodo,
                'calificacioncompromisos' => $calificacioncompromisos,
                'seleccionmultiple' => $seleccionmultiple,
                'registros' => $registros,
                'grupo' => $grupo,
                'tipo_calificacion' => $tipo_calificacion,
                'calificacionxcompetencia' => $calificacionxcompetencia, 
                'total_compromisos' => $total_compromisos,
            ]);
        }
    } 


    public function actionView($id)
    {
        $model = $this->findModel($id);
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new Calificacion model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new Calificacion();

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->id]);
        } else {
            return $this->render('create', [
                'model' => $model,
            ]);
        }
    }

    /**
     * Updates an existing Calificacion model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->id]);
        } else {
            return $this->render('update', [
                'model' => $model,
            ]);
        }
    }

    /**
     * Deletes an existing Calificacion model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     */
    public function actionDelete($id)
    {
        //$this->findModel($id)->deleteWithRelated();

        $model = $this->findModel($id);
        $model->eliminado_por = \Yii::$app->user->id;
        $model->eliminado_el = new \yii\db\Expression('NOW()');
        $model->update();

        return $this->redirect(['index']);
    }

    public function actionRestore($id)
    {
        $this->findModel($id)->restoreWithRelated();

        return $this->redirect(['index']);
    }



    protected function findModel($id)
    {
        if (($model = Calificacioncompromisos::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }
}
