<?php

namespace backend\controllers;

use Yii;
use backend\models\Campana;
use backend\models\Grado;
use backend\models\Grupo;

use backend\models\Campanaitem;
use backend\models\Campanavoto;
use backend\models\CampanaSearch;
use backend\models\base\Upload;

use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\data\SqlDataProvider;

class CampanaController extends Controller
{
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['post'],
                ],
            ],
        ];
    }

    public function actionIndex()
    {
        $searchModel = new CampanaSearch();
        $searchModel->eliminado_por = '0';

        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }


    public function actionView($id)
    {
        $model = $this->findModel($id);
        $providerCampanaItem = new \yii\data\ArrayDataProvider([
            'allModels' => $model->items,
        ]);
        $providerCampanaVoto = new \yii\data\ArrayDataProvider([
            'allModels' => $model->votos,
        ]);
        return $this->render('view', [
            'model' => $this->findModel($id),
            'providerCampanaItem' => $providerCampanaItem,
            'providerCampanaVoto' => $providerCampanaVoto,
        ]);
    }

    public function actionVotos($id)
    {
        $model = $this->findModel($id);

        $query = "SELECT concat (tercero.primer_nombre,' ',tercero.primer_apellido) as nombre, count(campana_voto.id) as votos
                  FROM campana_item 
                  LEFT OUTER JOIN campana_voto ON campana_item.id = campana_voto.item  
                  LEFT OUTER JOIN tercero ON tercero.id = campana_item.tercero
                  WHERE campana_item.campana = ".$id." GROUP BY campana_voto.item";

        $votos = Campanaitem::findbySql($query)->asArray()->all();

        return $this->renderAjax('votos', [
            'model' => $model,
            'votos' => $votos,
        ]);
    }




    public function actionCreate()
    {
        $model = new Campana();

        if ($model->load(Yii::$app->request->post())) {

            if(($model->tipo == 4) or ($model->tipo == 5))
            {
                if($model->tipo == 4)
                {
                    foreach ($model->grado as $grado)
                    {
                        $campana = new Campana();
                        $campana->campana = $model->campana;
                        $campana->tipo = $model->tipo;
                        $campana->grado = $grado;
                        $campana->fecha_inicio = $model->fecha_inicio;
                        $campana->fecha_fin = $model->fecha_fin;
                        $campana->estado = $model->estado;
                        $campana->save(false);
                    }

                }

                if($model->tipo == 5)
                {
                    foreach ($model->grupo as $grupo)
                    {
                        $campana = new Campana();
                        $campana->campana = $model->campana;
                        $campana->tipo = $model->tipo;
                        $campana->grupo = $grupo;
                        $campana->fecha_inicio = $model->fecha_inicio;
                        $campana->fecha_fin = $model->fecha_fin;
                        $campana->estado = $model->estado;
                        $campana->save(false);
                    }
                }
            }
            else
            {
                $campana = new Campana();
                $campana->campana = $model->campana;
                $campana->tipo = $model->tipo;
                $campana->fecha_inicio = $model->fecha_inicio;
                $campana->fecha_fin = $model->fecha_fin;
                $campana->estado = $model->estado;
                $campana->save(false);
            }

            return $this->redirect(['index']);
        } else {
            return $this->render('create', [
                'model' => $model,
            ]);
        }
    }


    public function actionUpdate($id)
    {
        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->id]);
        } else {
            return $this->render('update', [
                'model' => $model,
            ]);
        }
    }

    
    public function actionVotar($id)
    {
        $model = Campana::findOne($id);
        $voto =  CampanaVoto::find()->where(['campana' => $id])->andWhere(['tercero' => Yii::$app->session->get('__tercero')])->andWhere(['estado' => '1'])->andWhere(['eliminado_por' => '0'])->count();

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['campana/index']);
        } 
        else
        {

            if(count($model->items) == 0)
            {
                return '<center><h4>No hay candidatos aún!</h4></center>';

            }
            else 
            {
                return $this->renderAjax('votar', [
                            'model' => $model,
                            'voto' => $voto,
                        ]);
            }
        }
    }

    public function actionDelete($id)
    {
        //$this->findModel($id)->deleteWithRelated();

        $model = $this->findModel($id);
        $model->eliminado_por = \Yii::$app->user->id;
        $model->eliminado_el = new \yii\db\Expression('NOW()');
        $model->update();

        return $this->redirect(['index']);
    }
    

    public function actionPdf() {
        
        $campanas = Campana::find()->where(['eliminado_por' => 0])->all();
        
        $content = $this->renderAjax('_pdf', [
            'campanas' => $campanas,
        ]);

        $pdf = new \kartik\mpdf\Pdf([
            'mode' => \kartik\mpdf\Pdf::MODE_CORE,
            'format' => \kartik\mpdf\Pdf::FORMAT_A4,
            'orientation' => \kartik\mpdf\Pdf::ORIENT_PORTRAIT,
            'destination' => \kartik\mpdf\Pdf::DEST_BROWSER,
            'content' => $content,
            'cssFile' => '@vendor/kartik-v/yii2-mpdf/src/assets/kv-mpdf-bootstrap.min.css',
            'cssInline' => 'h4 {font-size:12px;color: #ff0000;}',
            'options' => ['title' => \Yii::$app->name],
            'methods' => [
                'SetHeader' => [\Yii::$app->name],
                'SetFooter' => ['{PAGENO}'],
            ]
        ]);

        return $pdf->render();
    }


    protected function findModel($id)
    {
        if (($model = Campana::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException(Yii::t('app', 'The requested page does not exist.'));
        }
    }
    

    public function actionAddCampanaItem()
    {
        if (Yii::$app->request->isAjax) {
            $row = Yii::$app->request->post('CampanaItem');
            if (!empty($row)) {
                $row = array_values($row);
            }
            if((Yii::$app->request->post('isNewRecord') && Yii::$app->request->post('_action') == 'load' && empty($row)) || Yii::$app->request->post('_action') == 'add')
                $row[] = [];
            return $this->renderAjax('_formCampanaItem', ['row' => $row]);
        } else {
            throw new NotFoundHttpException(Yii::t('app', 'The requested page does not exist.'));
        }
    }
    

    public function actionAddCampanaVoto()
    {
        if (Yii::$app->request->isAjax) {
            $row = Yii::$app->request->post('CampanaVoto');
            if (!empty($row)) {
                $row = array_values($row);
            }
            if((Yii::$app->request->post('isNewRecord') && Yii::$app->request->post('_action') == 'load' && empty($row)) || Yii::$app->request->post('_action') == 'add')
                $row[] = [];
            return $this->renderAjax('_formCampanaVoto', ['row' => $row]);
        } else {
            throw new NotFoundHttpException(Yii::t('app', 'The requested page does not exist.'));
        }
    }
}
