<?php

namespace backend\controllers;

use Yii;
use backend\models\Campanaitem;
use backend\models\Tercero;
use backend\models\Campana;
use backend\models\CampanaitemSearch;

use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;

use backend\models\base\Upload;
use yii\web\UploadedFile;
use yii\imagine\Image;
use Imagine\Image\Box;  


/**
 * CampanaitemController implements the CRUD actions for Campanaitem model.
 */
class CampanaitemController extends Controller
{
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['post'],
                ],
            ],
        ];
    }

    /**
     * Lists all Campanaitem models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new CampanaitemSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single Campanaitem model.
     * @param integer $id
     * @return mixed
     */
    public function actionView($id)
    {
        $model = $this->findModel($id);
        $providerCampanaVoto = new \yii\data\ArrayDataProvider([
            'allModels' => $model->campanaVotos,
        ]);
        return $this->render('view', [
            'model' => $this->findModel($id),
            'providerCampanaVoto' => $providerCampanaVoto,
        ]);
    }


    public function actionCreate($campana = null)
    {
        $model = new Campanaitem();
        $model->campana = $campana;

        $campana = Campana::findOne($campana);

        $tercero = new Tercero();

            if ($model->load(Yii::$app->request->post())) 
            {
                
                if($foto = UploadedFile::getInstance($model,'foto'))
                {

                    $file = rand(10,100).'-'.str_replace(' ','-',$foto);
                    $foto->saveAs( 'uploads/'.$file);
                    //Image::thumbnail('uploads/'.$foto->name, 120, 120)->save('uploads/'.$foto->name, ['quality' => 80]);

                    Image::getImagine()->open('uploads/'.$file)->thumbnail(new Box(120, 120))->save('uploads/thumbnail/sm-'.$file , ['quality' => 80]);
                    Image::getImagine()->open('uploads/'.$file)->thumbnail(new Box(360, 360))->save('uploads/thumbnail/lg-'.$file , ['quality' => 80]);

                    //save the path in DB..
                    $model->foto = $file;
                    unlink('uploads/'.$file);
                }

                /*
                $adjuntos = [];
                    
                foreach (UploadedFile::getInstances($model, 'adjunto') as $adjunto) {
                    list($drive) = Yii::$app->createController('drive');
                    $adjuntos[] =  serialize($drive->actionSubir(Yii::$app->params['drive-planesaula'], $adjunto));
                }

                $model->adjunto = implode(',',$adjuntos);  */

                
                if($adjunto = UploadedFile::getInstance($model,'adjunto'))
                {

                    $s3 = Yii::$app->get('s3');  

                    $id = $campana->id;  

                    if(!$s3->exist('campana/'.$id.'/'))
                    {
                        $s3->put('campana/'.$id.'/', null); 
                    }

                    /*if(!$s3->exist('planesaula/'.$id.'/'.Yii::$app->session->get('__tercero').'/'))
                    {
                        $s3->put('planesaula/'.$id.'/'.Yii::$app->session->get('__tercero').'/', null);    
                    }*/

                    $body = file_get_contents($adjunto->tempName);
                    $model->adjunto = $s3->put('campana/'.$id.'/'.$adjunto->name, $body);

                }
                
                $model->save();

                return $this->redirect(['campana/index']);
            } 
            else
            {
                return $this->renderAjax('create', [
                            'model' => $model,
                            'campana' => $campana,
                            'tercero' => $tercero,
                        ]);
                        
            }
    }

    
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->id]);
        } else {
            return $this->render('update', [
                'model' => $model,
            ]);
        }
    }

    /**
     * Deletes an existing Campanaitem model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     */
    public function actionDelete($id)
    {
        //$this->findModel($id)->deleteWithRelated();

        $model = $this->findModel($id);
        $model->eliminado_por = \Yii::$app->user->id;
        $model->eliminado_el = new \yii\db\Expression('NOW()');
        $model->update();

        return $this->redirect(['index']);
    }

    
    /**
     * Finds the Campanaitem model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Campanaitem the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Campanaitem::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException(Yii::t('app', 'The requested page does not exist.'));
        }
    }
    
    /**
    * Action to load a tabular form grid
    * for CampanaVoto
    * @author Yohanes Candrajaya <moo.tensai@gmail.com>
    * @author Jiwantoro Ndaru <jiwanndaru@gmail.com>
    *
    * @return mixed
    */
    public function actionAddCampanaVoto()
    {
        if (Yii::$app->request->isAjax) {
            $row = Yii::$app->request->post('CampanaVoto');
            if (!empty($row)) {
                $row = array_values($row);
            }
            if((Yii::$app->request->post('isNewRecord') && Yii::$app->request->post('_action') == 'load' && empty($row)) || Yii::$app->request->post('_action') == 'add')
                $row[] = [];
            return $this->renderAjax('_formCampanaVoto', ['row' => $row]);
        } else {
            throw new NotFoundHttpException(Yii::t('app', 'The requested page does not exist.'));
        }
    }
}
