<?php

namespace backend\controllers;

use Yii;
use backend\models\Carga;
use backend\models\Asignatura;
use backend\models\LanzadorCargaForm;
use yii\widgets\ActiveForm;
use yii\web\Response;


use backend\models\CargaSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;


/**
 * CargaController implements the CRUD actions for Carga model.
 */
class CargaController extends Controller
{
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['post'],
                ],
            ],
        ];
    }

    /**
     * Lists all Carga models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new CargaSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single Carga model.
     * @param integer $id
     * @return mixed
     */
    public function actionView($id)
    {
        $model = $this->findModel($id);
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    
    public function actionCreate($docente = NULL)
    {

        Yii::$app->session->remove('__docente');

            $lanzador = new LanzadorCargaForm();

            if (Yii::$app->request->isAjax && $lanzador->load(Yii::$app->request->post())) {
                Yii::$app->response->format = Response::FORMAT_JSON;
                return ActiveForm::validate($lanzador);
            }

            if ($lanzador->load(Yii::$app->request->post())) 
            {
                Yii::$app->session->set('__docente', $lanzador->docente);
                return $this->redirect('asignar');
            }    
            else
            {
                return $this->render('lanzador', [
                        'model' => $lanzador,
                    ]);

                exit;
            }     
    }


    public function actionAsignar()
    {  
        $model = new Carga();
        $model->docente = Yii::$app->session->get('__docente');
        $cargas = Carga::find()->where(['docente' => Yii::$app->session->get('__docente')])->andWhere(['eliminado_por' => '0'])->all();

        if ($model->load(Yii::$app->request->post()) && $model->save()) {

            $carga = new Carga();
            $carga->docente = Yii::$app->session->get('__docente');
            $carga->sede = $model->grupos->sede;
            $carga->grado = $model->grupos->grado;
            $carga->grupo = $model->grupo;

            $cargas = Carga::find()->where(['docente' => Yii::$app->session->get('__docente')])->andWhere(['eliminado_por' => '0'])->all();
            
            return $this->render('asignar', [
                'model' => $carga,
                'cargas' => $cargas,
            ]);
        } 
        else 
        {
            return $this->render('asignar', [
                'model' => $model,
                'cargas' => $cargas,
            ]);
        } 
    }


     public function actionFindasignaturas() {
    
        $out = [];
        if (isset($_POST['depdrop_parents'])) {
            $parents = $_POST['depdrop_parents'];
            if ($parents != null) {
                $grupo_id = $parents[0];
                $out=Asignatura::getAsignaturasbyGrupo($grupo_id);
                
                return json_encode(['output'=>$out, 'selected'=>'']);
            }
        }
        return json_encode(['output'=>'', 'selected'=>'']);
    }

    /**
     * Updates an existing Carga model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);
        $cargas = Carga::find()->where(['docente' => $model->docente])->andWhere(['eliminado_por' => '0'])->all();

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['update', 'id' => $model->id]);
        } else {
            return $this->render('update', [
                'model' => $model,
                'cargas' => $cargas
            ]);
        }
    }

    /**
     * Deletes an existing Carga model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     */
    public function actionDelete($id)
    {
        //$this->findModel($id)->deleteWithRelated();

        $model = $this->findModel($id);
        $model->eliminado_por = \Yii::$app->user->id;
        $model->eliminado_el = new \yii\db\Expression('NOW()');
        $model->update();

        if(Yii::$app->session->get('__docente'))
        {
            $model = new Carga();
            $model->docente = Yii::$app->session->get('__docente');
            
            $cargas = Carga::find()->where(['docente' => Yii::$app->session->get('__docente')])->andWhere(['eliminado_por' => '0'])->all();
            
            return $this->render('asignar', [
                'model' => $model,
                'cargas' => $cargas,
            ]);
        }
        else
        {
            return $this->redirect(['index']);    
        }

        
    }

    public function actionRestore($id)
    {
        $this->findModel($id)->restoreWithRelated();

        return $this->redirect(['index']);
    }

    public function actionEliminar($id)
    {
        //$this->findModel($id)->deleteWithRelated();

        $model = $this->findModel($id);
        $model->eliminado_por = \Yii::$app->user->id;
        $model->eliminado_el = new \yii\db\Expression('NOW()');
        $model->update();

        return $this->redirect(['index']);
    }
    
    /**
     * 
     * for export pdf at actionView
     *  
     * @param type $id
     * @return type
     */
    public function actionPdf($id) {
        $model = $this->findModel($id);

        $content = $this->renderAjax('_pdf', [
            'model' => $model,
        ]);

        $pdf = new \kartik\mpdf\Pdf([
            'mode' => \kartik\mpdf\Pdf::MODE_CORE,
            'format' => \kartik\mpdf\Pdf::FORMAT_A4,
            'orientation' => \kartik\mpdf\Pdf::ORIENT_PORTRAIT,
            'destination' => \kartik\mpdf\Pdf::DEST_BROWSER,
            'content' => $content,
            'cssFile' => '@vendor/kartik-v/yii2-mpdf/assets/kv-mpdf-bootstrap.min.css',
            'cssInline' => '.kv-heading-1{font-size:18px}',
            'options' => ['title' => \Yii::$app->name],
            'methods' => [
                'SetHeader' => [\Yii::$app->name],
                'SetFooter' => ['{PAGENO}'],
            ]
        ]);

        return $pdf->render();
    }
    
    
    protected function findModel($id)
    {
        if (($model = Carga::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }
}
