<?php

namespace backend\controllers;

use Yii;
use backend\models\Competencia;
use backend\models\CompetenciaSearch;
use backend\models\Asignatura;
use backend\models\Frd;

use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\data\ActiveDataProvider;
use yii\filters\VerbFilter;
use yii\web\Response;
use yii\helpers\Json;
use yii\widgets\ActiveForm;


/**
 * CompetenciaController implements the CRUD actions for Competencia model.
 */
class CompetenciaController extends Controller
{
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['post'],
                ],
            ],
        ];
    }

    /**
     * Lists all Competencia models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new CompetenciaSearch();

        if(Yii::$app->session->get('__tipo') == 2)
        {
            //$searchModel->creado_por = Yii::$app->session->get('__id');
        }
/*
        if(Yii::$app->session->get('__tipo') == 2)
        {
            $asignaturas = \backend\models\Carga::find()->select(['asignatura.id as id', 'concat(asignatura.asignatura, " - " , grado.grado) as asignatura'])->joinWith(['asignaturas', 'asignaturas.grados'])->where(['docente' => Yii::$app->session->get('__tercero')])->asArray()->all();
        }
*/
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    public function actionView($id)
    {
        $model = $this->findModel($id);

        return $this->render('view', [
            'model' => $this->findModel($id),
            'providerFrd' => $providerFrd,
            'providerNivel' => $providerNivel,
        ]); 
    } 

    public function actionCreate()
    {

        $model = new Competencia();
        
        if (Yii::$app->request->isAjax && $model->load(Yii::$app->request->post())) {
            Yii::$app->response->format = Response::FORMAT_JSON;
            return ActiveForm::validate($model);
        }

        elseif ($model->load(Yii::$app->request->post()))
        {

            if ($model->save()) 
            {
                \Yii::$app->session->addFlash('mensaje4', [
                                'tipo' => 'info',
                                'titulo' => 'Creación de Competencia',
                                'icono' => 'fa fa-user',
                                'mensaje' => 'La competencia '.$model->competencia.' se creó éxitosamente.',
                            ]);

                return $this->redirect(['update', 'id' => $model->id]);
                
            }
            else
            {
                    return $this->render('create', [
                        'model' => $model,
                    ]);
            }    
                
                
        }
        else {
            return $this->render('create', [
                'model' => $model,
            ]);
        }
    }


    public function actionUpdate($id)
    {
        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->id]);
        } else {

            $providerFrd = new \yii\data\ArrayDataProvider([
                'allModels' => $model->frds,
            ]);
            $providerNivel = new \yii\data\ArrayDataProvider([
                'allModels' => $model->nivels,
            ]);

            return $this->render('update', [
                'model' => $model,
                'providerFrd' => $providerFrd,
                'providerNivel' => $providerNivel,
            ]); 
        }
    }

    public function actionFrdbynivel($id)
    {
        $query = Frd::find()->where(['nivel' => $id])->andWhere(['eliminado_por' => 0]);

        return $query->createCommand()->getRawSql(); // 

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
            'pagination' => [
                'pageSize' => 500,
            ],
        ]);
     

        if(Yii::$app->request->isAjax)
        {
            return $this->renderAjax('_dataFrd', [
                 'dataProvider' => $dataProvider,
            ]);
            /*return Json::encode($this->renderAjax('_dataFrd', [
                 'dataProvider' => $dataProvider,
            ]));*/
        } else {
            return $this->renderPartial('/job-management/item', [
                 'dataProvider' => $dataProvider,
                 'model' => $model
            ]);
        }
    }

    public function actionDelete($id)
    {
        //$this->findModel($id)->deleteWithRelated();

        $model = $this->findModel($id);
        $model->eliminado_por = \Yii::$app->user->id;
        $model->eliminado_el = new \yii\db\Expression('NOW()');
        $model->update();

        return $this->redirect(['index']);
    }

    public function actionRestore($id)
    {
        $this->findModel($id)->restoreWithRelated();

        return $this->redirect(['index']);
    }
    
    public function actionAddCalificacionxcompetencia()
    {
        if (Yii::$app->request->isAjax) {
            $row = Yii::$app->request->post('Calificacionxcompetencia');
            if (!empty($row)) {
                $row = array_values($row);
            }
            if((Yii::$app->request->post('isNewRecord') && Yii::$app->request->post('_action') == 'load' && empty($row)) || Yii::$app->request->post('_action') == 'add')
                $row[] = [];
            return $this->renderAjax('_formCalificacionxcompetencia', ['row' => $row]);
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    } 


    public function actionAddNivel()
    {
        if (Yii::$app->request->isAjax) {
            $row = Yii::$app->request->post('Nivel');
            if (!empty($row)) {
                $row = array_values($row);
            }
            if((Yii::$app->request->post('isNewRecord') && Yii::$app->request->post('_action') == 'load' && empty($row)) || Yii::$app->request->post('_action') == 'add')
                $row[] = [];
            
            return $this->renderAjax('_formNivel', [
                    'row' => $row,
                    'grado' => Yii::$app->request->post('grado'), 
                ]);
        } else {
            throw new NotFoundHttpException(Yii::t('app', 'The requested page does not exist.'));
        }
    } 


    public function actionAddFrd()
    {
        if (Yii::$app->request->isAjax) {
            $row = Yii::$app->request->post('Frd');
            if (!empty($row)) {
                $row = array_values($row);
            }
            if((Yii::$app->request->post('isNewRecord') && Yii::$app->request->post('_action') == 'load' && empty($row)) || Yii::$app->request->post('_action') == 'add')
                $row[] = [];
            
            //return $this->renderAjax('_formFrd', ['row' => $row]);
            //return $this->renderAjax('_formFrd', ['row' => $row]);
            //return $this->renderAjax('_formFrd', ['row' => $row, 'grado' => Yii::$app->request->post('grado'), 'competencia' => Yii::$app->request->post('competencia'), 'nivel' => Yii::$app->request->post('nivel')]);

         
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    } 



    public function actionAddPlanAula()
    {
        if (Yii::$app->request->isAjax) {
            $row = Yii::$app->request->post('PlanAula');
            if (!empty($row)) {
                $row = array_values($row);
            }
            if((Yii::$app->request->post('isNewRecord') && Yii::$app->request->post('_action') == 'load' && empty($row)) || Yii::$app->request->post('_action') == 'add')
                $row[] = [];
            return $this->renderAjax('_formPlanAula', ['row' => $row]);
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }

    public function actionAddPlanMejoramiento()
    {
        if (Yii::$app->request->isAjax) {
            $row = Yii::$app->request->post('PlanMejoramiento');
            if (!empty($row)) {
                $row = array_values($row);
            }
            if((Yii::$app->request->post('isNewRecord') && Yii::$app->request->post('_action') == 'load' && empty($row)) || Yii::$app->request->post('_action') == 'add')
                $row[] = [];
            return $this->renderAjax('_formPlanMejoramiento', ['row' => $row]);
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }  

     public function actionFindasignaturas() {
    
        $out = [];
        if (isset($_POST['depdrop_parents'])) {
            $parents = $_POST['depdrop_parents'];
            if ($parents != null) {
                $grado_id = $parents[0];
                $out=Asignatura::getAsignaturasbyGrado($grado_id);
                
                return json_encode(['output'=>$out, 'selected'=>'']);
            }
        }
        return json_encode(['output'=>'', 'selected'=>'']);
    }

    public function findUserModel($id)
    {
        if (($model = Competencia::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }

    protected function findModel($id)
    {
        if (($model = Competencia::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }

}
