<?php

namespace backend\controllers;

use Yii;
use backend\models\Comportamiento;
use backend\models\Comportamientocalificaciones;
use backend\models\Comportamientoestudiante;
use backend\models\Calificacionobservacionesgenerales;
use backend\models\Seleccionmultiple;
use backend\models\Periodo;
use backend\models\Academico;
use backend\models\Grupo;
use backend\models\Tercero;
use backend\models\Desempeno;
use backend\models\Observaciongeneral;


use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\data\ActiveDataProvider;
use yii\base\Model;
use yii\helpers\Html;



/**
 * CalificacionController implements the CRUD actions for Calificacion model.
 */
class ComportamientoController extends Controller
{
    public $actions;

    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['post'],
                ],
            ],
        ];
    }

  

    public function actionCalificaciones()
    {

        $periodo = new Periodo();
        
        $grupo = Grupo::find()->where(['id' => Yii::$app->request->get('grupo')])->one();

        $entrada = $grupo->sedes->entrada;
        $fallas = $grupo->sedes->fallas;
        $observacion_general = $grupo->sedes->observaciones_generales;
        $observacion_especifica = $grupo->sedes->observaciones_especificas;




        if($grupo->sedes->autorizar_calificaciones == 0) {
            throw new NotFoundHttpException('Las calificaciones están inactivas por el momento.');
        }

        if($grupo->sedes->activar_comportamiento == 0) {
            throw new NotFoundHttpException('Las calificaciones del comportamiento están inactivas por el momento.');
        }

        $query = Academico::find()->select(['tercero.id', 'academico.estudiante', 'academico.grupo'])->joinWith(['estudiantes'])->where(['<', 'tercero.estado', 3])->andWhere(['academico.grupo' => Yii::$app->request->get('grupo')])->orderBy('primer_apellido');

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
            'pagination' => [
                'pageSize' => 500,
            ],
        ]);
   


        $registros = Comportamiento::find()->where(['grupo' => Yii::$app->request->get('grupo')])->andWhere(['periodo' => $periodo->actual->id])->count();

        $count = count(Yii::$app->request->post('Comportamiento', []));
        
        $tipo_calificacion = $grupo->grados->tipo_calificacion;
        $calificacionxcompetencia = $grupo->grados->calificacionxcompetencia;
        //$tipo_calificacion = $grupo->sedes->tipo_calificacion;
        $ver_nota = $grupo->sedes->ver_comportamiento_nota;



        $num_comportamientos = Comportamientoestudiante::find()->where(['eliminado_por' => '0'])->count();         

        if ($num_comportamientos == 0)
        {
            $error =  '<b>No hay observaciones cargadas para calificar</b>, debes cargar las observaciones de comportamiento primero para poder realizar el cargue de las calificaciones. ';
            $error .= Html::a('<i class="far fa-plus" aria-hidden="true"></i> Agregar Observaciones de Comportamiento', ['comportamientoestudiante/create'],['class' => 'btn btn-block btn-success', 'style' => 'margin-top: 20px;']);

            throw new NotFoundHttpException($error);
        } 
        else
        {
            $competencias = Comportamientoestudiante::find()->all(); 
        }   
        

        $comportamientos = [new Comportamiento()]; 

        $seleccionmultiple = new Seleccionmultiple();


        for($i = 1; $i < $count; $i++) {

            $comportamientos[] = new Comportamiento();
        }

        if (Model::loadMultiple($comportamientos, Yii::$app->request->post())) 
            //&& Model::validateMultiple($calificaciones))  // LA VALIDACION EN EL CONTROLLER DE CALIFICACION Y COEVALUACION GENERA CONFLICTO, SOLO EN LA VISTA LA VALIDACION   
        {

            foreach ($comportamientos as $comportamiento) {
                
                $reg = Comportamiento::find()->select(['id'])->where(['estudiante' => $comportamiento->estudiante])->andWhere(['grupo' => $comportamiento->grupo, 'periodo' => $periodo->actual->id])->one();
                
                $estudiante = Tercero::find()->where(['id' => $comportamiento->estudiante])->one();

                $count_reg = Comportamiento::find()->select(['id'])->where(['estudiante' => $comportamiento->estudiante])->andWhere(['grupo' => $comportamiento->grupo, 'periodo' => $periodo->actual->id])->count();
                


                if(!isset($reg))  /// NUEVO REGISTRO
                {                       
                    $model= new Comportamiento;
                    
                    if($ver_nota == 1)
                    {    
                        if($num_comportamientos > 0)
                        {
                            //$model->calificacion = implode(",", $comportamiento->calificacion);

                            $model->calificacion = implode(",", $comportamiento->calificacion);

                            //$model->definitiva = $comportamiento->definitiva;
                        }

                        if($num_comportamientos == '1')
                        {
                            $model->definitiva = implode(",", $comportamiento->calificacion);
                        }                          
                    }



                    $model->docente = $comportamiento->docente;
                    $model->estudiante = $comportamiento->estudiante;
                    $model->grupo = $comportamiento->grupo;
                    $model->periodo = $comportamiento->periodo;
                    
                    $observacion = new Observaciongeneral();

                    $model->observacion_general = $observacion->ValidarExistentes($comportamiento->observacion_general);
                    $model->observacion_especifica = $comportamiento->observacion_especifica;

                    $transaction = Yii::$app->db->beginTransaction();

                    try  {
                        if ($model->save(false)) {
                            

                            if($num_comportamientos > 0  && $ver_nota == 1)
                            {
                                $i = 1;
                                foreach ($comportamiento->calificacion as $c_saber) {
                                    $saber = new Comportamientocalificaciones();
                                    $saber->comportamiento_id = $model->id;

                                    if($tipo_calificacion == 1)
                                    {
                                        $total = Desempeno::find()->where(['nota' => $c_saber])
                                                ->andWhere(['tipo_calificacion' => $tipo_calificacion])
                                                ->count();
                                
                                        if($total > 0)
                                        {
                                            $saber->calificacion = $c_saber;
                                        }    
                                        else
                                        {
                                            if($c_saber != '')
                                            {

                                                Yii::$app->session->addFlash('mensaje', [
                                                    'tipo' => 'danger',
                                                    'titulo' => 'Error en la Nota',
                                                    'icono' => 'far info',
                                                    'mensaje' => 'La Nota <b>('.$c_saber.')</b> del estudiante <b>'.$estudiante->nombre.'</b> no exite.',
                                                ]);    
                                            }
                                            
                                            if($c_saber == '')
                                            {
                                                $saber->calificacion = $c_saber;
                                            }
                                        }
                                    }
                                    else
                                    {
                                        $saber->calificacion = $c_saber;
                                    }    
                                    

                                    $saber->docente = $model->docente;
                                    $saber->estudiante = $model->estudiante;
                                    $saber->grupo = $model->grupo;
                                    $saber->periodo = $model->periodo;

                                    //print_r($comportamiento->comportamiento);

                                    $saber->comportamiento = $comportamiento->comportamiento[$i];
                                    //echo "<br> Competencia: ".$comportamiento->comportamiento[$i];

                                    $saber->save();

                                    //var_dump($saber->errors);

                                    $i++;

                                }

                            }


                            $transaction->commit();

                            Yii::$app->session->addFlash('mensaje', [
                                'tipo' => 'success',
                                'titulo' => 'Observaciones Almacenadas',
                                'icono' => 'fa fa-check-square-o',
                                'mensaje' => 'Las observaciones al comportamiento de <b>'.$estudiante->nombre.'</b> se almacenaron con éxito en el sistema',
                            ]);

                        } else {
                            $transaction->rollBack();

                            Yii::$app->session->addFlash('mensaje', [
                                'tipo' => 'danger',
                                'titulo' => 'Observaciones No Almacenadas',
                                'icono' => 'fa fa-check-square-o',
                                'mensaje' => 'Las observaciones al comportamiento de <b>'.$estudiante->nombre.'</b> no se almacenaron en el sistema',
                            ]);
                        }

                        
                    } catch (Exception $e) {
                        $transaction->rollBack();
                    }

                }
                else //Actualizar Calificaciones 
                {  
                    $model = Comportamiento::find()->where(['id' => $reg->id])->one();
                      
                    if($ver_nota == 1)
                    {
                        if($num_comportamientos > 0)
                        {
                            $model->calificacion = implode(",", $comportamiento->calificacion);
                            $model->definitiva = $comportamiento->definitiva;
                        }

                        if($num_comportamientos == '1')
                        {
                            $model->definitiva = implode(",", $comportamiento->calificacion);
                        }
                    }

                    $model->docente = $comportamiento->docente;
                    $model->estudiante = $comportamiento->estudiante;
                    $model->grupo = $comportamiento->grupo;
                    $model->periodo = $comportamiento->periodo;
                    
                    $observacion = new Observaciongeneral();

                    $model->observacion_general = $observacion->ValidarExistentes($comportamiento->observacion_general);
                    $model->observacion_especifica = $comportamiento->observacion_especifica;

                    $transaction = Yii::$app->db->beginTransaction();

                    try {
                            if ($model->update(false)) 
                            {

                                if($num_comportamientos > 0 && $ver_nota == 1)
                                {

                                    $i = 1;
                                    
                                    foreach ($comportamiento->calificacion as $c_saber) 
                                    {

                                            $saber = Comportamientocalificaciones::find()
                                                ->where(['comportamiento_id' => $reg->id])
                                                ->andWhere(['docente' => $comportamiento->docente])
                                                ->andWhere(['estudiante' => $comportamiento->estudiante])
                                                ->andWhere(['grupo' => $comportamiento->grupo])
                                                ->andWhere(['periodo' => $comportamiento->periodo])
                                                ->andWhere(['comportamiento' => $comportamiento->comportamiento[$i]])
                                                ->one();
                                        
                                            if(!isset($saber))
                                            {
                                            
                                                $saber = new Comportamientocalificaciones();
                                                $saber->comportamiento_id = $reg->id;
                                                $saber->docente = $comportamiento->docente;
                                                $saber->estudiante = $comportamiento->estudiante;
                                                $saber->grupo = $comportamiento->grupo;
                                                $saber->periodo = $comportamiento->periodo;
                                                $saber->comportamiento = $comportamiento->comportamiento[$i];
                                                $saber->save(false);

                                                Yii::$app->session->addFlash('mensaje', [
                                                    'tipo' => 'success',
                                                    'titulo' => 'Calificaciones Almacenadas',
                                                    'icono' => 'fa fa-check-square-o',
                                                    'mensaje' => 'Las calificaciones de <b>'.$estudiante->nombre.'</b> se almacenaron con éxito en el sistema',
                                                ]);

                                                $saber = Comportamientocalificaciones::find()
                                                ->where(['comportamiento_id' => $reg->id])
                                                ->andWhere(['docente' => $comportamiento->docente])
                                                ->andWhere(['estudiante' => $comportamiento->estudiante])
                                                ->andWhere(['grupo' => $comportamiento->grupo])
                                                ->andWhere(['periodo' => $comportamiento->periodo])
                                                ->andWhere(['comportamiento' => $comportamiento->comportamiento[$i]])
                                                ->one();

                                            }   

                                            if($tipo_calificacion == 1)
                                            {
                                                $total = Desempeno::find()->where(['nota' => $c_saber])
                                                        ->andWhere(['tipo_calificacion' => $tipo_calificacion])
                                                        ->count();
                                        
                                                if($total > 0)
                                                {
                                                    $saber->calificacion = $c_saber;
                                                }    
                                                else
                                                {
                                                    if($c_saber != '')
                                                    {

                                                        Yii::$app->session->addFlash('mensaje', [
                                                            'tipo' => 'danger',
                                                            'titulo' => 'Error en la Nota',
                                                            'icono' => 'far info',
                                                            'mensaje' => 'La Nota <b>('.$c_saber.')</b> del estudiante <b>'.$estudiante->nombre.'</b> no exite.',
                                                        ]);    
                                                    }
                                                    
                                                    if($c_saber == '')
                                                    {
                                                        $saber->calificacion = $c_saber;
                                                    }
                                                }
                                            }
                                            else
                                            {
                                                $saber->calificacion = $c_saber;
                                            }
                                            

                                            $saber->update(false);

                                        $i++;

                                    }
                                }
                                  
                                $transaction->commit();

                                Yii::$app->session->addFlash('mensaje', [
                                    'tipo' => 'info',
                                    'titulo' => 'Observaciones Actualizadas',
                                    'icono' => 'fa info',
                                    'mensaje' => 'Las observaciones al comportamiento de <b>'.$estudiante->nombre.'</b> se actualizaron correctamente.',
                                ]); 

                            } else {

                                var_dump($model->errors);

                                $transaction->rollBack();
                            }
                        } catch (Exception $e) {
                    $transaction->rollBack();
                    }
                        
                    
                }    
            }

            return $this->redirect(['docente/index']);
            
        }
        else
        {

            return $this->render('calificaciones', [
                'dataProvider' => $dataProvider,
                'periodo' => $periodo,
                'comportamientos' => $comportamientos,
                'num_comportamientos' => $num_comportamientos,
                'competencias' => $competencias,
                'seleccionmultiple' => $seleccionmultiple,
                'registros' => $registros,
                'grupo' => $grupo,
                'entrada' => $entrada,
                'ver_nota' => $ver_nota,
                'calificacionxcompetencia' => $calificacionxcompetencia,
                'tipo_calificacion' => $tipo_calificacion,
                'observacion_general' => $observacion_general,
                'observacion_especifica' => $observacion_especifica,
            ]);

        }
    } 
   
    protected function findModel($id)
    {
        if (($model = Calificacion::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }
}
