<?php

namespace backend\controllers;

use Yii;
use backend\models\Compromisosacudiente;
use backend\models\CompromisosacudienteSearch;
use backend\models\Sede;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;

/**
 * CompromisosacudienteController implements the CRUD actions for Compromisosacudiente model.
 */
class CompromisosacudienteController extends Controller
{
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['post'],
                ],
            ],
        ];
    }

    /**
     * Lists all Compromisosacudiente models.
     * @return mixed
     */
    public function actionIndex()
    {
        
        $instituto = Sede::findOne('1');
        

        if ($instituto->compromiso_acudiente == '') 
        {
            return $this->redirect(['activar', 'id' => $instituto->id]);
        } 
        else 
        {

            $searchModel = new CompromisosacudienteSearch();
            $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

            return $this->render('index', [
                'searchModel' => $searchModel,
                'dataProvider' => $dataProvider,
            ]);
        }    
    }

    /**
     * Displays a single Compromisosacudiente model.
     * @param integer $id
     * @return mixed
     */
    public function actionView($id)
    {
        $model = $this->findModel($id);
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    public function actionActivar($id)
    {
        $model = Sede::findOne($id);

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect('index');
        } else {
            return $this->render('activar', [
                'model' => $model,
            ]);
        }
    }

    public function actionCreate()
    {
        $sede = Sede::findOne('1');
        

        if ($instituto->compromiso_acudiente == '') 
        {
            return $this->redirect(['activar', 'id' => $sede->id]);
        } 
        else 
        {

            $model = new Compromisosacudiente();

            if ($model->load(Yii::$app->request->post()) && $model->save()) {
                return $this->redirect(['view', 'id' => $model->id]);
            } else {
                return $this->render('create', [
                    'model' => $model,
                ]);
            }
        }    
    }

    /**
     * Updates an existing Compromisosacudiente model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->id]);
        } else {
            return $this->render('update', [
                'model' => $model,
            ]);
        }
    }

    /**
     * Deletes an existing Compromisosacudiente model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     */
    public function actionDelete($id)
    {
        //$this->findModel($id)->deleteWithRelated();

        $model = $this->findModel($id);
        $model->eliminado_por = \Yii::$app->user->id;
        $model->eliminado_el = new \yii\db\Expression('NOW()');
        $model->update();

        return $this->redirect(['index']);
    }

    public function actionRestore($id)
    {
        $this->findModel($id)->restoreWithRelated();

        return $this->redirect(['index']);
    }

    
    /**
     * Finds the Compromisosacudiente model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Compromisosacudiente the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Compromisosacudiente::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }
}
