<?php

namespace backend\controllers;

use Yii;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\widgets\ActiveForm;
use yii\web\Response;

use backend\models\Condicionpromocion;
use backend\models\CondicionpromocionSearch;
use backend\models\Desempeno;
use backend\models\Tercero;
use backend\models\Calificacion;
use backend\models\Grupo;
use backend\models\Grado;
use backend\models\Asignatura;
use backend\models\Academico;
use backend\models\LanzadorForm;

/**
 * CondicionpromocionController implements the CRUD actions for Condicionpromocion model.
 */
class CondicionpromocionController extends Controller
{
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['post'],
                ],
            ],
        ];
    }

    /**
     * Lists all Condicionpromocion models.
     * @return mixed
     */
    public function actionIndex()
    {
        return $this->redirect(['create']);
    }

    /**
     * Displays a single Condicionpromocion model.
     * @param integer $id
     * @return mixed
     */
    public function actionView($id)
    {
        $model = $this->findModel($id);
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new Condicionpromocion model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new Condicionpromocion();
        $condiciones = Condicionpromocion::find()->all();

        $searchModel = new CondicionpromocionSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        if ($model->load(Yii::$app->request->post())) {

            if($model->tipo=='1')
            {
                foreach ($model->area as $area) 
                {
                    $condicion = new Condicionpromocion();
                    $condicion->tipo = $model->tipo;
                    $condicion->grado = $model->grado;
                    $condicion->area = $area;
                    $condicion->desempeno = $model->desempeno;
                    $condicion->descripcion = $model->descripcion;
                    $condicion->save();
                }
            }

            if($model->tipo=='2')
            {
                foreach ($model->asignatura as $asignatura) 
                {
                    $condicion = new Condicionpromocion();
                    $condicion->tipo = $model->tipo;
                    $condicion->grado = $model->grado;
                    $condicion->asignatura = $asignatura;
                    $condicion->desempeno = $model->desempeno;
                    $condicion->descripcion = $model->descripcion;
                    $condicion->save();
                }
            }

            if(($model->tipo != '1') && ($model->tipo != '2'))
            {
                $model->save();
            }

            $condiciones = Condicionpromocion::find()->all();
            $searchModel = new CondicionpromocionSearch();
            $dataProvider = $searchModel->search(Yii::$app->request->queryParams);
            
            return $this->render('create', [
                'model' => $model,
                'condiciones' => $condiciones,
                'searchModel' => $searchModel,
                'dataProvider' => $dataProvider,
            ]);

        } else {
            return $this->render('create', [
                'model' => $model,
                'condiciones' => $condiciones,
                'searchModel' => $searchModel,
                'dataProvider' => $dataProvider,
            ]);
        }
    }

    /**
     * Updates an existing Condicionpromocion model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);
        $condiciones = Condicionpromocion::find()->all();

        $searchModel = new CondicionpromocionSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);


        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->id]);
        } else {
            return $this->render('update', [
                'model' => $model,
                'condiciones' => $condiciones,
                'searchModel' => $searchModel,
                'dataProvider' => $dataProvider,
            ]);
        }
    }

    /**
     * Deletes an existing Condicionpromocion model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     */
    public function actionDelete($id)
    {
        //$this->findModel($id)->deleteWithRelated();

        $model = $this->findModel($id);
        $model->eliminado_por = \Yii::$app->user->id;
        $model->eliminado_el = new \yii\db\Expression('NOW()');
        $model->update();

        return $this->redirect(['index']);
    }

    public function actionRestore($id)
    {
        $this->findModel($id)->restoreWithRelated();

        return $this->redirect(['index']);
    }

    public function actionComprobar($grupo = NULL, $asignatura = NULL) // Reporte de Ausentismo por Asignatura y Grupo
    {

        if($grupo == NULL or $asignatura == NULL)
        {    
            $model = new LanzadorForm(['scenario'=>'grado']);

            //$model->reporte = 'Reporte Consolidado de Ausentismo Mensual';
            //$model->observaciones = 'Exporta la información de ausentismo por asignatura y grupo según sea el caso; si no selecciona la asignatura por defecto será un informe por grupo, este reporte se genera en formato Excel.';

            $model->reporte = Yii::t('app', 'Comprobación Año Escolar');
            $model->observaciones = Yii::t('app', 'Comprobar si los estudiantes de un grupo o grado aprueban o no el año escolar.');

            if (Yii::$app->request->isAjax && $model->load(Yii::$app->request->post())) {
                Yii::$app->response->format = Response::FORMAT_JSON;
                return ActiveForm::validate($model);
            }

            if ($model->load(Yii::$app->request->post())) 
            {
                $grupo = $model->grupo;
                $grado = $model->grado;
                $asignatura = $model->asignatura; 
            }    
            else
            {
                if (Yii::$app->request->isAjax) 
                {
                    return $this->renderAjax('/publica/lanzador', [
                            'model' => $model,
                            'sede' => true,
                            'tercero' => false,
                            'grado' => true,
                            'grupo' => true,
                            'asignatura' => false,
                            'periodo' => false,
                            'competencia' => false,
                            'columnas' => false,
                            'ver_estandar' => false,
                            'ver_competencia' => false,
                            'ver_niveles' => false,
                            'ver_desempenos' => false,
                            'ver_frd' => false,
                            'ver_fecha' => false,
                            'ver_letrasonumeros' => false,
                        ]);

                    exit;
                }
                else
                {
                    return $this->render('/publica/lanzador', [
                            'model' => $model,
                            'sede' => true,
                            'tercero' => false,
                            'grado' => true,
                            'grupo' => true,
                            'asignatura' => false,
                            'periodo' => false,
                            'competencia' => false,
                            'columnas' => false,
                            'ver_estandar' => false,
                            'ver_competencia' => false,
                            'ver_niveles' => false,
                            'ver_desempenos' => false,
                            'ver_frd' => false,
                            'ver_fecha' => false,
                            'ver_letrasonumeros' => false,
                        ]);

                    //exit;
                }    
            }    
        }

        $periodo = '5';
        $resultado = "";
        
        if(isset($grado))
        {
            $grado = Grado::findOne($grado);

            $resultado .= "<br>Grado: (".$grado->id.") - ".$grado->grado;
        }

        if(isset($grupo))
        {
            $grupo = Grupo::findOne($grupo);

            $resultado .= "<br>Grupo: (".$grupo->id.") - ".$grupo->grupo."<BR>";
        }    
        
        $anio = $grupo->sedes->vigencia;



        $terceros = Tercero::find()->where(['=', 'academico.grupo', $grupo->id])->andWhere(['<', 'tercero.estado', 3])->andWhere(['tercero.eliminado_por' => 0])->andWhere(['academico.eliminado_por' => 0])->joinWith(['academicos'])->orderBy(['primer_apellido' => SORT_ASC, 'segundo_apellido' => SORT_ASC])->all();

        
        foreach ($terceros as $tercero) 
        {
            $aprobado = true;
            $areas_perdidas_desempeno = 0;
            $areas_perdidas_condicion = [];
            $asignaturas_perdidas = 0;
            $resultado .= "<h2>".$tercero->nombre." (".$tercero->id.")</h2>";

            //echo $tercero->id." - ".$tercero->nombre;
            //echo " Grupo: ".$tercero->academico->grupos->grupo;
            //echo " Esp: ".$tercero->academico->especialidades->especialidad;

            foreach ($tercero->AsiganturasxEspecialidadNoExcluida as $asignatura)
            {
                $promedio_area_estudiante = $tercero->promedioarea($tercero->id, $asignatura->area, $periodo, $grado->tipo_calificacion);

                $resultado .= "<h4 style='color:red;'>ÁREA ".$asignatura->areas->area." (".$promedio_area_estudiante.")</h4>";
                $resultado .= "<p style='color:blue;'>".$asignatura->asignatura."(".$asignatura->id.")</p>";
                
                
                //////////    AREAS PERDIDAS POR DESEMPEÑO  ////////////////////////
                
                $desempeno = new Desempeno();

                if ($desempeno->perdido($promedio_area_estudiante, $grado->tipo_calificacion) == '1')
                {
                    $areas_perdidas_desempeno++;
                }

                //echo "<br>ASIG: ".$asignatura->asignatura;
                //echo "<br>Prom Área :".$promedio_area_estudiante;
                //echo " Tipo Calif: ".$tercero->academico->grupos->grados->tipo_calificacion;


                ////////////////////////   CONDICIÓN POR ÁREA TIPO 1 /////////////////////

                
                $condicion_area = Condicionpromocion::find()
                    ->where(['tipo' => '1'])
                    ->andWhere(['grado' => $tercero->academico->grupos->grado])
                    ->andWhere(['area' => $asignatura->area])
                    ->andWhere(['eliminado_por' => '0'])
                    ->andWhere(['estado' => '1'])
                    ->one();

                if($condicion_area)
                {
                    //$resultado .= "<p style='color:primary;'>ÁREA ".$asignatura->areas->area." Nota: ".$promedio_area_estudiante."</p>";

                    $desempenos = Desempeno::find()
                    //->select('nota')
                    ->where(['tipo_calificacion' => $tercero->academico->grupos->grados->tipo_calificacion])
                    ->andWhere(['<=' , 'id', $condicion_area->desempeno])
                    ->andWhere(['eliminado_por' => '0'])
                    ->andWhere(['estado' => '1'])
                    ->all();

                    foreach ($desempenos as $desempeno)
                    {
                        
                        if($desempeno->nota == $promedio_area_estudiante)
                        {
                            $areas_perdidas_condicion[] = $asignatura->areas->area; 
                            $aprobado = false;
                            $resultado .= "<p style='color:red;'>ÁREA ".$asignatura->areas->area." <= ".$condicion_area->desempenos->desempeno." Validación (Desempeño: ".$desempeno->nota." = Promedio Área Estudiante: ".$promedio_area_estudiante.") = PERDÍO EL ÁREA</p>";
                        }
                    }

                    //echo "<br><br>".$desempenos->createCommand()->getRawSql(); // Mostrar SQL   
                }
                
                ////////////////////////  FIN  CONDICIÓN POR ÁREA TIPO 1 /////////////////////




                ////////////////////////   CONDICIÓN POR ASIGNATURA TIPO 2 /////////////////////
    
                if (($calificacion_asignatura = Calificacion::find()
                    ->where(['estudiante' => $tercero->id])
                    ->andWhere(['grupo' => $tercero->academico->grupo])
                    ->andWhere(['asignatura' => $asignatura->id])
                    ->andWhere(['periodo' => $periodo])
                    ->andWhere(['eliminado_por' => '0'])
                    ->andWhere(['estado' => '1'])
                    ->one()) !== NULL)
                {
                    $calificacion =  ($calificacion_asignatura->definitiva_final_periodo == '' ? 'NE' : $calificacion_asignatura->definitiva_final_periodo);
                }
                else
                {
                    $calificacion = 'NE';
                }

                $resultado .= "<p style='color:green;'>CALIFICACIÓN ASIGNATURA ".$asignatura->asignatura." (".$calificacion.")</p>";

                $condicion_asignatura = Condicionpromocion::find()
                    ->where(['tipo' => '2'])
                    ->andWhere(['grado' => $tercero->academico->grupos->grado])
                    ->andWhere(['asignatura' => $asignatura->id])
                    ->andWhere(['eliminado_por' => '0'])
                    ->andWhere(['estado' => '1'])
                    ->one();

                if($condicion_asignatura)
                {
                    $desempenos = Desempeno::find()
                    ->where(['tipo_calificacion' => $tercero->academico->grupos->grados->tipo_calificacion])
                    ->andWhere(['<=' , 'id', $condicion_asignatura->desempeno])
                    ->andWhere(['eliminado_por' => '0'])
                    ->andWhere(['estado' => '1'])
                    ->all();

                    foreach ($desempenos as $desempeno)
                    {
                        if($desempeno->nota == $calificacion)
                        {
                            $asignaturas_perdidas++;
                            
                            if($asignatura->principal == '1')
                            {
                                $aprobado = false;    
                            }
                            
                            $resultado .= "<p style='color:red;'>ASIGNATURA ".$asignatura->asignatura." <= ".$condicion_asignatura->desempenos->desempeno." Validación (Desempeño: ".$desempeno->nota." = Calificación: ".$calificacion.") = PERDÍO LA ASIGNATURA</p>";
                        }
                    }

                    //echo "<br><br>".$desempenos->createCommand()->getRawSql(); // Mostrar SQL   
                }
                
                ////////////////////////  FIN  CONDICIÓN POR ASIGNATURA TIPO 2 /////////////////////
            }



            ////////////////////////   CONDICIÓN POR ÁREA TIPO 3 /////////////////////

            $numero_areas = Condicionpromocion::find()
                //->select('numero_areas')
                ->where(['tipo' => '3'])
                ->andWhere(['eliminado_por' => '0'])
                ->andWhere(['estado' => '1'])
                ->one();

            if($numero_areas)
            {
                if($numero_areas->numero_areas <= $areas_perdidas_desempeno)
                {
                    $aprobado = false;
                    $resultado .= "<p style='color:red;'>TOTAL ÁREAS PERDIDAS X DESEMPEÑOS (".$areas_perdidas_desempeno."/".$numero_areas->numero_areas.")";
                }
                
            }



            ////////////////////////   CONDICIÓN POR ÁREA TIPO 3 /////////////////////

            $numero_asignaturas = Condicionpromocion::find()
                //->select('numero_areas')
                ->where(['tipo' => '4'])
                ->andWhere(['eliminado_por' => '0'])
                ->andWhere(['estado' => '1'])
                ->one();

            if($numero_asignaturas)
            {
                if($asignaturas_perdidas >= $numero_asignaturas->numero_asignaturas)
                {
                    $aprobado = false;
                    $resultado .= "<p style='color:red;'>TOTAL ASIGNATURAS PERDIDAS (".$asignaturas_perdidas."/".$numero_asignaturas->numero_asignaturas.")";
                }
                
            }


            //$total_areas_perdidas = count(array_unique($areas_perdidas_condicion));

               

            if($aprobado)
            {
                $resultado .= "<h5 style='color:green;'>APROBADO</h5>".$tercero->id;
                $academico = Academico::find()->where(['estudiante' => $tercero->id])->andWhere(['grupo' => $grupo->id])->andWhere(['eliminado_por' => '0'])->one();
                $academico->aprobo = '1';
                $academico->update(false);
            }
            else
            {
                $resultado .= "<h5 style='color:red;'>REPROBADO</h5>".$tercero->id;
                $academico = Academico::find()->where(['estudiante' => $tercero->id])->andWhere(['grupo' => $grupo->id])->andWhere(['eliminado_por' => '0'])->one();
                $academico->aprobo = '0';
                $academico->update(false);
            }
            
            $resultado .= "<br><hr>";

            
        }

           
            //$fallas = Asistencia::find()->where(['estudiante'=> $estudiante->id, 'asignatura' => $asignatura])->andWhere(['between', 'fecha', ''.$anio.'-'.$b.'-'.$x.' 00:00:00', ''.$anio.'-'.$b.'-'.$x.' 23:59:59'])->sum('fallas');
            //$fallas = Asistencia::find()->where(['estudiante'=> $estudiante->id])->andWhere(['between', 'fecha', ''.$anio.'-'.$b.'-'.$x.' 00:00:00', ''.$anio.'-'.$b.'-'.$x.' 23:59:59'])->sum('fallas'); 
        //return $resultado;

        if (Yii::$app->request->post()) 
        {
            return $this->render('informe', [
                'resultado' => $resultado,
            ]);
        }
        else
        {
            return $this->render('informe', [
                'resultado' => $resultado,
            ]);    
        }
        

    }
    
    ///////////////////////////////////////////////////////////////////////////////////////////////
    /**
     * Finds the Condicionpromocion model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Condicionpromocion the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Condicionpromocion::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException(Yii::t('app', 'The requested page does not exist.'));
        }
    }
}
