<?php

namespace backend\controllers;

use Yii;
use backend\models\Academico;
use backend\models\AcademicoSearch;

use backend\models\Carga;
use backend\models\CargaSearch;

use backend\models\Tercero;
use backend\models\Asistencia;
use backend\models\AsistenciaSearch;
use backend\models\Grupo;
use backend\models\Asignatura;
use backend\models\Periodo;
use backend\models\TipoInasistencia;
use backend\models\Calificacion;
use backend\models\TerceroForm;
use backend\models\Mensajes;


use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\helpers\ArrayHelper;
use yii\data\ActiveDataProvider;
use yii\web\Response;
use yii\widgets\ActiveForm;
use yii\helpers\Html;
use yii\helpers\Url;



/**
 * AcademicoController implements the CRUD actions for Academico model.
 */
class DocenteController extends Controller
{
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['post'],
                ],
            ],
        ];
    }

    /**
     * Lists all Academico models.
     * @return mixed
     */
    public function actionIndex()
    {

        if(Yii::$app->session->get('__tipo') == 2)
        {            
            $tercero = new TerceroForm();

            if (Yii::$app->request->isAjax && $tercero->load(Yii::$app->request->post())) {
                Yii::$app->response->format = Response::FORMAT_JSON;
                return ActiveForm::validate($tercero);
            }

            $tercero->load(Yii::$app->request->post());

            $dataProvider = new ActiveDataProvider([
                'query' => Carga::find()
                            ->joinWith(['asignaturas','grupos','grupos.grados'])
                            ->where(['docente' => Yii::$app->session->get('__tercero')])
                            ->andWhere(['carga.eliminado_por' => '0'])
                            ->andWhere(['asignatura.eliminado_por' => '0'])
                            ->andWhere(['carga.estado' => '1'])
                            ->orderBy(['asignatura.asignatura' => SORT_ASC, 'grado.id' => SORT_ASC, 'grupo.grupo' => SORT_ASC]),
                'pagination' => [
                    'pageSize' => 30,
                ],
            ]);
       
            $model = Tercero::findOne(Yii::$app->session->get('__tercero'));
            $periodo = new Periodo();

            $carteleras = Mensajes::find()->where(['remisor' => Yii::$app->session->get('__tercero')])->andWhere(['cartelera' => '1'])->andWhere(['eliminado_por' => '0'])->andWhere(['estado' => '1'])->all();
        

            return $this->render('index', [
                'dataProvider' => $dataProvider,
                'model' => $model,
                'tercero' => $tercero,
                'periodo' => $periodo,
                'carteleras' => $carteleras,
                
            ]);
        }
        else
        {
            $model = new Tercero();
        
            return $this->render('lanzador', [
                'model' => $model
            ]);
        }
    }

    public function actionBuscar($query = '')
    {
        $output = '';

        if(isset($_POST["query"]))
        {
            $search = $_POST["query"];

            $terceros = Tercero::find()
                        ->where(['like', 'primer_nombre', $search])
                        ->orWhere(['like', 'segundo_nombre', $search])
                        ->orWhere(['like', 'primer_apellido', $search])
                        ->orWhere(['like', 'segundo_apellido', $search])
                        ->andWhere(['tipo_tercero' => '2'])
                        ->orderBy(['primer_apellido' => SORT_ASC, 'segundo_apellido' => SORT_ASC, 'primer_nombre' => SORT_ASC, 'segundo_nombre' => SORT_ASC])
                        ->all();
        }
        else
        {
            $terceros = Tercero::find()
                        ->where(['tipo_tercero' => '2'])
                        ->orderBy(['primer_apellido' => SORT_ASC, 'segundo_apellido' => SORT_ASC, 'primer_nombre' => SORT_ASC, 'segundo_nombre' => SORT_ASC])
                        ->all();
        }

        if(count($terceros) > 0)
        {
            $output .= '
                <div class="table-responsive">
                    <table class="table table-hover table-striped">
                        <thead class="thead-light">
                            <tr>
                                 <th class="hidden-xs"></th>
                                 <th>Docente</th>
                                 <th>Acciones</th>
                            </tr>
                        </thead>    
             ';

            foreach ($terceros as $tercero) 
            {
                $output .= '<tr>';
                $output .= '<td>'.Html::img($tercero->foto ? '@web/uploads/thumbnail/sm-'.$tercero->foto : '@web/images/user.jpg', ['class'=>'img-36 rounded-circle']).'</td>';
                $output .= '<td>'.Html::a($tercero->nombre,false,['value' => Url::to([$tercero->id]), 'title' => $tercero->nombre, 'data-toggle' => 'tooltip', 'onClick' => 'cambiar_usuario('.$tercero->id.',"'.$tercero->nombre.'")', 'style' => 'cursor: pointer;']).'</td>';
                $output .= '<td align="center">'.Html::button('<i class="fa fa-rocket" aria-hidden="true"></i> <span class="hidden-xs">Lanzar</span>', ['value' => Url::to([$tercero->id]), 'title' => $tercero->nombre, 'data-toggle' => 'tooltip', 'class' => 'btn btn-xs btn-warning', 'onClick' => 'cambiar_usuario('.$tercero->id.',"'.$tercero->nombre.'")']).'</td>';  
                $output .= '</tr>';
            }
            return $output;
        }
        else
        {
            return '<center><h4>No Encontrado</h4></center>';
        }
    }

    public function actionCambiar($tercero)
    {

        $tercero = Tercero::findOne($tercero);

        $bitacora = new \backend\models\Bitacora;
        $bitacora->Registrar('Cambio al Panel del Docente "<span class="text-danger">'.$tercero->nombre.'</span>"');
        
        Yii::$app->session->set('__doc', $tercero->identificacion);
        Yii::$app->session->set('__tercero', $tercero->id);
        Yii::$app->session->set('__tipo', $tercero->tipo_tercero);
        Yii::$app->session->set('__genero', $tercero->genero);
        Yii::$app->session->set('__authKey', $tercero->usuario->authKey);
        Yii::$app->session->set('__id', $tercero->usuario->id);
        
        return $tercero->nombre;
    }



/*
    public function actionColor($calificacion)
    {
        $color ='#ccc;';
                    
        if ($calificacion!='')
        {   
            $query = "SELECT * FROM `desempeno` WHERE ".$calificacion." BETWEEN limite_inferior AND limite_superior";
            $desempeno = Desempeno::findbySql($query)->one();
            $color = $desempeno['color'];
        }
        return $color;
    }

*/
    public function actionCalificacionesok()
    {

        $dataProvider = new ActiveDataProvider([
            'query' => Academico::find()->select(['tercero.id', 'academico.estudiante', 'academico.grupo','calificacion.calificacion'])->joinWith(['estudiantes','calificaciones'])->where(['<', 'tercero.estado', 3])->andWhere(['academico.grupo' => Yii::$app->request->get('grupo')]),
            'pagination' => [
                'pageSize' => 50,
            ],
        ]);
        $periodo = new Periodo();

        $registros = Calificacion::find()->where(['grupo' => Yii::$app->request->get('grupo')])->andWhere(['asignatura' => Yii::$app->request->get('asignatura'), 'periodo' => $periodo->actual->id])->count();

        $count = count(Yii::$app->request->post('Calificacion', []));
        
        $grupo = Grupo::find()->where(['id' => $_GET['grupo']])->one();

        $tipo_calificacion = $grupo->grados->tipo_calificacion;
        $calificacionxcompetencia = $grupo->grados->calificacionxcompetencia;
    
        $calificaciones = [new Calificacion()]; 


        for($i = 1; $i < $count; $i++) {

            $calificaciones[] = new Calificacion();
        }

        if (Model::loadMultiple($calificaciones, Yii::$app->request->post()) 
            && Model::validateMultiple($calificaciones))     
        {

            foreach ($calificaciones as $calificacion) {
                  
                $reg = Calificacion::find()->select(['id'])->where(['estudiante' => $calificacion->estudiante])->andWhere(['grupo' => $calificacion->grupo, 'asignatura' => $calificacion->asignatura, 'periodo' => $periodo->actual->id])->one();
                $estudiante = Tercero::find()->where(['id' => $calificacion->estudiante])->one();


                if(count($reg) == '0')
                {   
                    $model= new Calificacion;
                    
                        if ($calificacionxcompetencia == 1) // POR ASIGNATURA
                        {
                            $model->calificacion = $calificacion->calificacion;
                        }
                        else // POR COMPETENCIA
                        {
                            $model->calificacion = implode(",", $calificacion->calificacion);
                        }    
                    
                    $model->coevaluacion = $calificacion->coevaluacion;
                    $model->autoevaluacion = $calificacion->autoevaluacion;
                    $model->heteroevaluacion = $calificacion->heteroevaluacion;
                    $model->docente = $calificacion->docente;
                    $model->estudiante = $calificacion->estudiante;
                    $model->asignatura = $calificacion->asignatura;
                    $model->grupo = $calificacion->grupo;
                    $model->periodo = $calificacion->periodo;
                        
                        if($model->save(false))
                        {
                            Yii::$app->session->addFlash('mensaje', [
                                'tipo' => 'success',
                                'titulo' => 'Calificaciones Almacenadas',
                                'icono' => 'fa fa-check-square-o',
                                'mensaje' => 'Las calificaciones de '.$estudiante->nombre.' se almacenaron con éxito en el sistema',
                            ]);  
                        } 
                        else
                        {
                            Yii::$app->session->addFlash('mensaje', [
                                'tipo' => 'danger',
                                'titulo' => 'Calificaciones Almacenadas',
                                'icono' => 'fa fa-check-square-o',
                                'mensaje' => 'Las calificaciones de '.$estudiante->nombre.' no se almacenaron en el sistema',
                            ]);
                        }
                }
                else
                {  
                    $model= Calificacion::find()->where(['id' => $reg->id])->one();


                        if ($calificacionxcompetencia == 1) // POR ASIGNATURA
                        {
                            $model->calificacion = $calificacion->calificacion;
                        }
                        else // POR COMPETENCIA
                        {
                            $model->calificacion = implode(",", $calificacion->calificacion);
                        } 
                    
                    $model->coevaluacion = $calificacion->coevaluacion;
                    $model->autoevaluacion = $calificacion->autoevaluacion;
                    $model->heteroevaluacion = $calificacion->heteroevaluacion;

                    
                    
                        if($model->update(false))
                        {
                            Yii::$app->session->addFlash('mensaje', [
                                'tipo' => 'success',
                                'titulo' => 'Calificaciones Almacenadas',
                                'icono' => 'fa fa-check-square-o',
                                'mensaje' => 'Las calificaciones de '.$estudiante->nombre.' se almacenaron con éxito en el sistema',
                            ]);  
                        } 
                        else
                        {
                            Yii::$app->session->addFlash('mensaje', [
                                'tipo' => 'info',
                                'titulo' => 'No hubo cambios!',
                                'icono' => 'fa fa-check-square-o',
                                'mensaje' => 'No hubo cambios en las calificaciones de '.$estudiante->nombre.' por eso no se actualizaron en el sistema',
                            ]);
                        }
                    
                }    
            }

            return $this->redirect(['index']);
            
        }
        else
        {

            return $this->render('calificaciones', [
                'dataProvider' => $dataProvider,
                'periodo' => $periodo,
                'calificaciones' => $calificaciones,
                'registros' => $registros,
                'grupo' => $grupo,
                'calificacionxcompetencia' => $calificacionxcompetencia,
                'tipo_calificacion' => $tipo_calificacion,
            ]);
        }
    }    



    public function actionAddAsistencia()
    {
        if (Yii::$app->request->isAjax) {
            $row = Yii::$app->request->post('Calificacion');
            if((Yii::$app->request->post('isNewRecord') && Yii::$app->request->post('action') == 'load' && empty($row)) || Yii::$app->request->post('action') == 'add')
                $row[] = [];
            return $this->renderAjax('_list_asistencia', ['row' => $row]);
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }    
}