<?php

namespace backend\controllers;

use Yii;
use backend\models\Documento;
use backend\models\Documentocategoria;
use backend\models\DocumentoSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\web\HttpException;
use yii\filters\VerbFilter;
use yii\web\UploadedFile;
use yii\helpers\FileHelper;

/**
 * DocumentoController implements the CRUD actions for Documento model.
 */
class DocumentoController extends Controller
{
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['post'],
                ],
            ],
        ];
    }

    /**
     * Lists all Documento models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new DocumentoSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single Documento model.
     * @param integer $id
     * @return mixed
     */
    public function actionView($id)
    {
        $model = $this->findModel($id);
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new Documento model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new Documento();

        if ($model->load(Yii::$app->request->post())) 
        {

            $carpeta = Yii::getAlias('@frontend') . "/web/documentos/".$model->categorias->carpeta;
            
            if (!is_dir($carpeta)) 
            {
                if (FileHelper::createDirectory($carpeta, $mode = 0775, $recursive = true)) 
                {
                    Yii::$app->session->addFlash('mensaje', [
                        'tipo' => 'info',
                        'titulo' => 'Carpeta Creada',
                        'icono' => 'far info',
                        'mensaje' => 'La Carpeta <b>'.$model->categorias->carpeta.'</b> fue creada con éxito.',
                    ]);
                }
            }


            if($file = UploadedFile::getInstance($model, 'archivo'))
            {

                //$file->upload($carpeta);
                $archivo = rand(10,100).'-'.$file;
                
                $file->saveAs($carpeta.'/'.$archivo);

                $model->archivo = $archivo;
            }
            
            if($model->save(false))
            {
                Yii::$app->session->addFlash('mensaje', [
                    'tipo' => 'info',
                    'titulo' => 'Documento Creado',
                    'icono' => 'far info',
                    'mensaje' => 'El documento <b>'.$model->titulo.'</b> fue creado con éxito.',
                ]);
            }
            else
            {
                    throw new HttpException($model->getErrors());
            }

            return $this->redirect(['index']);
        } else {
            return $this->render('create', [
                'model' => $model,
            ]);
        }
    }

    /**
     * Updates an existing Documento model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);

        if ($model->loadAll(Yii::$app->request->post()) && $model->saveAll()) {
            return $this->redirect(['view', 'id' => $model->id]);
        } else {
            return $this->render('update', [
                'model' => $model,
            ]);
        }
    }

    /**
     * Deletes an existing Documento model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     */
    public function actionDelete($id)
    {
        $this->findModel($id)->deleteWithRelated();

        return $this->redirect(['index']);
    }

    
    /**
     * Finds the Documento model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Documento the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Documento::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException(Yii::t('app', 'The requested page does not exist.'));
        }
    }
}
