<?php

namespace backend\controllers;

use Yii;
use backend\models\Documentocategoria;
use backend\models\DocumentocategoriaSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\helpers\FileHelper;

/**
 * DocumentocategoriaController implements the CRUD actions for Documentocategoria model.
 */
class DocumentocategoriaController extends Controller
{
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['post'],
                ],
            ],
        ];
    }

    /**
     * Lists all Documentocategoria models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new DocumentocategoriaSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single Documentocategoria model.
     * @param integer $id
     * @return mixed
     */
    public function actionView($id)
    {
        $model = $this->findModel($id);
        $providerDocumento = new \yii\data\ArrayDataProvider([
            'allModels' => $model->documentos,
        ]);
        $providerDocumentocategoria = new \yii\data\ArrayDataProvider([
            'allModels' => $model->documentocategorias,
        ]);
        return $this->render('view', [
            'model' => $this->findModel($id),
            'providerDocumento' => $providerDocumento,
            'providerDocumentocategoria' => $providerDocumentocategoria,
        ]);
    }

    /**
     * Creates a new Documentocategoria model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new Documentocategoria();

        if ($model->loadAll(Yii::$app->request->post()) && $model->saveAll()) {

            $path = Yii::getAlias('@frontend') . "/web/documentos";

            if (!is_dir($path)) 
            {
                FileHelper::createDirectory($path, $mode = 0775, $recursive = true);

            }

            $carpeta = Yii::getAlias('@frontend') . "/web/documentos/".$model->carpeta;

            if (FileHelper::createDirectory($carpeta, $mode = 0775, $recursive = true)) 
            {
                Yii::$app->session->addFlash('mensaje', [
                    'tipo' => 'info',
                    'titulo' => 'Carpeta Creada',
                    'icono' => 'far info',
                    'mensaje' => 'La Carpeta <b>'.$model->carpeta.'</b> fue creada con éxito.',
                ]);
            }
            else
            {
                Yii::$app->session->addFlash('mensaje', [
                    'tipo' => 'danger',
                    'titulo' => 'Error Creando Carpeta',
                    'icono' => 'far error',
                    'mensaje' => 'La Carpeta <b>'.$model->carpeta.'</b> no se creó.',
                ]); 
            }

            return $this->redirect(['index']);

        } else {
            return $this->render('create', [
                'model' => $model,
            ]);
        }
    }

    /**
     * Updates an existing Documentocategoria model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);

        if ($model->loadAll(Yii::$app->request->post()) && $model->saveAll()) {

            $path = Yii::getAlias('@frontend') . "/web/documentos";

            if (!is_dir($path)) 
            {
                FileHelper::createDirectory($path, $mode = 0775, $recursive = true);

            }

            $carpeta = Yii::getAlias('@frontend') . "/web/documentos/".$model->carpeta;
            
            if (!is_dir($carpeta)) 
            {
                if (FileHelper::createDirectory($carpeta, $mode = 0775, $recursive = true)) 
                {
                    Yii::$app->session->addFlash('mensaje', [
                        'tipo' => 'info',
                        'titulo' => 'Carpeta Creada',
                        'icono' => 'far info',
                        'mensaje' => 'La Carpeta <b>'.$model->carpeta.'</b> fue creada con éxito.',
                    ]);
                }
            }

            return $this->redirect(['index']);

        } else {
            return $this->render('update', [
                'model' => $model,
            ]);
        }
    }

    /**
     * Deletes an existing Documentocategoria model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     */
    public function actionDelete($id)
    {
        $this->findModel($id)->deleteWithRelated();

        return $this->redirect(['index']);
    }

    
    /**
     * Finds the Documentocategoria model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Documentocategoria the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Documentocategoria::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException(Yii::t('app', 'The requested page does not exist.'));
        }
    }
    
    /**
    * Action to load a tabular form grid
    * for Documento
    * @author Yohanes Candrajaya <moo.tensai@gmail.com>
    * @author Jiwantoro Ndaru <jiwanndaru@gmail.com>
    *
    * @return mixed
    */
    public function actionAddDocumento()
    {
        if (Yii::$app->request->isAjax) {
            $row = Yii::$app->request->post('Documento');
            if (!empty($row)) {
                $row = array_values($row);
            }
            if((Yii::$app->request->post('isNewRecord') && Yii::$app->request->post('_action') == 'load' && empty($row)) || Yii::$app->request->post('_action') == 'add')
                $row[] = [];
            return $this->renderAjax('_formDocumento', ['row' => $row]);
        } else {
            throw new NotFoundHttpException(Yii::t('app', 'The requested page does not exist.'));
        }
    }
    
    /**
    * Action to load a tabular form grid
    * for Documentocategoria
    * @author Yohanes Candrajaya <moo.tensai@gmail.com>
    * @author Jiwantoro Ndaru <jiwanndaru@gmail.com>
    *
    * @return mixed
    */
    public function actionAddDocumentocategoria()
    {
        if (Yii::$app->request->isAjax) {
            $row = Yii::$app->request->post('Documentocategoria');
            if (!empty($row)) {
                $row = array_values($row);
            }
            if((Yii::$app->request->post('isNewRecord') && Yii::$app->request->post('_action') == 'load' && empty($row)) || Yii::$app->request->post('_action') == 'add')
                $row[] = [];
            return $this->renderAjax('_formDocumentocategoria', ['row' => $row]);
        } else {
            throw new NotFoundHttpException(Yii::t('app', 'The requested page does not exist.'));
        }
    }
}
