<?php

namespace backend\controllers;

use yii;
use yii\web\Controller;
    
use League\Flysystem\Filesystem;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\Storage;
use Hypweb\Flysystem\GoogleDrive\GoogleDriveAdapter;

//require __DIR__ . '/../vendor/autoload.php';
//require __DIR__ . '/../vendor/yiisoft/yii2/Yii.php';

//require_once 'google/apiclient/src/Google/autoload.php';
//include(Yii::getAlias("@vendor/google/apiclient/src/Google/Client.php"));

//require_once(Yii::getAlias("@vendor/google/apiclient/src/Google/autoload.php"));

//require_once dirname(__FILE__).'/google/apiclient/src/Google/autoload.php';
//use Google\Google_Client as Google_Client;

//Google_Service
/*
require_once('/vendor/google-api-php-client-2.4.0/src/Google/autoload.php');
$path = Yii::getAlias("@vendor/google/apiclient/src/Google/Client.php");

require($path);

use Google\Apiclient\Google_Client as Google_Client;
*/

class DriveController extends Controller
{
   
    public function actionSubir($carpeta, $archivo) 
    {

		putenv('GOOGLE_APPLICATION_CREDENTIALS='.Yii::getAlias("@backend/config/credenciales.json"));

		$client = new \Google_Client();
		$client->useApplicationDefaultCredentials();
		$client->setScopes(['https://www.googleapis.com/auth/drive.file']);		

		try
		{
			//instanciamos el servicio
			$service = new \Google_Service_Drive($client);


			//ruta al archivo
			//$file_path = Yii::getAlias("@backend/web/tmp/test.docx");

			$file_path = $archivo->tempName;

			//instacia de archivo
			$file = new \Google_Service_Drive_DriveFile();
			$file->setName($archivo->name);

			//obtenemos el mime type
			$finfo = finfo_open(FILEINFO_MIME_TYPE); 
			$mime_type=finfo_file($finfo, $file_path);

			//id de la carpeta donde hemos dado el permiso a la cuenta de servicio 
			//$file->setParents(array("1XsYwEl4ErTEeH6_nb1fGifA8xz4ikRTm"));
			$file->setParents(array($carpeta));
			
			$file->setDescription('archivo subido desde php');
			$file->setMimeType($mime_type);

			$result = $service->files->create(
					  	$file,
					  	array(
					    	'data' => file_get_contents($file_path),
					    	'mimeType' => $mime_type,
					    	'uploadType' => 'media',
					  	)
					);

			//echo '<a href="https://drive.google.com/open?id='.$result->id.'" target="_blank">'.$result->name.'</a>';
			return ['file' => $archivo->name, 'id' => $result->id, 'tipo' => $mime_type];

		}
		catch(Google_Service_Exception $gs)
		{
		  	$m = json_decode($gs->getMessage());
		  	return $m->error->message;
		}
		catch(Exception $e)
		{
		    return $e->getMessage();  
		}

		return $this->render('upload');
    }

	public function actionListar($carpeta)
    {
        putenv('GOOGLE_APPLICATION_CREDENTIALS='.Yii::getAlias("@backend/config/credenciales.json"));

		$client = new \Google_Client();
		$client->useApplicationDefaultCredentials();
		$client->setScopes(['https://www.googleapis.com/auth/drive.file']);		

		try
		{
			//instanciamos el servicio
			$service = new \Google_Service_Drive($client);

			$file = new \Google_Service_Drive_DriveFile();
			$folder_id = $carpeta;
			
	        $response = $service->files->listFiles([
	            'q' => "'$folder_id' in parents and trashed=false",
	        ]);

	        /*foreach ($response->files as $file) {
	        	echo "<br>".$file->name;
	        }*/

	        //return "<br><br>Total de Archivos: ".count($response->files);
	        return $this->render('index', [
	            'response' => $response,
	        ]);
    	}
    	catch(Google_Service_Exception $gs)
		{
		  	$m = json_decode($gs->getMessage());
		  	return $m->error->message;
		}
		catch(Exception $e)
		{
		    return $e->getMessage();  
		}

		
    }

}	
