<?php

namespace backend\controllers;

use Yii;
use backend\models\base\Eps;
use backend\models\EpsSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\helpers\Json;

/**
 * EpsController implements the CRUD actions for Eps model.
 */
class EpsController extends Controller
{


    /**
     * Lists all Eps models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new EpsSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single Eps model.
     * @param integer $id
     * @return mixed
     */
    public function actionView($id)
    {
        $model = $this->findModel($id);
        $providerTercero = new \yii\data\ArrayDataProvider([
            'allModels' => $model->terceros,
        ]);
        return $this->render('view', [
            'model' => $this->findModel($id),
            'providerTercero' => $providerTercero,
        ]);
    }

    /**
     * Creates a new Eps model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new Eps();

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->id]);
        } else {
            return $this->render('create', [
                'model' => $model,
            ]);
        }
    }

    /**
     * Updates an existing Eps model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->id]);
        } else {
            return $this->render('update', [
                'model' => $model,
            ]);
        }
    }

    /**
     * Deletes an existing Eps model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     */

    /*
    public function actionDelete($id)
    {
        //$this->findModel($id)->deleteWithRelated();

        $model = $this->findModel($id);
        $model->eliminado_por = \Yii::$app->user->id;
        $model->eliminado_el = new \yii\db\Expression('NOW()');
        $model->update();

        //return $this->redirect(['index']);
        return true;
    }
    */
    
    public function actionDelete($id) {
        $post = Yii::$app->request->post();

        if (Yii::$app->request->isAjax) {
                if ($this->findModel($id)->delete()) {
                    
                    
 
                } else {
                    

                }
                return ;
        } elseif (Yii::$app->request->post()) {
                $this->findModel($id)->delete();
                return $this->redirect(['index']);
        }
        throw new InvalidCallException("You are not allowed to do this operation. Contact the administrator.");
    }

    /**
     * 
     * for export pdf at actionView
     *  
     * @param type $id
     * @return type
     */
    public function actionPdf($id) {
        $model = $this->findModel($id);
        $providerTercero = new \yii\data\ArrayDataProvider([
            'allModels' => $model->terceros,
        ]);

        $content = $this->renderAjax('_pdf', [
            'model' => $model,
            'providerTercero' => $providerTercero,
        ]);

        $pdf = new \kartik\mpdf\Pdf([
            'mode' => \kartik\mpdf\Pdf::MODE_CORE,
            'format' => \kartik\mpdf\Pdf::FORMAT_A4,
            'orientation' => \kartik\mpdf\Pdf::ORIENT_PORTRAIT,
            'destination' => \kartik\mpdf\Pdf::DEST_BROWSER,
            'content' => $content,
            'cssFile' => '@vendor/kartik-v/yii2-mpdf/assets/kv-mpdf-bootstrap.min.css',
            'cssInline' => '.kv-heading-1{font-size:18px}',
            'options' => ['title' => \Yii::$app->name],
            'methods' => [
                'SetHeader' => [\Yii::$app->name],
                'SetFooter' => ['{PAGENO}'],
            ]
        ]);

        return $pdf->render();
    }
    
    /**
     * Finds the Eps model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Eps the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Eps::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }
    
    /**
    * Action to load a tabular form grid
    * for Tercero
    * @author Yohanes Candrajaya <moo.tensai@gmail.com>
    * @author Jiwantoro Ndaru <jiwanndaru@gmail.com>
    *
    * @return mixed
    */
    public function actionAddTercero()
    {
        if (Yii::$app->request->isAjax) {
            $row = Yii::$app->request->post('Tercero');
            if((Yii::$app->request->post('isNewRecord') && Yii::$app->request->post('action') == 'load' && empty($row)) || Yii::$app->request->post('action') == 'add')
                $row[] = [];
            return $this->renderAjax('_formTercero', ['row' => $row]);
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }
}
