<?php

namespace backend\controllers;

use Yii;
use yii\filters\AccessControl;
use yii\web\Controller;
use common\models\LoginForm;
use yii\filters\VerbFilter;
use yii\data\SqlDataProvider;
use yii\web\Response;
use yii\widgets\ActiveForm;
use yii\data\ActiveDataProvider;


use common\models\User;
use backend\models\Agenda;
use backend\models\Sede;
use backend\models\Tercero;
use backend\models\TerceroForm;
use backend\models\Academico;
use backend\models\Grupo;
use backend\models\Asignatura;
use backend\models\Calificacion;
use backend\models\Periodo;
use backend\models\Mensajes;
use backend\models\Campana;
use backend\models\Tarea;
use backend\models\TareaSearch;
use backend\models\Planmejoramiento;


//use backend\models\SignupForm;
use yii\base\InvalidParamException;
use yii\web\BadRequestHttpException;
use yii\web\NotFoundHttpException;


class EstudianteController extends Controller
{

    public function actionIndex()
    {
        $tercero = Tercero::find()->where(['id' => Yii::$app->session->get('__tercero')])->one(); 
      
        if($tercero->tipo_tercero != 1) {
            throw new NotFoundHttpException('Módulo en Desarrollo.');
        }

        $terceroform = new TerceroForm();
        $periodo = new Periodo;

        if (Yii::$app->request->isAjax && $tercero->load(Yii::$app->request->post())) {
            Yii::$app->response->format = Response::FORMAT_JSON;
            return ActiveForm::validate($tercero);
        }

        $terceroform->load(Yii::$app->request->post());
        
        /*  
        "SELECT g1.grupo, 
                  (SELECT SUM(a2.fallas) FROM grupo g2 LEFT JOIN asistencia a2 ON g2.id = a2.grupo 
                  WHERE DATE(a2.fecha)=CURDATE()
                  AND g2.jornada = 2 
                  AND g2.grupo = g1.grupo) as 'Mañana',
                  (SELECT SUM(a3.fallas) FROM grupo g3 LEFT JOIN asistencia a3 ON g3.id = a3.grupo 
                  WHERE DATE(a3.fecha)=CURDATE()
                  AND g3.jornada = 3 
                  AND g3.grupo = g1.grupo) as 'Tarde'
                  from grupo g1
                  group by g1.grupo
                  order by g1.grupo ASC"  
                  
        */
        
        $query = "SELECT fecha, SUM(fallas) as fallas FROM asistencia WHERE estudiante = 1089 group by fecha";


        $dataProvider = new SqlDataProvider([
            'sql' => $query,
            'pagination' => false
        ]);


        $searchTareas = new TareaSearch();
        
        if(Yii::$app->session->get('__tipo') == 1)
        {
            $searchTareas->grupo = $tercero->grupoid;
        }

        if(Yii::$app->session->get('__tipo') == 2)
        {
            $searchTareas->creado_por = Yii::$app->session->get('__id');
        }

        $dataTareas = $searchTareas->search(Yii::$app->request->queryParams);



        $campanas = Campana::find()->where(['estado' => '1'])->all();

        $carteleras = Mensajes::find()->where(['remisor' => Yii::$app->session->get('__tercero')])->andWhere(['cartelera' => '1'])->andWhere(['eliminado_por' => '0'])->andWhere(['estado' => '1'])->all();

        $query = "SELECT * FROM `agenda` WHERE NOW() BETWEEN fecha_inicio AND fecha_fin AND estado = 1";
        $eventos = Agenda::findbySql($query)->all();


        $sede = Sede::find()->where(['principal' => '1'])->one();

        $periodo = new Periodo();

        //$actual = $periodo->actual->id;

        $academico = Academico::find()
                        ->select(['tercero.id', 'academico.estudiante', 'academico.grupo','academico.especialidad'])
                        ->joinWith(['estudiantes'])
                        ->where(['academico.estudiante' => $tercero->id])
                        ->one();
        
        if($academico)
        {
            $grupo = Grupo::find()->where(['id' => $academico->grupo])->one();

            if($academico->especialidad == '1')
            {   //echo "<br> Sin Especialidad";
                $asignaturas = Asignatura::find()
                                ->joinWith('areas')    
                                ->where(['grado' => $grupo->grados->id])
                                ->andWhere(['especialidad' => '1'])
                                ->orderBy(['area.area' => SORT_ASC])
                                ->all();
            }
            else
            {   //echo "<br> Con Especialidad";
                $asignaturas = Asignatura::find()
                                ->joinWith('areas')
                                ->where(['grado' => $grupo->grados->id])
                                ->andWhere(['especialidad' => '1'])
                                ->orWhere(['especialidad' => $academico->especialidad])
                                ->orderBy(['area' => SORT_ASC])
                                ->all();
            }

            $asignaturasperdidas_1 = Calificacion::find()->where(['estudiante' => Yii::$app->session->get('__tercero')])->andWhere(['periodo' => '1'])->andWhere(['IN','definitiva_periodo',['BJ','NE','']]);
            
            //echo $asignaturasperdidas->createCommand()->getRawSql(); 

            $asignaturas_perdidas_1 = new ActiveDataProvider([
                'query' => $asignaturasperdidas_1,
                'pagination' => [
                    'pageSize' => 500,
                ],
            ]);

            $asignaturasperdidas_2 = Calificacion::find()->where(['estudiante' => Yii::$app->session->get('__tercero')])->andWhere(['periodo' => '2'])->andWhere(['IN','definitiva_periodo',['BJ','NE','']]);
            
            //echo $asignaturasperdidas->createCommand()->getRawSql(); 

            $asignaturas_perdidas_2 = new ActiveDataProvider([
                'query' => $asignaturasperdidas_2,
                'pagination' => [
                    'pageSize' => 500,
                ],
            ]);

            $asignaturasperdidas_3 = Calificacion::find()->where(['estudiante' => Yii::$app->session->get('__tercero')])->andWhere(['periodo' => '3'])->andWhere(['IN','definitiva_periodo',['BJ','NE','']]);
            
            //echo $asignaturasperdidas->createCommand()->getRawSql(); 

            $asignaturas_perdidas_3 = new ActiveDataProvider([
                'query' => $asignaturasperdidas_3,
                'pagination' => [
                    'pageSize' => 500,
                ],
            ]);

            $asignaturasperdidas_4 = Calificacion::find()->where(['estudiante' => Yii::$app->session->get('__tercero')])->andWhere(['periodo' => '4'])->andWhere(['IN','definitiva_periodo',['BJ','NE','']]);
            
            //echo $asignaturasperdidas->createCommand()->getRawSql(); 

            $asignaturas_perdidas_4 = new ActiveDataProvider([
                'query' => $asignaturasperdidas_4,
                'pagination' => [
                    'pageSize' => 500,
                ],
            ]);

            foreach ($asignaturas as $asignatura) 
            {
                $calificacion = Calificacion::find()
                              ->where(['estudiante' => $tercero->id])
                              ->andWhere(['grupo' => $grupo->id])
                              ->andWhere(['asignatura' => $asignatura->id])
                              ->andWhere(['periodo' => $periodo->actual->id])
                              ->one();


                //echo "<br>Estudiante : ".$tercero->id." Grupo: ".$grupo->id."  Asignatura: ".$asignatura->id." Periodo : ".$periodo->actual->id." Nota: ".$calificacion->definitiva_final_periodo;

            }
                
            //echo "P:".$periodo->actual->id;


            return $this->render('index',[
                'periodo' => $periodo,
                'tercero' => $tercero,
                'terceroform' => $terceroform,
                'carteleras' => $carteleras,
                'campanas' => $campanas,
                'eventos' => $eventos,
                'sede' => $sede,
                'dataProvider' => $dataProvider,
                'searchTareas' => $searchTareas,
                'dataTareas' => $dataTareas,
                'asignaturas_perdidas_1' => $asignaturas_perdidas_1,
                'asignaturas_perdidas_2' => $asignaturas_perdidas_2,
                'asignaturas_perdidas_3' => $asignaturas_perdidas_3,
                'asignaturas_perdidas_4' => $asignaturas_perdidas_4,
                ]); 
        }
        else
        {
            if($sede->activar_matriculas == '1')
            {
                return $this->redirect(['tercero/step1', 'id' => Yii::$app->session->get('__tercero')]);
            }
            else
            {
                throw new NotFoundHttpException('Lo sentimos, el usuario proporcionado no tiene permiso para ingresar al sistema porque <b>no tiene carga académica</b>, debes acercarte a la institución educativa para solucionarlo.');
            }
        }

    }

  
}