<?php

namespace backend\controllers;

use Yii;

use backend\models\Frd;
use backend\models\FrdSearch;
use backend\models\Competencia;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\helpers\Html;


/**
 * FrdController implements the CRUD actions for Frd model.
 */
class FrdController extends Controller
{
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['post'],
                ],
            ],
        ];
    }

    /**
     * Lists all Frd models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new FrdSearch();

        if(Yii::$app->session->get('__tipo') == 2)
        {
            $searchModel->creado_por = Yii::$app->session->get('__id');
        }


        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single Frd model.
     * @param integer $id
     * @return mixed
     */
    public function actionView($id)
    {
        $model = $this->findModel($id);
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new Frd model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new Frd();

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->id]);
        } else {
            return $this->render('create', [
                'model' => $model,
            ]);
        }
    }

    /**
     * Updates an existing Frd model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->id]);
        } else {
            return $this->render('update', [
                'model' => $model,
            ]);
        }
    }


    
    public function actionListar()
    {
        $model = new Frd();
        $model->competencia = Yii::$app->request->get("competencia");

        $competencia = Competencia::findOne(Yii::$app->request->get("competencia"));
 
        return $this->renderAjax('listar', ['model' => $model, 'competencia' => $competencia]);
    }


    public function actionBuscar($query = '', $competencia = null)
    {
        $output = '';
        $competencia = Yii::$app->request->post("competencia");
        
        if(Yii::$app->request->post("query") != '')
        {
            $search = Yii::$app->request->post("query");
    
            $frds = Frd::find()
                        ->where(['like', 'descripcion', $search])
                        ->orWhere(['like', 'id', $search])
                        ->andWhere(['competencia' => $competencia])
                        ->andWhere(['estado' => '1'])
                        ->orderBy(['id' => SORT_ASC])
                        ->all();
        }
        else
        {
            $frds = Frd::find()
                        ->where(['estado' => '1'])
                        ->andWhere(['competencia' => $competencia])
                        ->orderBy(['id' => SORT_ASC])
                        ->all();
        }

        if(count($frds) > 0)
        {
            $output .= '
                <div class="table-responsive">
                    <table class="table table-hover table-striped">
                        <thead class="thead-light">
                            <tr>
                                 <th class="hidden-xs">#</th>
                                 <th>Desempeño</th>
                                 <th>Tipo</th>
                                 <th>Descripción</th>
                            </tr>
                        </thead>    
             ';

            foreach ($frds as $frd) 
            {
                $output .= '<tr>';
                $output .= '<td>'.$frd->id.'</td>';

                $output .= '<td><span class="label" data-toggle="tooltip" title="'.$frd->desempenos->desempeno.'" style="width:50px; background-color:'.$frd->desempenos->color.'; color:#fff; margin:0 2px 0 10px;">'.$frd->desempenos->nota.'</span></td>';
                $output .= '<td>'.Html::encode($frd->tipos->tipo).'</td>';
                $output .= '<td>'.Html::encode($frd->descripcion).'</td>';
                //$output .= '<td align="center">'.Html::button('<i class="fa fa-rocket" aria-hidden="true"></i> <span class="hidden-xs">Lanzar</span>', ['value' => '', 'title' => '', 'data-toggle' => 'tooltip', 'class' => 'showModalButton btn btn-xs btn-warning']).'</td>';  
                $output .= '</tr>';
            }
            return $output;
        }
        else
        {
            return '<center><h4 class="text-primary">No hay registros con los parámetros requeridos</h4></center>';
        }
    }

    public function actionDelete($id)
    {
        //$this->findModel($id)->deleteWithRelated();

        $model = $this->findModel($id);
        $model->eliminado_por = \Yii::$app->user->id;
        $model->eliminado_el = new \yii\db\Expression('NOW()');
        $model->update();

        return $this->redirect(['index']);
    }

    public function actionRestore($id)
    {
        $this->findModel($id)->restoreWithRelated();

        return $this->redirect(['index']);
    }

    
    /**
     * Finds the Frd model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Frd the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Frd::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }
}
