<?php

namespace backend\controllers;

use Yii;
use backend\models\Frd;
use backend\models\FrdSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\web\Response;
use yii\widgets\ActiveForm;
use backend\models\Competencia;


/**
 * FrdController implements the CRUD actions for Frd model.
 */
class FrdController extends Controller
{
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['post'],
                ],
            ],
        ];
    }

    /**
     * Lists all Frd models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new FrdSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single Frd model.
     * @param integer $id
     * @return mixed
     */
    public function actionView($id)
    {
        $model = $this->findModel($id);
        $providerCalificacionFrd = new \yii\data\ArrayDataProvider([
            'allModels' => $model->calificacionFrds,
        ]);
        return $this->render('view', [
            'model' => $this->findModel($id),
            'providerCalificacionFrd' => $providerCalificacionFrd,
        ]);
    }

    /**
     * Creates a new Frd model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new Frd();

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->id]);
        } else {
            return $this->render('create', [
                'model' => $model,
            ]);
        }
    }

    public function actionUpdate($id)
    {
        $model = $this->findModel($id);

        return $this->renderAjax('_formAjax', [
                    'model' => $model,
        ]);
    }


    public function actionAdd($competencia, $nivel)
    {
        $model = new Frd();
        $model->competencia = Yii::$app->request->get('competencia');
        $model->nivel = Yii::$app->request->get('nivel');

        return $this->renderAjax('_formAjax', [
                    'model' => $model,
        ]);
    }


    public function actionSave($id = null)
    {
        
        if(Yii::$app->request->post('id'))
        {
            $model = $this->findModel(Yii::$app->request->post('id'));
        }
        else
        {
            $model = new Frd();    
        }

        if (Yii::$app->request->isAjax && $model->load(Yii::$app->request->post())) {
            Yii::$app->response->format = Response::FORMAT_JSON;
            return ActiveForm::validate($model);
        }

        if (Yii::$app->request->isAjax) 
        {
            $model->competencia = Yii::$app->request->post('competencia');
            $model->nivel = Yii::$app->request->post('nivel');
            $model->frd_tipo = Yii::$app->request->post('frd_tipo');
            $model->descripcion = Yii::$app->request->post('descripcion');
            $model->save();

            return $model->id;
        }


    }

    public function actionDelete($id = NULL)
    {
        

        if (Yii::$app->request->isAjax){
            //$this->findModel(Yii::$app->request->post('id'))->deleteWithRelated();
            $model = $this->findModel(Yii::$app->request->post('id'));
            $model->eliminado_por = \Yii::$app->user->id;
            $model->eliminado_el = new \yii\db\Expression('NOW()');
            $model->update();
            return Yii::$app->request->post('id');
        }
        else
        {
            //$this->findModel($id)->deleteWithRelated();

            $model = $this->findModel($id);
            $model->eliminado_por = \Yii::$app->user->id;
            $model->eliminado_el = new \yii\db\Expression('NOW()');
            $model->update();
            return $this->redirect(['index']);    
        }
    }


    
    public function actionListar()
    {
        $model = new Frd();
        $model->competencia = Yii::$app->request->get("competencia");

        $competencia = Competencia::findOne(Yii::$app->request->get("competencia"));
 
        return $this->renderAjax('listar', ['model' => $model, 'competencia' => $competencia]);
    }


    public function actionBuscar($query = '', $competencia = null)
    {
        $output = '';
        $competencia = Yii::$app->request->post("competencia");
        
        if(Yii::$app->request->post("query") != '')
        {
            $search = Yii::$app->request->post("query");
    
            $frds = Frd::find()
                        ->where(['like', 'descripcion', $search])
                        ->orWhere(['like', 'id', $search])
                        ->andWhere(['competencia' => $competencia])
                        ->andWhere(['estado' => '1'])
                        ->orderBy(['id' => SORT_ASC])
                        ->all();
        }
        else
        {
            $frds = Frd::find()
                        ->where(['estado' => '1'])
                        ->andWhere(['competencia' => $competencia])
                        ->orderBy(['id' => SORT_ASC])
                        ->all();
        }

        if(count($frds) > 0)
        {
            $output .= '
                <div class="table-responsive">
                    <table class="table table-hover table-striped">
                        <thead class="thead-light">
                            <tr>
                                 <th class="hidden-xs">#</th>
                                 <th>Desempeño</th>
                                 <th>Tipo</th>
                                 <th>Descripción</th>
                            </tr>
                        </thead>    
             ';

            foreach ($frds as $frd) 
            {
                $output .= '<tr>';
                $output .= '<td>'.$frd->id.'</td>';

                $output .= '<td><span class="label" data-toggle="tooltip" title="'.$frd->desempenos->desempeno.'" style="width:50px; background-color:'.$frd->desempenos->color.'; color:#fff; margin:0 2px 0 10px;">'.$frd->desempenos->nota.'</span></td>';
                $output .= '<td>'.Html::encode($frd->tipos->tipo).'</td>';
                $output .= '<td>'.Html::encode($frd->descripcion).'</td>';
                //$output .= '<td align="center">'.Html::button('<i class="fa fa-rocket" aria-hidden="true"></i> <span class="hidden-xs">Lanzar</span>', ['value' => '', 'title' => '', 'data-toggle' => 'tooltip', 'class' => 'showModalButton btn btn-xs btn-warning']).'</td>';  
                $output .= '</tr>';
            }
            return $output;
        }
        else
        {
            return '<center><h4 class="text-primary">No hay registros con los parámetros requeridos</h4></center>';
        }
    }


    
    /**
     * Finds the Frd model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Frd the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Frd::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException(Yii::t('app', 'The requested page does not exist.'));
        }
    }
    
    /**
    * Action to load a tabular form grid
    * for CalificacionFrd
    * @author Yohanes Candrajaya <moo.tensai@gmail.com>
    * @author Jiwantoro Ndaru <jiwanndaru@gmail.com>
    *
    * @return mixed
    */
    public function actionAddCalificacionFrd()
    {
        if (Yii::$app->request->isAjax) {
            $row = Yii::$app->request->post('CalificacionFrd');
            if (!empty($row)) {
                $row = array_values($row);
            }
            if((Yii::$app->request->post('isNewRecord') && Yii::$app->request->post('_action') == 'load' && empty($row)) || Yii::$app->request->post('_action') == 'add')
                $row[] = [];
            return $this->renderAjax('_formCalificacionFrd', ['row' => $row]);
        } else {
            throw new NotFoundHttpException(Yii::t('app', 'The requested page does not exist.'));
        }
    }
}
