<?php

namespace backend\controllers;

use Yii;
use backend\models\Grupomatricular;
use backend\models\Grupo;
use backend\models\GupomatricularSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;

/**
 * GrupomatricularController implements the CRUD actions for Grupomatricular model.
 */
class GrupomatricularController extends Controller
{
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['post'],
                ],
            ],
        ];
    }

  
    public function actionIndex()
    {
        return $this->redirect(['create']);
    }

    public function actionCreate($id = null)
    {
        if(isset($id))
        {   
            $model = $this->findModel($id);
        }
        else
        {
            $model = new Grupomatricular();    
        }

        
        $grupos_configurados = Grupomatricular::find()->select(['grupo_actual'])->where(['eliminado_por' => 0]);
        $grupos = Grupo::find()->where(['NOT IN', 'id', $grupos_configurados])->andWhere(['eliminado_por' => 0]);
                            
        //echo $grupos->createCommand()->getRawSql(); // Mostrar SQL   

        $grupos_configurados = Grupomatricular::find()->select(['grupo_actual'])->where(['eliminado_por' => 0]);
        $grupos = Grupo::find()->where(['NOT IN', 'id', $grupos_configurados])->andWhere(['eliminado_por' => 0])->all();

        $searchModel = new GupomatricularSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        //$grupos = Grupomatricular::find()->where(['estado' => '1'])->andWhere(['eliminado_por' => '0'])->all();

        if ($model->load(Yii::$app->request->post()) && $model->save()) 
        {
            Yii::$app->session->addFlash('mensaje', [
                'tipo' => 'info',
                'titulo' => 'Nuevo Registro',
                'icono' => 'far info',
                'mensaje' => 'Se agregó un nuevo registro <b>'.$model->grupoactual->grupo.'</b> >> <b>'.$model->gruponuevo->grupo.'</b> con éxito.',
            ]);

            $model = new Grupomatricular();

            return $this->render('create', [
                'model' => $model,
                'grupos' => $grupos,
                'searchModel' => $searchModel,
                'dataProvider' => $dataProvider,
            ]);
        }


        return $this->render('create', [
            'model' => $model,
            'grupos' => $grupos,
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }


    public function actionUpdate($id)
    {
        return $this->redirect(['create', 'id' => $id]);
    }

    public function actionDelete($id)
    {
        //$this->findModel($id)->deleteWithRelated();

        $model = $this->findModel($id);
        $model->eliminado_por = \Yii::$app->user->id;
        $model->eliminado_el = new \yii\db\Expression('NOW()');
        $model->update();

        return $this->redirect(['index']);
    }

    public function actionRestore($id)
    {
        $this->findModel($id)->restoreWithRelated();

        return $this->redirect(['index']);
    }

    
    protected function findModel($id)
    {
        if (($model = Grupomatricular::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException(Yii::t('app', 'The requested page does not exist.'));
        }
    }
}
