<?php

namespace backend\controllers;

use Yii;
use backend\models\base\Mensajes;
use backend\models\base\Upload;
use backend\models\base\Academico;
use yii\web\UploadedFile;

use backend\models\MensajesSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\data\ActiveDataProvider;
use yii\db\Expression;



/**
 * MensajesController implements the CRUD actions for Mensajes model.
 */
class MensajesController extends Controller
{
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['post'],
                ],
            ],
        ];
    }


    public function actionIndex()
    {
        $searchModel = new MensajesSearch();

        $searchModel->remisor = Yii::$app->session->get('__tercero');

        $searchModel->categoria = Yii::$app->request->get('categoria');
            
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    public function actionEnviados()
    {
        $searchModel = new MensajesSearch();

        if(Yii::$app->session->get('__tipo') == 2)
        {
            $searchModel->creado_por = Yii::$app->session->get('__id');
        }


        $searchModel->remitente = Yii::$app->session->get('__tercero');

        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('enviados', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    public function actionImportantes()
    {
        $searchModel = new MensajesSearch();

        if(Yii::$app->session->get('__tipo') == 2)
        {
            $searchModel->creado_por = Yii::$app->session->get('__id');
        }


        $searchModel->remisor = Yii::$app->session->get('__tercero');
        $searchModel->importante = '1';
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }    

    public function actionEliminados()
    {
        $searchModel = new MensajesSearch();

        if(Yii::$app->session->get('__tipo') == 2)
        {
            $searchModel->creado_por = Yii::$app->session->get('__id');
        }


        $searchModel->remisor = Yii::$app->session->get('__tercero');
        $searchModel->estado = '0';
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }  

    public function actionView($id)
    {
        $model = $this->findModel($id);
        
        if($model->visto == '0')
        {
            $model->visto = '1';
            $model->visto_el = new Expression('NOW()');
            $model->save(false);
        }
            

        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }



    public function actionCreate()
    {
        $model = new Mensajes();

        if ($model->load(Yii::$app->request->post()) ) {
            
            $mid = rand();

            /*
                $file = new Upload();

                if($file->files = UploadedFile::getInstances($model, 'adjunto'))
                {
                   $adjuntos = $file->upload('mensajes'); 
                }    
            */

            
            $adjuntos = [];
            
            /*    
            foreach (UploadedFile::getInstances($model, 'adjunto') as $adjunto) {
                list($drive) = Yii::$app->createController('drive');
                $adjuntos[] =  serialize($drive->actionSubir($adjunto));
            }*/


            foreach (UploadedFile::getInstances($model, 'adjunto') as $adjunto)
            {
                $id = Mensajes::find()->max('id') + 1;

                $s3 = Yii::$app->get('s3');    

                if(!$s3->exist('mensajes/'.$id.'/'))
                {
                    $s3->put('mensajes/'.$id.'/', null); 
                }

                /*if(!$s3->exist('planesaula/'.$id.'/'.Yii::$app->session->get('__tercero').'/'))
                {
                    $s3->put('planesaula/'.$id.'/'.Yii::$app->session->get('__tercero').'/', null);    
                }*/

                $body = file_get_contents($adjunto->tempName);
                $adjuntos[] = $s3->put('mensajes/'.$id.'/'.$adjunto->name, $body);
            } 
            
            $model->adjunto = json_encode(array_values($adjuntos));
            //$adjuntos = implode(',',$adjuntos);    

            if($model->tipo == 1 OR $model->tipo == 2 OR $model->tipo == 3) // ESTUDIANTE, DOCENTE, ADMINISTRATIVO
            {

                if($model->grupo == 1) // INDIVIDUAL
                {    
                    foreach ($model->remisor as $remisor) 
                    {    
                        $mensaje = new Mensajes();
                        $mensaje->mid = $mid;
                        $mensaje->remitente = (Yii::$app->session->get('__tercero')=='') ? NULL : Yii::$app->session->get('__tercero');
                        $mensaje->remisor = $remisor;
                        $mensaje->asunto = $model->asunto;
                        $mensaje->categoria = $model->categoria;
                        $mensaje->importante = $model->importante;
                        $mensaje->cartelera = $model->cartelera;
                        $mensaje->mensaje = $model->mensaje;
                        $mensaje->adjunto = $adjuntos;
                        $mensaje->estado = '1';
                        $mensaje->save(false);
                        
                    }
                }
                else // GRUPO
                {
                    foreach ($model->remisor as $remisor) 
                    {    
                        $estudiantes = Academico::find()->where(['grupo' => $remisor])->all();
                        
                        foreach ($estudiantes as $estudiante) 
                        {
                            
                            $mensaje = new Mensajes();
                            $mensaje->mid = $mid;
                            $mensaje->remitente = (Yii::$app->session->get('__tercero')=='') ? NULL : Yii::$app->session->get('__tercero');
                            $mensaje->remisor = $estudiante->estudiante;
                            $mensaje->asunto = $model->asunto;
                            $mensaje->categoria = $model->categoria;
                            $mensaje->importante = $model->importante;
                            $mensaje->cartelera = $model->cartelera;
                            $mensaje->mensaje = $model->mensaje;
                            $mensaje->adjunto = $adjuntos;
                            $mensaje->estado = '1';
                            $mensaje->save(false);                              
                        }
                        
                    }
                }
            }

            if($model->tipo == 4) //ACUDIENTE
            {
                if($model->grupo == 1) // INDIVIDUAL
                {    
                    
                }
                else // GRUPO
                {
                    
                }
            }


            \Yii::$app->session->addFlash('mail', [
                            'tipo' => 'success',
                            'titulo' => 'Mensaje Enviado',
                            'icono' => 'fa fa-envelope',
                            'mensaje' => 'Su mensaje ha sido enviado!',
                        ]);

            return $this->redirect(['index']);
        } else {
            return $this->render('create', [
                'model' => $model,
            ]);
        }
    }

    public function actionDelete($id)
    {
        //$this->findModel($id)->deleteWithRelated();

        $model = $this->findModel($id);
        $model->eliminado_por = \Yii::$app->user->id;
        $model->eliminado_el = new \yii\db\Expression('NOW()');
        $model->update();   
        return $this->redirect(['index']);   
    }

    public function actionDeletenota($id)
    {
        if (Yii::$app->request->isAjax) 
        {
            //$this->findModel($id)->deleteWithRelated();

        $model = $this->findModel($id);
        $model->eliminado_por = \Yii::$app->user->id;
        $model->eliminado_el = new \yii\db\Expression('NOW()');
        $model->update();
        }        
    }

    
    /**
     * Finds the Mensajes model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Mensajes the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Mensajes::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }

    public function actionFindxgrupo() {
    
        $out = [];
        if (isset($_POST['depdrop_parents'])) {
            $parents = $_POST['depdrop_parents'];
            if ($parents != null) {
                $tipo_id = $parents[0];

                if($tipo_id ==1 or $tipo_id == 4)
                {
                    $out=[['id' => 1, 'name'=> 'Seleccionar Individualmente'],['id' => 2, 'name'=> 'Seleccionar por Grupo']];
                    return json_encode(['output'=>$out, 'selected'=> '']);
                }
                else
                {
                    $out=[['id' => 1, 'name'=> 'Seleccionar Individualmente']];
                                    
                    return json_encode(['output'=>$out, 'selected'=> '1']);
                }    
                
                return;
            }
        }
        return json_encode(['output'=>'', 'selected'=>'']);
    }

    public function actionFinddestinatarios() {
    
        $out = [];
        if (isset($_POST['depdrop_parents'])) {
            $parents = $_POST['depdrop_parents'];
            if ($parents != null) {
                $tipo_id = $parents[0];
                $grupo_id = $parents[1];
                $out = Mensajes::getDestinatariosbyTipo($tipo_id,$grupo_id);
                
                return json_encode(['output'=>$out, 'selected'=>'']);
            }
        }
        return json_encode(['output'=>'', 'selected'=>'']);
    }
}
