<?php

namespace backend\controllers;

use Yii;
use backend\models\Menuweb;
use backend\models\MenuwebSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;

use backend\models\Blogcategoria;
use backend\models\Blog;
use backend\models\Documentocategoria;
                        
/**
 * MenuwebController implements the CRUD actions for Menuweb model.
 */
class MenuController extends Controller
{
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['post'],
                ],
            ],
        ];
    }

    /**
     * Lists all Menuweb models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new MenuwebSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single Menuweb model.
     * @param integer $id
     * @return mixed
     */
    public function actionView($id)
    {
        $model = $this->findModel($id);
        $providerMenuweb = new \yii\data\ArrayDataProvider([
            'allModels' => $model->hijos,
        ]);
        return $this->render('view', [
            'model' => $this->findModel($id),
            'providerMenuweb' => $providerMenuweb,
        ]);
    }

    /**
     * Creates a new Menuweb model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new Menuweb();

        if ($model->loadAll(Yii::$app->request->post()) && $model->saveAll()) {
            return $this->redirect(['index']);
        } else {
            return $this->render('create', [
                'model' => $model,
            ]);
        }
    }

    /**
     * Updates an existing Menuweb model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);

        if ($model->loadAll(Yii::$app->request->post()) && $model->saveAll()) {
            return $this->redirect(['index']);
        } else {
            return $this->render('update', [
                'model' => $model,
            ]);
        }
    }

    /**
     * Deletes an existing Menuweb model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     */
    public function actionDelete($id)
    {
        $this->findModel($id)->deleteWithRelated();

        return $this->redirect(['index']);
    }


    public function actionFinditem() {
    
        $out = [];
        if (isset($_POST['depdrop_parents'])) {
            $parents = $_POST['depdrop_parents'];
            if ($parents != null) {
                
                $tipo = $parents[0];

                switch ($tipo) 
                {
                    case '1':
                        // CATEGORIA DE ARTICULO
                        $out=Blogcategoria::getItemsbytipo($tipo);
                        break;

                    case '2':
                        // ARTICULO
                        $out=Blog::getItemsbytipo($tipo);
                        break;
                    
                    case '3':
                        // CATEGORIA DE DOCUMENTO                    
                        $out=Documentocategoria::getItemsbytipo($tipo);
                        break;

                    case '4':
                        // DOCUMENTO
                        $out=Documento::getItemsbytipo($tipo);
                        break;

                    case '5':
                        // ENLACE
                        $out=Documento::getItemsbytipo($tipo);
                        break;

                    case '6':
                        // CONTÁCTO
                        echo Html::a($menu->nombre, ['site/contacto'], ['class'=>'nav-link']);  
                        break;

                    case '7':
                        // PQRSD

                        $out = [['id' => '1', 'name' => 'Con Registro'],
                                ['id' => '2', 'name' => 'Anónimo'],
                                ['id' => '3', 'name' => 'Consultar']
                               ];
                        break;

                    case '8':
                        // AGENDA
                        //echo Html::a($menu->nombre, ['agenda'], ['class'=>'nav-link']);  
                        $out = [['id' => '1', 'name' => 'Agenda Mensual']];
                        break;

                    default:
                        # code...
                        break;
                }
                
                
                return json_encode(['output'=>$out, 'selected'=>'']);
            }
        }
        return json_encode(['output'=>'', 'selected'=>'']);
    }


    protected function findModel($id)
    {
        if (($model = Menuweb::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException(Yii::t('app', 'The requested page does not exist.'));
        }
    }
    
    /**
    * Action to load a tabular form grid
    * for Menuweb
    * @author Yohanes Candrajaya <moo.tensai@gmail.com>
    * @author Jiwantoro Ndaru <jiwanndaru@gmail.com>
    *
    * @return mixed
    */
    public function actionAddMenuweb()
    {
        if (Yii::$app->request->isAjax) {
            $row = Yii::$app->request->post('Menuweb');
            if (!empty($row)) {
                $row = array_values($row);
            }
            if((Yii::$app->request->post('isNewRecord') && Yii::$app->request->post('_action') == 'load' && empty($row)) || Yii::$app->request->post('_action') == 'add')
                $row[] = [];
            return $this->renderAjax('_formMenuweb', ['row' => $row]);
        } else {
            throw new NotFoundHttpException(Yii::t('app', 'The requested page does not exist.'));
        }
    }
}
