<?php

namespace backend\controllers;

use Yii;
use backend\models\Nivel;
use backend\models\NivelSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\web\Response;
use yii\helpers\Json;
use yii\widgets\ActiveForm;



class NivelController extends Controller
{
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['post'],
                ],
            ],
        ];
    }


    public function actionIndex()
    {
        $searchModel = new NivelSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }


    public function actionView($id)
    {
        $model = $this->findModel($id);
        $providerFrd = new \yii\data\ArrayDataProvider([
            'allModels' => $model->frds,
        ]);
        return $this->render('view', [
            'model' => $this->findModel($id),
            'providerFrd' => $providerFrd,
        ]);
    }


    public function actionCreate()
    {
        $model = new Nivel();

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->id]);
        } else {
            return $this->render('create', [
                'model' => $model,
            ]);
        }
    }


    public function actionUpdate($id)
    {
        $model = $this->findModel($id);

        return $this->renderAjax('_formAjax', [
                    'model' => $model,
        ]);
    }


    public function actionAdd($id = NULL, $competencia = NULL)
    {
        $model = new Nivel();
        $model->competencia = Yii::$app->request->get('competencia');

        return $this->renderAjax('_formAjax', [
                    'model' => $model,
        ]);
    }

    public function actionSave($id = NULL)
    {
        
        if(Yii::$app->request->post('id'))
        {
            $model = $this->findModel(Yii::$app->request->post('id'));
        }
        else
        {
            $model = new Nivel();    
        }

        if (Yii::$app->request->isAjax && $model->load(Yii::$app->request->post())) {
            Yii::$app->response->format = Response::FORMAT_JSON;
            return ActiveForm::validate($model);
        }

        if (Yii::$app->request->isAjax) 
        {
            $model->competencia = Yii::$app->request->post('competencia');
            $model->desempeno = Yii::$app->request->post('desempeno');
            $model->nivel = Yii::$app->request->post('nivel');
            $model->recomendacion = Yii::$app->request->post('recomendacion');
            $model->save();
            
            return $model->id;
        }


    }


    public function actionDelete($id = NULL)
    {
        if (Yii::$app->request->isAjax){
            //$this->findModel(Yii::$app->request->post('id'))->deleteWithRelated();
            $model = $this->findModel(Yii::$app->request->post('id'));
            $model->eliminado_por = \Yii::$app->user->id;
            $model->eliminado_el = new \yii\db\Expression('NOW()');
            $model->update();
            return Yii::$app->request->post('id');
        }
        else
        {
            //$this->findModel($id)->deleteWithRelated();

        $model = $this->findModel($id);
        $model->eliminado_por = \Yii::$app->user->id;
        $model->eliminado_el = new \yii\db\Expression('NOW()');
        $model->update();
            return $this->redirect(['index']);    
        }
    }


    protected function findModel($id)
    {
        if (($model = Nivel::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException(Yii::t('app', 'The requested page does not exist.'));
        }
    }
    
    
    public function actionAddFrd()
    {
        if (Yii::$app->request->isAjax) {
            $row = Yii::$app->request->post('Frd');
            if (!empty($row)) {
                $row = array_values($row);
            }
            if((Yii::$app->request->post('isNewRecord') && Yii::$app->request->post('_action') == 'load' && empty($row)) || Yii::$app->request->post('_action') == 'add')
                $row[] = [];
            return $this->renderAjax('_formFrd', ['row' => $row]);
        } else {
            throw new NotFoundHttpException(Yii::t('app', 'The requested page does not exist.'));
        }
    }
}
