<?php

namespace backend\controllers;

use Yii;
use backend\models\Observador;
use backend\models\ObservadorSearch;
use backend\models\Tercero;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\web\Response;
use yii\widgets\ActiveForm;

/**
 * ObservadorController implements the CRUD actions for Observador model.
 */
class ObservadorController extends Controller
{

/*
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::class,
                'actions' => [
                    'delete' => ['post'],
                ],
            ],
        ];
    }
*/


    /**
     * Lists all Observador models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new ObservadorSearch();

        if(Yii::$app->session->get('__tipo') == 2)
        {
            $searchModel->creado_por = Yii::$app->session->get('__id');
        }


        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    public function actionComprometidos($id)
    {

        $array = explode(",", $id);
        $estudiantes = '';
        foreach ($array as $id) {
            $estudiantes .= Tercero::find()->where(['id' => $id])->one()->nombre.'<br>';
        }

        return $estudiantes;
    }

    /**
     * Displays a single Observador model.
     * @param integer $id
     * @return mixed
     */
    public function actionView($id)
    {
        $model = $this->findModel($id);
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    

    public function actionCreate()
    {
        $model = new Observador();
        $tercero = new Tercero();

        if (Yii::$app->request->isAjax && $model->load(Yii::$app->request->post())) {
            Yii::$app->response->format = Response::FORMAT_JSON;
            return ActiveForm::validate($model);
        }

        if ($model->load(Yii::$app->request->post())) {
                    
            foreach ($model->comprometidos as $estudiante) 
            {
            
                $observador = new Observador();
                $observador->estudiante = $estudiante;
                $observador->comprometidos = implode(",", $model->comprometidos);
                $observador->momento = $model->momento;
                $observador->asignatura = $model->asignatura;
                $observador->periodo = $model->periodo;
                $observador->fecha = $model->fecha;
                $observador->docente = (Yii::$app->session->get('__tercero')=='') ? NULL : Yii::$app->session->get('__tercero');
                $observador->clase_observacion = $model->clase_observacion;
                $observador->tipo_observacion = $model->tipo_observacion;
                $observador->descripcion = $model->descripcion;
                $observador->descargos = $model->descargos;
                $observador->proceso = $model->proceso;
                $observador->estado = '1';
                $observador->save();

            }

            return $this->redirect(['index', 'id' => $model->id]);

        } 
        else 
        {
                    
            return $this->render('create', [
                'model' => $model,
                'estudiantes' => $tercero->getEstudiantes(),
            ]);
            
             
        }
    }

    public function actionRefresh()
    {
        $tercero = new Tercero();
        Yii::$app->getResponse()->format = 'json';
        return $tercero->getEstudiantes();
    }


    public function actionAssign($success = null)
    {
        if (Yii::$app->request->isAjax) 
        {
            Yii::$app->getResponse()->format = 'json';
            return ['success' => $success];
        }
        else
        {
            throw new NotFoundHttpException('Solicitud no valida');
        }
    }

    public function actionRemove()
    {
        if (Yii::$app->request->isAjax) 
        {
            Yii::$app->getResponse()->format = 'json';
            return true;
        }
        else
        {
            throw new NotFoundHttpException('Solicitud no valida');
        }
    }


    /**
     * Updates an existing Observador model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     */
    
    
    public function actionUpdate($id)
    {
        if (Yii::$app->request->post('_asnew') == '1') {
            $model = new Observador();
        }else{
            $model = $this->findModel($id);
        }

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->id]);
        } else {
            return $this->render('update', [
                'model' => $model,
            ]);
        }
    }



    /**
     * Deletes an existing Observador model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     */
    public function actionDelete($id)
    {
        //$this->findModel($id)->deleteWithRelated();

        $model = $this->findModel($id);
        $model->eliminado_por = \Yii::$app->user->id;
        $model->eliminado_el = new \yii\db\Expression('NOW()');
        $model->update();

        return $this->redirect(['index']);
    }

    public function actionRestore($id)
    {
        $this->findModel($id)->restoreWithRelated();

        return $this->redirect(['index']);
    }
    
    /**
     * 
     * Export Observador information into PDF format.
     * @param integer $id
     * @return mixed
     */
    public function actionPdf($id) {
        $model = $this->findModel($id);

        $content = $this->renderAjax('_pdf', [
            'model' => $model,
        ]);

        $pdf = new \kartik\mpdf\Pdf([
            'mode' => \kartik\mpdf\Pdf::MODE_CORE,
            'format' => \kartik\mpdf\Pdf::FORMAT_A4,
            'orientation' => \kartik\mpdf\Pdf::ORIENT_PORTRAIT,
            'destination' => \kartik\mpdf\Pdf::DEST_BROWSER,
            'content' => $content,
            'cssFile' => '@vendor/kartik-v/yii2-mpdf/assets/kv-mpdf-bootstrap.min.css',
            'cssInline' => '.kv-heading-1{font-size:18px}',
            'options' => ['title' => \Yii::$app->name],
            'methods' => [
                'SetHeader' => [\Yii::$app->name],
                'SetFooter' => ['{PAGENO}'],
            ]
        ]);

        return $pdf->render();
    }

    /**
    * Creates a new Observador model by another data,
    * so user don't need to input all field from scratch.
    * If creation is successful, the browser will be redirected to the 'view' page.
    *
    * @param type $id
    * @return type
    */
    public function actionSaveAsNew($id) {
        $model = new Observador();

        if (Yii::$app->request->post('_asnew') != '1') {
            $model = $this->findModel($id);
        }
    
        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->id]);
        } else {
            return $this->render('saveAsNew', [
                'model' => $model,
            ]);
        }
    }
    
    /**
     * Finds the Observador model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Observador the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Observador::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }
}
