<?php

namespace backend\controllers;

use Yii;
use backend\models\base\Observaciongeneral;
use backend\models\ObsgeneralSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\helpers\Html;
use yii\helpers\Url;


/**
 * ObsgeneralController implements the CRUD actions for Observaciongeneral model.
 */
class ObsgeneralController extends Controller
{


    /**
     * Lists all Observaciongeneral models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new ObsgeneralSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single Observaciongeneral model.
     * @param integer $id
     * @return mixed
     */
    public function actionView($id)
    {
        $model = $this->findModel($id);
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new Observaciongeneral model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new Observaciongeneral();

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->id]);
        } else {
            return $this->render('create', [
                'model' => $model,
            ]);
        }
    }

    /**
     * Updates an existing Observaciongeneral model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->id]);
        } else {
            return $this->render('update', [
                'model' => $model,
            ]);
        }
    }

    /**
     * Deletes an existing Observaciongeneral model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     */
    public function actionDelete($id)
    {
        //$this->findModel($id)->deleteWithRelated();

        $model = $this->findModel($id);
        $model->eliminado_por = \Yii::$app->user->id;
        $model->eliminado_el = new \yii\db\Expression('NOW()');
        $model->update();

        return $this->redirect(['index']);
    }

    public function actionRestore($id)
    {
        $this->findModel($id)->restoreWithRelated();

        return $this->redirect(['index']);
    }
    
    
    public function actionListar()
    {
        $model = new Observaciongeneral();
        return $this->renderAjax('listar', ['model' => $model]);
    }


    public function actionBuscar($query = '', $id = NULL)
    {
        $output = '';

        if(isset($_POST["query"]))
        {
            $search = $_POST["query"];
    
            $observaciones = Observaciongeneral::find()
                        ->where(['like', 'observacion', $search])
                        ->orWhere(['like', 'id', $search])
                        ->andWhere(['estado' => '1'])
                        ->orderBy(['id' => SORT_ASC])
                        ->all();
        }
        else
        {
            $observaciones = Observaciongeneral::find()
                        ->where(['estado' => '1'])
                        ->orderBy(['id' => SORT_ASC])
                        ->all();
        }

        if(count($observaciones) > 0)
        {
            $output .= '
                <div class="table-responsive">
                    <table class="table table-hover table-striped">
                        <thead class="thead-light">
                            <tr>
                                 <th class="hidden-xs">#</th>
                                 <th colspan="2">Observación General</th>
                            </tr>
                        </thead>    
             ';

            foreach ($observaciones as $observacion) 
            {
                $output .= '<tr>';
                $output .= '<td>'.$observacion->id.'</td>';
                $output .= '<td>'.Html::encode($observacion->observacion).'</td>';
                $output .= '<td><div id="add_'.$observacion->id.'">'.Html::button('<i class="fa fa-plus" aria-hidden="true"></i>', ['id' => 'add', 'title' => Yii::t('app', 'Agregar'), 'class' => 'btn btn-primary btn-xs', 'disabled' => false, 'onclick' => 'AddObservaciones('.$_POST["id"].','.$observacion->id.');']).'</div></td>';
                                 
                                 

                //$output .= '<td align="center">'.Html::button('<i class="fa fa-rocket" aria-hidden="true"></i> <span class="hidden-xs">Lanzar</span>', ['value' => '', 'title' => '', 'data-toggle' => 'tooltip', 'class' => 'showModalButton btn btn-xs btn-warning']).'</td>';  
                $output .= '</tr>';
            }
            return $output;
        }
        else
        {
            return '<center><h4 class="text-primary">No hay registros con los parámetros requeridos</h4></center>';
        }
    }


    public function actionPdf($id) {
        $model = $this->findModel($id);

        $content = $this->renderAjax('_pdf', [
            'model' => $model,
        ]);

        $pdf = new \kartik\mpdf\Pdf([
            'mode' => \kartik\mpdf\Pdf::MODE_CORE,
            'format' => \kartik\mpdf\Pdf::FORMAT_A4,
            'orientation' => \kartik\mpdf\Pdf::ORIENT_PORTRAIT,
            'destination' => \kartik\mpdf\Pdf::DEST_BROWSER,
            'content' => $content,
            'cssFile' => '@vendor/kartik-v/yii2-mpdf/assets/kv-mpdf-bootstrap.min.css',
            'cssInline' => '.kv-heading-1{font-size:18px}',
            'options' => ['title' => \Yii::$app->name],
            'methods' => [
                'SetHeader' => [\Yii::$app->name],
                'SetFooter' => ['{PAGENO}'],
            ]
        ]);

        return $pdf->render();
    }
    
    /**
     * Finds the Observaciongeneral model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Observaciongeneral the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Observaciongeneral::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }
}
