<?php

namespace backend\controllers;

use Yii;
use backend\models\Academico;
use backend\models\Carga;
use backend\models\Tercero;
use backend\models\Asistencia;
use backend\models\AsistenciaSearch;
use backend\models\Grupo;
use backend\models\Asignatura;
use backend\models\Periodo;
use backend\models\TipoInasistencia;
use backend\models\Calificacion;
use backend\models\Desempeno;
use backend\models\Competencia;
use backend\models\Sede;
use backend\models\LanzadorForm;


use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\helpers\ArrayHelper;
use yii\data\ActiveDataProvider;
use yii\base\Model;
use yii\helpers\Html;


use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Style\Alignment;
use PhpOffice\PhpSpreadsheet\Style\Border;
use PhpOffice\PhpSpreadsheet\Style\Fill;
use PhpOffice\PhpSpreadsheet\Style\Style;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpSpreadsheet\Helper\Sample;
use PhpOffice\PhpSpreadsheet\IOFactory;
use PhpOffice\PhpSpreadsheet\Worksheet\PageSetup;


use Mpdf\Mpdf;


class ReporteController extends Controller
{

    public function action101($grupo = NULL, $asignatura = NULL) // Reporte de Ausentismo por Asignatura y Grupo
    {

        if($asignatura == NULL && $grupo == NULL)
        {    
            $model = new LanzadorForm();
            $model->reporte = 'Reporte Consolidado de Ausentismo Mensual';
            $model->observaciones = 'Exporta la información de ausentismo por asignatura y grupo según sea el caso; este reporte se genera en formato Excel.';

            if ($model->load(Yii::$app->request->post())) {

                $asignatura = $model->asignatura; 
                $grupo = $model->grupo;
                
            }
            else
            {
                return $this->render('/publica/lanzador', ['model' => $model]);
                exit;
            }    
        }

        date_default_timezone_set('America/Bogota');

        /// MARGENES HOJA
        $top = '1';
        $right = '0.5';
        $left = '0.5';
        $bottom = '1';

        $grupo = Grupo::findOne($grupo);
        
        if(isset($asignatura))
        {
            $asignatura = Asignatura::findOne($asignatura);  
        }    
        
        $anio = $grupo->sedes->vigencia;

        $mes = ['ENE', 'FEB', 'MAR', 'ABR', 'MAY', 'JUN', 'JUL', 'AGO', 'SEP', 'OCT', 'NOV', 'DIC'];
        $mescompleto = ['Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre'];


        $Excel = new Spreadsheet();

        $Excel->getProperties()
            ->setCreator("Sonic")
            ->setLastModifiedBy("Sonic")
            ->setTitle("Reporte 101 - Consolidado de Ausentismo Mensual")
            ->setDescription("Documento Generado por Sonic")
            ->setCategory("Listados");     

        $this->render('_headerandfooter_excel_landscape', ['Excel' => $Excel]);    

        $Excel->setActiveSheetIndex(0);

        $Excel->getActiveSheet()->getPageSetup()->setOrientation(PageSetup::ORIENTATION_LANDSCAPE);
        $Excel->getActiveSheet()->getPageSetup()->setPaperSize(PageSetup::PAPERSIZE_FOLIO);
        $Excel->getActiveSheet()->getPageSetup()->setHorizontalCentered(true);
        $Excel->getActiveSheet()->getPageMargins()->setTop($top);
        $Excel->getActiveSheet()->getPageMargins()->setRight($right);
        $Excel->getActiveSheet()->getPageMargins()->setLeft($left);
        $Excel->getActiveSheet()->getPageMargins()->setBottom($bottom);
        
        $Excel->getActiveSheet()->setTitle('Consolidado');


        $Excel->getActiveSheet()->getStyle('A1:A2')->applyFromArray(array(
            'font'  => array(
                    'bold'  => true,
                    'color' => array('rgb' => '000000'),
                    'size'  => 12,
                    'name'  => 'Calibri'
            ),
            'alignment' => array(
              'horizontal' => Alignment::HORIZONTAL_CENTER,
            )
        ));
        

        $fila = '4';
        $Excel->getActiveSheet()->setCellValue('A'.$fila, "#");
        $Excel->getActiveSheet()->setCellValue('B'.$fila, "ESTUDIANTE");  
        

        $d = 'C';
        for ($x='1'; $x <= date('m'); $x++)
        {   

            $Excel->getActiveSheet()->setCellValue($d.$fila, $mes[$x-1]);
            $d++;
        } 

        
        $Excel->getActiveSheet()->mergeCells('A1:'.$d.'1');
        
        $Excel->getActiveSheet()->setCellValue('A1', isset($asignatura) ? 'Reporte Consolidado Mensual de Ausentismo por Asignatura & Grupo' : 'Reporte Consolidado Mensual de Ausentismo por Grupo');
        
        $Excel->getActiveSheet()->mergeCells('A2:'.$d.'2');
        $Excel->getActiveSheet()->setCellValue('A2', isset($asignatura) ? 'Asignatura - '.$asignatura->asignatura.'   |   Grupo - '.$grupo->grupo : 'Grupo - '.$grupo->grupo);
        $Excel->getActiveSheet()->mergeCells('A3:'.$d.'3');

        $Excel->getActiveSheet()->setCellValue($d.$fila, 'TOTAL');

        $estudiantes = Tercero::find()->where(['=', 'academico.grupo', $grupo->id])->joinWith(['academicos'])->all();

        $i = $fila + 1;     
     
        foreach ($estudiantes as $estudiante) 
        {
            $Excel->getActiveSheet()->getRowDimension($i)->setRowHeight('15');
            $Excel->getActiveSheet()->setCellValue('A'.$i, $i-$fila);  
            $Excel->getActiveSheet()->setCellValue('B'.$i, mb_strtoupper($estudiante->nombreinverso));    
            
            $h ='C';
            for ($x='1'; $x <= date('m'); $x++)
            { 
              $k = $x - 1;
              $Excel->getActiveSheet()->getColumnDimension($h)->setAutoSize(true);

              
              //$Excel->getActiveSheet()->getColumnDimension($h)->setWidth(7);
              $Excel->getActiveSheet()->setCellValue($h.$i, "=".$mes[$k]."!AH".$i."");

              $g = $h;
              $h++;

            }

            $Excel->getActiveSheet()->setCellValue($h.$i, "=SUM(C".$i.":".$g.$i.")");
          $i++;
        }

          $i--;


          // BORDE
          $Excel->getActiveSheet()->getStyle('A'.$fila.':' . 
            $Excel->getActiveSheet()->getHighestColumn() . 
            $Excel->getActiveSheet()->getHighestRow()
            )->getBorders()->getAllBorders()->setBorderStyle(Border::BORDER_THIN);

          
          // ENCABEZADO LISTA
          $Excel->getActiveSheet()->getStyle('A'.$fila.':'.$d.$fila)->applyFromArray(
              array(
                'font'  => array(
                    'bold'  => true,
                    'size'  => 12,
                    'name'  => 'Calibri'
                ),
                'fill' => array(
                    'fillType' => Fill::FILL_SOLID,
                    'color' => array('rgb' => 'DDDDDD')
                ),
                'alignment' => array(
                  'horizontal' => Alignment::HORIZONTAL_CENTER,
                )
              )
          );


          // TAMAÑO Y FUENTE
          $fila = $fila+1;
          $Excel->getActiveSheet()->getStyle('A'.$fila.':' . 
            $Excel->getActiveSheet()->getHighestColumn() . 
            $Excel->getActiveSheet()->getHighestRow()
            )->applyFromArray(array(
                'font'  => array(
                    'bold'  => false,
                    'size'  => 12,
                    'name'  => 'Calibri'
                ),
                'alignment' => array(
                   // 'horizontal' => \PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
                   // 'vertical' => \PHPExcel_Style_Alignment::VERTICAL_CENTER,
                ),
            ));  

          //COLUMNA ID         
          $Excel->getActiveSheet()
            ->getStyle('A'.$fila.':A'.$Excel->getActiveSheet()->getHighestRow())
            ->applyFromArray(array(
                'font'  => array(
                    'bold'  => true,
                ),
                
            ));

          //COLUMNA DOCENTE         
          $Excel->getActiveSheet()
            ->getStyle('B'.$fila.':B'.$Excel->getActiveSheet()->getHighestRow())
            ->applyFromArray(array(
                'alignment' => array(
                   // 'horizontal' => \PHPExcel_Style_Alignment::HORIZONTAL_LEFT,
                ),
            ));   

        $Excel->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);
        $Excel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
        $Excel->getActiveSheet()->getColumnDimension('O')->setAutoSize(true);      

          
        /////////////////////////////////////////////////////////////////////////////////////////
        /////                                                                               /////
        /////                                                                               /////
        /////                            FIN CONSOLIDADO MENSUAL                            /////
        /////                                  LISTADO MES                                  /////
        /////                                                                               /////
        /////                                                                               /////
        /////////////////////////////////////////////////////////////////////////////////////////        


        for ($b = 1; $b <= date('m'); $b++) 
        {
            $n = $b -1;
            $Excel->createSheet();    
            $Excel->setActiveSheetIndex($b);

            $Excel->getActiveSheet()->getPageSetup()->setOrientation(PageSetup::ORIENTATION_LANDSCAPE);
            $Excel->getActiveSheet()->getPageSetup()->setPaperSize(PageSetup::PAPERSIZE_FOLIO);
            $Excel->getActiveSheet()->getPageMargins()->setTop($top);
            $Excel->getActiveSheet()->getPageMargins()->setRight($right);
            $Excel->getActiveSheet()->getPageMargins()->setLeft($left);
            $Excel->getActiveSheet()->getPageMargins()->setBottom($bottom);
            $Excel->getActiveSheet()->setTitle($mes[$n]);


            $this->render('_headerandfooter_excel_landscape', ['Excel' => $Excel]);    


            $Excel->getActiveSheet()->getStyle('A1:A2')->applyFromArray(array(
                'font'  => array(
                        'bold'  => true,
                        //'color' => array('rgb' => 'FF0000'),
                        'size'  => 12,
                        'name'  => 'Calibri'
                ),
                'alignment' => array(
                  'horizontal' => Alignment::HORIZONTAL_CENTER,
                )
            ));
            

            $fila = '4';
            $Excel->getActiveSheet()->setCellValue('A'.$fila, "#");
            $Excel->getActiveSheet()->setCellValue('B'.$fila, "ESTUDIANTE");  
            

            $d = 'C';
            for ($x='1'; $x <= '31'; $x++)
            {   

                $Excel->getActiveSheet()->setCellValue($d.$fila, $x);
                $d++;
            } 

            
            $Excel->getActiveSheet()->mergeCells('A1:'.$d.'1');
            
            $Excel->getActiveSheet()->setCellValue('A1', isset($asignatura) ? 'Reporte Consolidado Mensual de Ausentismo por Asignatura & Grupo' : 'Reporte Consolidado Mensual de Ausentismo por Grupo');
            
            $Excel->getActiveSheet()->mergeCells('A2:'.$d.'2');
            $Excel->getActiveSheet()->setCellValue('A2', isset($asignatura) ? 'Asignatura - '.$asignatura->asignatura.'   |   Grupo - '.$grupo->grupo.'   |   Mes - '.$mescompleto[$n] : 'Grupo - '.$grupo->grupo.'   |   Mes - '.$mescompleto[$n]);
            $Excel->getActiveSheet()->mergeCells('A3:'.$d.'3');

            $Excel->getActiveSheet()->setCellValue($d.$fila, 'TOTAL');

            $estudiantes = Tercero::find()->where(['=', 'academico.grupo', $grupo->id])->joinWith(['academicos'])->all();

            $i = $fila + 1;     
         
            foreach ($estudiantes as $estudiante) 
            {
                $Excel->getActiveSheet()->getRowDimension($i)->setRowHeight('15');
                $Excel->getActiveSheet()->setCellValue('A'.$i, $i-$fila);  
                $Excel->getActiveSheet()->setCellValue('B'.$i, mb_strtoupper($estudiante->nombreinverso));    
                
                $h ='C';
                for ($x='1'; $x <= '31'; $x++)
                { 
                    
                    if(isset($asignatura))
                    {  
                        $fallas = Asistencia::find()->where(['estudiante'=> $estudiante->id, 'asignatura' => $asignatura])->andWhere(['between', 'fecha', ''.$anio.'-'.$b.'-'.$x.' 00:00:00', ''.$anio.'-'.$b.'-'.$x.' 23:59:59'])->sum('fallas');
                    }
                    else 
                    {
                        $fallas = Asistencia::find()->where(['estudiante'=> $estudiante->id])->andWhere(['between', 'fecha', ''.$anio.'-'.$b.'-'.$x.' 00:00:00', ''.$anio.'-'.$b.'-'.$x.' 23:59:59'])->sum('fallas'); 
                    }  

                    //$Excel->getActiveSheet()->getColumnDimensionByColumn($h)->setAutoSize(false);
                    $Excel->getActiveSheet()->getColumnDimension($h)->setWidth(2.8);
                    $Excel->getActiveSheet()->setCellValue($h.$i, $fallas);

                    if($fallas != '')
                    {
                        $Excel->getActiveSheet()->getStyle($h.$i)->applyFromArray(
                          array(
                            'fill' => array(
                                'fillType' => Fill::FILL_SOLID,
                                'color' => array('rgb' => 'FF7373')
                            )
                          )
                        );
                    }  

                    $h++; 

                }
                
                $Excel->getActiveSheet()->setCellValue("AH".$i, "=SUM(B".$i.":AF".$i.")");
              $i++;

            }
        
      
          $i--;


          // BORDE
          $Excel->getActiveSheet()->getStyle('A'.$fila.':' . 
            $Excel->getActiveSheet()->getHighestColumn() . 
            $Excel->getActiveSheet()->getHighestRow()
            )->getBorders()->getAllBorders()->setBorderStyle(Border::BORDER_THIN);

          
          // ENCABEZADO LISTA
          $Excel->getActiveSheet()->getStyle('A'.$fila.':'.$d.$fila)->applyFromArray(
              array(
                'font'  => array(
                    'bold'  => true,
                    'size'  => 12,
                    'name'  => 'Calibri'
                ),
                'fill' => array(
                    'fillType' => Fill::FILL_SOLID,
                    'color' => array('rgb' => 'DDDDDD')
                ),
                'alignment' => array(
                  'horizontal' => Alignment::HORIZONTAL_CENTER,
                )
              )
          );



          // TAMAÑO Y FUENTE
          $fila = $fila+1;
          $Excel->getActiveSheet()->getStyle('A'.$fila.':' . 
            $Excel->getActiveSheet()->getHighestColumn() . 
            $Excel->getActiveSheet()->getHighestRow()
            )->applyFromArray(array(
                'font'  => array(
                    'bold'  => false,
                    'size'  => 12,
                    'name'  => 'Calibri'
                ),
                'alignment' => array(
                    //'horizontal' => \PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
                    //'vertical' => \PHPExcel_Style_Alignment::VERTICAL_CENTER,
                ),
            ));  

          //COLUMNA ID         
          $Excel->getActiveSheet()
            ->getStyle('A'.$fila.':A'.$Excel->getActiveSheet()->getHighestRow())
            ->applyFromArray(array(
                'font'  => array(
                    'bold'  => true,
                ),
                
            ));

          //COLUMNA ESTUDIANTE         
          $Excel->getActiveSheet()
            ->getStyle('B'.$fila.':B'.$Excel->getActiveSheet()->getHighestRow())
            ->applyFromArray(array(
                'alignment' => array(
                    //'horizontal' => \PHPExcel_Style_Alignment::HORIZONTAL_LEFT,
                ),
            ));   

        $Excel->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);
        $Excel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
        $Excel->getActiveSheet()->getColumnDimension('O')->setAutoSize(true);  

        } // crear mes

        $Excel->setActiveSheetIndex('0');

        if(isset($_GET['asignatura']))
        {
            $filename = "R101-Ausentismo-Asignatura-Grupo(".date("d-m-Y_H-i").").xlsx";
        }    
        else
        {
            $filename = "R101-Ausentismo-Grupo(".date("d-m-Y_H-i").").xlsx";
        } 

        

        // Redirect output to a client’s web browser (Xlsx)
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment;filename="' . $filename . '"');
        header('Cache-Control: max-age=0');

        // If you're serving to IE 9, then the following may be needed
        header('Cache-Control: max-age=1');
         
        // If you're serving to IE over SSL, then the following may be needed
        header('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
        header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT'); // always modified
        header('Cache-Control: cache, must-revalidate'); // HTTP/1.1
        header('Pragma: public'); // HTTP/1.0

        $writer = IOFactory::createWriter($Excel, 'Xlsx');
        $writer->save('php://output');
        exit;
        
    }

    public function action102($grupo = NULL, $asignatura = NULL, $columnas = NULL) // Reporte de Lista de Alumnos por Asignatura y Grupo
    {
        if($asignatura == NULL && $grupo == NULL)
        {    
            $model = new LanzadorForm();
            $model->reporte = 'Reporte de Estudiantes por Asignatura y Grupo';
            $model->observaciones = 'Exporta la lista de estudiantes por asignatura y grupos.; este reporte se genera en formato Excel.';

            if ($model->load(Yii::$app->request->post())) {

                $asignatura = $model->asignatura; 
                $grupo = $model->grupo;
                $columnas = $model->columnas;
                
            }
            else
            {
                return $this->render('/publica/lanzador', ['model' => $model]);
                exit;
            }    
        }
        else
        {
            $grupo = Yii::$app->request->get('grupo');
            $asignatura = Yii::$app->request->get('asignatura');
            $columnas = Yii::$app->request->get('columnas');    
            
        }    

        $grupo = Grupo::find($grupo)->one();
        $asignatura = Asignatura::find($asignatura)->one();
        
        

        date_default_timezone_set('America/Bogota');

        /// MARGENES HOJA
        $top = '1';
        $right = '0.5';
        $left = '0.5';
        $bottom = '1';

        $grupo = Grupo::find($grupo)->one();

        if(isset($asignatura))
        {
        $asignatura = Asignatura::find($asignatura)->one();    
        }    

        $Excel = new Spreadsheet();

        $Excel->getProperties()
        ->setCreator("Sonic")
        ->setLastModifiedBy("Sonic")
        ->setTitle("Reporte 102 - Estudiantes por Asignatura y Grupo")
        ->setDescription("Documento generado por Sonic")
        ->setCategory("Listados"); 



        $this->render('_headerandfooter_excel_landscape', ['Excel' => $Excel]);    

        $Excel->setActiveSheetIndex(0);

        $Excel->getActiveSheet()->getPageSetup()->setOrientation(PageSetup::ORIENTATION_LANDSCAPE);
        $Excel->getActiveSheet()->getPageSetup()->setPaperSize(PageSetup::PAPERSIZE_FOLIO);
        $Excel->getActiveSheet()->getPageSetup()->setHorizontalCentered(true);
        $Excel->getActiveSheet()->getPageMargins()->setTop($top);
        $Excel->getActiveSheet()->getPageMargins()->setRight($right);
        $Excel->getActiveSheet()->getPageMargins()->setLeft($left);
        $Excel->getActiveSheet()->getPageMargins()->setBottom($bottom);
        
        $Excel->getActiveSheet()->setTitle('Listado');

        $style = array(
            'alignment' => array(
                'horizontal' => Alignment::HORIZONTAL_CENTER,
            )
        );

        $Excel->getActiveSheet()->getStyle('A1:A2')->applyFromArray($style);
        $Excel->getActiveSheet()->getStyle('A1:A2')->getFont()->setBold(true);

        $Excel->getActiveSheet()->setCellValue('A4', "#");
        $Excel->getActiveSheet()->setCellValue('B4', "ESTUDIANTE");  


        $d = 'B';
        for ($x='1'; $x <= $columnas; $x++)
        {   
            $d++;
            $Excel->getActiveSheet()->setCellValue($d.'4', $x);
            //$Excel->getActiveSheet()->getColumnDimension($d)->setAutoSize(true);
            $Excel->getActiveSheet()->getColumnDimension($d)->setWidth(10);
        } 
        

        $Excel->getActiveSheet()->mergeCells('A1:'.$d.'1');
        $Excel->getActiveSheet()->setCellValue('A1', 'LISTADO DE ESTUDIANTES');

        $Excel->getActiveSheet()->mergeCells('A2:'.$d.'2');
        $Excel->getActiveSheet()->setCellValue('A2', isset($asignatura) ? 'Asignatura: '.$asignatura->asignatura.'  -  Grupo: '.$grupo->grupo : 'Grupo: '.$grupo->grupo);

        $Excel->getActiveSheet()->getStyle('A4:'.$d.'4')->getFont()->setBold(true);

        $Excel->getActiveSheet()->getStyle('A4:'.$d.'4')->applyFromArray(
            array(
                'fill' => array(
                    'typeFill' => Fill::FILL_SOLID,
                    'color' => array('rgb' => 'DDDDDD')
                ),
            'alignment' => array(
                'horizontal' => Alignment::HORIZONTAL_CENTER,
                )
            )
        );

        $estudiantes = Tercero::find()->where(['=', 'academico.grupo', $grupo->id])->joinWith(['academicos'])->all();

        $i = 5;     

        foreach ($estudiantes as $estudiante) 
        {

            $Excel->getActiveSheet()->setCellValue('A'.$i, $i-4);  
            $Excel->getActiveSheet()->setCellValue('B'.$i, mb_strtoupper($estudiante->nombreinverso));    
        
            $i++;
        }

        $i--;

        
        $Excel->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);
        $Excel->getActiveSheet()->getColumnDimension('A')->setWidth(4);
        $Excel->getActiveSheet()->getStyle('B4:B'.$i)->getFont()->setBold(true);
        $Excel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
        $Excel->getActiveSheet()->getColumnDimension('B')->setWidth(40);

        $Excel->getActiveSheet()->getStyle('A4:' . 
        $Excel->getActiveSheet()->getHighestColumn() . 
        $Excel->getActiveSheet()->getHighestRow()
        )->getBorders()->getAllBorders()->setBorderStyle(Border::BORDER_THIN);

        $Excel->getActiveSheet()
        ->getStyle('B5:B'.$Excel->getActiveSheet()->getHighestRow())
        ->getAlignment()->setHorizontal(Alignment::HORIZONTAL_LEFT);

        $Excel->setActiveSheetIndex('0');

        if(isset($asignatura))
        {
            $filename = "R102-Reporte-Estudiantes-Asignatura-Grupo(".date("d-m-Y_H-i").").xlsx";
        }    
        else
        {
            $filename = "R102-Reporte-Estudiantes-Grupo(".date("d-m-Y_H-i").").xlsx";
        } 

        

        // Redirect output to a client’s web browser (Xlsx)
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment;filename="' . $filename . '"');
        header('Cache-Control: max-age=0');

        // If you're serving to IE 9, then the following may be needed
        header('Cache-Control: max-age=1');
         
        // If you're serving to IE over SSL, then the following may be needed
        header('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
        header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT'); // always modified
        header('Cache-Control: cache, must-revalidate'); // HTTP/1.1
        header('Pragma: public'); // HTTP/1.0

        $writer = IOFactory::createWriter($Excel, 'Xlsx');
        $writer->save('php://output');
        exit;
    }


    public function action501($grupo = NULL, $asignatura = NULL) // Reporte Valorativo (Boletín de Calificaciones) por Grupo
    {

        if($grupo == NULL && $asignatura == NULL)
        {    
            $model = new LanzadorForm();
            $model->reporte = 'Reporte de Estudiantes por Asignatura y Grupo';
            $model->observaciones = 'Exporta la lista de estudiantes por asignatura y grupos.; este reporte se genera en formato Excel.';

            if ($model->load(Yii::$app->request->post())) {

                $grado = $model->grado;
                $grupo = $model->grupo;
                $asignatura = $model->asignatura; 
                $periodo = $model->periodo;
                $columnas = $model->columnas;
                
            }
            else
            {
                return $this->render('/publica/lanzador', ['model' => $model]);
                exit;
            }    
        }
        else
        {
            $grado = Yii::$app->request->get('grado');
            $grupo = Yii::$app->request->get('grupo');
            $asignatura = Yii::$app->request->get('asignatura');
            $periodo = Yii::$app->request->get('periodo');
            $columnas = Yii::$app->request->get('columnas');
            
        }

        $grupo = Grupo::findOne($grupo);
        $asignatura = Asignatura::findOne($asignatura);
        $docente = Carga::find()->where(['asignatura' => $asignatura])->one();
        $docente = isset($docente) ? $docente->docentes->nombre : 'Sin Docente'; 
        $director = (isset($grupo->directores->nombre)) ? $grupo->directores->nombre : 'Director(a) de Grupo';        
        
        date_default_timezone_set('America/Bogota');
        setlocale(LC_TIME,"es_ES");
        $sede = Sede::FindOne(1);


        $pdf = new mPDF(['mode' => 'utf-8',
                         'format' => 'LETTER',
                         'default_font_size' => 0,
                         'default_font' => '',
                         'margin_left' => 15,
                         'margin_right' => 15,
                         'margin_top' => 38,
                         'margin_bottom' => 25,
                         'margin_header' => 10,
                         'margin_footer' => 10,
                         'orientation' => 'P']);        

        if ($sede->pdf_marcadeagua == 'T')
        {
            $pdf->SetWatermarkText($sede->pdf_marcadeagua_contenido);
            $pdf->showWatermarkText = true;
            $pdf->watermarkTextAlpha = 0.1;
        }

        if ($sede->pdf_marcadeagua == 'I')
        {
            $pdf->SetWatermarkImage($sede->pdf_marcadeagua_contenido);
            $pdf->showWatermarkImage = true;
            $pdf->watermarkImageAlpha = 0.1;
        }

        
        $pdf->setHeader($sede->pdf_header);
        $pdf->setFooter($sede->pdf_footer);

        $pdf->AliasNbPages();

        $pdf->Open();
        $pdf->AddPage(0,'Letter');

        $pdf->SetFillColor(255);
        $pdf->SetTextColor(0);
        $pdf->SetDrawColor(0,0,0);


        $fecha = strftime("%A, %d de %B de %Y");

        $pdf->setX(140);
        $pdf->SetFont('Century Gothic','',8);
        $pdf->Cell(60,5,$fecha,0,0,'R');

        $pdf->Ln(5);

        $pdf->SetFont('Century Gothic','B',10); 
        $pdf->Cell(190,10,'INFORME VALORATIVO',0,0,'C');

        $pdf->Ln(10);

        $pdf->SetFont('Century Gothic','B',8);
        $pdf->Cell(15,5,'Docente:',0,0); 
        $pdf->SetFont('Century Gothic','',8);  
        
        $pdf->Cell(65,5,$docente,0,0);
        $pdf->SetFont('Century Gothic','B',8);
        $pdf->Cell(18,5,'Asignatura: ',0,0);
        $pdf->SetFont('Century Gothic','',8);
        $pdf->Cell(42,5,$asignatura->id.' - '.$asignatura->asignatura,0,0);
        
        
        $pdf->SetFont('Century Gothic','B',8);
        $pdf->Cell(20,5,'Especialidad: ',0,0);
        $pdf->SetFont('Century Gothic','',8);
        $pdf->Cell(50,5,$asignatura->especialidades->especialidad ,0,0);
        
        
        $pdf->Ln(5);
        
        $pdf->SetFont('Century Gothic','B',8);
        $pdf->Cell(15,5,'Sede:',0,0);
        $pdf->SetFont('Century Gothic','',8);    
        $pdf->Cell(65,5,$grupo->sedes->sede,0,0);

        $pdf->SetFont('Century Gothic','B',8);
        $pdf->Cell(18,5,'Jornada:',0,0);
        $pdf->SetFont('Century Gothic','',8);    
        $pdf->Cell(20,5,$grupo->jornadas->jornada,0,0);  

        $pdf->SetFont('Century Gothic','B',8);
        $pdf->Cell(12,5,'Grupo:',0,0);
        $pdf->SetFont('Century Gothic','',8);    
        $pdf->Cell(10,5,$grupo->grupo,0,0);
        
        $pdf->SetFont('Century Gothic','B',8);
        $pdf->Cell(13,5,'Periodo:',0,0);
        $pdf->SetFont('Century Gothic','',8);    
        $pdf->Cell(8,5,$periodo,0,0);

        $pdf->SetFont('Century Gothic','B',8);
        $pdf->Cell(10,5,'Año:',0,0);
        $pdf->SetFont('Century Gothic','',8);    
        $pdf->Cell(8,5,$sede->vigencia,0,0);

        $pdf->Ln(10);
        
        $competencias = Competencia::find()->where(['asignatura' => $asignatura])->andWhere(['periodo' => $periodo])->all(); 
    
        if (count($competencias) > 0)
        {
            $pdf->SetFont('Century Gothic','B',8);
            $pdf->Cell(10,5,'Competencias',0,0);
            $pdf->Ln(5);
            $pdf->SetFont('Century Gothic','',8);    
            
            $c = 1;
            foreach ($competencias as $competencia) 
            {
                $pdf->MultiCell(180,5,$c." - ".mb_strtoupper($competencia->competencia),0,'J',0);
                $pdf->Ln(1);
                $c++;
            }
            
        }

        $tipo_calificacion = $grupo->grados->tipo_calificacion;
        $calificacionxcompetencia = $grupo->grados->calificacionxcompetencia;
        $num_calificaciones_saber = $asignatura->num_calificaciones_saber;
        $num_calificaciones_ser = $asignatura->num_calificaciones_ser;    
        $por_calificaciones_saber = $asignatura->por_calificaciones_saber;
        $por_calificaciones_ser = $asignatura->por_calificaciones_ser;      

        $pdf->SetFont('Century Gothic','B',8);
        $pdf->setFillColor(180);
        $pdf->Cell(8,5,'#','LBTR',0,'C',1);
        $pdf->Cell(70,5,'ESTUDIANTE','LBTR',0,'C',1);

        for ($i=1; $i <= $num_calificaciones_saber; $i++) { 
            $pdf->Cell(8,5,'C'.$i,'LBTR',0,'C',1);
        }
        
        $pdf->Cell(12,5,'SABER','LBTR',0,'C',1);

        for ($i=1; $i <= $num_calificaciones_ser; $i++) { 
            $pdf->Cell(8,5,'C'.$i,'LBTR',0,'C',1);
        }
        
        $pdf->Cell(12,5,'SER','LBTR',0,'C',1);

        $pdf->Cell(15,5,'DEF','LBTR',0,'C',1);

        

        $pdf->Cell(15,5,'FALLAS','LBTR',0,'C',1);

        $pdf->setFillColor(255);
        $pdf->Ln(5);
        $pdf->SetFont('Century Gothic','',8);    
  
        
        $i = 1;        
        

        if($asignatura->especialidad == 1)
        {
            $estudiantes = Academico::find()->select(['tercero.id', 'academico.estudiante', 'academico.grupo'])->joinWith(['estudiantes'])->where(['<', 'tercero.estado', 3])->andWhere(['academico.grupo' => $grupo->id])->orderBy('primer_apellido')->all();  
        }
        else
        {
            $estudiantes = Academico::find()->select(['tercero.id', 'academico.estudiante', 'academico.grupo'])->joinWith(['estudiantes'])->where(['<', 'tercero.estado', 3])->andWhere(['academico.grupo' => $grupo->id])->andWhere(['academico.especialidad' => $asignatura->especialidad])->orderBy('primer_apellido')->all();     
        }

        foreach ($estudiantes as $estudiante) 
        {
        
            $pdf->Cell(8,5,$i,'LBTR',0,'C',0);
            
            $pdf->Cell(70,5,mb_strtoupper(utf8_decode($estudiante->estudiantes->nombreinverso)),'LBTR',0,'C',0);
            
            $i++;
            
            for($p=1;$p<=$periodo;$p++)
            {   
                
                $notas = Calificacion::find()->where(['estudiante' => $estudiante->id])->andWhere(['grupo' => $grupo, 'asignatura' => $asignatura, 'periodo' => $p])->one();
                
                if($tipo_calificacion=='1') // LETRAS
                {   
                    
                } 
                else  // NUMEROS
                {
                    if ($calificacionxcompetencia == '2')  // CALIFICACION POR COMPETENCIAS Y NUMEROS
                    {
                        if(count($notas) > 0)
                        {
                            //echo "1";
                            $notas2 = explode(",", $notas->saber);
                            $promedio=array_sum($notas2)/count($notas2); 
                            $desempeno = new Desempeno();
                            $color = $desempeno->color($promedio);
                            $desempenos = $desempeno->desempeno($promedio);
                            //$nota = $desempeno->nota($promedio);
                            $nota = round($promedio,1);
                        }
                        else
                        {
                            //echo "2";
                            $desempeno = new Desempeno();
                            $color = $desempeno->color('0');
                            $desempenos = $desempeno->desempeno('0');
                            //$nota = $desempeno->nota('0');
                            $nota = 'NE';
                        }   
                    }
                    else  // CALIFICACION POR ASIGNATURA Y NUMEROS
                    {
                        
                        $calificaciones = explode(',', isset($notas->saber) ? $notas->saber : '');

                        $desempeno = new Desempeno();
                        
                        for ($x=0; $x<count($calificaciones);$x++)
                        {
                            $color = ($calificaciones[$x]=='') ? '#cccccc' :  $desempeno->color($calificaciones[$x],$tipo_calificacion);
                            $desempenos = ($calificaciones[$x]=='') ? 'No Evaluado' : $desempeno->desempeno($calificaciones[$x],$tipo_calificacion);   
                            $nota = ($calificaciones[$x]=='') ? 'NE' : $calificaciones[$x]; 

                            
                            $pdf->Cell(8,5,$nota,'LBTR',0,'C',0);
                        }
                    }
                }   
                
                $pdf->setFillColor(230);
                $pdf->Cell(12,5,$saber = isset($notas->definitiva_saber) ? $notas->definitiva_saber : '','LBTR',0,'C',1);

            

                // CALIFICACION DEL SER

                if($tipo_calificacion=='1') // LETRAS
                {   
                    
                } 
                else  // NUMEROS
                {
                    if ($calificacionxcompetencia == '2')  // CALIFICACION POR COMPETENCIAS Y NUMEROS
                    {
                        if(count($notas) > 0)
                        {
                            //echo "1";
                            $notas2 = explode(",", $notas->ser);
                            $promedio=array_sum($notas2)/count($notas2); 
                            $desempeno = new Desempeno();
                            $color = $desempeno->color($promedio);
                            $desempenos = $desempeno->desempeno($promedio);
                            //$nota = $desempeno->nota($promedio);
                            $nota = round($promedio,1);
                        }
                        else
                        {
                            //echo "2";
                            $desempeno = new Desempeno();
                            $color = $desempeno->color('0');
                            $desempenos = $desempeno->desempeno('0');
                            //$nota = $desempeno->nota('0');
                            $nota = 'NE';
                        }   
                    }
                    else  // CALIFICACION POR ASIGNATURA Y NUMEROS
                    {
                        
                        $calificaciones = explode(',', isset($notas->ser) ? $notas->ser : '');

                        $desempeno = new Desempeno();
                        
                        for ($x=0; $x<count($calificaciones);$x++)
                        {
                            $color = ($calificaciones[$x]=='') ? '#cccccc' :  $desempeno->color($calificaciones[$x],$tipo_calificacion);
                            $desempenos = ($calificaciones[$x]=='') ? 'No Evaluado' : $desempeno->desempeno($calificaciones[$x],$tipo_calificacion);   
                            $nota = ($calificaciones[$x]=='') ? 'NE' : $calificaciones[$x]; 

                            
                            $pdf->Cell(8,5,$nota,'LBTR',0,'C',0);
                        }

                        $pdf->setFillColor(230);
                        $pdf->Cell(12,5, isset($notas->definitiva_ser) ? $notas->definitiva_ser : '·','LBTR',0,'C',1);
                        $pdf->setFillColor(180);
                        $pdf->Cell(15,5, isset($notas->definitiva_periodo) ? $notas->definitiva_periodo : '-','LBTR',0,'C',1);
                        
                    }

                }
                
                $fallas = Asistencia::find()->where(['estudiante' => $estudiante->id])->andWhere(['grupo' => $grupo, 'asignatura' => $asignatura, 'periodo' => $p])->sum('fallas');
                
                $pdf->Cell(15,5,$fallas,'LBTR',0,'C',1);
              
                $pdf->Ln(5);
            } // FIN FOR        


        }

        $pdf->SetFont('Century Gothic','',8);
        $pdf->Ln(8);
        $pdf->Cell(180,6,"En constancia de entrega y publicación del informe valorativo y en constancia firmamos. ",0,0);
        $pdf->Ln(30);
        $pdf->SetFont('Century Gothic','B',8);

        $pdf->Cell(25);
        $pdf->Cell(60,5,$docente,'T',0,'C',0);

        $pdf->Cell(15);
        $pdf->Cell(60,5,$sede->rector_nombre,'T',0,'C',0);

        $pdf->Ln(3);
        $pdf->SetFont('Century Gothic','',8);
        $pdf->Cell(25);
        $pdf->Cell(60,5,"Docente",'',0,'C',0);
        $pdf->Cell(15);
        $pdf->Cell(60,5,"Rector(a)",'',0,'C',0);

        
        $pdf->Output("R501-Reporte-Valorativo-Docente-Grupo(".date("d-m-Y_H-i").").pdf",'D');

    }


    public function action701($grupo = NULL, $asignatura = NULL) // Reporte Valorativo Condensado (Boletín de Calificaciones) por Grupo
    {

        if($grupo == NULL && $asignatura == NULL)
        {    
            $model = new LanzadorForm();
            $model->reporte = 'Reporte de Estudiantes por Asignatura y Grupo';
            $model->observaciones = 'Exporta la lista de estudiantes por asignatura y grupos.; este reporte se genera en formato Excel.';

            if ($model->load(Yii::$app->request->post())) {

                $grado = $model->grado;
                $grupo = $model->grupo;
                $asignatura = $model->asignatura; 
                $periodo = $model->periodo;
                $columnas = $model->columnas;
                
            }
            else
            {
                return $this->render('/publica/lanzador', ['model' => $model]);
                exit;
            }    
        }
        else
        {
            $grado = Yii::$app->request->get('grado');
            $grupo = Yii::$app->request->get('grupo');
            $asignatura = Yii::$app->request->get('asignatura');
            $periodo = Yii::$app->request->get('periodo');
            $columnas = Yii::$app->request->get('columnas');
            
        }

        date_default_timezone_set('America/Bogota');
        setlocale(LC_TIME,"es_ES");

        //$periodo = new Periodo();
        $grupo = Grupo::find()->where(['id' => $grupo])->one();
        $director = (isset($grupo->directores->nombre)) ? $grupo->directores->nombre : 'Director(a) de Grupo';
        
        $sede = Sede::FindOne($grupo->sede);

        $pdf = new mPDF(['mode' => 'utf-8',
                         'format' => 'LETTER',
                         'default_font_size' => 0,
                         'default_font' => '',
                         'margin_left' => 15,
                         'margin_right' => 15,
                         'margin_top' => 35,
                         'margin_bottom' => 16,
                         'margin_header' => 9,
                         'margin_footer' => 9,
                         'orientation' => 'P']);        

        if ($sede->pdf_marcadeagua == 'T' OR $sede->pdf_marcadeagua == 'B')
        {
            $pdf->SetWatermarkText($sede->pdf_marcadeagua_contenido);
            $pdf->showWatermarkText = true;
            $pdf->watermarkTextAlpha = 0.1;
        }

        if ($sede->pdf_marcadeagua == 'I')
        {
            $pdf->SetWatermarkImage($sede->pdf_marcadeagua_contenido);
            $pdf->showWatermarkImage = true;
            $pdf->watermarkImageAlpha = 0.1;
        }

        $pdf->setHeader($sede->pdf_header);
        $pdf->setFooter($sede->pdf_footer);
        
        $pdf->AliasNbPages();

        $pdf->Open();

        $i = 1;        
        
        $estudiantes = Academico::find()->select(['tercero.id', 'academico.estudiante', 'academico.grupo','academico.especialidad'])->joinWith(['estudiantes'])->where(['<', 'tercero.estado', 3])->andWhere(['academico.grupo' => $grupo->id])->orderBy('primer_apellido')->all();  
        
        foreach ($estudiantes as $estudiante) 
        {

            $pdf->AddPage(0,'Letter');

            $pdf->SetFillColor(255);
            $pdf->SetTextColor(0);
            $pdf->SetDrawColor(0,0,0);
        
            $fecha = strftime("%A, %d de %B de %Y");

            $pdf->setX(140);
            $pdf->SetFont('Century Gothic','',8);
            $pdf->Cell(60,5,$fecha,0,0,'R');

            $pdf->Ln(5);
            $pdf->SetFont('Century Gothic','B',10);   
            $pdf->Cell(190,10,'INFORME VALORATIVO CONSOLIDADO',0,0,'C');

            $pdf->Ln(10);

            $pdf->SetFont('Century Gothic','B',8);
            $pdf->Cell(18,5,'Estudiante:',0,0); 
            $pdf->SetFont('Century Gothic','',8);

            $nombre = mb_strtoupper(utf8_decode($estudiante->estudiantes->nombreinverso));

            $pdf->Bookmark($nombre, 0);
            $pdf->Cell(65,5,$nombre,0,0);
            
            $pdf->SetFont('Century Gothic','B',8);
            $pdf->Cell(23,5,'Identificación: ',0,0);
            $pdf->SetFont('Century Gothic','',8);
            $pdf->Cell(25,5,$estudiante->estudiantes->identificacion,0,0);
            
            
            $pdf->SetFont('Century Gothic','B',8);
            $pdf->Cell(20,5,'Especialidad: ',0,0);
            $pdf->SetFont('Century Gothic','',8);
            $pdf->Cell(50,5,$estudiante->especialidades->especialidad,0,0);
            
            
            $pdf->Ln(5);
            
            $pdf->SetFont('Century Gothic','B',8);
            $pdf->Cell(15,5,'Sede:',0,0);
            $pdf->SetFont('Century Gothic','',8);    
            $pdf->Cell(68,5,$grupo->sedes->sede,0,0);

            $pdf->SetFont('Century Gothic','B',8);
            $pdf->Cell(18,5,'Jornada:',0,0);
            $pdf->SetFont('Century Gothic','',8);    
            $pdf->Cell(20,5,$grupo->jornadas->jornada,0,0);  

            $pdf->SetFont('Century Gothic','B',8);
            $pdf->Cell(12,5,'Grupo:',0,0);
            $pdf->SetFont('Century Gothic','',8);    
            $pdf->Cell(10,5,$grupo->grupo,0,0);
            
            $pdf->SetFont('Century Gothic','B',8);
            $pdf->Cell(13,5,'Periodo:',0,0);
            $pdf->SetFont('Century Gothic','',8);    
            $pdf->Cell(8,5,$periodo,0,0);

            $pdf->SetFont('Century Gothic','B',8);
            $pdf->Cell(10,5,'Año:',0,0);
            $pdf->SetFont('Century Gothic','',8);    
            $pdf->Cell(8,5,date('Y'),0,0);

            $pdf->Ln(10);
            
            
            $tipo_calificacion = $grupo->grados->tipo_calificacion;
            $calificacionxcompetencia = $grupo->grados->calificacionxcompetencia;


            $pdf->SetFont('Century Gothic','B',8);
            $pdf->setFillColor(180);
            $pdf->Cell(5,5,'#','LBTR',0,'C',1);
            $pdf->Cell(65,5,'ASIGNATURA','LBTR',0,'C',1);


            $pdf->Cell(5,5,'IH','LBTR',0,'C',1);

            for($p=1;$p<=$periodo;$p++)
            {
                $pdf->Cell(24,5,'Periodo '.$p,'LBTR',0,'C',1);
                $pdf->Cell(5,5,'F','LBTR',0,'C',1);
            }    

            $pdf->setFillColor(255);
            $pdf->Ln(5);
            $pdf->SetFont('Century Gothic','',8);    
  

            if($estudiante->especialidad == '1')
            {
                $asignaturas = Asignatura::find()
                                ->where(['grado' => $grupo->grados->id])
                                ->andWhere(['especialidad' => '1'])
                                ->all();
            }
            else
            {
                $asignaturas = Asignatura::find()
                                ->where(['grado' => $grupo->grados->id])
                                ->andWhere(['especialidad' => '1'])
                                ->orWhere(['especialidad' => $estudiante->especialidad])
                                ->all();
            }    

            
            
            $i = 1;
            
            foreach ($asignaturas as $asignatura) 
            {
                //$asignatura->asignatura;

                $pdf->Cell(5,5,$i,'LBR',0,'C',0);
                $i++;
                $pdf->Cell(65,5,mb_strtoupper($asignatura->asignatura),'LBR',0,'J',0);  
                $pdf->Cell(5,5,mb_strtoupper($asignatura->intensidad),'LBR',0,'C',0); 

            
                for($p=1;$p<=$periodo;$p++)
                {   
                    
                    $notas = Calificacion::find()
                                ->where(['estudiante' => $estudiante->id])
                                ->andWhere(['grupo' => $grupo->id, 'asignatura' => $asignatura->id, 'periodo' => $p])
                                ->one();
                    
                    if($tipo_calificacion=='1') // LETRAS
                    {   
                        
                    } 
                    else  // NUMEROS
                    {
                        if ($calificacionxcompetencia == '2')  // CALIFICACION POR COMPETENCIAS Y NUMEROS
                        {
                            if(count($notas) > 0)
                            {
                                //echo "1";
                                $notas2 = explode(",", $notas->saber);
                                $promedio=array_sum($notas2)/count($notas2); 
                                $desempeno = new Desempeno();
                                $color = $desempeno->color($promedio,$tipo_calificacion);
                                $desempenos = $desempeno->desempeno($promedio,$tipo_calificacion);
                                //$nota = $desempeno->nota($promedio);
                                $nota = round($promedio,1);
                            }
                            else
                            {
                                //echo "2";
                                $desempeno = new Desempeno();
                                $color = $desempeno->color('0',$tipo_calificacion);
                                $desempenos = $desempeno->desempeno('0',$tipo_calificacion);
                                //$nota = $desempeno->nota('0');
                                $nota = 'NE';
                            }   
                        }
                        else  // CALIFICACION POR ASIGNATURA Y NUMEROS
                        {

                            $definitiva = (double)isset($notas->definitiva_periodo) ? $notas->definitiva_periodo : 0;
                            
                            $desempeno = new Desempeno();
                            
                            
                                $color = $desempeno->hex2rgb($desempeno->color($definitiva,$tipo_calificacion));

                                $desempenos = $desempeno->desempeno($definitiva,$tipo_calificacion);   
                                //$nota = ($notas->definitiva_periodo=='') ? 'NE' : $notas->definitiva_periodo; 

                                
                                $pdf->setFillColor($color['r'],$color['g'],$color['b']);
                                $pdf->Cell(6,5,$definitiva,'LBR',0,'C',1);
                                $pdf->setFillColor(255);
                                $pdf->Cell(18 ,5,$desempenos,'LBR',0,'C',0);

                        }
                    }   
                    
                    $fallas = Asistencia::find()->where(['estudiante' => $estudiante->id])->andWhere(['grupo' => Yii::$app->request->get('grupo'), 'asignatura' => $asignatura->id, 'periodo' => $p])->sum('fallas');
                    $fallas = isset($fallas) ? $fallas : 0;
                    $pdf->Cell(5,5,(int)$fallas,'LBR',0,'C',1);
                    

                } // FIN FOR 
                $pdf->Ln(5);
                
            }

                $pdf->SetFont('Century Gothic','',8);
                //$pdf->Ln(8);
                //$pdf->Cell(180,6,"En constancia de entrega y publicación del informe valorativo y en constancia firmamos. ",0,0);
                $pdf->Ln(40);
                $pdf->SetFont('Century Gothic','B',8);

                $pdf->Cell(25);
                
                $pdf->Cell(60,5,$director,'T',0,'C',0);

                $pdf->Cell(15);
                $pdf->Cell(60,5,$sede->rector_nombre,'T',0,'C',0);

                $pdf->Ln(3);
                $pdf->SetFont('Century Gothic','',8);
                $pdf->Cell(25);
                $pdf->Cell(60,5,"Docente",'',0,'C',0);
                $pdf->Cell(15);
                $pdf->Cell(60,5,"Rector(a)",'',0,'C',0);
                $pdf->Ln(1); 


        }
        
        $pdf->Output("R701-Reporte-Valorativo-Condensado-Grupo(".date("d-m-Y_H-i").").pdf",'D');
    }

  

}





