<?php

namespace backend\controllers;

use Yii;
use backend\models\Periodo;
use backend\models\Calificacion;
use backend\models\Grupo;
use backend\models\Asignatura;
use backend\models\Promedio;
use backend\models\Academico;
use backend\models\Condicionpromocion;

use backend\models\PeriodoSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\data\ActiveDataProvider;
use yii\helpers\Json;
use yii\helpers\Url;
use yii\web\Response;
use kartik\tabs\TabsX;
use yii\base\Model;




/**
 * PeriodoController implements the CRUD actions for Periodo model.
 */
class PeriodoController extends Controller
{
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['post'],
                ],
            ],
        ];
    }



    public function actionIndex()
    {
        $searchModel = new PeriodoSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }


    public function actionCambiar($periodo)
    {
        if (Yii::$app->request->isAjax) 
        {
            Periodo::updateAll(['habilitado' => 0], ['<', 'id', '5']);
            $id = Yii::$app->request->get('periodo');

            if($id <= 4)
            {   
                $nuevo = $id + 1;
                $model = $this->findModel($nuevo);
                $model->habilitado = 1;
                $model->update(false);  

                $bitacora = new \backend\models\Bitacora;
                $bitacora->Registrar('Se habilitó el <span class="text-success">Periodo '.$nuevo.'</span>');
                     
            }    
            return $nuevo;
        } else {
            throw new NotFoundHttpException('No puedo cambiar periodo');
        }
    }

    public function actionSeleccionar()
    {
        if (Yii::$app->request->isAjax) 
        {
            $id = Yii::$app->request->get('periodo');
            Periodo::updateAll(['habilitado' => 0], ['<', 'id', '6']);
        
            if($id <= 5)
            {   
                $model = $this->findModel($id);
                $model->habilitado = 1;
                $model->update(false);  

                $bitacora = new \backend\models\Bitacora;
                $bitacora->Registrar('Se habilitó el <span class="text-success">Periodo '.$id.'</span>');
  
            }
            return $model->periodo;
        }


        $model = new Periodo(['scenario'=>'cambiar']);
        $model->periodo = $model->actual->id;


        for($i = 1; $i <= 5; $i++) {

            $periodos[] = $this->findModel($i);
        }

        if (Model::loadMultiple($periodos, Yii::$app->request->post()) && Model::validateMultiple($periodos))  
        {

            foreach ($periodos as $index => $periodo) {    

                if ($periodo->save(false)) {
                
                    Yii::$app->session->addFlash('mensaje', [
                        'tipo' => 'info',
                        'titulo' => 'Información Almacenada',
                        'icono' => 'fa fa-info',
                        'mensaje' => 'La información del <b>'.$periodo->periodo.'</b> se almacenó con éxito.',
                    ]);

                    //$bitacora = new \backend\models\Bitacora;
                    //$bitacora->Registrar('Se habilitó el <span class="text-success">Periodo '.$id.'</span>');
                }
            }
            return $this->redirect(['seleccionar']);
            //return $this->goBack();
        }
        else
        {
            
            return $this->render('seleccionar', [
                'model' => $model,
                'periodos' => $periodos
            ]);
        }
    }

    public function actionTabs() {

        if (Yii::$app->request->isAjax) {
            Yii::$app->response->format = Response::FORMAT_JSON;
            return ActiveForm::validate($model);
        }
        else 
        {
            $id = Yii::$app->request->get('id');
            $html = $this->renderAjax('_formSeleccionar',[
                'model' => $this->findModel($id),
            ]);
            return Json::encode($html);
        }
        
    }
    
    public function actionView($id)
    {
        $model = $this->findModel($id);
        
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }


    public function actionCreate()
    {
        $model = new Periodo();

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->id]);
        } else {
            return $this->render('create', [
                'model' => $model,
            ]);
        }
    }


    public function actionUpdate($id)
    {
        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->id]);
        } else {
            return $this->render('update', [
                'model' => $model,
            ]);
        }
    }


    public function actionDelete($id)
    {
        //$this->findModel($id)->deleteWithRelated();

        $model = $this->findModel($id);
        $model->eliminado_por = \Yii::$app->user->id;
        $model->eliminado_el = new \yii\db\Expression('NOW()');
        $model->update();

        return $this->redirect(['index']);
    }

    public function actionRestore($id)
    {
        $this->findModel($id)->restoreWithRelated();

        return $this->redirect(['index']);
    }


    public function actionCerrar()
    {
        if (Yii::$app->request->isAjax) 
        {
            //$periodo = Yii::$app->request->post('periodo');
            
            $grupo = Grupo::find()->where(['id' => Yii::$app->request->post('grupo')])->one();

            $asignaturas = Asignatura::find()->where(['grado' => $grupo->grado])->all(); 

            $promedio = new Promedio;

            $result = "";

            foreach ($asignaturas as $asignatura) 
            {
                if($asignatura->especialidad == 1)
                {
                    $estudiantes = Academico::find()->where('fecha_retiro IS NULL')->andWhere(['grupo' => $grupo->id]);  
                    $result .= "<br>".$estudiantes->createCommand()->getRawSql(); // Mostrar SQL   

                    $estudiantes = Academico::find()->where('fecha_retiro IS NULL')->andWhere(['grupo' => $grupo->id])->all();  
                    //$estudiantes = Academico::find()->select(['tercero.id', 'academico.estudiante', 'academico.grupo'])->joinWith(['estudiantes'])->where(['<', 'tercero.estado', 3])->andWhere(['academico.grupo' => $grupo->id])->orderBy('primer_apellido')->all();  
                }
                else
                {
                    $estudiantes = Academico::find()->where(['fecha_retiro' => new \yii\db\Expression('IS NULL')])->andWhere(['academico.grupo' => $grupo->id])->andWhere(['academico.especialidad' => $asignatura->especialidad]);     
                    $result .= "<br>".$estudiantes->createCommand()->getRawSql(); // Mostrar SQL   

                    $estudiantes = Academico::find()->where(['fecha_retiro' => new \yii\db\Expression('IS NULL')])->andWhere(['academico.grupo' => $grupo->id])->andWhere(['academico.especialidad' => $asignatura->especialidad])->all();     
                    //$estudiantes = Academico::find()->select(['tercero.id', 'academico.estudiante', 'academico.grupo'])->joinWith(['estudiantes'])->where(['<', 'tercero.estado', 3])->andWhere(['academico.grupo' => $grupo->id])->andWhere(['academico.especialidad' => $asignatura->especialidad])->orderBy('primer_apellido')->all();     
                }



                foreach ($estudiantes as $estudiante) 
                {
                    //$promedio->getPromedioxEstudiante($grupo->grados->tipo_calificacion, $estudiante->estudiante, $grupo->grados->id, $grupo->id, $asignatura->id, $periodo);
                    $calificacion = Calificacion::find()
                                    ->select(['ROUND((SUM(definitiva_final_periodo)/4),1) as definitiva_final_periodo', 'docente'])
                                    ->where(['estudiante' => $estudiante->estudiante])
                                    ->andWhere(['asignatura' => $asignatura->id])
                                    ->andWhere(['grupo' => $grupo->id])
                                    ->andWhere(['<=', 'periodo', '4'])
                                    ->groupBy(['estudiante']);
                                    

                    //$result .= "<br>".$calificacion->createCommand()->getRawSql(); // Mostrar SQL   

                    $calificacion = Calificacion::find()
                                    ->select(['ROUND((SUM(definitiva_final_periodo)/4),1) as definitiva_final_periodo', 'docente'])
                                    ->where(['estudiante' => $estudiante->estudiante])
                                    ->andWhere(['asignatura' => $asignatura->id])
                                    ->andWhere(['grupo' => $grupo->id])
                                    ->andWhere(['<=', 'periodo', '4'])
                                    ->groupBy(['estudiante'])
                                    ->one();

                    $definitiva = Calificacion::find()
                                    ->where(['estudiante' => $estudiante->estudiante])
                                    ->andWhere(['asignatura' => $asignatura->id])
                                    ->andWhere(['grupo' => $grupo->id])
                                    ->andWhere(['periodo' => '5'])
                                    ->one();

                    if(isset($definitiva))
                    {
                        $definitiva->definitiva_periodo = $calificacion->definitiva_final_periodo;
                        $definitiva->definitiva_final_periodo = $calificacion->definitiva_final_periodo;
                        $definitiva->update(false);

                    }
                    else
                    {
                        $model =  new Calificacion;
                        $model->definitiva_periodo = $calificacion->definitiva_final_periodo;
                        $model->definitiva_final_periodo = $calificacion->definitiva_final_periodo;
                        $model->estudiante = $estudiante->estudiante;
                        $model->docente = $calificacion->docente;
                        $model->asignatura = $asignatura->id;
                        $model->grupo = $grupo->id;
                        $model->periodo = '5';
                        $model->save(false);    
                    }
                    /*
                        1 - Área
                        2 - Asignatura
                        3 - Máx Área
                        4 - Máx Asignatura
                        5 - Máx Ausentismo
                    */

                    /*
                    $condiciones = Condicionpromocion::find()
                                    ->where(['tipo' => 1])
                                    ->andWhere(['grado' => $grupo->grados->id])
                                    ->andWhere(['area' => $asignatura->area])
                                    ->andWhere(['estado' => 1])
                                    ->andWhere(['eliminado_por' => 0])
                                    ->all();

                    if(isset($condiciones))
                    {
                        foreach ($condiciones as $condicion) 
                        {
                            $result .= "<br>".$estudiante->estudiante." - Grado ".$grupo->grados->id." - ".$condicion->id;
                        }
                    }
                    else
                    {
                        $result .= "<br>".$estudiante->estudiante." - Grado ".$grupo->grados->id." - N.A.";
                    }

                    */

                    //echo "<br>".$calificacion->definitiva_final_periodo;

                    //echo "<br>".$model->createCommand()->getRawSql(); // Mostrar SQL   

                    $estudiante->aprobo = 1;
                    $estudiante->update(false);

                }

                //$promedio->getPuestoxGrupo($grupo->grados->tipo_calificacion, $grupo->grados->id, $grupo->id, $asignatura->id, $periodo);
                //$promedio->getPromedios($grupo->grados->tipo_calificacion, $grupo->grados->id, $grupo->id, $asignatura->id, $periodo);

            }
            
            return $result;
        }

        /*
        $model = new Promedio(['scenario'=>'cambiar']);
        $periodo = new Periodo();
        $model->periodo = $periodo->actual->id;
        */

        $grupos = Grupo::find()->where(['estado' => '1'])->all();
        
        return $this->render('cerrar', [
            'grupos' => $grupos,
        ]);
    
    }

    public function actionPromedio() {
        if (Yii::$app->request->isAjax) 
        {
            $id = \Yii::$app->request->post('id');

            $model= Calificacion::find()->where(['id' => $id])->one();

            $model->definitiva_saber = round((array_sum(explode(",", $model->saber)) / $model->asignaturas->num_calificaciones_saber),1);
            $model->definitiva_ser = round((array_sum(explode(",", $model->ser)) / $model->asignaturas->num_calificaciones_ser),1);
            $model->definitiva_periodo = round((($model->definitiva_saber * $model->asignaturas->por_calificaciones_saber) / 100) + (($model->definitiva_ser * $model->asignaturas->por_calificaciones_ser) / 100),1);

            $model->update(false);

            Yii::$app->response->format = Response::FORMAT_JSON;
            return true;
        }
    }

    protected function findModel($id)
    {
        if (($model = Periodo::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }
    
    /**
    * Action to load a tabular form grid
    * for Asistencia
    * @author Yohanes Candrajaya <moo.tensai@gmail.com>
    * @author Jiwantoro Ndaru <jiwanndaru@gmail.com>
    *
    * @return mixed
    */
    public function actionAddAsistencia()
    {
        if (Yii::$app->request->isAjax) {
            $row = Yii::$app->request->post('Asistencia');
            if((Yii::$app->request->post('isNewRecord') && Yii::$app->request->post('_action') == 'load' && empty($row)) || Yii::$app->request->post('_action') == 'add')
                $row[] = [];
            return $this->renderAjax('_formAsistencia', ['row' => $row]);
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }
    
    /**
    * Action to load a tabular form grid
    * for Calificacion
    * @author Yohanes Candrajaya <moo.tensai@gmail.com>
    * @author Jiwantoro Ndaru <jiwanndaru@gmail.com>
    *
    * @return mixed
    */
    public function actionAddCalificacion()
    {
        if (Yii::$app->request->isAjax) {
            $row = Yii::$app->request->post('Calificacion');
            if((Yii::$app->request->post('isNewRecord') && Yii::$app->request->post('_action') == 'load' && empty($row)) || Yii::$app->request->post('_action') == 'add')
                $row[] = [];
            return $this->renderAjax('_formCalificacion', ['row' => $row]);
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }
    
    /**
    * Action to load a tabular form grid
    * for Calificacionxcompetencia
    * @author Yohanes Candrajaya <moo.tensai@gmail.com>
    * @author Jiwantoro Ndaru <jiwanndaru@gmail.com>
    *
    * @return mixed
    */
    public function actionAddCalificacionxcompetencia()
    {
        if (Yii::$app->request->isAjax) {
            $row = Yii::$app->request->post('Calificacionxcompetencia');
            if((Yii::$app->request->post('isNewRecord') && Yii::$app->request->post('_action') == 'load' && empty($row)) || Yii::$app->request->post('_action') == 'add')
                $row[] = [];
            return $this->renderAjax('_formCalificacionxcompetencia', ['row' => $row]);
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }
    
    /**
    * Action to load a tabular form grid
    * for Competencia
    * @author Yohanes Candrajaya <moo.tensai@gmail.com>
    * @author Jiwantoro Ndaru <jiwanndaru@gmail.com>
    *
    * @return mixed
    */
    public function actionAddCompetencia()
    {
        if (Yii::$app->request->isAjax) {
            $row = Yii::$app->request->post('Competencia');
            if((Yii::$app->request->post('isNewRecord') && Yii::$app->request->post('_action') == 'load' && empty($row)) || Yii::$app->request->post('_action') == 'add')
                $row[] = [];
            return $this->renderAjax('_formCompetencia', ['row' => $row]);
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }
    
    /**
    * Action to load a tabular form grid
    * for DesempenoNivel
    * @author Yohanes Candrajaya <moo.tensai@gmail.com>
    * @author Jiwantoro Ndaru <jiwanndaru@gmail.com>
    *
    * @return mixed
    */
    public function actionAddDesempenoNivel()
    {
        if (Yii::$app->request->isAjax) {
            $row = Yii::$app->request->post('DesempenoNivel');
            if((Yii::$app->request->post('isNewRecord') && Yii::$app->request->post('_action') == 'load' && empty($row)) || Yii::$app->request->post('_action') == 'add')
                $row[] = [];
            return $this->renderAjax('_formDesempenoNivel', ['row' => $row]);
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }
    
    /**
    * Action to load a tabular form grid
    * for ObservacionFrd
    * @author Yohanes Candrajaya <moo.tensai@gmail.com>
    * @author Jiwantoro Ndaru <jiwanndaru@gmail.com>
    *
    * @return mixed
    */
    public function actionAddObservacionFrd()
    {
        if (Yii::$app->request->isAjax) {
            $row = Yii::$app->request->post('ObservacionFrd');
            if((Yii::$app->request->post('isNewRecord') && Yii::$app->request->post('_action') == 'load' && empty($row)) || Yii::$app->request->post('_action') == 'add')
                $row[] = [];
            return $this->renderAjax('_formObservacionFrd', ['row' => $row]);
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }
    
    /**
    * Action to load a tabular form grid
    * for Observador
    * @author Yohanes Candrajaya <moo.tensai@gmail.com>
    * @author Jiwantoro Ndaru <jiwanndaru@gmail.com>
    *
    * @return mixed
    */
    public function actionAddObservador()
    {
        if (Yii::$app->request->isAjax) {
            $row = Yii::$app->request->post('Observador');
            if((Yii::$app->request->post('isNewRecord') && Yii::$app->request->post('_action') == 'load' && empty($row)) || Yii::$app->request->post('_action') == 'add')
                $row[] = [];
            return $this->renderAjax('_formObservador', ['row' => $row]);
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }
    
    /**
    * Action to load a tabular form grid
    * for PlanAula
    * @author Yohanes Candrajaya <moo.tensai@gmail.com>
    * @author Jiwantoro Ndaru <jiwanndaru@gmail.com>
    *
    * @return mixed
    */
    public function actionAddPlanAula()
    {
        if (Yii::$app->request->isAjax) {
            $row = Yii::$app->request->post('PlanAula');
            if((Yii::$app->request->post('isNewRecord') && Yii::$app->request->post('_action') == 'load' && empty($row)) || Yii::$app->request->post('_action') == 'add')
                $row[] = [];
            return $this->renderAjax('_formPlanAula', ['row' => $row]);
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }
}
