<?php

namespace backend\controllers;

use Yii;
use backend\models\Planaula;
use backend\models\Asignatura;
use backend\models\Area;
use backend\models\Grupo;
use backend\models\Competencia;
use backend\models\Estandar;
use backend\models\Desempenonivel;
use backend\models\Academico;
use backend\models\Carga;
use backend\models\Tercero;
use backend\models\Asistencia;
use backend\models\AsistenciaSearch;
use backend\models\Periodo;
use backend\models\TipoInasistencia;
use backend\models\Calificacion;
use backend\models\Desempeno;
use backend\models\Desempenofrd;
use backend\models\Planmejoramiento;
use backend\models\Sede;
use backend\models\Compromisosacudiente;
use backend\models\Calificacioncompromisos;
use backend\models\LanzadorForm;
use yii\web\UploadedFile;
use backend\models\base\Upload;


use backend\models\PlanaulaSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\helpers\ArrayHelper;
use yii\data\ActiveDataProvider;
use yii\base\Model;
use yii\helpers\Html;
use yii\helpers\Url;
use yii\web\Response;
use yii\widgets\ActiveForm;
use Da\QrCode\QrCode;


use Mpdf\Mpdf;

/**
 * PlanaulaController implements the CRUD actions for Planaula model.
 */
class PlanaulaController extends Controller
{
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['post'],
                ],
            ],
        ];
    }

    /**
     * Lists all Planaula models.
     * @return mixed
     */
    public function actionIndex()
    {
        
        $searchModel = new PlanaulaSearch();

        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    public function actionLists($id)
    {
        $countPosts = nivelesdesempeno::find()
                ->where(['category_id' => $id])
                ->count();
 
        $posts = nivelesdesempeno::find()
                ->where(['category_id' => $id])
                ->orderBy('id DESC')
                ->all();
 
        if($countPosts>0){
            foreach($posts as $post){
                echo "<option value='".$post->id."'>".$post->title."</option>";
            }
        }
        else{
            echo "Nada";
        }
 
    }

    public function actionView($id)
    {
        $model = $this->findModel($id);
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    public function actionCreate()
    {
        $model = new Planaula();

        if ($model->load(Yii::$app->request->post())) {
            
            foreach ($model->grupo as $grupo) {

                $plan = new Planaula();

                if($adjunto = UploadedFile::getInstance($model, 'adjunto'))
                {
                    $id = Planaula::find()->max('id') + 1;

                    $s3 = Yii::$app->get('s3');    

                    if(!$s3->exist('planesdeaula/'.$id.'/'))
                    {
                        $s3->put('planesdeaula/'.$id.'/', null); 
                    }

                    /*if(!$s3->exist('planesaula/'.$id.'/'.Yii::$app->session->get('__tercero').'/'))
                    {
                        $s3->put('planesaula/'.$id.'/'.Yii::$app->session->get('__tercero').'/', null);    
                    }*/

                    $body = file_get_contents($adjunto->tempName);
                    $model->adjunto = $s3->put('planesdeaula/'.$id.'/'.$adjunto->name, $body);
                } 

                $plan->docente = $model->docente;
                $plan->semana_inicio = $model->semana_inicio;
                $plan->semana_fin = $model->semana_fin;
                $plan->grado = $model->grado;
                $plan->asignatura = $model->asignatura;
                $plan->grupo = $grupo;
                $plan->periodo = $model->periodo;
                $plan->competencia = $model->competencia;
                $plan->unidad = $model->unidad;
                $plan->nombre_unidad = $model->nombre_unidad;
                $plan->horas = $model->horas;
                $plan->derechos = $model->derechos;
                $plan->inicio = $model->inicio;
                $plan->desarrollo = $model->desarrollo;
                $plan->cierre = $model->cierre;
                $plan->formativa = $model->formativa;
                $plan->articulacion = $model->articulacion;
                $plan->recursos = $model->recursos;
                $plan->reflexion = $model->reflexion;
                $plan->observaciones = $model->observaciones;
                $plan->metodo = $model->metodo;
                $plan->adjunto = $model->adjunto;
                
                
                if(!$plan->save())
                {
                    print_r($plan->getAttributes());
                    echo "<br><br><br><br>";
                    print_r($plan->getErrors());
                }
            }

            return $this->redirect(['index']);

        } else {
            return $this->render('create', [
                'model' => $model,
            ]);
        }
    }

    public function actionUpdate($id)
    {
        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->id]);
        } else {
            return $this->render('update', [
                'model' => $model,
            ]);
        }
    }

    public function actionDelete($id)
    {
        //$this->findModel($id)->deleteWithRelated();

        $model = $this->findModel($id);
        $model->eliminado_por = \Yii::$app->user->id;
        $model->eliminado_el = new \yii\db\Expression('NOW()');
        $model->update();
        
        return $this->redirect(['index']);
    }

    public function actionRestore($id)
    {
        $this->findModel($id)->restoreWithRelated();

        return $this->redirect(['index']);
    }
    
    public function actionPdf($id) 
    {       
        $size_font = 8;
        $model = $this->findModel($id);

        $pdf = new Mpdf(['mode' => 'utf-8',
                         'format' => 'LETTER',
                         'default_font_size' => 0,
                         'default_font' => '',
                         'margin_left' => 15,
                         'margin_right' => 15,
                         'margin_top' => 35,
                         'margin_bottom' => 18,
                         'margin_header' => 9,
                         'margin_footer' => 5,
                         'orientation' => 'P']);  
        

        if ($model->grupos->sedes->pdf_marcadeagua == 'T' OR $model->grupos->sedes->pdf_marcadeagua == 'B')
        {
            $pdf->SetWatermarkText($sede->pdf_marcadeagua_contenido);
            $pdf->showWatermarkText = true;
            $pdf->watermarkTextAlpha = 0.1;
        }

        if ($model->grupos->sedes->pdf_marcadeagua == 'I')
        {
            $pdf->SetWatermarkImage($model->grupos->sedes->pdf_marcadeagua_contenido);
            $pdf->showWatermarkImage = true;
            $pdf->watermarkImageAlpha = 0.1;
        }

        $pdf->setHeader($model->grupos->sedes->pdf_header);
        $pdf->setFooter($model->grupos->sedes->pdf_footer);
        
        $pdf->AliasNbPages();

        
        $pdf->AddPage(0,'Letter');

        $pdf->SetY(35);

        $pdf->SetFillColor(255,255,255);
        $pdf->SetFont('Helvetica','B',12);
        $pdf->Cell(185,5,'Plan de Aula',0,1,'C');
        
        $pdf->ln(5);
        

        $pdf->SetFont('Helvetica','B',$size_font);
        $pdf->Cell(25,5,Yii::t('app', 'Docente'),0,0,'J');
        $pdf->SetFont('Helvetica','',$size_font);
        $pdf->Cell(68,5,$model->docentes->nombre,0,0,'J');
        

        $pdf->SetFont('Helvetica','B',$size_font);
        $pdf->Cell(25,5,Yii::t('app', 'Identificación'),0,0,'J');
        $pdf->SetFont('Helvetica','',$size_font);
        $pdf->Cell(68,5, $model->docentes->identificacion,0,0,'J');

        $pdf->Ln(5);
        
        $pdf->SetFont('Helvetica','B',$size_font);
        $pdf->Cell(25,5,Yii::t('app', 'Grado'),0,0,'J');
        $pdf->SetFont('Helvetica','',$size_font);
        $pdf->Cell(68,5,$model->grados->grado,0,0,'J');       

        $pdf->SetFont('Helvetica','B',$size_font);
        $pdf->Cell(25,5,Yii::t('app', 'Grupo'),0,0,'J');
        $pdf->SetFont('Helvetica','',$size_font);
        $pdf->Cell(68,5,$model->grupos->grupo,0,0,'J');

        $pdf->Ln(5);

        $pdf->SetFont('Helvetica','B',$size_font);
        $pdf->Cell(25,5,Yii::t('app', 'Área'),0,0,'J');
        $pdf->SetFont('Helvetica','',$size_font);
        $pdf->Cell(68,5,$model->asignaturas->areas->area,0,0,'J');

        $pdf->SetFont('Helvetica','B',$size_font);
        $pdf->Cell(25,5,Yii::t('app', 'Asignatura'),0,0,'J');
        $pdf->SetFont('Helvetica','',$size_font);
        $pdf->Cell(68,5,$model->asignaturas->asignatura,0,0,'J');
        
        $pdf->Ln(5);        

        $pdf->SetFont('Helvetica','B',$size_font);
        $pdf->Cell(25,5,Yii::t('app', 'Especialidad'),0,0,'J');
        $pdf->SetFont('Helvetica','',$size_font);
        $pdf->Cell(68,5,$model->asignaturas->especialidades->especialidad,0,0,'J');


        $pdf->SetFont('Helvetica','B',$size_font);
        $pdf->Cell(25,5,Yii::t('app', 'Vigencia'),0,0,'J');
        $pdf->SetFont('Helvetica','',$size_font);
        $pdf->Cell(68,5,$model->grupos->sedes->vigencia,0,0,'J');

        $pdf->Ln(5);        

        $pdf->SetFont('Helvetica','B',$size_font);
        $pdf->Cell(25,5,Yii::t('app', 'Jornada'),0,0,'J');
        $pdf->SetFont('Helvetica','',$size_font);
        $pdf->Cell(68,5, $model->grupos->jornadas->jornada,0,0,'J');
        

        $pdf->SetFont('Helvetica','B',$size_font);
        $pdf->Cell(25,5,Yii::t('app', 'Periodo'),0,0,'J');
        $pdf->SetFont('Helvetica','',$size_font);
        $pdf->Cell(68,5,$model->periodo,0,0,'J');

        $pdf->Ln(5);        

        $pdf->SetFont('Helvetica','B',$size_font);
        $pdf->Cell(25,5,Yii::t('app', 'Fecha Inicio'),0,0,'J');
        $pdf->SetFont('Helvetica','',$size_font);
        $pdf->Cell(68,5, Yii::$app->formatter->asDate($model->semana_inicio, 'long'),0,0,'J');

        $pdf->SetFont('Helvetica','B',$size_font);
        $pdf->Cell(25,5,Yii::t('app', 'Fecha Final'),0,0,'J');
        $pdf->SetFont('Helvetica','',$size_font);
        $pdf->Cell(68,5, Yii::$app->formatter->asDate($model->semana_fin, 'long'),0,0,'J');
    
        //$pdf->SetDrawColor(220,220,220);
        //$pdf->Line(15,$pdf->y+8,200,$pdf->y+8);

        $estandar = Estandar::find()->where(['grado' => $model->grado, 'asignatura' =>$model->asignatura])->one();
        $pdf->ln(10);    

        $pdf->SetFillColor(220,220,220);
        $pdf->SetDrawColor(220,220,220);
        $pdf->SetFont('Helvetica','B',$size_font);
        $pdf->Cell(185,5,Yii::t('app', 'Estandar'),1,1,'J',1);
        $pdf->SetFillColor(255,255,255);
        $pdf->SetFont('Helvetica','',$size_font);
        $pdf->MultiCell(185,5,$estandar->estandar,1,'J',1);

        $pdf->ln(5);

        $pdf->SetFillColor(220,220,220);
        $pdf->SetDrawColor(220,220,220);
        $pdf->SetFont('Helvetica','B',$size_font);
        $pdf->Cell(185,5,Yii::t('app', 'Competencia'),1,1,'J',1);
        $pdf->SetFillColor(255,255,255);
        $pdf->SetFont('Helvetica','',$size_font);
        $pdf->MultiCell(185, 5, $model->competencias->competencia, 1,'J',1);


        $pdf->ln(3);    
        $pdf->SetFillColor(220,220,220);
        $pdf->SetDrawColor(220,220,220);
        $pdf->SetFont('Helvetica','B',$size_font);
        $pdf->Cell(185,5,Yii::t('app', 'Niveles de Desempeño'),1,1,'J',1);
        $pdf->ln(3);

        
            foreach ($model->competencias->frds as $desempeno) 
            {
                
                switch ($desempeno->id) {
                    case '1':
                         $nivel ='NO EVALUADO';
                         $pdf->SetFillColor(187,187,187);
                         $pdf->SetDrawColor(187,187,187);
                        break;
                    
                    case '2':
                         $nivel ='BAJO';
                         $pdf->SetFillColor(217,83,79);
                         $pdf->SetDrawColor(217,83,79);
                        break;

                    case '3':
                         $nivel ='BÁSICO';
                         $pdf->SetFillColor(240,173,78);
                         $pdf->SetDrawColor(240,173,78);
                        break;
                    
                    case '4':
                         $nivel ='ALTO';
                         $pdf->SetFillColor(92,184,92);
                         $pdf->SetDrawColor(92,184,92);
                        break;
                    
                    case '5':
                         $nivel ='SUPERIOR';
                         $pdf->SetFillColor(51,122,183);
                         $pdf->SetDrawColor(51,122,183);
                        break;
                        
                    default:
                         $nivel ='NO ESTABLECIDO';
                         $pdf->SetFillColor(187,187,187);
                         $pdf->SetDrawColor(187,187,187);
                        break;
                 } 

                
            
                $pdf->SetTextColor(255,255,255);
                $pdf->SetFont('Helvetica','B',6);
                $pdf->Cell(20,5,$nivel,1,0,'C',1);
                $pdf->SetFont('Helvetica','',$size_font);
                $pdf->SetTextColor(0,0,0);
                $pdf->SetDrawColor(220,220,220);
                $pdf->Cell(165,5,'Hola',1,0,'J',0);
                $pdf->ln(6);

/*
            if($desempeno->desempeno == 2 or $desempeno->desempeno == 3 or $desempeno->desempeno == 7 or $desempeno->desempeno == 8)
            {
                $pdf->SetFont('Helvetica','B',$size_font);          
                $pdf->Cell(188,4,'Debilidad','LR',0,'L',0);
                $pdf->Ln(4);
                $pdf->SetFont('Helvetica','',$size_font);          
                $pdf->MultiCell(188, 4,$desempeno->debilidad, 'LR', 'J',0);

                $pdf->SetFont('Helvetica','B',$size_font);          
                $pdf->Cell(188,4,'Recomendación','LR',0,'L',0);
                $pdf->Ln(4);
                $pdf->SetFont('Helvetica','',$size_font);          
                $pdf->MultiCell(188, 4,$desempeno->recomendacion, 'LR', 'J',0);
            }
            if($desempeno->desempeno == 4 or $desempeno->desempeno == 5 or $desempeno->desempeno == 9 or $desempeno->desempeno == 10)
            {
                $pdf->SetFont('Helvetica','B',$size_font);          
                $pdf->Cell(188,4,'Fortaleza','LR',0,'L',0);
                $pdf->Ln(4);
                $pdf->SetFont('timezone_abbreviations_list()','',$size_font);          
                $pdf->MultiCell(188, 4,$desempeno->fortaleza, 'LR', 'J',0);                                    
            }    

       */   

            }

        $pdf->SetDrawColor(187,187,187);
    
        $pdf->ln(5);    
        $pdf->SetFillColor(220,220,220);
        $pdf->SetDrawColor(220,220,220);
        $pdf->SetFont('Helvetica','B',$size_font);
        $pdf->Cell(20,5,Yii::t('app', 'Unidad'),1,0,'C',1);
        $pdf->Cell(145,5,Yii::t('app', 'Nombre de la Unidad'),1,0,'C',1);
        $pdf->Cell(20,5,Yii::t('app', 'Horas'),1,0,'C',1);

        $pdf->ln(5); 
        $pdf->SetFont('Helvetica','',$size_font);
        $pdf->Cell(20,5,$model->unidad,1,0,'C',0);
        $pdf->Cell(145,5,$model->nombre_unidad,1,0,'J',0);
        $pdf->Cell(20,5,utf8_encode($model->horas),1,0,'C',0);
                    

        $pdf->ln(10);    
        $pdf->SetFont('Helvetica','B',$size_font);
        $pdf->Cell(185,5,Yii::t('app', 'Derechos Básicos Asociados'),1,1,'J',1);
        $pdf->SetFont('Helvetica','',$size_font);
        $pdf->MultiCell(185,5,$model->derechos,1,'J',0);

        $pdf->ln(5); 
        $pdf->SetFont('Helvetica','B',$size_font);
        $pdf->Cell(185,5,Yii::t('app', 'Actividades Inicio (Exploración, Acercamiento a Temáticas)'),1,1,'J',1);
        $pdf->SetFont('Helvetica','',$size_font);
        $pdf->MultiCell(185,5,$model->inicio,1,'J',0);
        
        $pdf->ln(5);    
        $pdf->SetFont('Helvetica','B',$size_font);
        $pdf->Cell(185,5,Yii::t('app', 'Actividades de Desarrollo (Indagación, Conceptualización)'),1,1,'J',1);
        $pdf->SetFont('Helvetica','',$size_font);
        $pdf->MultiCell(185,5,$model->desarrollo,1,'J',0);

        $pdf->ln(5);    
        $pdf->SetFont('Helvetica','B',$size_font);
        $pdf->Cell(185,5,Yii::t('app', 'Actividades de Cierre (Aplicabilidad, Valoración)'),1,1,'J',1);
        $pdf->SetFont('Helvetica','',$size_font);
        $pdf->MultiCell(185,5,$model->cierre,1,'J',0);

        $pdf->ln(5);    
        $pdf->SetFont('Helvetica','B',$size_font);
        $pdf->Cell(185,5,Yii::t('app', 'Evaluación Formativa (Técnicas, Criterios e Indicadores)'),1,1,'J',1);
        $pdf->SetFont('Helvetica','',$size_font);
        $pdf->MultiCell(185,5,$model->formativa,1,'J',0);

        $pdf->ln(5);    
        $pdf->SetFont('Helvetica','B',$size_font);
        $pdf->Cell(185,5,Yii::t('app', 'Articulación con Otras Áreas y Proyectos'),1,1,'J',1);
        $pdf->SetFont('Helvetica','',$size_font);
        $pdf->MultiCell(185,5,$model->articulacion,1,'J',0); 

        $pdf->ln(5);    
        $pdf->SetFont('Helvetica','B',$size_font);
        $pdf->Cell(185,5,Yii::t('app', 'Recursos e Instrumentos'),1,1,'J',1);
        $pdf->SetFont('Helvetica','',$size_font);
        $pdf->MultiCell(185,5,$model->recursos,1,'J',0); 

        $pdf->ln(5);    
        $pdf->SetFont('Helvetica','B',$size_font);
        $pdf->Cell(185,5,Yii::t('app', 'Reflexión'),1,1,'J',1);
        $pdf->SetFont('Helvetica','',$size_font);
        $pdf->MultiCell(185,5,$model->reflexion,1,'J',0);    

        $pdf->ln(5);    
        $pdf->SetFont('Helvetica','B',$size_font);
        $pdf->Cell(185,5,Yii::t('app', 'Observaciones'),1,1,'J',1);
        $pdf->SetFont('Helvetica','',$size_font);
        $pdf->MultiCell(185,5,$model->observaciones,1,'J',0);                                                                        

        $pdf->SetFont('Helvetica','',$size_font);
        $pdf->Ln(5);
        $pdf->Cell(180,6,"En constancia de entrega y publicación el día ".Yii::$app->formatter->asDate($model->creado_el, 'long').".",0,0);
            
        $pdf->ln(30);
        $pdf->SetFont('Helvetica','B',$size_font);

        $y = $pdf->y;
        $x = $pdf->x;

        if($model->docentes->firma != '' or $model->docentes->firma != NULL )
        {
            $pdf->Image(\Yii::getAlias('@webroot/uploads/'.$model->docentes->firma),85,$y,50);    
        }    
        
                
        $pdf->setY($pdf->y-15);
        $pdf->Cell(65);
        $pdf->Cell(60,5,$model->docentes->nombre,'T',0,'C',0);
        $pdf->Ln(3);
        $pdf->SetFont('Helvetica','',$size_font);
        $pdf->Cell(65);
        $pdf->Cell(60,5,Yii::t('app', 'Docente'),'',0,'C',0);


        $pdf->Output("Plan de Aula (".date("d-m-Y_H-i").").pdf",'D');

    }
    
    protected function findModel($id)
    {
        if (($model = Planaula::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }
}
