<?php

namespace backend\controllers;

use Yii;
use backend\models\Calificacion;
use backend\models\Calificacioncalificaciones;
use backend\models\Calificacionfrd;
use backend\models\Calificacionobservacionesgenerales;
use backend\models\Seleccionmultiple;
use backend\models\Periodo;
use backend\models\Academico;
use backend\models\Grupo;
use backend\models\Asignatura;
use backend\models\Tercero;
use backend\models\Competencia;
use backend\models\CalificacionSearch;
use backend\models\Frd;
use backend\models\Desempeno;
use backend\models\Promedio;
use backend\models\Promedioarea;

use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\data\ActiveDataProvider;
use yii\base\Model;
use yii\helpers\Html;



class PromedioController extends Controller
{
    public $actions;

    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['post'],
                ],
            ],
        ];
    }


    public function actionProcesar()
    {
        if (Yii::$app->request->isAjax) 
        {
            $periodo = Yii::$app->request->post('periodo');
            
            $grupo = Grupo::find()->where(['id' => Yii::$app->request->post('grupo')])->one();

            $asignaturas = Asignatura::find()->where(['grado' => $grupo->grado])->all(); 

            $promedio = new Promedio;

            foreach ($asignaturas as $asignatura) 
            {
                if($asignatura->especialidad == 1)
                {
                    $estudiantes = Academico::find()->select(['tercero.id', 'academico.estudiante', 'academico.grupo'])->joinWith(['estudiantes'])->where(['<', 'tercero.estado', 3])->andWhere(['academico.grupo' => $grupo->id])->orderBy('primer_apellido')->all();  
                }
                else
                {
                    $estudiantes = Academico::find()->select(['tercero.id', 'academico.estudiante', 'academico.grupo'])->joinWith(['estudiantes'])->where(['<', 'tercero.estado', 3])->andWhere(['academico.grupo' => $grupo->id])->andWhere(['academico.especialidad' => $asignatura->especialidad])->orderBy('primer_apellido')->all();     
                }

                foreach ($estudiantes as $estudiante) 
                {
                    $promedio->getPromedioxEstudiante($grupo->grados->tipo_calificacion, $estudiante->estudiante, $grupo->grados->id, $grupo->id, $asignatura->id, $periodo);
                }

                $promedio->getPuestoxGrupo($grupo->grados->tipo_calificacion, $grupo->grados->id, $grupo->id, $asignatura->id, $periodo);
                $promedio->getPromedios($grupo->grados->tipo_calificacion, $grupo->grados->id, $grupo->id, $asignatura->id, $periodo);

            }
            
            return true;
        }


        $model = new Promedio(['scenario'=>'cambiar']);
        $periodo = new Periodo();
        $model->periodo = $periodo->actual->id;

        $grupos = Grupo::find()->where(['estado' => '1'])->all();
        
        return $this->render('procesar', [
            'model' => $model,
            'grupos' => $grupos,
        ]);
    
    }

}