<?php

namespace backend\controllers;

use yii;
use yii\web\Controller;
use yii\web\UploadedFile;
use yii\filters\AccessControl;

use backend\models\Asignatura;
use backend\models\Area;
use backend\models\Grupo;
use backend\models\Grado;
use backend\models\Periodo;
use backend\models\Estandar;
use backend\models\Carga;
use backend\models\Competencia;
use backend\models\Municipio;
use backend\models\Barrio;
use backend\models\Desempeno;
use backend\models\Tercero;
use backend\models\Terceroestado;
use backend\models\Resguardo;
use backend\models\Frd;
use backend\models\LanzadorForm;
use backend\models\BloquearboletinesForm;

//<script src="https://cdn.ckeditor.com/ckeditor5/18.0.0/classic/ckeditor.js"></script>

class PublicaController extends Controller
{
    /*
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
                'denyCallback' => function ($rule, $action) {
                    if (Yii::$app->user->getIsGuest()) {
                        Yii::$app->user->loginRequired(true, false);
                    } else {
                        throw new ForbiddenHttpException(Yii::t('yii', 'You are not allowed to perform this action.'));
                    }

                    return new ForbiddenHttpException(Yii::t('yii', 'You are not allowed to perform this action.'));
                },
            ],
        ];
    }*/


    public function actionUpload()
    {

        if (Yii::$app->request->isAjax) 
        {
            Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;

        
            //$this->load(Yii::$app->request->post());

            //$file = UploadedFile::getInstancebyname($_FILES['file_data']);

            $file = $_FILES['adjunto'];  // the path for the uploaded file chunk 
            //$fileName = $_POST['fileName'];          // you receive the file name as a separate post data
            //$fileSize = $_POST['fileSize'];          // you receive the file size as a separa

            $s3 = Yii::$app->get('s3');

            //$result = $s3->get('filename.ext');

            //$result = $s3->put('filename.ext', 'body');

            //$body = file_get_contents($file->tempName);

            //return $s3->put($file->name, $body);

            return $s3->upload($file->name,'/');

             
             //return ActiveForm::validate($model);
        } 

    }

    public function actionBloquearboletines($grupo = NULL)
    {
        /*
        if (!Yii::$app->user->can('Bloquearboletines')) 
        {
            throw new ForbiddenHttpException(Yii::t('yii', 'You are not allowed to perform this action.'));
        }*/

        $model = new BloquearboletinesForm();
        $tercero = new Tercero();

        if (Yii::$app->request->isAjax && $model->load(Yii::$app->request->post())) {
            Yii::$app->response->format = Response::FORMAT_JSON;
            return ActiveForm::validate($model);
        }
        if ($model->load(Yii::$app->request->post())) {
            return $this->redirect(['site/index']);
        } else {
            return $this->renderAjax('bloquear_boletines', [
                'model' => $model,
                'estudiantes' => $tercero->getEstudiantesbloqueados($grupo),
            ]);
        }

    }

    public function actionRefresh()
    {
        $tercero = new Tercero();
        Yii::$app->getResponse()->format = 'json';
        return $tercero->getEstudiantesbloqueados($grupo);
    }


    public function actionAssign()
    {
        $estudiantes = Yii::$app->getRequest()->post('routes', []);
        
        foreach ($estudiantes as $estudiante) {
            
            $tercero = Tercero::findOne($estudiante);
            $tercero->bloqueo = '1';
            $tercero->update(false);
        }

        Yii::$app->getResponse()->format = 'json';
        return ['success' => $success];
    }

    public function actionRemove()
    {
        $estudiantes = Yii::$app->getRequest()->post('routes', []);
        
        foreach ($estudiantes as $estudiante) {
            
            $tercero = Tercero::findOne($estudiante);
            $tercero->bloqueo = '0';
            $tercero->update(false);
        }

        Yii::$app->getResponse()->format = 'json';
        return ['success' => $success];
    }

    public function actionFindasignaturas() {
    
        $out = [];
        if (isset($_POST['depdrop_parents'])) {
            $parents = $_POST['depdrop_parents'];
            if ($parents != null) {
                $grado = $parents[0];
                $out = Asignatura::getAsignaturasbyGrado($grado);
                
                return json_encode(['output'=>$out, 'selected'=>'']);
            }
        }
        return json_encode(['output'=>'', 'selected'=>'']);
    }

    public function actionAsignaturasbygradoindex($id = NULL) {
    
        if (isset($id)) 
        {
            $out = Asignatura::getAsignaturasbyGradoIndex($id);
            echo $out;
            
        }
        else
        {
            echo "<option>No hay Asignaturas</option>";
        }
    }

    public function actionFindasignaturasbygradoygrupo() {
    
        $out = [];
        if (isset($_POST['depdrop_parents'])) {
            $parents = $_POST['depdrop_parents'];
            if ($parents != null) {
                $grado = $parents[0];
                $grupo = $parents[1];
                $out = Asignatura::getAsignaturasbyGradoyGrupo($grado, $grupo);
                
                return json_encode(['output'=>$out, 'selected'=>'']);
            }
        }
        return json_encode(['output'=>'', 'selected'=>'']);
    }

    public function actionFindasignaturasbygrupo() {
    
        $out = [];
        if (isset($_POST['depdrop_parents'])) {
            $parents = $_POST['depdrop_parents'];
            if ($parents != null) {

                $grupo_id = $parents[0];

                if(Yii::$app->session->get('__doc') == 'admin')
                {
                    $grupo = Grupo::findOne($grupo_id);
                    $out = Asignatura::getAsignaturasbyGrupo($grupo->grado);    
                }
                else
                {
                    $out = Carga::getAsignaturasbyGrupoxDocente($grupo_id);
                }

                return json_encode(['output'=>$out, 'selected'=>'']);
            }
        }
        return json_encode(['output'=>'', 'selected'=>'']);
    }

    public function actionFindasignaturasnoexcluidas() {
    
        $out = [];
        if (isset($_POST['depdrop_parents'])) {
            $parents = $_POST['depdrop_parents'];
            if ($parents != null) {
                $grado = $parents[0];
                $out = Asignatura::getAsignaturasbyGradonoExcluidas($grado);
                
                return json_encode(['output'=>$out, 'selected'=>'']);
            }
        }
        return json_encode(['output'=>'', 'selected'=>'']);
    }

    public function actionFindareas() {
    
        $out = [];
        if (isset($_POST['depdrop_parents'])) {
            $parents = $_POST['depdrop_parents'];
            if ($parents != null) {
                $asignatura_id = $parents[0];
                $out=Area::getAreasbyAsignatura($asignatura_id);
                
                return json_encode(['output'=>$out, 'selected'=>'']);
            }
        }
        return json_encode(['output'=>'', 'selected'=>'']);
    }

    public function actionFindareasxgrado() {
    
        $out = [];
        if (isset($_POST['depdrop_parents'])) {
            $parents = $_POST['depdrop_parents'];
            if ($parents != null) {
                $grado = $parents[0];
                $out = Area::getAreasbyGrado($grado);
                
                return json_encode(['output'=>$out, 'selected'=>'']);
            }
        }
        return json_encode(['output'=>'', 'selected'=>'']);
    }

    public function actionFindgrados() {
    
        $out = [];
        if (isset($_POST['depdrop_parents'])) {
            $parents = $_POST['depdrop_parents'];
            if ($parents != null) {
                $sede_id = $parents[0];
                $tercero_id = isset($parents[1]) ? $parents[1] : null; 

                $out=Grupo::getGradobyTercero($sede_id, $tercero_id);
                return json_encode(['output'=>$out, 'selected'=> isset($parents[1]) ? $out : '']);
            }
        }
        return json_encode(['output'=>'', 'selected'=>'']);
    }

    public function actionFindgradosbydocente() {
    
        $out = [];
        if (isset($_POST['depdrop_parents'])) {
            $parents = $_POST['depdrop_parents'];
            if ($parents != null) {
                $sede_id = $parents[0];
                $tercero_id = $parents[1];
                $out=Grado::getGradobydocente($sede_id, $tercero_id);
                
                return json_encode(['output'=>$out, 'selected'=> '']);
            }
        }
        return json_encode(['output'=>'', 'selected'=>'']);
    }

    public function actionFindgrupos() {
    
        $out = [];
        if (isset($_POST['depdrop_parents'])) {
            $parents = $_POST['depdrop_parents'];
            if ($parents != null) {
                $sede_id = $parents[0];
                $grado_id = $parents[1];
                $tercero_id = isset($parents[2]) ? $parents[2] : NULL;
                $out=Grupo::getGruposbyGrado($sede_id,$grado_id,$tercero_id);
                
                return json_encode(['output'=>$out, 'selected' => '']);
            }
        }
        return json_encode(['output'=>'', 'selected'=>'']);
    }

    public function actionFindgruposbygradojornada() {
    
        $out = [];
        if (isset($_POST['depdrop_parents'])) {
            $parents = $_POST['depdrop_parents'];
            if ($parents != null) {
                $sede_id = $parents[0];
                $grado_id = $parents[1];
                $jornada_id = $parents[2];
                $out=Grupo::getGruposbyGradoJornada($sede_id,$grado_id,$jornada_id);
                
                return json_encode(['output'=>$out, 'selected' => '']);
            }
        }
        return json_encode(['output'=>'', 'selected'=>'']);
    }


    public function actionFindestandares() {
    
        $out = [];
        if (isset($_POST['depdrop_parents'])) {
            $parents = $_POST['depdrop_parents'];
            if ($parents != null) {
                $grado_id = $parents[0];
                $asignatura_id = $parents[1];
                $periodo_id = $parents[2];
                $out=Estandar::getEstandar($grado_id,$asignatura_id,$periodo_id);
                
                return json_encode(['output'=>$out, 'selected'=>'']);
            }
        }
        return json_encode(['output'=>'', 'selected'=>'']);
    }

    public function actionFindcompetencias() {
    
        $out = [];
        if (isset($_POST['depdrop_parents'])) {
            $parents = $_POST['depdrop_parents'];
            if ($parents != null) {
                $asignatura_id = $parents[0];
                $periodo_id = $parents[1];
                $out=Competencia::getCompetenciasbyPeriodo($asignatura_id,$periodo_id);
                
                return json_encode(['output'=>$out, 'selected'=>'']);
            }
        }
        return json_encode(['output'=>'', 'selected'=>'']);
    }

    public function actionFinddesempenos() {
    
        $out = [];
        if (isset($_POST['depdrop_parents'])) {
            $parents = $_POST['depdrop_parents'];
            if ($parents != null) {
                $grado_id = $parents[0];
                $out=Desempeno::getDesempenosbyGrado($grado_id);
                
                return json_encode(['output'=>$out, 'selected'=>'']);
            }
        }
        return json_encode(['output'=>'', 'selected'=>'']);
    }

    public function actionFindperiodos() {
    
        $out = [];
        if (isset($_POST['depdrop_parents'])) {
            $parents = $_POST['depdrop_parents'];
            if ($parents != null) {
                $out=Periodo::getPeriodos();
                
                return json_encode(['output'=>$out, 'selected'=>'']);
            }
        }
        return json_encode(['output'=>'', 'selected'=>'']);
    }    


    public function actionFindniveles()
    {
        $data = Yii::$app->request->post('test');
            if (isset($data)) {
                $test = $data;

                $niveles = frd::find()
                ->where(['competencia' => $data])
                ->orderBy('frd_tipo ASC')
                ->all();

                $test ="<ul class='list-group'>";

                    if(!empty($niveles))
                    {
                      foreach($niveles as $row)
                      {
                        //SELECT desempeno.desempeno, color, descripcion FROM desempeno, desempeno_nivel WHERE desempeno_nivel.desempeno=desempeno.id AND desempeno_nivel.estado=1;
                        
                        $test .= "<li class='list-group-item w940'><span class='label standar' style='background-color:".$row->desempenos->color.";'>".mb_strtoupper($row->tipos->tipo)."</span>".mb_strtoupper($row->descripcion)."</li>";
                      }
                    }
                $test .= "</ul>";   

            } else {
                $test = "No hay niveles de desempeño.";
            }
        return $test;
    }

    public function actionFindestandar()
    {
        $grado = Yii::$app->request->post('grado');
        $asignatura = Yii::$app->request->post('asignatura');
        $periodo = Yii::$app->request->post('periodo');
                   
            if (isset($grado) && isset($asignatura) && isset($periodo)) {
                //$test = $data;

                $estandares = Estandar::find()
                ->where(['grado' => $grado])
                ->andWhere(['asignatura' => $asignatura])
                ->andWhere(['periodo' => $periodo])
                ->andWhere(['eliminado_por' => '0'])
                ->andWhere(['estado' => '1'])
                ->all();

                $test='';

                    if(!empty($estandares))
                    {
                      $test ="<ul class='list-group'>";  
                      foreach($estandares as $estandar)
                      {
                        //SELECT desempeno.desempeno, color, descripcion FROM desempeno, desempeno_nivel WHERE desempeno_nivel.desempeno=desempeno.id AND desempeno_nivel.estado=1;
                        $test .= "<li class='list-group-item w940'><span class='label standar'>".mb_strtoupper(Yii::t('app', 'Estandar'))."</span>".mb_strtoupper($estandar->estandar)."</li>";

                      }
                      $test .= "</ul>";  
                    }
                 

            } else {
                $test = Yii::t('app', 'No hay Estandar');
            }
        return $test;
    }

    public function actionFindcargas() {
    
        $out = [];
        if (isset($_POST['depdrop_parents'])) {
            $parents = $_POST['depdrop_parents'];
            if ($parents != null) {
                $tercero_id = $parents[0];
                $out=Carga::getAsignaturasbyDocente($tercero_id);
                
                return json_encode(['output'=>$out, 'selected'=>'']);
                //return $out;
            }
        }
        return json_encode(['output'=>'', 'selected'=>'']);
        //return $out;
    }

    public function Municipios($departamento) {
        $out = [];
        if (isset($departamento)) {
            $id = end($departamento);
            $list = Municipio::find()->where(['departamento'=>$id])->asArray()->all();
            $selected  = null;
            if ($id != null && count($list) > 0) {
                $selected = '';
                foreach ($list as $i => $data) {
                    $out[] = ['id' => $data['id'], 'name' => $data['nombre']];
                    if ($i == 0) {
                        $selected = $data['id'];
                    }
                }
                // Shows how you can preselect a value
                return Json_encode(['output' => $out, 'selected'=>$selected]);
            }
        }
        return Json_encode(['output' => '', 'selected'=>'']);
    }


    public function Barrios($municipio) {
        $out = [];
        if (isset($municipio)) {
            $id = end($municipio);
            $list = Barrio::find()->where(['municipio' => $id])->orderBy(['nombre' => SORT_ASC])->asArray()->all();
            $selected  = null;
            if ($id != null && count($list) > 0) {
                $selected = '';
                foreach ($list as $i => $data) {
                    $out[] = ['id' => $data['id'], 'name' => $data['nombre']];
                    if ($i == 0) {
                        $selected = $data['id'];
                    }
                }
                // Shows how you can preselect a value
                return Json_encode(['output' => $out, 'selected'=>$selected]);
            }
        }
        return Json_encode(['output' => '', 'selected'=>'']);
    }
 
 
     public function Estados($tipo_tercero) {
        $out = [];
        if (isset($tipo_tercero)) {
            $id = end($tipo_tercero);
            $list = Terceroestado::find()->andWhere(['tipo_tercero'=>$id])->asArray()->all();
            $selected  = null;
            if ($id != null && count($list) > 0) {
                $selected = '';
                foreach ($list as $i => $data) {
                    $out[] = ['id' => $data['id'], 'name' => $data['estado']];
                    if ($i == 0) {
                        $selected = $data['id'];
                    }
                }
                // Shows how you can preselect a value
                return Json_encode(['output' => $out, 'selected'=>$selected]);
            }
        }
        return Json_encode(['output' => '', 'selected'=>'']);
    }


    public function Resguardos($departamento) {
        $out = [];
        if (isset($departamento)) {
            $id = end($departamento);
            $list = Resguardo::find()->andWhere(['departamento'=>$id])->asArray()->all();
            $selected  = null;
            if ($id != null && count($list) > 0) {
                $selected = '';
                foreach ($list as $i => $data) {
                    $out[] = ['id' => $data['id'], 'name' => $data['resguardo']];
                    if ($i == 0) {
                        //$selected = $data['id'];
                    }
                }
                // Shows how you can preselect a value
                return Json_encode(['output' => $out, 'selected'=>$selected]);
            }
        }
        return Json_encode(['output' => '', 'selected'=>'']);
    }

    public function Filesize($bytes, $decimales = 2)
    {
        $size = array('B','kB','MB','GB','TB','PB','EB','ZB','YB');
        $factor = floor((strlen($bytes) - 1) / 3);
        return sprintf("%.{$decimales}f ", $bytes / pow(1024, $factor)) . @$size[$factor];
    }    

}
