<?php

namespace backend\controllers;

use Yii;
use yii\web\Controller;
use yii\widgets\ActiveForm;
use yii\web\Response;


use backend\models\Carga;
use backend\models\Tercero;
use backend\models\Asistencia;
use backend\models\Grupo;
use backend\models\Asignatura;
use backend\models\LanzadorForm;

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Style\Alignment;
use PhpOffice\PhpSpreadsheet\Style\Border;
use PhpOffice\PhpSpreadsheet\Style\Fill;
use PhpOffice\PhpSpreadsheet\Style\Style;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpSpreadsheet\Helper\Sample;
use PhpOffice\PhpSpreadsheet\IOFactory;
use PhpOffice\PhpSpreadsheet\Worksheet\PageSetup;


class Reporte101Controller extends Controller
{

    public function actionIndex($grupo = NULL, $asignatura = NULL) // Reporte de Ausentismo por Asignatura y Grupo
    {

        if($grupo == NULL or $asignatura == NULL)
        {    
            $model = new LanzadorForm(['scenario'=>'grupo']);

            //$model->reporte = 'Reporte Consolidado de Ausentismo Mensual';
            //$model->observaciones = 'Exporta la información de ausentismo por asignatura y grupo según sea el caso; si no selecciona la asignatura por defecto será un informe por grupo, este reporte se genera en formato Excel.';

            $model->reporte = Yii::t('app', 'R101-Reporte');
            $model->observaciones = Yii::t('app', 'R101-Observaciones');

            if (Yii::$app->request->isAjax && $model->load(Yii::$app->request->post())) {
                Yii::$app->response->format = Response::FORMAT_JSON;
                return ActiveForm::validate($model);
            }

            if ($model->load(Yii::$app->request->post())) 
            {
                $grupo = $model->grupo;
                $asignatura = $model->asignatura; 
            }    
            else
            {
                if (Yii::$app->request->isAjax) 
                {
                    return $this->renderAjax('/publica/lanzador', [
                            'model' => $model,
                            'sede' => true,
                            'tercero' => false,
                            'grado' => true,
                            'grupo' => true,
                            'asignatura' => true,
                            'periodo' => false,
                            'competencia' => false,
                            'columnas' => false,
                            'ver_estandar' => false,
                            'ver_competencia' => false,
                            'ver_niveles' => false,
                            'ver_desempenos' => false,
                            'ver_frd' => false,
                            'ver_fecha' => true,
                            'ver_letrasonumeros' => false,
                        ]);

                    exit;
                }
                else
                {
                    return $this->render('/publica/lanzador', [
                            'model' => $model,
                            'sede' => true,
                            'tercero' => false,
                            'grado' => true,
                            'grupo' => true,
                            'asignatura' => true,
                            'periodo' => false,
                            'competencia' => false,
                            'columnas' => false,
                            'ver_estandar' => false,
                            'ver_competencia' => false,
                            'ver_niveles' => false,
                            'ver_desempenos' => false,
                            'ver_frd' => false,
                            'ver_fecha' => true,
                            'ver_letrasonumeros' => false,
                        ]);

                    exit;
                }    
            }    
        }

        date_default_timezone_set('America/Bogota');

        /// MARGENES HOJA
        $top = '1';
        $right = '0.5';
        $left = '0.5';
        $bottom = '1';

        $grupo = Grupo::findOne($grupo);
        
        if(isset($asignatura))
        {
            $asignatura = Asignatura::findOne($asignatura);  
        }    
        
        $anio = $grupo->sedes->vigencia;

        $mes = ['ENE', 'FEB', 'MAR', 'ABR', 'MAY', 'JUN', 'JUL', 'AGO', 'SEP', 'OCT', 'NOV', 'DIC'];
        $mescompleto = ['Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre'];


        $Excel = new Spreadsheet();

        $Excel->getProperties()
            ->setCreator("Sonic")
            ->setLastModifiedBy("Sonic")
            ->setTitle("Reporte 101 - Consolidado de Ausentismo Mensual")
            ->setDescription("Documento Generado por Sonic")
            ->setCategory("Listados");     

        $this->render('/reporte/_headerandfooter_excel_landscape', ['Excel' => $Excel]);    

        $Excel->setActiveSheetIndex(0);

        $Excel->getActiveSheet()->getPageSetup()->setOrientation(PageSetup::ORIENTATION_LANDSCAPE);
        $Excel->getActiveSheet()->getPageSetup()->setPaperSize(PageSetup::PAPERSIZE_FOLIO);
        $Excel->getActiveSheet()->getPageSetup()->setHorizontalCentered(true);
        $Excel->getActiveSheet()->getPageMargins()->setTop($top);
        $Excel->getActiveSheet()->getPageMargins()->setRight($right);
        $Excel->getActiveSheet()->getPageMargins()->setLeft($left);
        $Excel->getActiveSheet()->getPageMargins()->setBottom($bottom);
        
        $Excel->getActiveSheet()->setTitle('Consolidado');


        $Excel->getActiveSheet()->getStyle('A1:A2')->applyFromArray(array(
            'font'  => array(
                    'bold'  => true,
                    'color' => array('rgb' => '000000'),
                    'size'  => 12,
                    'name'  => 'Calibri'
            ),
            'alignment' => array(
              'horizontal' => Alignment::HORIZONTAL_CENTER,
            )
        ));
        

        $fila = '4';
        $Excel->getActiveSheet()->setCellValue('A'.$fila, Yii::t('app', '#'));
        $Excel->getActiveSheet()->setCellValue('B'.$fila, Yii::t('app', 'Estudiante'));  
        

        $d = 'C';
        for ($x='1'; $x <= date('m'); $x++)
        {   

            $Excel->getActiveSheet()->setCellValue($d.$fila, $mes[$x-1]);
            $d++;
        } 

        
        $Excel->getActiveSheet()->mergeCells('A1:'.$d.'1');
        
        $Excel->getActiveSheet()->setCellValue('A1', isset($asignatura) ? Yii::t('app', 'Reporte Consolidado Mensual de Ausentismo por Asignatura & Grupo') : Yii::t('app', 'Reporte Consolidado Mensual de Ausentismo por Grupo'));
        
        $Excel->getActiveSheet()->mergeCells('A2:'.$d.'2');
        $Excel->getActiveSheet()->setCellValue('A2', isset($asignatura) ? 'Asignatura - '.$asignatura->asignatura.'   |   Grupo - '.$grupo->grupo : 'Grupo - '.$grupo->grupo);
        $Excel->getActiveSheet()->mergeCells('A3:'.$d.'3');

        $Excel->getActiveSheet()->setCellValue($d.$fila, 'TOTAL');

        $estudiantes = Tercero::find()->where(['=', 'academico.grupo', $grupo->id])->andWhere(['<', 'tercero.estado', 3])->andWhere(['tercero.eliminado_por' => 0])->andWhere(['academico.eliminado_por' => 0])->joinWith(['academicos'])->orderBy(['primer_apellido' => SORT_ASC, 'segundo_apellido' => SORT_ASC])->all();

        $i = $fila + 1;     
     
        foreach ($estudiantes as $estudiante) 
        {
            $Excel->getActiveSheet()->getRowDimension($i)->setRowHeight('15');
            $Excel->getActiveSheet()->setCellValue('A'.$i, $i-$fila);  
            $Excel->getActiveSheet()->setCellValue('B'.$i, mb_strtoupper($estudiante->nombreinverso));    
            
            $h ='C';
            for ($x='1'; $x <= date('m'); $x++)
            { 
              $k = $x - 1;
              $Excel->getActiveSheet()->getColumnDimension($h)->setAutoSize(true);

              
              //$Excel->getActiveSheet()->getColumnDimension($h)->setWidth(7);
              $Excel->getActiveSheet()->setCellValue($h.$i, "=".$mes[$k]."!AH".$i."");

              $g = $h;
              $h++;

            }

            $Excel->getActiveSheet()->setCellValue($h.$i, "=SUM(C".$i.":".$g.$i.")");
          $i++;
        }

          $i--;


          // BORDE
          $Excel->getActiveSheet()->getStyle('A'.$fila.':' . 
            $Excel->getActiveSheet()->getHighestColumn() . 
            $Excel->getActiveSheet()->getHighestRow()
            )->getBorders()->getAllBorders()->setBorderStyle(Border::BORDER_THIN);

          
          // ENCABEZADO LISTA
          $Excel->getActiveSheet()->getStyle('A'.$fila.':'.$d.$fila)->applyFromArray(
              array(
                'font'  => array(
                    'bold'  => true,
                    'size'  => 12,
                    'name'  => 'Calibri'
                ),
                'fill' => array(
                    'fillType' => Fill::FILL_SOLID,
                    'color' => array('rgb' => 'DDDDDD')
                ),
                'alignment' => array(
                  'horizontal' => Alignment::HORIZONTAL_CENTER,
                )
              )
          );


          // TAMAÑO Y FUENTE
          $fila = $fila+1;
          $Excel->getActiveSheet()->getStyle('A'.$fila.':' . 
            $Excel->getActiveSheet()->getHighestColumn() . 
            $Excel->getActiveSheet()->getHighestRow()
            )->applyFromArray(array(
                'font'  => array(
                    'bold'  => false,
                    'size'  => 12,
                    'name'  => 'Calibri'
                ),
                'alignment' => array(
                   // 'horizontal' => \PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
                   // 'vertical' => \PHPExcel_Style_Alignment::VERTICAL_CENTER,
                ),
            ));  

          //COLUMNA ID         
          $Excel->getActiveSheet()
            ->getStyle('A'.$fila.':A'.$Excel->getActiveSheet()->getHighestRow())
            ->applyFromArray(array(
                'font'  => array(
                    'bold'  => true,
                ),
                
            ));

          //COLUMNA DOCENTE         
          $Excel->getActiveSheet()
            ->getStyle('B'.$fila.':B'.$Excel->getActiveSheet()->getHighestRow())
            ->applyFromArray(array(
                'alignment' => array(
                   // 'horizontal' => \PHPExcel_Style_Alignment::HORIZONTAL_LEFT,
                ),
            ));   

        $Excel->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);
        $Excel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
        $Excel->getActiveSheet()->getColumnDimension('O')->setAutoSize(true);      

          
        /////////////////////////////////////////////////////////////////////////////////////////
        /////                                                                               /////
        /////                                                                               /////
        /////                            FIN CONSOLIDADO MENSUAL                            /////
        /////                                  LISTADO MES                                  /////
        /////                                                                               /////
        /////                                                                               /////
        /////////////////////////////////////////////////////////////////////////////////////////        


        for ($b = 1; $b <= date('m'); $b++) 
        {
            $n = $b -1;
            $Excel->createSheet();    
            $Excel->setActiveSheetIndex($b);

            $Excel->getActiveSheet()->getPageSetup()->setOrientation(PageSetup::ORIENTATION_LANDSCAPE);
            $Excel->getActiveSheet()->getPageSetup()->setPaperSize(PageSetup::PAPERSIZE_FOLIO);
            $Excel->getActiveSheet()->getPageMargins()->setTop($top);
            $Excel->getActiveSheet()->getPageMargins()->setRight($right);
            $Excel->getActiveSheet()->getPageMargins()->setLeft($left);
            $Excel->getActiveSheet()->getPageMargins()->setBottom($bottom);
            $Excel->getActiveSheet()->setTitle($mes[$n]);


            $this->render('/reporte/_headerandfooter_excel_landscape', ['Excel' => $Excel]);    


            $Excel->getActiveSheet()->getStyle('A1:A2')->applyFromArray(array(
                'font'  => array(
                        'bold'  => true,
                        //'color' => array('rgb' => 'FF0000'),
                        'size'  => 12,
                        'name'  => 'Calibri'
                ),
                'alignment' => array(
                  'horizontal' => Alignment::HORIZONTAL_CENTER,
                )
            ));
            

            $fila = '4';
            $Excel->getActiveSheet()->setCellValue('A'.$fila, Yii::t('app', '#'));
            $Excel->getActiveSheet()->setCellValue('B'.$fila, Yii::t('app', 'Estudiante'));  
            

            $d = 'C';
            for ($x='1'; $x <= '31'; $x++)
            {   

                $Excel->getActiveSheet()->setCellValue($d.$fila, $x);
                $d++;
            } 

            
            $Excel->getActiveSheet()->mergeCells('A1:'.$d.'1');
            
            $Excel->getActiveSheet()->setCellValue('A1', isset($asignatura) ? 'Reporte Consolidado Mensual de Ausentismo por Asignatura & Grupo' : 'Reporte Consolidado Mensual de Ausentismo por Grupo');
            
            $Excel->getActiveSheet()->mergeCells('A2:'.$d.'2');
            $Excel->getActiveSheet()->setCellValue('A2', isset($asignatura) ? 'Asignatura - '.$asignatura->asignatura.'   |   Grupo - '.$grupo->grupo.'   |   Mes - '.$mescompleto[$n] : 'Grupo - '.$grupo->grupo.'   |   Mes - '.$mescompleto[$n]);
            $Excel->getActiveSheet()->mergeCells('A3:'.$d.'3');

            $Excel->getActiveSheet()->setCellValue($d.$fila, 'TOTAL');

            $estudiantes = Tercero::find()->where(['=', 'academico.grupo', $grupo->id])->andWhere(['<', 'tercero.estado', 3])->joinWith(['academicos'])->orderBy(['primer_apellido' => SORT_ASC, 'segundo_apellido' => SORT_ASC])->all();

            $i = $fila + 1;     
         
            foreach ($estudiantes as $estudiante) 
            {
                $Excel->getActiveSheet()->getRowDimension($i)->setRowHeight('15');
                $Excel->getActiveSheet()->setCellValue('A'.$i, $i-$fila);  
                $Excel->getActiveSheet()->setCellValue('B'.$i, mb_strtoupper($estudiante->nombreinverso));    
                
                $h ='C';
                for ($x='1'; $x <= '31'; $x++)
                { 
                    
                    if(isset($asignatura))
                    {  
                        $fallas = Asistencia::find()->where(['estudiante'=> $estudiante->id, 'asignatura' => $asignatura->id])->andWhere(['between', 'fecha', ''.$anio.'-'.$b.'-'.$x.' 00:00:00', ''.$anio.'-'.$b.'-'.$x.' 23:59:59'])->sum('fallas');
                    }
                    else 
                    {
                        $fallas = Asistencia::find()->where(['estudiante'=> $estudiante->id])->andWhere(['between', 'fecha', ''.$anio.'-'.$b.'-'.$x.' 00:00:00', ''.$anio.'-'.$b.'-'.$x.' 23:59:59'])->sum('fallas'); 
                    }  

                    //$Excel->getActiveSheet()->getColumnDimensionByColumn($h)->setAutoSize(false);
                    $Excel->getActiveSheet()->getColumnDimension($h)->setWidth(2.8);
                    $Excel->getActiveSheet()->setCellValue($h.$i, $fallas);

                    if($fallas != '')
                    {
                        $Excel->getActiveSheet()->getStyle($h.$i)->applyFromArray(
                          array(
                            'fill' => array(
                                'fillType' => Fill::FILL_SOLID,
                                'color' => array('rgb' => 'FF7373')
                            )
                          )
                        );
                    }  

                    $h++; 

                }
                
                $Excel->getActiveSheet()->setCellValue("AH".$i, "=SUM(B".$i.":AF".$i.")");
              $i++;

            }
        
      
          $i--;


          // BORDE
          $Excel->getActiveSheet()->getStyle('A'.$fila.':' . 
            $Excel->getActiveSheet()->getHighestColumn() . 
            $Excel->getActiveSheet()->getHighestRow()
            )->getBorders()->getAllBorders()->setBorderStyle(Border::BORDER_THIN);

          
          // ENCABEZADO LISTA
          $Excel->getActiveSheet()->getStyle('A'.$fila.':'.$d.$fila)->applyFromArray(
              array(
                'font'  => array(
                    'bold'  => true,
                    'size'  => 12,
                    'name'  => 'Calibri'
                ),
                'fill' => array(
                    'fillType' => Fill::FILL_SOLID,
                    'color' => array('rgb' => 'DDDDDD')
                ),
                'alignment' => array(
                  'horizontal' => Alignment::HORIZONTAL_CENTER,
                )
              )
          );



          // TAMAÑO Y FUENTE
          $fila = $fila+1;
          $Excel->getActiveSheet()->getStyle('A'.$fila.':' . 
            $Excel->getActiveSheet()->getHighestColumn() . 
            $Excel->getActiveSheet()->getHighestRow()
            )->applyFromArray(array(
                'font'  => array(
                    'bold'  => false,
                    'size'  => 12,
                    'name'  => 'Calibri'
                ),
                'alignment' => array(
                    //'horizontal' => \PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
                    //'vertical' => \PHPExcel_Style_Alignment::VERTICAL_CENTER,
                ),
            ));  

          //COLUMNA ID         
          $Excel->getActiveSheet()
            ->getStyle('A'.$fila.':A'.$Excel->getActiveSheet()->getHighestRow())
            ->applyFromArray(array(
                'font'  => array(
                    'bold'  => true,
                ),
                
            ));

          //COLUMNA ESTUDIANTE         
          $Excel->getActiveSheet()
            ->getStyle('B'.$fila.':B'.$Excel->getActiveSheet()->getHighestRow())
            ->applyFromArray(array(
                'alignment' => array(
                    //'horizontal' => \PHPExcel_Style_Alignment::HORIZONTAL_LEFT,
                ),
            ));   

        $Excel->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);
        $Excel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
        $Excel->getActiveSheet()->getColumnDimension('O')->setAutoSize(true);  

        } // crear mes

        $Excel->setActiveSheetIndex('0');

        if(isset($_GET['asignatura']))
        {
            $filename = "R101-Ausentismo-Asignatura-Grupo(".date("d-m-Y_H-i").").xlsx";
        }    
        else
        {
            $filename = "R101-Ausentismo-Grupo(".date("d-m-Y_H-i").").xlsx";
        } 

        

        // Redirect output to a client’s web browser (Xlsx)
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment;filename="' . $filename . '"');
        header('Cache-Control: max-age=0');

        // If you're serving to IE 9, then the following may be needed
        header('Cache-Control: max-age=1');
         
        // If you're serving to IE over SSL, then the following may be needed
        header('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
        header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT'); // always modified
        header('Cache-Control: cache, must-revalidate'); // HTTP/1.1
        header('Pragma: public'); // HTTP/1.0

        $writer = IOFactory::createWriter($Excel, 'Xlsx');
        $writer->save('php://output');
        exit;  
    }
}





