<?php

namespace backend\controllers;

use Yii;
use yii\web\Controller;
use yii\web\Response;
use yii\widgets\ActiveForm;


use backend\models\Tercero;
use backend\models\Grupo;
use backend\models\Asignatura;
use backend\models\LanzadorForm;


use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Style\Alignment;
use PhpOffice\PhpSpreadsheet\Style\Border;
use PhpOffice\PhpSpreadsheet\Style\Fill;
use PhpOffice\PhpSpreadsheet\Style\Style;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpSpreadsheet\Helper\Sample;
use PhpOffice\PhpSpreadsheet\IOFactory;
use PhpOffice\PhpSpreadsheet\Worksheet\PageSetup;


class Reporte102Controller extends Controller
{

    public function actionIndex($grupo = NULL, $asignatura = NULL, $columnas = 0) // Reporte de Lista de Alumnos por Asignatura y Grupo
    {
        if($asignatura == NULL && $grupo == NULL)
        {    
            $model = new LanzadorForm(['scenario'=>'grupo']);

            //$model->reporte = 'Reporte de Estudiantes por Asignatura y Grupo';
            //$model->observaciones = 'Exporta la lista de estudiantes por asignatura y grupos.; este reporte se genera en formato Excel.';
            $model->reporte = Yii::t('app', 'R102-Reporte');
            $model->observaciones = Yii::t('app', 'R102-Observaciones');

            if (Yii::$app->request->isAjax && $model->load(Yii::$app->request->post())) {
                Yii::$app->response->format = Response::FORMAT_JSON;
                return ActiveForm::validate($model);
            }

            if ($model->load(Yii::$app->request->post())) {

                $asignatura = $model->asignatura; 
                $grupo = $model->grupo;
                $columnas = $model->columnas;
                
            }
            else
            {
                if (Yii::$app->request->isAjax) 
                {
                    return $this->renderAjax('/publica/lanzador', [
                            'model' => $model,
                            'sede' => true,
                            'tercero' => false,
                            'grado' => true,
                            'grupo' => true,
                            'asignatura' => true,
                            'periodo' => false,
                            'competencia' => false,
                            'columnas' => true,
                            'ver_estandar' => false,
                            'ver_competencia' => false,
                            'ver_niveles' => false,
                            'ver_desempenos' => false,
                            'ver_frd' => false,
                            'ver_fecha' => true,
                            'ver_letrasonumeros' => false,
                        ]);

                    exit;
                }
                else
                {
                    return $this->render('/publica/lanzador', [
                            'model' => $model,
                            'sede' => true,
                            'tercero' => false,
                            'grado' => true,
                            'grupo' => true,
                            'asignatura' => true,
                            'periodo' => false,
                            'competencia' => false,
                            'columnas' => true,
                            'ver_estandar' => false,
                            'ver_competencia' => false,
                            'ver_niveles' => false,
                            'ver_desempenos' => false,
                            'ver_frd' => false,
                            'ver_fecha' => true,
                            'ver_letrasonumeros' => false,
                        ]);

                    exit;
                }
            }    
        }
        else
        {
            $grupo = Yii::$app->request->get('grupo');
            $asignatura = Yii::$app->request->get('asignatura');
            $columnas = Yii::$app->request->get('columnas');    
            
        }    

        $grupo = Grupo::find()->where(['id' => $grupo])->one();
        $asignatura = Asignatura::find()->where(['id' => $asignatura])->one();
        
        

        date_default_timezone_set('America/Bogota');

        /// MARGENES HOJA
        $top = '1';
        $right = '0.5';
        $left = '0.5';
        $bottom = '1';
/*
        $grupo = Grupo::find($grupo)->one();

        if(isset($asignatura))
        {
            $asignatura = Asignatura::find($asignatura)->one();    
        }    
*/
        $Excel = new Spreadsheet();

        $Excel->getProperties()
        ->setCreator("Sonic")
        ->setLastModifiedBy("Sonic")
        ->setTitle("Reporte 102 - Estudiantes por Asignatura y Grupo")
        ->setDescription("Documento generado por Sonic")
        ->setCategory("Listados"); 



        $this->render('/reporte/_headerandfooter_excel_landscape', ['Excel' => $Excel]);    

        $Excel->setActiveSheetIndex(0);

        $Excel->getActiveSheet()->getPageSetup()->setOrientation(PageSetup::ORIENTATION_LANDSCAPE);
        $Excel->getActiveSheet()->getPageSetup()->setPaperSize(PageSetup::PAPERSIZE_FOLIO);
        $Excel->getActiveSheet()->getPageSetup()->setHorizontalCentered(true);
        $Excel->getActiveSheet()->getPageMargins()->setTop($top);
        $Excel->getActiveSheet()->getPageMargins()->setRight($right);
        $Excel->getActiveSheet()->getPageMargins()->setLeft($left);
        $Excel->getActiveSheet()->getPageMargins()->setBottom($bottom);
        
        $Excel->getActiveSheet()->setTitle('Listado');

        $style = array(
            'alignment' => array(
                'horizontal' => Alignment::HORIZONTAL_CENTER,
            )
        );

        $Excel->getActiveSheet()->getStyle('A1:A2')->applyFromArray($style);
        $Excel->getActiveSheet()->getStyle('A1:A2')->getFont()->setBold(true);

        $Excel->getActiveSheet()->setCellValue('A4', "#");
        $Excel->getActiveSheet()->setCellValue('B4', "ESTUDIANTE");  


        $d = 'B';
        for ($x='1'; $x <= $columnas; $x++)
        {   
            $d++;
            $Excel->getActiveSheet()->setCellValue($d.'4', $x);
            //$Excel->getActiveSheet()->getColumnDimension($d)->setAutoSize(true);
            $Excel->getActiveSheet()->getColumnDimension($d)->setWidth(10);
        } 
        

        $Excel->getActiveSheet()->mergeCells('A1:'.$d.'1');
        $Excel->getActiveSheet()->setCellValue('A1', 'LISTADO DE ESTUDIANTES');

        $Excel->getActiveSheet()->mergeCells('A2:'.$d.'2');
        $Excel->getActiveSheet()->setCellValue('A2', isset($asignatura) ? 'Asignatura: '.$asignatura->asignatura.'  -  Grupo: '.$grupo->grupo : 'Grupo: '.$grupo->grupo);

        $Excel->getActiveSheet()->getStyle('A4:'.$d.'4')->getFont()->setBold(true);

        $Excel->getActiveSheet()->getStyle('A4:'.$d.'4')->applyFromArray(
            array(
                'fill' => array(
                    'typeFill' => Fill::FILL_SOLID,
                    'color' => array('rgb' => 'DDDDDD')
                ),
            'alignment' => array(
                'horizontal' => Alignment::HORIZONTAL_CENTER,
                )
            )
        );

        $estudiantes = Tercero::find()->where(['=', 'academico.grupo', $grupo->id])->andWhere(['<', 'tercero.estado', 3])->andWhere(['tercero.eliminado_por' => 0])->andWhere(['academico.eliminado_por' => 0])->joinWith(['academicos'])->orderBy(['primer_apellido' => SORT_ASC, 'segundo_apellido' => SORT_ASC, 'primer_nombre' => SORT_ASC, 'segundo_nombre' => SORT_ASC])->all();

        $i = 5;     

        foreach ($estudiantes as $estudiante) 
        {

            $Excel->getActiveSheet()->setCellValue('A'.$i, $i-4);  
            $Excel->getActiveSheet()->setCellValue('B'.$i, mb_strtoupper($estudiante->nombreinverso));    
        
            $i++;
        }

        $i--;

        
        $Excel->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);
        $Excel->getActiveSheet()->getColumnDimension('A')->setWidth(4);
        $Excel->getActiveSheet()->getStyle('B4:B'.$i)->getFont()->setBold(true);
        $Excel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
        $Excel->getActiveSheet()->getColumnDimension('B')->setWidth(40);

        $Excel->getActiveSheet()->getStyle('A4:' . 
        $Excel->getActiveSheet()->getHighestColumn() . 
        $Excel->getActiveSheet()->getHighestRow()
        )->getBorders()->getAllBorders()->setBorderStyle(Border::BORDER_THIN);

        $Excel->getActiveSheet()
        ->getStyle('B5:B'.$Excel->getActiveSheet()->getHighestRow())
        ->getAlignment()->setHorizontal(Alignment::HORIZONTAL_LEFT);

        $Excel->setActiveSheetIndex('0');

        if(isset($asignatura))
        {
            $filename = "R102-Reporte-Estudiantes-Asignatura-Grupo(".date("d-m-Y_H-i").").xlsx";
        }    
        else
        {
            $filename = "R102-Reporte-Estudiantes-Grupo(".date("d-m-Y_H-i").").xlsx";
        } 

        

        // Redirect output to a client’s web browser (Xlsx)
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment;filename="' . $filename . '"');
        header('Cache-Control: max-age=0');

        // If you're serving to IE 9, then the following may be needed
        header('Cache-Control: max-age=1');
         
        // If you're serving to IE over SSL, then the following may be needed
        header('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
        header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT'); // always modified
        header('Cache-Control: cache, must-revalidate'); // HTTP/1.1
        header('Pragma: public'); // HTTP/1.0

        $writer = IOFactory::createWriter($Excel, 'Xlsx');
        $writer->save('php://output');
        exit;
    }

}
