<?php

namespace backend\controllers;

use Yii;
use backend\models\Academico;
use backend\models\Asistencia;
use backend\models\Tercero;
use backend\models\Grupo;
use backend\models\Asignatura;
use backend\models\Periodo;
use backend\models\TipoInasistencia;
use backend\models\Sede;
use backend\models\Compromisosacudiente;
use backend\models\LanzadorForm;


use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\helpers\ArrayHelper;
use yii\data\ActiveDataProvider;
use yii\base\Model;
use yii\helpers\Html;
use yii\web\Response;
use yii\widgets\ActiveForm;

use Mpdf\Mpdf;

class Reporte103Controller extends Controller
{

    public function actionIndex($tercero = NULL, $ver_estandar = 1,$ver_competencia = 1, $ver_niveles = 1, $ver_desempenos = 1, $ver_frd = 1, $ver_fecha = 1, $ver_letrasonumeros = 1) // Reporte Valorativo Condensado (Boletín de Calificaciones) por Grupo
    {
        $size_font = 7;

        if($tercero == NULL)
        {    
            $model = new LanzadorForm(['scenario'=>'grupo']);

            //$model->reporte = 'Reporte de Valorativo por Grupo';
            //$model->observaciones = 'Exporta el informe valorativo de los estudiantes por grupos.; este reporte se genera en formato PDF.';
            $model->reporte = Yii::t('app', 'R103-Reporte');
            $model->observaciones = Yii::t('app', 'R103-Observaciones');

            if (Yii::$app->request->isAjax && $model->load(Yii::$app->request->post())) {
                Yii::$app->response->format = Response::FORMAT_JSON;
                return ActiveForm::validate($model);
            }

            if ($model->load(Yii::$app->request->post())) {

                $id_tercero = $model->tercero;
                $grado = $model->grado;
                $grupo = $model->grupo;
                $periodo = $model->periodo;

                $ver_estandar = $model->ver_estandar;
                $ver_competencia = $model->ver_competencia;
                $ver_niveles = $model->ver_niveles;
                $ver_desempenos = $model->ver_desempenos;
                $ver_frd = $model->ver_frd;
                $ver_fecha = $model->ver_fecha;
                $ver_letrasonumeros = $model->ver_letrasonumeros;

                //$ver_emoticonos = $model->ver_emoticonos;
                //$ver_criterios = $model->ver_criterios;

                
            }
            else
            {
                if (Yii::$app->request->isAjax) 
                {
                    return $this->renderAjax('/publica/lanzador', [
                            'model' => $model,
                            'sede' => true,
                            'tercero' => true,
                            'grado' => true,
                            'grupo' => true,
                            'asignatura' => false,
                            'periodo' => false,
                            'competencia' => false,
                            'columnas' => false,
                            'ver_estandar' => false,
                            'ver_competencia' => false,
                            'ver_niveles' => false,
                            'ver_desempenos' => false,
                            'ver_frd' => false,
                            'ver_fecha' => true,
                            'ver_letrasonumeros' => false,
                        ]);

                    //exit;
                }
                else
                {
                    $model->scenario = 'tercero';

                    return $this->render('/publica/lanzador', [
                            'model' => $model,
                            'sede' => true,
                            'tercero' => true,
                            'grado' => false,
                            'grupo' => false,
                            'asignatura' => false,
                            'periodo' => false,
                            'competencia' => false,
                            'columnas' => false,
                            'ver_estandar' => false,
                            'ver_competencia' => false,
                            'ver_niveles' => false,
                            'ver_desempenos' => false,
                            'ver_frd' => false,
                            'ver_fecha' => true,
                            'ver_letrasonumeros' => false,
                        ]);

                    //exit;
                }
            }    
        }
        else
        {
            $id_tercero = Yii::$app->request->get('tercero');
            $periodo = new Periodo();
            $periodo = $periodo->actual->id;

            /*$grado = Yii::$app->request->get('grado');
            $grupo = Yii::$app->request->get('grupo');
            $asignatura = Yii::$app->request->get('asignatura');
            $periodo = Yii::$app->request->get('periodo');*/
            
        }

        date_default_timezone_set('America/Bogota');
        setlocale(LC_TIME,"es_ES");

        if($id_tercero != '')
        {
            
            if (($tercero = Tercero::find()->where(['id' => $id_tercero])->one()) === null)
            {
                throw new NotFoundHttpException('No existe el tercero');
            }  

            if (($estudiantes = Academico::find()
                            ->select(['tercero.id', 'academico.estudiante', 'academico.grupo','academico.especialidad'])
                            ->joinWith(['estudiantes'])->where(['<', 'tercero.estado', 3])
                            ->andWhere(['academico.estudiante' => $tercero->id])
                            ->orderBy('primer_apellido')
                            ->all()) === null)
            {
                throw new NotFoundHttpException('No estudiante no tiene registro académico.');
            }  
            else
            {
                foreach ($estudiantes as $tercero) {
                    $grupo = Grupo::find()->where(['id' => $tercero->grupo])->one();
                }    
            } 
            
        }
        else
        {
            $grupo = Grupo::find()->where(['id' => $grupo])->one();
            //$sede = Sede::FindOne($grupo->sede);
            $estudiantes = Academico::find()
                            ->select(['tercero.id', 'academico.estudiante', 'academico.grupo','academico.especialidad'])
                            ->joinWith(['estudiantes'])
                            ->where(['<', 'tercero.estado', 3])
                            ->andWhere(['academico.grupo' => $grupo->id])
                            ->orderBy(['primer_apellido' => SORT_ASC, 'segundo_apellido' => SORT_ASC])
                            ->all();  
        }    
        
        if(isset($grupo->director))
        {
            $director_nombre = $grupo->directores->nombre;
            $director_firma = $grupo->directores->firma != NULL ? $grupo->directores->firma : '';
        }
        else
        {
            $director_nombre = Yii::t('app', 'Director(a) de Grupo');
            //'Director(a) de Grupo'
            $director_firma = '';
        }
            
        $pdf = new Mpdf(['mode' => 'utf-8',
                         'format' => 'LETTER',
                         'default_font_size' => 0,
                         'default_font' => '',
                         'margin_left' => 15,
                         'margin_right' => 15,
                         'margin_top' => 35,
                         'margin_bottom' => 18,
                         'margin_header' => 9,
                         'margin_footer' => 5,
                         'orientation' => 'P']);  
        
        //$pdf->StarProgressBarOutput(2);


        if ($grupo->sedes->pdf_marcadeagua == 'T' OR $grupo->sedes->pdf_marcadeagua == 'B')
        {
            $pdf->SetWatermarkText($sede->pdf_marcadeagua_contenido);
            $pdf->showWatermarkText = true;
            $pdf->watermarkTextAlpha = 0.1;
        }

        if ($grupo->sedes->pdf_marcadeagua == 'I')
        {
            $pdf->SetWatermarkImage($grupo->sedes->pdf_marcadeagua_contenido);
            $pdf->showWatermarkImage = true;
            $pdf->watermarkImageAlpha = 0.1;
        }

        $pdf->setHeader($grupo->sedes->pdf_header);
        $pdf->setFooter($grupo->sedes->pdf_footer);
        
        $pdf->AliasNbPages();

        $i = 1;    

        $compromisos = Compromisosacudiente::find()->select(['compromiso'])->asArray()->all();

        $compromiso = [];

        foreach ($compromisos as $compromiso1) {
            $compromiso[] = $compromiso1['compromiso'];
        }
        
        foreach ($estudiantes as $estudiante) 
        {

            $pdf->AddPage(0,'Letter');

            $pdf->SetFillColor(255);
            $pdf->SetTextColor(0);
            $pdf->SetDrawColor(0,0,0);
        
            if($ver_fecha == 1)
            {
                $fecha = strftime("%A, %d de %B de %Y");

                $pdf->setX(140);
                $pdf->SetFont('helvetica','',$size_font);
                $pdf->Cell(60,5,$fecha,0,0,'R');
                $pdf->Ln(5);
            }    

            $pdf->SetFont('Helvetica','B',10);   
            $pdf->Cell(190,10,mb_strtoupper(Yii::t('app', 'R103-INFORME DE AUSENTISMO DEL ESTUDIANTE')),0,0,'C');

            $pdf->Ln(10);

            $pdf->SetFont('Helvetica','B',$size_font);
            $pdf->Cell(18,5,Yii::t('app', 'Estudiante'),0,0); 
            $pdf->SetFont('Helvetica','',$size_font);

            $nombre = mb_strtoupper($estudiante->estudiantes->nombreinverso);
            //echo "<br><br>Estudiante : ".$nombre;
            $pdf->Bookmark($nombre, 0);
            $pdf->Cell(65,5,$nombre,0,0);
            
            $pdf->SetFont('Helvetica','B',$size_font);
            $pdf->Cell(23,5,Yii::t('app', 'Identificación'),0,0);
            $pdf->SetFont('Helvetica','',$size_font);
            $pdf->Cell(25,5,$estudiante->estudiantes->identificacion,0,0);
            
            
            $pdf->SetFont('Helvetica','B',$size_font);
            $pdf->Cell(20,5,Yii::t('app', 'Especialidad'),0,0);
            $pdf->SetFont('Helvetica','',$size_font);
            $pdf->Cell(50,5,$estudiante->especialidades->especialidad,0,0);
            
            
            $pdf->Ln(5);
            
            $pdf->SetFont('Helvetica','B',$size_font);
            $pdf->Cell(10,5,Yii::t('app', 'Sede'),0,0);
            $pdf->SetFont('Helvetica','',$size_font);    
            $pdf->Cell(50,5,$grupo->sedes->sede,0,0);

            $pdf->SetFont('Helvetica','B',$size_font);
            $pdf->Cell(12,5,Yii::t('app', 'Jornada'),0,0);
            $pdf->SetFont('Helvetica','',$size_font);    
            $pdf->Cell(20,5,$grupo->jornadas->jornada,0,0);  

            $pdf->SetFont('Helvetica','B',$size_font);
            $pdf->Cell(10,5,Yii::t('app', 'Grupo'),0,0);
            $pdf->SetFont('Helvetica','',$size_font);    
            $pdf->Cell(20,5,$grupo->grupo,0,0);


            $pdf->SetFont('Helvetica','B',$size_font);
            $pdf->Cell(10,5,Yii::t('app', 'Año'),0,0);
            $pdf->SetFont('Helvetica','',$size_font);    
            $pdf->Cell(15,5,$grupo->sedes->vigencia,0,0);

            
            $total_fallas = Asistencia::find()
                            ->where(['estudiante' => $estudiante->estudiante])
                            ->sum('fallas');

            $pdf->SetFont('Helvetica','B',$size_font);
            $pdf->Cell(18,5,Yii::t('app', 'Total Fallas'),0,0);
            $pdf->SetFont('Helvetica','',$size_font);    
            $pdf->Cell(10,5,$total_fallas,0,0);

            $pdf->Ln(10);
            
            
            if($total_fallas > 0)
            {    
                $asistencias = Asistencia::find()
                                ->where(['estudiante' => $estudiante->estudiante])
                                ->all();
            
                $pdf->setFillColor(230);
                $pdf->SetFont('Helvetica','B',$size_font);
                $pdf->Cell(12,5,mb_strtoupper(Yii::t('app', 'Fecha')),1,0,'C',1);
                $pdf->Cell(12,5,mb_strtoupper(Yii::t('app', 'Fallas')),1,0,'C',1);
                $pdf->Cell(40,5,mb_strtoupper(Yii::t('app', 'Asignatura')),1,0,'C',1);
                $pdf->Cell(60,5,mb_strtoupper(Yii::t('app', 'Docente')),1,0,'C',1);
                $pdf->Cell(64,5,mb_strtoupper(Yii::t('app', 'Tipo de Inasistencia')),1,0,'C',1);
                $pdf->Ln(5);

                foreach ($asistencias as $asistencia) 
                {

                    $pdf->setFillColor(255);
                    $pdf->SetFont('Helvetica','',$size_font);    
                    $pdf->Cell(12,5,Yii::$app->formatter->asDate($asistencia->fecha,'short'),1,0,'J',0);
                    $pdf->Cell(12,5,mb_strtoupper($asistencia->fallas),1,0,'C',0);
                    $pdf->Cell(40,5,mb_strtoupper(substr($asistencia->asignaturas->asignatura,0, 28)),1,0,'J',0);
                    $pdf->Cell(60,5,mb_strtoupper($asistencia->docentes->nombre),1,0,'J',0);
                    $pdf->Cell(64,5,mb_strtoupper($asistencia->tipoinasistencias->tipo_inasistencia),1,0,'J',0);
                    $pdf->Ln(5);
                }
            }
            else
            {
                $pdf->setFillColor(230);
                $pdf->SetFont('Helvetica','B',$size_font);
                $pdf->Cell(188,5,mb_strtoupper(Yii::t('app', 'El estudiante no presenta fallas hasta la fecha')),1,0,'C',1); 
            }    


            $pdf->Ln(8);
            $pdf->SetFont('Helvetica','',$size_font);
            
            $pdf->Cell(180,6,Yii::t('app', 'Reporte generado de las inasistencias registradas por el docente en el inicio de clases.'),0,0);
            $pdf->Ln(5);
            
            $pdf->SetFont('Helvetica','B',$size_font);

            $y = $pdf->y;
            $x = $pdf->x;

            if($director_firma != '' or $director_firma != NULL )
            {
                $pdf->Image(\Yii::getAlias('@webroot/uploads/'.$director_firma),$x+30,$y,50);    
            }    
            
            
            $pdf->Image(\Yii::getAlias('@webroot/uploads/'.$grupo->sedes->rector_firma),$x+110,$y,50);
            
            $pdf->setY($pdf->y-15);
            $pdf->Cell(30);
            $pdf->Cell(60,5,$director_nombre,'T',0,'C',0);

            $pdf->Cell(15);
            $pdf->Cell(60,5,$grupo->sedes->rector_nombre,'T',0,'C',0);

            $pdf->Ln(3);
            $pdf->SetFont('Helvetica','',$size_font);
            $pdf->Cell(30);
            $pdf->Cell(60,5,Yii::t('app', 'Director(a)'),'',0,'C',0);
            $pdf->Cell(15);
            $pdf->Cell(60,5,"Rector(a)",'',0,'C',0);
            $pdf->Ln(1); 


        }

        $pdf->Output("R103-Reporte-Ausentismo(".date("d-m-Y_H-i").").pdf",'D');
    }

  

}
