<?php

namespace backend\controllers;

use Yii;
use yii\web\Controller;
use yii\web\Response;
use yii\widgets\ActiveForm;


use backend\models\Tercero;
use backend\models\Acudiente;
use backend\models\Grupo;
use backend\models\Grado;
use backend\models\LanzadorForm;


use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Style\Alignment;
use PhpOffice\PhpSpreadsheet\Style\Border;
use PhpOffice\PhpSpreadsheet\Style\Fill;
use PhpOffice\PhpSpreadsheet\Style\Style;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpSpreadsheet\Helper\Sample;
use PhpOffice\PhpSpreadsheet\IOFactory;
use PhpOffice\PhpSpreadsheet\Worksheet\PageSetup;


class Reporte105Controller extends Controller
{

    public function actionIndex($grado = NULL, $grupo = NULL) // Reporte de Lista de Alumnos por Asignatura y Grupo
    {
        if($grado == NULL && $grupo == NULL)
        {    
            $model = new LanzadorForm(['scenario'=>'sede']);

            $model->reporte = Yii::t('app', 'R105-Reporte');
            $model->observaciones = Yii::t('app', 'R105-Observaciones');

            if (Yii::$app->request->isAjax && $model->load(Yii::$app->request->post())) {
                Yii::$app->response->format = Response::FORMAT_JSON;
                return ActiveForm::validate($model);
            }

            if ($model->load(Yii::$app->request->post())) {

                $sede = $model->sede;
                $grado = $model->grado;
                $grupo = $model->grupo;
                
            }
            else
            {
                if (Yii::$app->request->isAjax) 
                {
                    return $this->renderAjax('/publica/lanzador', [
                            'model' => $model,
                            'sede' => true,
                            'tercero' => false,
                            'grado' => true,
                            'grupo' => true,
                            'asignatura' => false,
                            'periodo' => false,
                            'competencia' => false,
                            'columnas' => false,
                            'ver_estandar' => false,
                            'ver_competencia' => false,
                            'ver_niveles' => false,
                            'ver_desempenos' => false,
                            'ver_frd' => false,
                            'ver_fecha' => false,
                            'ver_letrasonumeros' => false,
                        ]);

                    exit;
                }
                else
                {
                    return $this->render('/publica/lanzador', [
                            'model' => $model,
                            'sede' => true,
                            'tercero' => false,
                            'grado' => true,
                            'grupo' => true,
                            'asignatura' => false,
                            'periodo' => false,
                            'competencia' => false,
                            'columnas' => false,
                            'ver_estandar' => false,
                            'ver_competencia' => false,
                            'ver_niveles' => false,
                            'ver_desempenos' => false,
                            'ver_frd' => false,
                            'ver_fecha' => false,
                            'ver_letrasonumeros' => false,
                        ]);

                    exit;
                }
            }    
        }
        else
        {
            $sede = Yii::$app->request->get('sede');
            $grado = Yii::$app->request->get('grado');
            $grupo = Yii::$app->request->get('grupo');
        }    

        
        if(isset($grado))
        {
            $grado = Grado::find()->where(['id' => $grado])->one();
        }
        
        if(isset($grupo))
        {
            $grupo = Grupo::find()->where(['id' => $grupo])->one();        
        }
        

        date_default_timezone_set('America/Bogota');

        /// MARGENES HOJA
        $top = '1';
        $right = '0.5';
        $left = '0.5';
        $bottom = '1';

        $Excel = new Spreadsheet();

        $Excel->getProperties()
        ->setCreator("Sonic")
        ->setLastModifiedBy("Sonic")
        ->setTitle("Reporte 105 - Caracterización de Estudiantes")
        ->setDescription("Documento generado por Sonic")
        ->setCategory("Listados"); 



        $this->render('/reporte/_headerandfooter_excel_landscape', ['Excel' => $Excel]);    

        $Excel->setActiveSheetIndex(0);

        $Excel->getActiveSheet()->getPageSetup()->setOrientation(PageSetup::ORIENTATION_LANDSCAPE);
        $Excel->getActiveSheet()->getPageSetup()->setPaperSize(PageSetup::PAPERSIZE_FOLIO);
        $Excel->getActiveSheet()->getPageSetup()->setHorizontalCentered(true);
        $Excel->getActiveSheet()->getPageMargins()->setTop($top);
        $Excel->getActiveSheet()->getPageMargins()->setRight($right);
        $Excel->getActiveSheet()->getPageMargins()->setLeft($left);
        $Excel->getActiveSheet()->getPageMargins()->setBottom($bottom);
        
        $Excel->getActiveSheet()->setTitle('Listado');

        $style = array(
            'alignment' => array(
                'horizontal' => Alignment::HORIZONTAL_CENTER,
            )
        );

        
        $Excel->getActiveSheet()->mergeCells('A1:V1');
        $Excel->getActiveSheet()->setCellValue('A1', mb_strtoupper(Yii::t('app', 'Caracterización Estudiantes')));
        $Excel->getActiveSheet()->getStyle('A1')->applyFromArray($style);
        $Excel->getActiveSheet()->getStyle('A1')->getFont()->setBold(true);

        $Excel->getActiveSheet()->mergeCells('A2:V2');
        //$Excel->getActiveSheet()->setCellValue('A2', isset($grupo) ? mb_strtoupper(Yii::t('app', 'Grupo').' '.$grupo->grupo) : mb_strtoupper(Yii::t('app', 'Grado').' '.$grado->grado));
        $Excel->getActiveSheet()->getStyle('A2')->applyFromArray($style);
        $Excel->getActiveSheet()->getStyle('A2')->getFont()->setBold(true);

        if(isset($sede) && $grado == '' && $grupo == '')
        {
            $grupos = Grupo::find()->select(['id'])->andWhere(['estado' => '1'])->orderBy(['id' => SORT_ASC]);
            //$estudiantes = Tercero::find()->where(['IN', 'grupo', $grupos])->joinWith(['academicos'])->orderBy(['grupo' => SORT_ASC, 'primer_apellido' => SORT_ASC, 'segundo_apellido' => SORT_ASC, 'primer_nombre' => SORT_ASC, 'segundo_nombre' => SORT_ASC]);
            //echo "<br>L176  :".$estudiantes->createCommand()->getRawSql(); // Mostrar SQL 
            $estudiantes = Tercero::find()->where(['IN', 'grupo', $grupos])->joinWith(['academicos'])->orderBy(['academico.grupo' => SORT_ASC, 'primer_apellido' => SORT_ASC, 'segundo_apellido' => SORT_ASC, 'primer_nombre' => SORT_ASC, 'segundo_nombre' => SORT_ASC])->all();
        }

        if(isset($grado) && $grupo == '')
        {
            $grupos = Grupo::find()->select(['id'])->where(['grado' => $grado->id])->andWhere(['estado' => '1'])->orderBy(['id' => SORT_ASC]);
            //$estudiantes = Tercero::find()->where(['IN', 'grupo', $grupos])->joinWith(['academicos'])->orderBy(['grupo' => SORT_ASC, 'primer_apellido' => SORT_ASC, 'segundo_apellido' => SORT_ASC, 'primer_nombre' => SORT_ASC, 'segundo_nombre' => SORT_ASC]);
            //echo "<br>L176  :".$estudiantes->createCommand()->getRawSql(); // Mostrar SQL 
            $estudiantes = Tercero::find()->where(['IN', 'grupo', $grupos])->joinWith(['academicos'])->orderBy(['academico.grupo' => SORT_ASC, 'primer_apellido' => SORT_ASC, 'segundo_apellido' => SORT_ASC, 'primer_nombre' => SORT_ASC, 'segundo_nombre' => SORT_ASC])->all();
        }

        if(isset($grupo))
        {
            //$estudiantes = Tercero::find()->where(['=', 'academico.grupo', $grupo->id])->joinWith(['academicos'])->orderBy(['primer_apellido' => SORT_ASC, 'segundo_apellido' => SORT_ASC, 'primer_nombre' => SORT_ASC, 'segundo_nombre' => SORT_ASC]);
            //echo "<br>L170  :".$estudiantes->createCommand()->getRawSql(); // Mostrar SQL 
            $estudiantes = Tercero::find()->where(['=', 'academico.grupo', $grupo->id])->joinWith(['academicos'])->orderBy(['primer_apellido' => SORT_ASC, 'segundo_apellido' => SORT_ASC, 'primer_nombre' => SORT_ASC, 'segundo_nombre' => SORT_ASC])->all();
        }
        

        
        $i = 2;
        $x = 1;

        $grupo_anterior = 0;    

        foreach ($estudiantes as $estudiante) 
        {
            

            //$grupo_nuevo = $estudiante->grupo->id;

            //echo "<br><br>".$estudiante->nombreinverso." - ".$estudiante->grupo->id." - ";
            //print_r($grupo_nuevo);

            //echo "<br>".$estudiante->nombreinverso."  Grupo Anterior : ".$grupo_anterior."  Grupo Actual: ".$grupo_nuevo;
            
            //exit;

            if($x == '1')
            {
                //$grupo_anterior = $estudiante->grupo->id;
                //$x = 1;
                $i = $i + 2;

                //$Excel->getActiveSheet()->mergeCells('A'.$i.':X'.$i);
                //$Excel->getActiveSheet()->setCellValue('A'.$i, mb_strtoupper(Yii::t('app', 'Grupo').' '.$estudiante->grupo->grupo));

                $Excel->getActiveSheet()->getStyle('A'.$i.':'.$Excel->getActiveSheet()->getHighestColumn().$i)->applyFromArray(
                    array(
                        'font'  => array(
                            'bold'  => true,
                            'size'  => 12,
                            'name'  => 'Calibri'
                        ),
                        'fill' => array(
                            'fillType' => Fill::FILL_SOLID,
                            'color' => array('rgb' => 'DDDDDD')
                        ),
                        'alignment' => array(
                          'horizontal' => Alignment::HORIZONTAL_CENTER,
                        )
                      )
                );

                $i++;

                $Excel->getActiveSheet()->getStyle('A'.$i.':X'.$i)->getBorders()->getAllBorders()->setBorderStyle(Border::BORDER_THIN);

                $Excel->getActiveSheet()->setCellValue('A'.$i, mb_strtoupper(Yii::t('app', '#')));
                $Excel->getActiveSheet()->setCellValue('B'.$i, mb_strtoupper(Yii::t('app', 'Estudiante')));
                $Excel->getActiveSheet()->setCellValue('C'.$i, mb_strtoupper(Yii::t('app', 'Tipo de Identificación')));
                $Excel->getActiveSheet()->setCellValue('D'.$i, mb_strtoupper(Yii::t('app', 'Identificación')));
                $Excel->getActiveSheet()->setCellValue('E'.$i, mb_strtoupper(Yii::t('app', 'Nacionalidad')));
                $Excel->getActiveSheet()->setCellValue('F'.$i, mb_strtoupper(Yii::t('app', 'Dirección')));
                $Excel->getActiveSheet()->setCellValue('G'.$i, mb_strtoupper(Yii::t('app', 'Barrio')));
                $Excel->getActiveSheet()->setCellValue('H'.$i, mb_strtoupper(Yii::t('app', 'Teléfono')));
                $Excel->getActiveSheet()->setCellValue('I'.$i, mb_strtoupper(Yii::t('app', 'Celular')));
                $Excel->getActiveSheet()->setCellValue('J'.$i, mb_strtoupper(Yii::t('app', 'Correo')));
                $Excel->getActiveSheet()->setCellValue('K'.$i, mb_strtoupper(Yii::t('app', 'Sexo')));
                $Excel->getActiveSheet()->setCellValue('L'.$i, mb_strtoupper(Yii::t('app', 'Estrato')));
                $Excel->getActiveSheet()->setCellValue('M'.$i, mb_strtoupper(Yii::t('app', 'RH')));
                $Excel->getActiveSheet()->setCellValue('N'.$i, mb_strtoupper(Yii::t('app', 'Eps')));
                $Excel->getActiveSheet()->setCellValue('O'.$i, mb_strtoupper(Yii::t('app', 'Discapacidad')));
                $Excel->getActiveSheet()->setCellValue('P'.$i, mb_strtoupper(Yii::t('app', 'Nivel')));
                $Excel->getActiveSheet()->setCellValue('Q'.$i, mb_strtoupper(Yii::t('app', 'Acudiente')));
                $Excel->getActiveSheet()->setCellValue('R'.$i, mb_strtoupper(Yii::t('app', 'Dirección')));
                $Excel->getActiveSheet()->setCellValue('S'.$i, mb_strtoupper(Yii::t('app', 'Teléfono')));
                $Excel->getActiveSheet()->setCellValue('T'.$i, mb_strtoupper(Yii::t('app', 'Parentesco')));
                $Excel->getActiveSheet()->setCellValue('U'.$i, mb_strtoupper(Yii::t('app', 'Situación')));
                $Excel->getActiveSheet()->setCellValue('V'.$i, mb_strtoupper(Yii::t('app', 'Etnia')));
                $Excel->getActiveSheet()->setCellValue('W'.$i, mb_strtoupper(Yii::t('app', 'Estado')));
                $Excel->getActiveSheet()->setCellValue('X'.$i, mb_strtoupper(Yii::t('app', 'Grupo')));
                $Excel->getActiveSheet()->setCellValue('Y'.$i, mb_strtoupper(Yii::t('app', 'Matriculado')));
                $Excel->getActiveSheet()->setCellValue('Z'.$i, mb_strtoupper(Yii::t('app', 'Retirado')));


                $Excel->getActiveSheet()->getStyle('A'.$i.':'.$Excel->getActiveSheet()->getHighestColumn().$i)->applyFromArray(
                    array(
                        'font'  => array(
                            'bold'  => true,
                            'size'  => 12,
                            'name'  => 'Calibri'
                        ),
                        'fill' => array(
                            'fillType' => Fill::FILL_SOLID,
                            'color' => array('rgb' => 'BBBBBB')
                        ),
                        'alignment' => array(
                          'horizontal' => Alignment::HORIZONTAL_CENTER,
                        )
                      )
                );

                $Excel->getActiveSheet()->getStyle('A'.$i.':Z'.$i)->getBorders()->getAllBorders()->setBorderStyle(Border::BORDER_THIN);

                $Excel->getActiveSheet()->setAutoFilter('A'.$i.':Z'.$i);

                $i++;
            }


            $Excel->getActiveSheet()->setCellValue('A'.$i, $x);  
            $Excel->getActiveSheet()->setCellValue('B'.$i, mb_strtoupper($estudiante->nombreinverso));
            $Excel->getActiveSheet()->setCellValue('C'.$i, mb_strtoupper($estudiante->tipos->tipo));
            $Excel->getActiveSheet()->setCellValue('D'.$i, mb_strtoupper($estudiante->identificacion));
            $Excel->getActiveSheet()->setCellValue('E'.$i, mb_strtoupper($estudiante->paises->pais));
            $Excel->getActiveSheet()->setCellValue('F'.$i, mb_strtoupper($estudiante->direccion));
            $Excel->getActiveSheet()->setCellValue('G'.$i, mb_strtoupper(isset($estudiante->barrios) ? $estudiante->barrios->nombre : ''));
            $Excel->getActiveSheet()->setCellValue('H'.$i, mb_strtoupper($estudiante->fijo));
            $Excel->getActiveSheet()->setCellValue('I'.$i, mb_strtoupper($estudiante->movil));
            $Excel->getActiveSheet()->setCellValue('J'.$i, mb_strtoupper($estudiante->email));
            $Excel->getActiveSheet()->setCellValue('K'.$i, mb_strtoupper($estudiante->generos->genero));
            $Excel->getActiveSheet()->setCellValue('L'.$i, mb_strtoupper(isset($estudiante->estratos) ? $estudiante->estratos->estrato : ''));
            $Excel->getActiveSheet()->setCellValue('M'.$i, mb_strtoupper(isset($estudiante->rhs) ? $estudiante->rhs->rh : ''));
            $Excel->getActiveSheet()->setCellValue('N'.$i, mb_strtoupper(isset($estudiante->epss) ? $estudiante->epss->eps : ''));
            $Excel->getActiveSheet()->setCellValue('O'.$i, mb_strtoupper($estudiante->discapacidad));
            $Excel->getActiveSheet()->setCellValue('P'.$i, mb_strtoupper(isset($estudiante->capacidades) ? $estudiante->capacidades->tipo : ''));
            
            $acudiente = new Acudiente;
            $principal = $acudiente->principal($estudiante->id);

            $Excel->getActiveSheet()->setCellValue('Q'.$i, mb_strtoupper(isset($principal) ? $principal->nombreinverso : ''));
            $Excel->getActiveSheet()->setCellValue('R'.$i, mb_strtoupper(isset($principal) ? $principal->direccion : ''));
            $Excel->getActiveSheet()->setCellValue('S'.$i, mb_strtoupper(isset($principal) ? $principal->movil : ''));
            $Excel->getActiveSheet()->setCellValue('T'.$i, mb_strtoupper(isset($principal) ? $principal->parentescos->parentesco : ''));
            $Excel->getActiveSheet()->setCellValue('U'.$i, mb_strtoupper(isset($estudiante->situaciones) ? $estudiante->situaciones->tipo : ''));
            $Excel->getActiveSheet()->setCellValue('V'.$i, mb_strtoupper(isset($estudiante->etnias) ? $estudiante->etnias->etnia : ''));
            $Excel->getActiveSheet()->setCellValue('W'.$i, mb_strtoupper($estudiante->estados->estado));
            $Excel->getActiveSheet()->setCellValue('X'.$i, mb_strtoupper($estudiante->grupo->grupo));
            $Excel->getActiveSheet()->setCellValue('Y'.$i, mb_strtoupper($estudiante->academico->fecha_matricula));
            $Excel->getActiveSheet()->setCellValue('Z'.$i, mb_strtoupper($estudiante->academico->fecha_retiro));
        
            $Excel->getActiveSheet()->getStyle('A'.$i.':Z'.$i)->getBorders()->getAllBorders()->setBorderStyle(Border::BORDER_THIN);

            $i++;
            $x++;
        }

        $i--;

        
        $Excel->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);
        $Excel->getActiveSheet()->getColumnDimension('A')->setWidth(4);
        $Excel->getActiveSheet()->getStyle('B5:B'.$i)->getFont()->setBold(true);
        
        foreach (range('A', $Excel->getActiveSheet()->getHighestDataColumn()) as $col) 
        {
            $Excel->getActiveSheet()->getColumnDimension($col)->setAutoSize(true);
        } 

        
        $Excel->setActiveSheetIndex('0');

        if(isset($grupo))
        {
            $filename = "R105-Caracterizacion-Estudiantes-Grupo(".date("d-m-Y_H-i").").xlsx";
        }    
        else
        {
            $filename = "R105-Caracterizacion-Estudiantes-Grado(".date("d-m-Y_H-i").").xlsx";
        } 

        

        // Redirect output to a client’s web browser (Xlsx)
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment;filename="' . $filename . '"');
        header('Cache-Control: max-age=0');

         
        // If you're serving to IE over SSL, then the following may be needed
        header('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
        header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT'); // always modified
        header('Cache-Control: cache, must-revalidate'); // HTTP/1.1
        header('Pragma: public'); // HTTP/1.0

        $writer = IOFactory::createWriter($Excel, 'Xlsx');
        $writer->save('php://output');
        exit;


 
    }

}
