<?php

namespace backend\controllers;

use Yii;
use backend\models\Academico;
use backend\models\Asistencia;
use backend\models\Tercero;
use backend\models\Grupo;
use backend\models\Asignatura;
use backend\models\Periodo;
use backend\models\TipoInasistencia;
use backend\models\Sede;
use backend\models\Compromisosacudiente;
use backend\models\LanzadorForm;


use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\helpers\ArrayHelper;
use yii\data\ActiveDataProvider;
use yii\base\Model;
use yii\helpers\Html;
use yii\web\Response;
use yii\widgets\ActiveForm;

use Mpdf\Mpdf;

class Reporte108Controller extends Controller
{

    public function actionIndex($tercero = NULL, $ver_estandar = 1,$ver_competencia = 1, $ver_niveles = 1, $ver_desempenos = 1, $ver_frd = 1, $ver_fecha = 1, $ver_letrasonumeros = 1) // Reporte Valorativo Condensado (Boletín de Calificaciones) por Grupo
    {
        $size_font = 10;

        if($tercero == NULL)
        {    
            $model = new LanzadorForm(['scenario'=>'grupo']);

            //$model->reporte = 'Reporte de Valorativo por Grupo';
            //$model->observaciones = 'Exporta el informe valorativo de los estudiantes por grupos.; este reporte se genera en formato PDF.';
            $model->reporte = Yii::t('app', 'R108-Reporte');
            $model->observaciones = Yii::t('app', 'R108-Observaciones');

            if (Yii::$app->request->isAjax && $model->load(Yii::$app->request->post())) {
                Yii::$app->response->format = Response::FORMAT_JSON;
                return ActiveForm::validate($model);
            }

            if ($model->load(Yii::$app->request->post())) {

                $id_tercero = $model->tercero;
                $grado = $model->grado;
                $grupo = $model->grupo;
                $periodo = $model->periodo;

                $ver_estandar = $model->ver_estandar;
                $ver_competencia = $model->ver_competencia;
                $ver_niveles = $model->ver_niveles;
                $ver_desempenos = $model->ver_desempenos;
                $ver_frd = $model->ver_frd;
                $ver_fecha = $model->ver_fecha;
                $ver_letrasonumeros = $model->ver_letrasonumeros;
                
                $ver_parametros = $model->ver_parametros;
                $ver_colores = $model->ver_colores;
                $size_font = $model->fuente;
                $alto = $model->alto;


                //$ver_emoticonos = $model->ver_emoticonos;
                //$ver_criterios = $model->ver_criterios;

                
            }
            else
            {
                if (Yii::$app->request->isAjax) 
                {
                    return $this->renderAjax('/publica/lanzador', [
                            'model' => $model,
                            'sede' => true,
                            'tercero' => true,
                            'grado' => true,
                            'grupo' => true,
                            'asignatura' => false,
                            'periodo' => false,
                            'competencia' => false,
                            'columnas' => false,
                            'ver_estandar' => false,
                            'ver_competencia' => false,
                            'ver_niveles' => false,
                            'ver_desempenos' => false,
                            'ver_frd' => false,
                            'ver_fecha' => true,
                            'ver_letrasonumeros' => false,
                            'ver_parametros' => true,
                        ]);

                    //exit;
                }
                else
                {
                    $model->scenario = 'tercero';

                    return $this->render('/publica/lanzador', [
                            'model' => $model,
                            'sede' => true,
                            'tercero' => true,
                            'grado' => false,
                            'grupo' => false,
                            'asignatura' => false,
                            'periodo' => false,
                            'competencia' => false,
                            'columnas' => false,
                            'ver_estandar' => false,
                            'ver_competencia' => false,
                            'ver_niveles' => false,
                            'ver_desempenos' => false,
                            'ver_frd' => false,
                            'ver_fecha' => true,
                            'ver_letrasonumeros' => false,
                            'ver_parametros' => true,
                        ]);

                    //exit;
                }
            }    
        }
        else
        {
            $id_tercero = Yii::$app->request->get('tercero');
            $periodo = new Periodo();
            $periodo = $periodo->actual->id;

            /*$grado = Yii::$app->request->get('grado');
            $grupo = Yii::$app->request->get('grupo');
            $asignatura = Yii::$app->request->get('asignatura');
            $periodo = Yii::$app->request->get('periodo');*/
            
        }

        date_default_timezone_set('America/Bogota');
        setlocale(LC_TIME,"es_ES");

        if($id_tercero != '')
        {
            
            if (($tercero = Tercero::find()->where(['id' => $id_tercero])->one()) === null)
            {
                throw new NotFoundHttpException('No existe el tercero');
            }  

            if (($estudiantes = Academico::find()
                            ->select(['tercero.id', 'academico.estudiante', 'academico.grupo','academico.especialidad'])
                            ->joinWith(['estudiantes'])
                            //>where(['<', 'tercero.estado', 3])
                            ->where(['academico.estudiante' => $tercero->id])
                            ->orderBy('primer_apellido')
                            ->all()) === null)
            {
                throw new NotFoundHttpException('No estudiante no tiene registro académico.');
            }  
            else
            {
                foreach ($estudiantes as $tercero) {
                    $grupo = Grupo::find()->where(['id' => $tercero->grupo])->one();
                }    
            } 
            
        }
        else
        {
            $grupo = Grupo::find()->where(['id' => $grupo])->one();
            //$sede = Sede::FindOne($grupo->sede);
            $estudiantes = Academico::find()
                            ->select(['tercero.id', 'academico.estudiante', 'academico.grupo','academico.especialidad'])
                            ->joinWith(['estudiantes'])
                            //->where(['<', 'tercero.estado', 3])
                            ->where(['academico.grupo' => $grupo->id])
                            ->orderBy(['primer_apellido' => SORT_ASC, 'segundo_apellido' => SORT_ASC])
                            ->all();  
        }    
        
        
            
        $pdf = new Mpdf(['mode' => 'utf-8',
                         'format' => 'LETTER',
                         'default_font_size' => 0,
                         'default_font' => '',
                         'margin_left' => 15,
                         'margin_right' => 15,
                         'margin_top' => 50,
                         'margin_bottom' => 18,
                         'margin_header' => 9,
                         'margin_footer' => 5,
                         'orientation' => 'P']);  
        
        //$pdf->StarProgressBarOutput(2);


        if ($grupo->sedes->pdf_marcadeagua == 'T' OR $grupo->sedes->pdf_marcadeagua == 'B')
        {
            $pdf->SetWatermarkText($sede->pdf_marcadeagua_contenido);
            $pdf->showWatermarkText = true;
            $pdf->watermarkTextAlpha = 0.1;
        }

        if ($grupo->sedes->pdf_marcadeagua == 'I')
        {
            $pdf->SetWatermarkImage($grupo->sedes->pdf_marcadeagua_contenido);
            $pdf->showWatermarkImage = true;
            $pdf->watermarkImageAlpha = 0.1;
        }

        $pdf->setHeader($grupo->sedes->pdf_header);
        $pdf->setFooter($grupo->sedes->pdf_footer);
        
        $pdf->AliasNbPages();

        $i = 1;    
        
        foreach ($estudiantes as $estudiante) 
        {

            $pdf->AddPage(0,'Letter');

            $pdf->SetFillColor(255);
            $pdf->SetTextColor(0);
            $pdf->SetDrawColor(0,0,0);
        
            $pdf->SetFont('Helvetica','B',12);   
            $pdf->Cell(190,5,mb_strtoupper(Yii::t('app', 'Constancia de Matricula')),0,0,'C'); 
            
            $pdf->Ln(15);

            $pdf->SetFont('Helvetica','B',$size_font);
            $pdf->Cell(40,5,Yii::t('app', 'Institución Educativa'),0,0);
            $pdf->SetFont('Helvetica','',$size_font);    
            $pdf->Cell(130,5,mb_strtoupper($grupo->sedes->sede),0,0);

            $pdf->Ln(5);
            $pdf->SetFont('Helvetica','B',$size_font);
            $pdf->Cell(40,5,Yii::t('app', 'Municipio'),0,0);
            $pdf->SetFont('Helvetica','',$size_font);    
            $pdf->Cell(130,5,mb_strtoupper($grupo->sedes->municipios->nombre.' - '.$grupo->sedes->departamentos->nombre),0,0);  

            $pdf->Ln(5);
            $pdf->SetFont('Helvetica','B',$size_font);
            $pdf->Cell(40,5,Yii::t('app', 'Código DANE'),0,0);
            $pdf->SetFont('Helvetica','',$size_font);    
            $pdf->Cell(130,5,mb_strtoupper($grupo->sedes->dane),0,0);


            $pdf->Ln(5);
            $fecha = strftime("%A, %d de %B de %Y");

            $pdf->SetFont('Helvetica','B',$size_font);
            $pdf->Cell(40,5,Yii::t('app', 'Fecha'),0,0);
            $pdf->SetFont('Helvetica','',$size_font);    
            $pdf->Cell(130,5,mb_strtoupper($fecha),0,0);

            $pdf->Ln(10);
            $pdf->MultiCell(180,6,Yii::t('app', 'El señor Rector {rector} en virtud de su cargo en esta institución.',[
                        'rector' => $grupo->sedes->rector_nombre,
                    ]),0,'J',0);

            $pdf->Ln(10);

            $pdf->SetFont('Helvetica','B',12);   
            $pdf->Cell(190,5,mb_strtoupper(Yii::t('app', 'Hace Constar')),0,0,'C'); 

            $pdf->Ln(15);
            $pdf->SetFont('Helvetica','',$size_font);    

            $pdf->MultiCell(190,6,Yii::t('app', 'Qué el estudiante {estudiante} identificado(a) con {tipo_documento} Nº {identificacion} de {municipio_expedida} - {departamento_expedida}, se encuentra matriculado(a) en esta Institución Educativa en el Grado {grado} - Grupo {grupo} de {modalidad} para el año escolar {vigencia} y asiste a las clases programadas en la jornada {jornada}.',[
                        'estudiante' => mb_strtoupper($estudiante->estudiantes->nombreinverso),
                        'tipo_documento' => mb_strtoupper($estudiante->estudiantes->tipos->tipo),
                        'identificacion' => mb_strtoupper($estudiante->estudiantes->identificacion),
                        'municipio_expedida' => mb_strtoupper($estudiante->estudiantes->municipioexpedido->nombre),
                        'departamento_expedida' => mb_strtoupper($estudiante->estudiantes->departamentoexpedido->nombre),
                        'grado' => mb_strtoupper($grupo->grados->grado),
                        'grupo' => mb_strtoupper($grupo->grupo),
                        'modalidad' => mb_strtoupper($grupo->modalidades->modalidad),
                        'vigencia' => $grupo->sedes->vigencia,
                        'jornada' => mb_strtoupper($grupo->jornadas->jornada),
                    ]),0,'',0); 


            $pdf->Ln(8);
            $pdf->SetFont('Helvetica','',$size_font);
            
            $fecha = strftime("%A, %d de %B de %Y");

            $pdf->Cell(190,6,Yii::t('app', 'Se expide a solicitud del interesado para el Programa Familias en Acción.'),0,0);
            $pdf->Ln(5);
            
            $pdf->SetFont('Helvetica','B',$size_font);

            $y = $pdf->y;
            $x = $pdf->x;

                
            
            
            //$pdf->Image(\Yii::getAlias('@webroot/uploads/'.$grupo->sedes->rector_firma),$x+65,$y+20,50);
            
            //$pdf->SetY($pdf->y-15);
            $pdf->Ln(20); 
            $pdf->Cell(60);
            $pdf->Cell(60,5,$grupo->sedes->rector_nombre,'T',0,'C',0);

            $pdf->Ln(3);
            $pdf->SetFont('Helvetica','',$size_font);
            $pdf->Cell(60);
            $pdf->Cell(60,5,"Rector(a)",'',0,'C',0);
            $pdf->Ln(1); 


        }

        $pdf->Output("R108-Certificado-Familias-En-Accion(".date("d-m-Y_H-i").").pdf",'D');
    }

  

}
