<?php

namespace backend\controllers;

use Yii;
use backend\models\Academico;
use backend\models\Asistencia;
use backend\models\Tercero;
use backend\models\Grupo;
use backend\models\Asignatura;
use backend\models\Periodo;
use backend\models\TipoInasistencia;
use backend\models\Sede;
use backend\models\Desempeno;
use backend\models\Compromisosacudiente;
use backend\models\LanzadorForm;


use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\helpers\ArrayHelper;
use yii\data\ActiveDataProvider;
use yii\base\Model;
use yii\helpers\Html;
use yii\web\Response;
use yii\widgets\ActiveForm;
//use dosamigos\qrcode\QrCode;
//use Da\QrCode\QrCode;
use Mpdf\Mpdf;


class Reporte110Controller extends Controller
{
    public function Horizontal($pdf, $x = 10, $y = 0, $tercero, $sede)
    {
        date_default_timezone_set('America/Bogota');
        setlocale(LC_TIME,"es_ES");

        $pdf->SetTextColor(0);
        $pdf->Rect( (0 + $x), (13 + $y), 86, 54); //Marco exterior
       
        if($sede->logo !='')
        {
           $pdf->Image(Yii::getAlias('@web/images/'.$sede->logo), (62 + $x), (33 + $y), 20); 
        }

        if ($tercero->estudiantes->foto !='')
        {
            $pdf->Image(Yii::getAlias('@web/uploads/thumbnail/sm-'.$tercero->estudiantes->foto), (3 + $x), (25 + $y), 25, 32);
        }
        else
        {
            $pdf->Rect((3 + $x), (25 + $y), 25, 32); //Marco exterior
            $pdf->Image(Yii::getAlias('@web/images/login-sonic.png'), (3 + $x), (25 + $y), 25);
            
        }
        
        $pdf->SetFont('Helvetica','B','10');

        $pdf->setXY($x, (15 + $y));
        $pdf->SetTextColor(0);

        //setlocale(LC_ALL,'es_ES');
        $pdf->Cell(86, 7, mb_strtoupper($sede->sede),0,0,'C',0);

        if($tercero->grupos->sede != $sede->id)
        {
            $pdf->SetTextColor(0,105,140);
            $pdf->SetFont('Helvetica','B','8');
            $pdf->setXY($x, (19 + $y));
            $pdf->Cell(90, 7, mb_strtoupper($tercero->grupos->sedes->sede),0,0,'C',0);
        }

        $pdf->SetTextColor(0);
        $pdf->SetFont('Helvetica','B','11');        
        $pdf->setXY((30 + $x), (26 + $y));
        $pdf->Cell(50, 7, mb_strtoupper($tercero->estudiantes->primer_apellido." ".$tercero->estudiantes->segundo_apellido), 0);
        
        $pdf->SetFont('Helvetica','','9');
        $pdf->setXY((30 + $x), (30 + $y));
        $pdf->Cell(50, 7, mb_strtoupper($tercero->estudiantes->primer_nombre." ".$tercero->estudiantes->segundo_nombre), 0);
        
        $pdf->SetTextColor(150);
        $pdf->SetFont('Helvetica','','5');
        $pdf->setXY((30 + $x), (33 + $y));
        $pdf->Cell(29, 7, 'APELLIDOS Y NOMBRES');

        $pdf->SetTextColor(0);
        $pdf->SetFont('Helvetica','B','10');
        $pdf->setXY((30 + $x), (40 + $y));        
        $pdf->Cell(50, 7, mb_strtoupper($tercero->estudiantes->identificacion), 0);
        
        $pdf->SetTextColor(150);
        $pdf->SetFont('Helvetica','','5');
        $pdf->setXY((30 + $x), (43 + $y));
        $pdf->Cell(50, 7, mb_strtoupper($tercero->estudiantes->tipos->tipo), 0);
        

        $pdf->SetTextColor(0);
        $pdf->SetFont('Helvetica','B','7');
        $pdf->setXY((30 + $x), (50 + $y));
        $pdf->Cell(24, 5, mb_strtoupper($tercero->grupos->grados->grado),0);
        $pdf->setXY((45 + $x), (50 + $y));
        $pdf->Cell(24, 5, mb_strtoupper($tercero->grupos->grupo),0);
        $pdf->setXY((53 + $x), (50 + $y));
        $pdf->Cell(24, 5, mb_strtoupper($tercero->grupos->jornadas->jornada),0);


        $pdf->SetTextColor(150);
        $pdf->SetFont('Helvetica','','5');
        $pdf->setXY((30 + $x), (53 + $y));
        $pdf->Cell(50, 5, mb_strtoupper("Grado"), 0);
        $pdf->setXY((45 + $x), (53 + $y));
        $pdf->Cell(50, 5, mb_strtoupper("Grupo"), 0);
        $pdf->setXY((53 + $x), (53 + $y));
        $pdf->Cell(50, 5, mb_strtoupper("Jornada"), 0);
        
/*
        $pdf->SetTextColor(150);
        $pdf->SetFont('Helvetica','','5');
        $pdf->setXY((5 + $x), (59 + $y));
        $pdf->Cell(50, 7, mb_strtoupper("RH"), 0);
*/
        
        $pdf->SetFont('Helvetica','','8');
        $pdf->SetTextColor(255);
        
        $desempeno = new Desempeno;
        $color = $desempeno->hex2rgb($sede->color);
        $pdf->setFillColor($color['r'],$color['g'],$color['b']);


        $pdf->setXY($x, (59 + $y));
        $pdf->SetFont('Helvetica','B','10');
        $pdf->Cell(86 ,8,mb_strtoupper($tercero->estudiantes->tipoterceros->tipo),1,0,'C',1); 

        $pdf->SetTextColor(255);
        $pdf->SetFont('Helvetica','B','10');
        $pdf->setXY((3 + $x), (59 + $y));        
        $pdf->Cell(50, 8, mb_strtoupper($tercero->estudiantes->rhs->rh), 0);
        
        /*
        $qrCode = (new QrCode($tercero->estudiantes->id))
        ->setSize(250)
        ->setMargin(5);
        //->useForegroundColor(51, 153, 255);

        //$qrCode->writeDataUri()

        $pdf->Image($qrCode->writeDataUri(), (74 + $x), (55 + $y), 11);

        */

        $pdf->SetTextColor(0);
        $pdf->setFillColor(255);
        $pdf->Rect( (86 + $x), (13 + $y), 86, 54); //Marco exterior

        $pdf->Image(Yii::getAlias('@web/images/logo_colegio_traslucido.jpg'), (115 + $x), (15 + $y), 30); 

        $pdf->setXY((86 +$x), (25 + $y));
        $pdf->SetFont('Helvetica','',9);   

        if($sede->mensaje == "")
        {
            $pdf->MultiCell(86,4,Yii::t('app', 'Este carnet es personal e intransferible y acredita al titular de {sede} de {municipio} - {departamento}',[
                    'sede' => $tercero->grupos->sedes->sede,
                    'municipio' => $tercero->grupos->sedes->municipios->nombre,
                    'departamento' => $tercero->grupos->sedes->departamentos->nombre,
                    ]),0,'C',0);
        }
        else
        {
            $pdf->MultiCell(86,4,$sede->mensaje,0,'C',0);
        }

        $pdf->Image(($tercero->grupos->sedes->rector_firma !='' ) ? Yii::getAlias('@web/uploads/'.$tercero->grupos->sedes->rector_firma) : '@web/images/', (115 + $x), (38 + $y), 40);

        $pdf->SetFont('Helvetica','B','10');
        $pdf->setXY((86 + $x), (50 + $y));
        $pdf->Cell(86, 5, mb_strtoupper($tercero->grupos->sedes->rector_nombre),0,0,'C',0);
        $pdf->SetFont('Helvetica','','8');
        $pdf->setXY((86 + $x), (53 + $y));
        $pdf->Cell(86, 5, mb_strtoupper("Rector"),0,0,'C',0);

        $pdf->SetTextColor(255);
        $pdf->setFillColor($color['r'],$color['g'],$color['b']);

        //$pdf->setFillColor(178,0,0);

        $pdf->setXY((86 + $x), (59 + $y));
        $pdf->SetFont('Helvetica','B','10');
        $pdf->Cell(86 ,8, mb_strtoupper("Válido hasta Diciembre de ".$tercero->grupos->sedes->vigencia),1,0,'C',1); 
        
    }

    public function Vertical($pdf, $x = 10, $y = 0, $tercero, $sede)
    {
        date_default_timezone_set('America/Bogota');
        setlocale(LC_TIME,"es_ES");

        $pdf->SetTextColor(0);
        //$pdf->Rect( (0 + $x), (13 + $y), 90, 55); //Marco exterior
        $pdf->Rect( (0 + $x), (13 + $y), 54, 86); //Marco exterior
       
        if($sede->logo !='')
        {
           $pdf->Image(Yii::getAlias('@web/images/'.$sede->logo), (20 + $x), (28 + $y), 15); 
        }

        if ($tercero->estudiantes->foto !='')
        {
            $pdf->Image(Yii::getAlias('@web/uploads/thumbnail/sm-'.$tercero->estudiantes->foto), (27 + $x), (57 + $y), 25, 32);
        }
        else
        {
            $pdf->Rect((27 + $x), (57 + $y), 25, 32); //Marco exterior
            $pdf->Image(Yii::getAlias('@web/images/login-sonic.png'), (27 + $x), (57 + $y), 25);
            
        }
        

        $pdf->SetFont('Helvetica','B','10');

        $pdf->setXY($x, (15 + $y));
        $pdf->SetTextColor(0);

        //setlocale(LC_ALL,'es_ES');
        //$pdf->Cell(55, 7, mb_strtoupper($sede->sede),0,0,'C',0);
        $pdf->MultiCell(54,4,mb_strtoupper($sede->sede),0,'C',0);

        if($tercero->grupos->sede != $sede->id)
        {
            $pdf->SetTextColor(0,105,140);
            $pdf->SetFont('Helvetica','B','8');
            $pdf->setXY($x, $pdf->y);
            $pdf->Cell(54, 5, mb_strtoupper($tercero->grupos->sedes->sede),0,0,'C',0);
        }

        $pdf->SetTextColor(0);
        $pdf->SetFont('Helvetica','B','11');        
        $pdf->setXY((3 + $x), (45 + $y));
        $pdf->Cell(50, 7, mb_strtoupper($tercero->estudiantes->primer_apellido." ".$tercero->estudiantes->segundo_apellido),0,0,'C');
        
        $pdf->SetFont('Helvetica','','9');
        $pdf->setXY((3 + $x), (49 + $y));
        $pdf->Cell(50, 7, mb_strtoupper($tercero->estudiantes->primer_nombre." ".$tercero->estudiantes->segundo_nombre),0,0,'C');
        
        $pdf->SetTextColor(150);
        $pdf->SetFont('Helvetica','','5');
        $pdf->setXY((3 + $x), (52 + $y));
        $pdf->Cell(50, 7, 'APELLIDOS Y NOMBRES', 0, 0, 'C');

        $pdf->SetTextColor(0);
        $pdf->SetFont('Helvetica','B','10');
        $pdf->setXY((3 + $x), (57 + $y));        
        $pdf->Cell(50, 7, mb_strtoupper($tercero->estudiantes->identificacion), 0);
        
        $pdf->SetTextColor(150);
        $pdf->SetFont('Helvetica','','5');
        $pdf->setXY((3 + $x), (60 + $y));
        $pdf->Cell(50, 7, mb_strtoupper($tercero->estudiantes->tipos->tipo), 0);
        

        $pdf->SetTextColor(0);
        $pdf->SetFont('Helvetica','B','7');
        $pdf->setXY((3 + $x), (65 + $y));
        $pdf->Cell(24, 5, mb_strtoupper($tercero->grupos->grados->grado),0);
        $pdf->setXY((3 + $x), (72 + $y));
        $pdf->Cell(24, 5, mb_strtoupper($tercero->grupos->grupo),0);
        $pdf->setXY((3 + $x), (79 + $y));
        $pdf->Cell(24, 5, mb_strtoupper($tercero->grupos->jornadas->jornada),0);


        $pdf->SetTextColor(150);
        $pdf->SetFont('Helvetica','','5');
        $pdf->setXY((3 + $x), (68 + $y));
        $pdf->Cell(50, 5, mb_strtoupper("Grado"), 0);
        $pdf->setXY((3 + $x), (75 + $y));
        $pdf->Cell(50, 5, mb_strtoupper("Grupo"), 0);
        $pdf->setXY((3 + $x), (82 + $y));
        $pdf->Cell(50, 5, mb_strtoupper("Jornada"), 0);
        
        /*
        $pdf->SetTextColor(150);
        $pdf->SetFont('Helvetica','','5');
        $pdf->setXY((3 + $x), (85 + $y));
        $pdf->Cell(50, 7, mb_strtoupper("RH"), 0);
        */

        $pdf->SetTextColor(0);
        $pdf->SetFont('Helvetica','B','10');
        $pdf->setXY((3 + $x), (85 + $y));        
        $pdf->Cell(50, 7, mb_strtoupper($tercero->estudiantes->rhs->rh), 0);
        
        $pdf->SetFont('Helvetica','','8');
        $pdf->SetTextColor(255);
        
        $desempeno = new Desempeno;
        $color = $desempeno->hex2rgb($sede->color);
        $pdf->setFillColor($color['r'],$color['g'],$color['b']);


        $pdf->setXY($x, (91 + $y));
        $pdf->SetFont('Helvetica','B','10');
        $pdf->Cell(54 ,8,mb_strtoupper($tercero->estudiantes->tipoterceros->tipo),1,0,'C',1); 

        $pdf->SetTextColor(0);
        $pdf->setFillColor(255);
        $pdf->Rect( (54 + $x), (13 + $y), 54, 86); //Marco exterior

        $pdf->Image(Yii::getAlias('@web/images/logo_colegio_traslucido.jpg'), (63 + $x), (25 + $y), 40); 

        $pdf->setXY((54 +$x), (25 + $y));
        $pdf->SetFont('Helvetica','',9);   
        $pdf->MultiCell(54,4,Yii::t('app', 'Este carnet es personal e intransferible y acredita al titular de {sede} de {municipio} - {departamento}',[
                'sede' => $tercero->grupos->sedes->sede,
                'municipio' => $tercero->grupos->sedes->municipios->nombre,
                'departamento' => $tercero->grupos->sedes->departamentos->nombre,
                ]),0,'C',0);

        $pdf->Image(($tercero->grupos->sedes->rector_firma !='' ) ? Yii::getAlias('@web/uploads/'.$tercero->grupos->sedes->rector_firma) : '@web/images/', (64 + $x), (50 + $y), 40);

        $pdf->SetFont('Helvetica','B','10');
        $pdf->setXY((58 + $x), (62 + $y));

        $pdf->MultiCell(45,4,mb_strtoupper($tercero->grupos->sedes->rector_nombre),0,'C',0);

        //$pdf->Cell(55, 5, mb_strtoupper($tercero->grupos->sedes->rector_nombre),0,0,'C',0);
        $pdf->SetFont('Helvetica','','8');

        //$pdf->setXY((55 + $x), (55 + $y));
        $pdf->setXY((54 + $x), ($pdf->y));
        $pdf->Cell(54, 5, mb_strtoupper("Rector"),0,0,'C',0);

        $pdf->SetTextColor(255);
        $pdf->setFillColor($color['r'],$color['g'],$color['b']);


        $pdf->setXY((54 + $x), (91 + $y));
        $pdf->SetFont('Helvetica','B','10');
        $pdf->Cell(54 ,8, mb_strtoupper("Válido hasta Dic ".$tercero->grupos->sedes->vigencia),1,0,'C',1); 
        
    }

    public function actionIndex($tercero = NULL, $ver_estandar = 1,$ver_competencia = 1, $ver_niveles = 1, $ver_desempenos = 1, $ver_frd = 1, $ver_fecha = 1, $ver_letrasonumeros = 1) // Reporte Valorativo Condensado (Boletín de Calificaciones) por Grupo
    {
        
        //setlocale(LC_ALL,'es_ES');

        $size_font = 8;

        if($tercero == NULL)
        {    
            $model = new LanzadorForm(['scenario'=>'grupo']);

            //$model->reporte = 'Reporte de Valorativo por Grupo';
            //$model->observaciones = 'Exporta el informe valorativo de los estudiantes por grupos.; este reporte se genera en formato PDF.';
            $model->reporte = Yii::t('app', 'R110-Reporte');
            $model->observaciones = Yii::t('app', 'R110-Observaciones');

            if (Yii::$app->request->isAjax && $model->load(Yii::$app->request->post())) {
                Yii::$app->response->format = Response::FORMAT_JSON;
                return ActiveForm::validate($model);
            }

            if ($model->load(Yii::$app->request->post())) {

                $id_tercero = $model->tercero;
                $grado = $model->grado;
                $grupo = $model->grupo;
                $periodo = $model->periodo;

                $ver_estandar = $model->ver_estandar;
                $ver_competencia = $model->ver_competencia;
                $ver_niveles = $model->ver_niveles;
                $ver_desempenos = $model->ver_desempenos;
                $ver_frd = $model->ver_frd;
                $ver_fecha = $model->ver_fecha;
                $ver_letrasonumeros = $model->ver_letrasonumeros;
                $ver_orientacion = $model->ver_orientacion;

                //$ver_emoticonos = $model->ver_emoticonos;
                //$ver_criterios = $model->ver_criterios;

                
            }
            else
            {
                if (Yii::$app->request->isAjax) 
                {
                    return $this->renderAjax('/publica/lanzador', [
                            'model' => $model,
                            'sede' => true,
                            'tercero' => true,
                            'grado' => true,
                            'grupo' => true,
                            'asignatura' => false,
                            'periodo' => false,
                            'competencia' => false,
                            'columnas' => false,
                            'ver_estandar' => false,
                            'ver_competencia' => false,
                            'ver_niveles' => false,
                            'ver_desempenos' => false,
                            'ver_frd' => false,
                            'ver_fecha' => false,
                            'ver_letrasonumeros' => false,
                            'ver_orientacion' => true,
                        ]);

                    //exit;
                }
                else
                {
                    $model->scenario = 'tercero';

                    return $this->render('/publica/lanzador', [
                            'model' => $model,
                            'sede' => true,
                            'tercero' => true,
                            'grado' => false,
                            'grupo' => false,
                            'asignatura' => false,
                            'periodo' => false,
                            'competencia' => false,
                            'columnas' => false,
                            'ver_estandar' => false,
                            'ver_competencia' => false,
                            'ver_niveles' => false,
                            'ver_desempenos' => false,
                            'ver_frd' => false,
                            'ver_fecha' => false,
                            'ver_letrasonumeros' => false,
                            'ver_orientacion' => true,
                        ]);

                    //exit;
                }
            }    
        }
        else
        {
            $id_tercero = Yii::$app->request->get('tercero');
            $periodo = new Periodo();
            $periodo = $periodo->actual->id;

            /*$grado = Yii::$app->request->get('grado');
            $grupo = Yii::$app->request->get('grupo');
            $asignatura = Yii::$app->request->get('asignatura');
            $periodo = Yii::$app->request->get('periodo');*/
            
        }

        date_default_timezone_set('America/Bogota');
        setlocale(LC_TIME,"es_ES");

        if($id_tercero != '')
        {
            
            if (($tercero = Tercero::find()->where(['id' => $id_tercero])->one()) === null)
            {
                throw new NotFoundHttpException('No existe el tercero');
            }  

            if (($estudiantes = Academico::find()
                            ->select(['tercero.id', 'academico.estudiante', 'academico.grupo','academico.especialidad'])
                            ->joinWith(['estudiantes'])
                            //->where(['<', 'tercero.estado', 3])
                            ->where(['academico.estudiante' => $tercero->id])
                            ->orderBy('primer_apellido')
                            ->all()) === null)
            {
                throw new NotFoundHttpException('No estudiante no tiene registro académico.');
            }  
            else
            {
                foreach ($estudiantes as $tercero) {
                    $grupo = Grupo::find()->where(['id' => $tercero->grupo])->one();
                }    
            } 
            
        }
        else
        {
            $grupo = Grupo::find()->where(['id' => $grupo])->one();
            //$sede = Sede::FindOne($grupo->sede);
            $estudiantes = Academico::find()
                            ->select(['tercero.id', 'academico.estudiante', 'academico.grupo','academico.especialidad'])
                            ->joinWith(['estudiantes'])
                            //->where(['<', 'tercero.estado', 3])
                            ->where(['academico.grupo' => $grupo->id])
                            ->orderBy(['primer_apellido' => SORT_ASC, 'segundo_apellido' => SORT_ASC])
                            ->all();  
        }    
        
        
        $sede = Sede::Find()->where(['principal' => '1'])->one();

            
        $pdf = new Mpdf(['mode' => 'utf-8',
                         'format' => 'LETTER',
                         'default_font_size' => 0,
                         'default_font' => '',
                         'margin_left' => 15,
                         'margin_right' => 15,
                         'margin_top' => 10,
                         'margin_bottom' => 10,
                         'margin_header' => 0,
                         'margin_footer' => 0,
                         'orientation' => ($ver_orientacion == '1' ? 'P' : 'L')]);  
        
        //$pdf->StarProgressBarOutput(2);

/*
        if ($grupo->sedes->pdf_marcadeagua == 'T' OR $grupo->sedes->pdf_marcadeagua == 'B')
        {
            $pdf->SetWatermarkText($sede->pdf_marcadeagua_contenido);
            $pdf->showWatermarkText = true;
            $pdf->watermarkTextAlpha = 0.1;
        }

        if ($grupo->sedes->pdf_marcadeagua == 'I')
        {
            $pdf->SetWatermarkImage($grupo->sedes->pdf_marcadeagua_contenido);
            $pdf->showWatermarkImage = true;
            $pdf->watermarkImageAlpha = 0.1;
        }
*/
        //$pdf->setHeader($grupo->sedes->pdf_header);
        //$pdf->setFooter($grupo->sedes->pdf_footer);
        
        //$pdf->AliasNbPages();

        $i = 1;
        $x = 10;
        $y = 0;    
        
        if(count($estudiantes) <= 0)
        {
            $pdf->AddPage(0,'Letter');
            $pdf->Cell(190, 7, mb_strtoupper("No hay estudiantes registrados"),0,0,'C',0);

        }
        foreach ($estudiantes as $estudiante) 
        {

            if ($ver_orientacion == '1') // HORIZONTAL
            {
                if($i == 1 OR $i == 5)
                {
                    $pdf->AddPage(0,'Letter');
                }

                if($i == 5)
                {
                    $i = 1;
                    $y = 0;
                }

                $this->Horizontal($pdf, $x, $y, $estudiante, $sede);    
                
                $i++;
                $y = $y + 65;
            }
            else  //  VERTICAL
            {
                if($i == 1 OR $i == 5)
                {
                    $pdf->AddPage(0,'Letter');
                }

                if($i == 1 OR $i == 5)
                {
                    $i = 1;
                    $x = 10;
                    $y = 0;
                }

                $this->Vertical($pdf, $x, $y, $estudiante, $sede);    
                
                $i++;
                $y = $y + 95;

                if($i == 2)
                {
                    $y = 0;
                    $x = 125;
                }

                if($i == 3)
                {
                    //$y = 0;
                    $x = 10;
                }

                if($i == 4)
                {
                    $y = $y - 95;
                    $x = 125;
                }
            }
        }

        $pdf->Output("R110-Carnet-Estudiantil(".date("d-m-Y_H-i").").pdf",'D');
    }

  

}
