<?php

namespace backend\controllers;

use Yii;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\helpers\ArrayHelper;
use yii\data\ActiveDataProvider;
use yii\base\Model;
use yii\helpers\Html;
use yii\web\Response;
use yii\widgets\ActiveForm;

use backend\models\Sede;
use backend\models\Academico;
use backend\models\Carga;
use backend\models\Asistencia;
use backend\models\Grupo;
use backend\models\Periodo;
use backend\models\Asignatura;
use backend\models\Calificacion;
use backend\models\Calificacioncalificaciones;
use backend\models\Calificacionfrd;
use backend\models\Competencia;
use backend\models\Desempeno;
use backend\models\LanzadorForm;

use Mpdf\Mpdf;


class Reporte501Controller extends Controller
{

    public function actionIndex($grupo = NULL, $asignatura = NULL, $ver_fecha = 0, $ver_competencia = 0) // Reporte Valorativo (Boletín de Calificaciones) por Grupo
    {

        if($grupo == NULL && $asignatura == NULL)
        {    
            $model = new LanzadorForm(['scenario'=>'asignatura-periodo']);
            
            //$model->reporte = 'Reporte de Estudiantes por Asignatura y Grupo';
            //$model->observaciones = 'Exporta la lista de estudiantes por asignatura y grupos.; este reporte se genera en formato Excel.';
            $model->reporte = Yii::t('app', 'R501-Reporte');
            $model->observaciones = Yii::t('app', 'R501-Observaciones');

            if (Yii::$app->request->isAjax && $model->load(Yii::$app->request->post())) {
                Yii::$app->response->format = Response::FORMAT_JSON;
                return ActiveForm::validate($model);
            }

            if ($model->load(Yii::$app->request->post())) {

                $grado = $model->grado;
                $grupo = $model->grupo;
                $asignatura = $model->asignatura; 
                $periodo = $model->periodo;
                $columnas = $model->columnas;
                $ver_estandar = $model->ver_estandar;
                $ver_competencia = $model->ver_competencia;
                $ver_niveles = $model->ver_niveles;
                $ver_desempenos = $model->ver_desempenos;
                $ver_frd = $model->ver_frd;
                $ver_fecha = $model->ver_fecha;

                $ver_parametros = $model->ver_parametros;
                $ver_colores = $model->ver_colores;
                $size_font = $model->fuente;
                $alto = $model->alto;
                
            }
            else
            {
                if (Yii::$app->request->isAjax) 
                {
                    return $this->renderAjax('/publica/lanzador', [
                            'model' => $model,
                            'sede' => true,
                            'tercero' => false,
                            'grado' => true,
                            'grupo' => true,
                            'asignatura' => true,
                            'periodo' => true,
                            'competencia' => false,
                            'columnas' => false,
                            'ver_estandar' => false,
                            'ver_competencia' => true,
                            'ver_niveles' => false,
                            'ver_desempenos' => false,
                            'ver_frd' => false,
                            'ver_fecha' => true,
                            'ver_letrasonumeros' => false,
                            'ver_parametros' => true,
                        ]);

                    exit;
                }
                else
                {
                    return $this->render('/publica/lanzador', [
                            'model' => $model,
                            'sede' => true,
                            'tercero' => false,
                            'grado' => true,
                            'grupo' => true,
                            'asignatura' => true,
                            'periodo' => true,
                            'competencia' => false,
                            'columnas' => false,
                            'ver_estandar' => false,
                            'ver_competencia' => true,
                            'ver_niveles' => false,
                            'ver_desempenos' => false,
                            'ver_frd' => false,
                            'ver_fecha' => true,
                            'ver_letrasonumeros' => false,
                            'ver_parametros' => true,
                        ]);

                    exit;
                } 
            }    
        }
        else
        {

            if(!Yii::$app->request->get('periodo'))
            {
                $periodo = new Periodo();
                $periodo = $periodo->actual->id;    
            }
            else
            {
                $periodo = Yii::$app->request->get('periodo');
            }
            

            $grado = Yii::$app->request->get('grado');
            $grupo = Yii::$app->request->get('grupo');
            $asignatura = Yii::$app->request->get('asignatura');

            $sede = Sede::find()->where(['principal' => '1'])->one();
            $grupo = Grupo::find()->where(['id' => $grupo])->one();
            
            $ver_fecha = !Yii::$app->request->get('ver_fecha') ? 1 : Yii::$app->request->get('ver_fecha');
            $ver_letrasonumeros = !Yii::$app->request->get('ver_letrasonumeros') ? $grupo->grados->tipo_calificacion : Yii::$app->request->get('ver_letrasonumeros');
            $ver_parametros = !Yii::$app->request->get('ver_parametros') ? 0 : Yii::$app->request->get('ver_parametros');
            $ver_colores = !Yii::$app->request->get('ver_colores') ? 1 : Yii::$app->request->get('ver_colores');
            $ver_frd = !Yii::$app->request->get('ver_frd') ? $sede->frd : Yii::$app->request->get('ver_frd');
            $size_font = !Yii::$app->request->get('fuente') ? '7' : Yii::$app->request->get('fuente');
            $alto = !Yii::$app->request->get('alto') ? '5' : Yii::$app->request->get('alto');
    
            $grupo = Yii::$app->request->get('grupo');
            
        }

        $grupo = Grupo::find()->where(['id' => $grupo])->one();
        $asignatura = Asignatura::find()->where(['id' => $asignatura])->one();
        $docente = Carga::find()->where(['asignatura' => $asignatura->id])->andWhere(['grupo' => $grupo->id])->andWhere(['eliminado_por' => '0'])->one();
        $docente_nombre = isset($docente) ? $docente->docentes->nombre : 'Sin Docente'; 
        $docente_firma = $docente->docentes->firma != NULL ? $docente->docentes->firma : ''; 
        $director = (isset($grupo->directores->nombre)) ? $grupo->directores->nombre : 'Director(a) de Grupo';        
        
        date_default_timezone_set('America/Bogota');
        setlocale(LC_TIME,"es_ES");


        $pdf = new mPDF(['mode' => 'utf-8',
                         'format' => 'LETTER',
                         'default_font_size' => 7,
                         'default_font' => '7',
                         'margin_left' => 15,
                         'margin_right' => 15,
                         'margin_top' => 26,
                         'margin_bottom' => 20,
                         'margin_header' => 5,
                         'margin_footer' => 5,
                         'orientation' => 'P']);        

        if ($grupo->sedes->pdf_marcadeagua == 'T')
        {
            $pdf->SetWatermarkText($$grupo->sedes->pdf_marcadeagua_contenido);
            $pdf->showWatermarkText = true;
            $pdf->watermarkTextAlpha = 0.1;
        }

        if ($grupo->sedes->pdf_marcadeagua == 'I')
        {
            $pdf->SetWatermarkImage($grupo->sedes->pdf_marcadeagua_contenido);
            $pdf->showWatermarkImage = true;
            $pdf->watermarkImageAlpha = 0.1;
        }

        
        $pdf->setHeader($grupo->sedes->pdf_header);
        $pdf->setFooter($grupo->sedes->pdf_footer);

        $pdf->AliasNbPages();

        $pdf->Open();
        $pdf->AddPage(0,'Letter');

        $pdf->SetFillColor(255);
        $pdf->SetTextColor(0);
        $pdf->SetDrawColor(0,0,0);

        if($ver_fecha == 1)
        {
            $fecha = strftime("%A, %d de %B de %Y");

            $pdf->setX(140);
            $pdf->SetFont('Century Gothic','',$size_font);
            $pdf->Cell(60,5,$fecha,0,0,'R');
            $pdf->Ln(5);
        } 
           
        $pdf->SetFont('Century Gothic','B',10); 
        $pdf->Cell(190,10,Yii::t('app', 'R501-INFORME VALORATIVO'),0,0,'C');

        $pdf->Ln(8);

        $pdf->SetFont('Century Gothic','B',$size_font);
        $pdf->Cell(15,5,Yii::t('app', 'Docente'),0,0); 
        $pdf->SetFont('Century Gothic','',$size_font);  
        
        $pdf->Cell(65,5,$docente_nombre,0,0);
        $pdf->SetFont('Century Gothic','B',$size_font);
        $pdf->Cell(18,5,Yii::t('app', 'Asignatura'),0,0);
        $pdf->SetFont('Century Gothic','',$size_font);
        $pdf->Cell(42,5,$asignatura->asignatura,0,0);
        
        
        $pdf->SetFont('Century Gothic','B',$size_font);
        $pdf->Cell(20,5,Yii::t('app', 'Especialidad'),0,0);
        $pdf->SetFont('Century Gothic','',$size_font);
        $pdf->Cell(50,5,$asignatura->especialidades->especialidad ,0,0);
        
        
        $pdf->Ln(5);
        
        $pdf->SetFont('Century Gothic','B',$size_font);
        $pdf->Cell(15,5,Yii::t('app', 'Sede'),0,0);
        $pdf->SetFont('Century Gothic','',$size_font);    
        $pdf->Cell(55,5,$grupo->sedes->sede,0,0);

        $pdf->SetFont('Century Gothic','B',$size_font);
        $pdf->Cell(15,5,Yii::t('app', 'Jornada'),0,0);
        $pdf->SetFont('Century Gothic','',$size_font);    
        $pdf->Cell(20,5,$grupo->jornadas->jornada,0,0);  

        $pdf->SetFont('Century Gothic','B',$size_font);
        $pdf->Cell(12,5,Yii::t('app', 'Grupo'),0,0);
        $pdf->SetFont('Century Gothic','',$size_font);    
        $pdf->Cell(25,5,$grupo->grupo,0,0);
        
        $pdf->SetFont('Century Gothic','B',$size_font);
        $pdf->Cell(13,5,Yii::t('app', 'Periodo'),0,0);
        $pdf->SetFont('Century Gothic','',$size_font);    
        $pdf->Cell(8,5,$periodo,0,0);

        $pdf->SetFont('Century Gothic','B',$size_font);
        $pdf->Cell(10,5,Yii::t('app', 'Año'),0,0);
        $pdf->SetFont('Century Gothic','',$size_font);    
        $pdf->Cell(8,5,$grupo->sedes->vigencia,0,0);

        $pdf->Ln();
        
        $size_font = $size_font - 1;

        $competencias = Competencia::find()
                                ->where(['asignatura' => $asignatura->id])
                                ->andWhere(['periodo' => $periodo])
                                ->andWhere(['estado' => '1'])
                                ->all(); 

        if($ver_competencia == 1)
        {    

            if (count($competencias) > 0)
            {
                $pdf->SetFont('Century Gothic','B',$size_font);
                $pdf->Cell(10,5,Yii::t('app', 'Competencias'),0,0);
                $pdf->Ln(5);
                $pdf->SetFont('Century Gothic','',$size_font);    
                
                $c = 1;
                foreach ($competencias as $competencia) 
                {
                    $pdf->MultiCell(180,4,$c." - ".mb_strtoupper($competencia->competencia),0,'J',0);
                    $c++;
                }
                $pdf->Ln(5);   
            }

        }
            
        $pdf->Ln(5);
        
        $tipo_calificacion = $grupo->grados->tipo_calificacion;
        $calificacionxcompetencia = $grupo->grados->calificacionxcompetencia;
        $num_calificaciones_saber = $asignatura->num_calificaciones_saber;
        $num_calificaciones_ser = $asignatura->num_calificaciones_ser;    
        $por_calificaciones_saber = $asignatura->por_calificaciones_saber;
        $por_calificaciones_ser = $asignatura->por_calificaciones_ser;    
        $num_calificaciones_psi = $grupo->sedes->num_calificaciones_psi;      



        if($tipo_calificacion=='1') // CALIFICACION POR LETRAS
        {   
            if ($calificacionxcompetencia == '1')  // CALIFICACION POR ASIGNATURA Y LETRAS
            {
                $pdf->SetFont('Century Gothic','B',$size_font);
                $pdf->setFillColor(180);

                $pdf->Cell(55,5,'',0,0,'C',0);

                $ancho = 5 * count($competencias);

                $pdf->Cell(10,5,mb_strtoupper(Yii::t('app', 'Nota')),'LBTR',0,'C',1);

                //$pdf->Cell(10,5,mb_strtoupper(Yii::t('app', 'DSAB')),'LTR',0,'C',0);

                /////////////////////////     PSI      ////////////////////////////////

                if($grupo->sedes->psi == 1)
                {
                    $ancho = 5 * $num_calificaciones_psi;

                    $pdf->Cell($ancho,5,mb_strtoupper(Yii::t('app', 'PSI')),'LBTR',0,'C',1);

                    $pdf->Cell(10,5,mb_strtoupper(Yii::t('app', 'DEF')),'LTR',0,'C',0);
                }

                /////////////////////////     SER      ////////////////////////////////

                if($num_calificaciones_ser > 0)
                {            
                    $ancho = 5 * $num_calificaciones_ser;

                    $pdf->Cell($ancho,5,mb_strtoupper(Yii::t('app', 'SER')),'LBTR',0,'C',1);

                    $pdf->Cell(10,5,mb_strtoupper(Yii::t('app', 'DEF')),'LTR',0,'C',0);
                }
                ///////////////////////////// DEF PERIODO  ////////////////////////

                $pdf->Cell(10,5,mb_strtoupper(Yii::t('app', 'DEF')),'LTR',0,'C',0);
                
                
                /////////////////////////     FRD      ////////////////////////////////

                if($ver_frd == 1)
                {
                    $ancho = 5 * count($competencias);
                    $pdf->Cell($ancho,5,mb_strtoupper(Yii::t('app', 'Frd')),'LBTR',0,'C',1);
                }

                ////////////////////////    OBSERVACIONES     //////////////////////////

                $pdf->Cell(40,5,Yii::t('app', 'OBSERVACIONES'),'LBTR',0,'C',1);
                $pdf->Cell(5,5,Yii::t('app', 'F'),'LBTR',0,'C',1);

                $pdf->Ln(5);

                //////////////////////////////////////   SEGUNDA FILA DEL HEADER   ///////////////////////////

                $pdf->Cell(5,5,Yii::t('app', '#'),'LBTR',0,'C',1);
                $pdf->Cell(50,5,Yii::t('app', 'Estudiante'),'LBTR',0,'C',1);

                //$pdf->Cell(10,5,Yii::t('app', 'Nota'),'LBTR',0,'C',1);
                
                
                $pdf->Cell(10,5,mb_strtoupper(Yii::t('app', 'Saber')),'LBR',0,'C',0);

                if($grupo->sedes->psi == 1)
                {    
                    for ($i=1; $i <= $num_calificaciones_psi; $i++) { 
                        $pdf->Cell(5,5,$i,'LBTR',0,'C',1);
                    }

                    $pdf->Cell(8,5,mb_strtoupper(Yii::t('app', 'PSI')),'LBR',0,'C',0);
                }
                        
                if($num_calificaciones_ser > 0)
                {    
                    for ($i=1; $i <= $num_calificaciones_ser; $i++) { 
                        $pdf->Cell(5,5,$i,'LBTR',0,'C',1);
                    }

                    $pdf->Cell(8,5,mb_strtoupper(Yii::t('app', 'Ser')),'LBR',0,'C',0);
                }
                    
                $pdf->Cell(10,5,mb_strtoupper(Yii::t('app', 'Per')),'LBR',0,'C',0);
               

                $fallas = $grupo->sedes->fallas == 1 ? 'A' : 'M';

                $pdf->Cell(30,5,Yii::t('app', 'GENERALES'),'LBTR',0,'C',1);
                $pdf->Cell(10,5,Yii::t('app', 'ESP'),'LBTR',0,'C',1);
                $pdf->Cell(5,5,$fallas,'LBTR',0,'C',1);
            }
            else  // CALIFICACION POR COMPETENCIAS Y LETRAS
            {

            }
        }
        else  // CALIFICACION POR NUMEROS
        {
            if ($calificacionxcompetencia == '1')  // CALIFICACION POR ASIGNATURA Y LETRAS
            {
                $pdf->SetFont('Century Gothic','B',$size_font);
                $pdf->setFillColor(180);

                $pdf->Cell(55,5,'',0,0,'C',0);

                $ancho = 5 * count($competencias);

                $pdf->Cell(10,5,mb_strtoupper(Yii::t('app', 'Nota')),'LBTR',0,'C',1);

                //$pdf->Cell(10,5,mb_strtoupper(Yii::t('app', 'DSAB')),'LTR',0,'C',0);

                /////////////////////////     PSI      ////////////////////////////////

                if($grupo->sedes->psi == 1)
                {
                    $ancho = 5 * $num_calificaciones_psi;

                    $pdf->Cell($ancho,5,mb_strtoupper(Yii::t('app', 'PSI')),'LBTR',0,'C',1);

                    $pdf->Cell(10,5,mb_strtoupper(Yii::t('app', 'DEF')),'LTR',0,'C',0);
                }

                /////////////////////////     SER      ////////////////////////////////

                if($num_calificaciones_ser > 0)
                {            
                    $ancho = 5 * $num_calificaciones_ser;

                    $pdf->Cell($ancho,5,mb_strtoupper(Yii::t('app', 'SER')),'LBTR',0,'C',1);

                    $pdf->Cell(10,5,mb_strtoupper(Yii::t('app', 'DEF')),'LTR',0,'C',0);
                }
                ///////////////////////////// DEF PERIODO  ////////////////////////

                $pdf->Cell(10,5,mb_strtoupper(Yii::t('app', 'DEF')),'LTR',0,'C',0);
                
                
                /////////////////////////     FRD      ////////////////////////////////

                if($ver_frd == 1)
                {
                    $ancho = 5 * count($competencias);
                    $pdf->Cell($ancho,5,mb_strtoupper(Yii::t('app', 'Frd')),'LBTR',0,'C',1);
                }

                ////////////////////////    OBSERVACIONES     //////////////////////////

                $pdf->Cell(40,5,Yii::t('app', 'OBSERVACIONES'),'LBTR',0,'C',1);
                $pdf->Cell(5,5,Yii::t('app', 'F'),'LBTR',0,'C',1);

                $pdf->Ln(5);

                //////////////////////////////////////   SEGUNDA FILA DEL HEADER   ///////////////////////////

                $pdf->Cell(5,5,Yii::t('app', '#'),'LBTR',0,'C',1);
                $pdf->Cell(50,5,Yii::t('app', 'Estudiante'),'LBTR',0,'C',1);

                //$pdf->Cell(10,5,Yii::t('app', 'Nota'),'LBTR',0,'C',1);
                
                
                $pdf->Cell(10,5,mb_strtoupper(Yii::t('app', 'Saber')),'LBR',0,'C',0);

                if($grupo->sedes->psi == 1)
                {    
                    for ($i=1; $i <= $num_calificaciones_psi; $i++) { 
                        $pdf->Cell(5,5,$i,'LBTR',0,'C',1);
                    }

                    $pdf->Cell(8,5,mb_strtoupper(Yii::t('app', 'PSI')),'LBR',0,'C',0);
                }
                        
                if($num_calificaciones_ser > 0)
                {    
                    for ($i=1; $i <= $num_calificaciones_ser; $i++) { 
                        $pdf->Cell(5,5,$i,'LBTR',0,'C',1);
                    }

                    $pdf->Cell(8,5,mb_strtoupper(Yii::t('app', 'Ser')),'LBR',0,'C',0);
                }
                    
                $pdf->Cell(10,5,mb_strtoupper(Yii::t('app', 'Per')),'LBR',0,'C',0);
               

                $fallas = $grupo->sedes->fallas == 1 ? 'A' : 'M';

                $pdf->Cell(30,5,Yii::t('app', 'GENERALES'),'LBTR',0,'C',1);
                $pdf->Cell(10,5,Yii::t('app', 'ESP'),'LBTR',0,'C',1);
                $pdf->Cell(5,5,$fallas,'LBTR',0,'C',1);
            }
            else  // CALIFICACION POR COMPETENCIAS Y LETRAS
            {

            }
        }


        $pdf->setFillColor(255);
        $pdf->Ln(5);
        $pdf->SetFont('Century Gothic','',$size_font);    
  
        
        $e = 1;        
        

        if($asignatura->especialidad == 1)
        {
            $estudiantes = Academico::find()->select(['tercero.id', 'academico.estudiante', 'academico.grupo'])->joinWith(['estudiantes'])->where(['<', 'tercero.estado', 3])->andWhere(['academico.grupo' => $grupo->id])->orderBy('primer_apellido')->all();  
        }
        else
        {
            $estudiantes = Academico::find()->select(['tercero.id', 'academico.estudiante', 'academico.grupo'])->joinWith(['estudiantes'])->where(['<', 'tercero.estado', 3])->andWhere(['academico.grupo' => $grupo->id])->andWhere(['academico.especialidad' => $asignatura->especialidad])->orderBy('primer_apellido')->all();     
        }

  
        foreach ($estudiantes as $estudiante) 
        {

            $pdf->setFillColor(255);
            $pdf->SetFont('Helvetica','',$size_font);          
            $pdf->Cell(5,3,$e,'LBTR',0,'C',0);
            $pdf->Cell(50,3,mb_strtoupper(utf8_decode($estudiante->estudiantes->nombreinverso)),'LBTR',0,'J',0);
            
            $e++;
            
              
                
                $notas = Calificacion::find()->where(['estudiante' => $estudiante->id])->andWhere(['grupo' => $grupo, 'asignatura' => $asignatura->id, 'periodo' => $periodo])->one();
                


                if($tipo_calificacion=='1') // LETRAS
                {   
                    if ($calificacionxcompetencia == '1')  // CALIFICACION POR ASIGNATURA Y LETRAS
                    {
                        $calificacion = Calificacioncalificaciones::find()
                                ->where(['estudiante' => $estudiante->id])
                                ->andWhere(['grupo' => $grupo->id])
                                ->andWhere(['asignatura' => $asignatura->id])
                                ->andWhere(['periodo' => $periodo])
                                ->andWhere(['tipo' => 'saber'])
                                ->one();

                                //$pdf->Cell(180,3,$grupo->id.'-'.$asignatura->id.'-'.$calificacion->calificacion,'LTRB',0,'C',1);
                        if(isset($calificacion))
                        {
                            $desempeno = new Desempeno();
                            $color = $desempeno->hex2rgb($desempeno->color($calificacion->calificacion,$tipo_calificacion));
                            $desempenos = $desempeno->desempeno($calificacion->calificacion,$tipo_calificacion);

                            $pdf->SetFont('Helvetica','B',$size_font);          
                            $pdf->setFillColor(255);
                            $pdf->SetTextColor(255);
                            $pdf->setFillColor($color['r'],$color['g'],$color['b']);
                            $pdf->Cell(10,3,$calificacion->calificacion,'LTRB',0,'C',1);
                            $pdf->setFillColor(255);
                            $pdf->SetTextColor(0);  


                            // DEFINITIVA PERIODO POR ASIGNATURAS Y LETRAS
                            
                            $color = $desempeno->hex2rgb($desempeno->color($calificacion->calificaciones->definitiva_periodo,$tipo_calificacion));
                            $desempenos = $desempeno->desempeno($calificacion->calificaciones->definitiva_periodo,$tipo_calificacion);

                            $pdf->SetFont('Helvetica','B',$size_font);          
                            $pdf->setFillColor(255);
                            $pdf->SetTextColor(255);
                            $pdf->setFillColor($color['r'],$color['g'],$color['b']);
                            $pdf->Cell(10,3,$calificacion->calificaciones->definitiva_periodo,'LTRB',0,'C',1);
                            $pdf->setFillColor(255);
                            $pdf->SetTextColor(0);    
                            

                        }
                        else
                        {
                            $pdf->Cell(10,3,'','LTRB',0,'C',1);
                        }    
                    }
                    else  // CALIFICACION POR COMPETENCIAS Y LETRAS
                    {
                        foreach ($competencias as $competencia) {

                            $nota = Calificacioncalificaciones::find()
                                    ->where(['estudiante' => $estudiante->id])
                                    ->andWhere(['grupo' => $grupo])
                                    ->andWhere(['asignatura' => $asignatura])
                                    ->andWhere(['periodo' => $periodo])
                                    ->andWhere(['competencia' => $competencia->id])
                                    ->andWhere(['tipo' => 'ser'])
                                    ->one();

                            if(isset($nota))
                            {
                                $desempeno = new Desempeno();
                                $color = $desempeno->hex2rgb($desempeno->color($nota->saber,$tipo_calificacion));
                                $desempenos = $desempeno->desempeno($nota->saber,$tipo_calificacion);

                                $pdf->SetFont('Helvetica','B',$size_font);          
                                $pdf->setFillColor(255);
                                $pdf->SetTextColor(255);
                                $pdf->setFillColor($color['r'],$color['g'],$color['b']);
                                $pdf->Cell(5,3,$nota->saber,'LTRB',0,'C',1);
                                $pdf->setFillColor(255);
                                $pdf->SetTextColor(0);    
                            }
                            else
                            {
                                $pdf->Cell(5,3,'','LTRB',0,'C',1);
                            }    
                            
                
                        }
                    }    
                    
                } 
                else  // NUMEROS
                {
                    if ($calificacionxcompetencia == '2')  // CALIFICACION POR COMPETENCIAS Y NUMEROS
                    {
                        foreach ($competencias as $competencia) {

                            $nota = Calificacioncalificaciones::find()
                                    ->where(['estudiante' => $estudiante->id])
                                    ->andWhere(['tipo' => 'saber'])
                                    ->andWhere(['grupo' => $grupo])
                                    ->andWhere(['asignatura' => $asignatura])
                                    ->andWhere(['periodo' => $periodo])
                                    ->andWhere(['competencia' => $competencia->id])
                                    ->one();

                            if(isset($nota))
                            {
                                $desempeno = new Desempeno();
                                $color = $desempeno->hex2rgb($desempeno->color($nota->calificacion =='' ? 0 : $nota->calificacion,$tipo_calificacion));
                                $desempenos = $desempeno->desempeno($nota->calificacion =='' ? 0 : $nota->calificacion,$tipo_calificacion);

                                $pdf->SetFont('Helvetica','',$size_font);          
                                $pdf->setFillColor(255);
                                $pdf->SetTextColor(255);
                                $pdf->setFillColor($color['r'],$color['g'],$color['b']);
                                $pdf->Cell(5,3,$nota->calificacion,'LTRB',0,'C',1);
                                $pdf->setFillColor(255);
                                $pdf->SetTextColor(0);    
                            }
                            else
                            {
                                $pdf->Cell(5,3,'','LTRB',0,'C',1);
                            }    
                            
                
                        }

                        /// NOTA DEFINITIVA SABER

                        if(isset($notas))
                        {
                            //$desempeno = new Desempeno();
                            //$color = $desempeno->hex2rgb($desempeno->color($notas->definitiva_saber =='' ? 0 : $notas->definitiva_saber,$tipo_calificacion));
                            //$desempenos = $desempeno->desempeno($notas->definitiva_saber =='' ? 0 : $notas->definitiva_saber,$tipo_calificacion);

                            $pdf->SetFont('Helvetica','B',$size_font);          
                            $pdf->setFillColor(255);
                            $pdf->SetTextColor(0);
                            //$pdf->setFillColor($color['r'],$color['g'],$color['b']);
                            $pdf->Cell(8,3,$notas->definitiva_saber,'LTRB',0,'C',1);
                            $pdf->setFillColor(255);
                            $pdf->SetTextColor(0);    
                        }
                        else
                        {
                            $pdf->Cell(8,3,'','LTRB',0,'C',1);
                        }
                        /////// FIN NOTA DEFINITIVA  SABER 


                        /////////////////////////   NOTAS DEL PSI  /////////////////////

                        if($grupo->sedes->psi == 1)
                        { 
                            for ($i=1; $i<=$num_calificaciones_psi; $i++) 
                            { 

                                $psi = Calificacioncalificaciones::find()
                                        ->where(['estudiante' => $estudiante->id])
                                        ->andWhere(['tipo' => 'psi'])
                                        ->andWhere(['grupo' => $grupo])
                                        ->andWhere(['asignatura' => $asignatura])
                                        ->andWhere(['periodo' => $periodo])
                                        ->andWhere(['calificacion_numero' => $i])
                                        ->one();

                                if(isset($psi))
                                {
                                    $desempeno = new Desempeno();
                                    $color = $desempeno->hex2rgb($desempeno->color($psi->calificacion =='' ? 0 : $psi->calificacion,$tipo_calificacion));
                                    $desempenos = $desempeno->desempeno($psi->calificacion =='' ? 0 : $psi->calificacion,$tipo_calificacion);

                                    $pdf->SetFont('Helvetica','',$size_font);          
                                    $pdf->setFillColor(255);
                                    $pdf->SetTextColor(255);
                                    $pdf->setFillColor($color['r'],$color['g'],$color['b']);
                                    $pdf->Cell(5,3,$psi->calificacion,'LTRB',0,'C',1);
                                    $pdf->setFillColor(255);
                                    $pdf->SetTextColor(0);    
                                }
                                else
                                {
                                    $pdf->Cell(5,3,'','LTRB',0,'C',1);
                                }    
                                
                    
                            }
                            /// NOTA DEFINITIVA PSI

                            if(isset($notas))
                            {
                                //$desempeno = new Desempeno();
                                //$color = $desempeno->hex2rgb($desempeno->color($notas->definitiva_psi =='' ? 0 : $notas->definitiva_psi,$tipo_calificacion));
                                //$desempenos = $desempeno->desempeno($notas->definitiva_psi =='' ? 0 : $notas->definitiva_psi,$tipo_calificacion);

                                $pdf->SetFont('Helvetica','B',$size_font);          
                                $pdf->setFillColor(255);
                                $pdf->SetTextColor(0);
                                //$pdf->setFillColor($color['r'],$color['g'],$color['b']);
                                $pdf->Cell(8,3,$notas->definitiva_psi,'LTRB',0,'C',1);
                                $pdf->setFillColor(255);
                                $pdf->SetTextColor(0);    
                            }
                            else
                            {
                                $pdf->Cell(8,3,'','LTRB',0,'C',1);
                            }
                        }
                        /////// FIN NOTA DEFINITIVA  PSI



                        /////////////////////////   NOTAS DEL SER  /////////////////////
                        if($num_calificaciones_ser > 0)
                        {    
                            for ($i=1; $i<=$num_calificaciones_ser; $i++) 
                            { 

                                $ser = Calificacioncalificaciones::find()
                                        ->where(['estudiante' => $estudiante->id])
                                        ->andWhere(['tipo' => 'ser'])
                                        ->andWhere(['grupo' => $grupo])
                                        ->andWhere(['asignatura' => $asignatura])
                                        ->andWhere(['periodo' => $periodo])
                                        ->andWhere(['calificacion_numero' => $i])
                                        ->one();

                                if(isset($ser))
                                {
                                    $desempeno = new Desempeno();
                                    $color = $desempeno->hex2rgb($desempeno->color($ser->calificacion =='' ? 0 : $ser->calificacion,$tipo_calificacion));
                                    $desempenos = $desempeno->desempeno($ser->calificacion =='' ? 0 : $ser->calificacion,$tipo_calificacion);

                                    $pdf->SetFont('Helvetica','',$size_font);          
                                    $pdf->setFillColor(255);
                                    $pdf->SetTextColor(255);
                                    $pdf->setFillColor($color['r'],$color['g'],$color['b']);
                                    $pdf->Cell(5,3,$ser->calificacion,'LTRB',0,'C',1);
                                    $pdf->setFillColor(255);
                                    $pdf->SetTextColor(0);    
                                }
                                else
                                {
                                    $pdf->Cell(5,3,'','LTRB',0,'C',1);
                                }    
                                
                    
                            }

                            /// NOTA DEFINITIVA SER

                            if(isset($notas))
                            {
                                //$desempeno = new Desempeno();
                                //$color = $desempeno->hex2rgb($desempeno->color($notas->definitiva_ser =='' ? 0 : $notas->definitiva_ser,$tipo_calificacion));
                                //$desempenos = $desempeno->desempeno($notas->definitiva_ser =='' ? 0 : $notas->definitiva_ser,$tipo_calificacion);

                                $pdf->SetFont('Helvetica','B',$size_font);          
                                $pdf->setFillColor(255);
                                $pdf->SetTextColor(0);
                                //$pdf->setFillColor($color['r'],$color['g'],$color['b']);
                                $pdf->Cell(8,3,$notas->definitiva_ser,'LTRB',0,'C',1);
                                $pdf->setFillColor(255);
                                $pdf->SetTextColor(0);    
                            }
                            else
                            {
                                $pdf->Cell(8,3,'','LTRB',0,'C',1);
                            }

                        }
                        /////// FIN NOTA DEFINITIVA  SER



                        //////////////////////////////        NOTA DEFINITIVA DEL PERIODO          //////////////////////

                        if(isset($notas))
                        {
                            $desempeno = new Desempeno();
                            $color = $desempeno->hex2rgb($desempeno->color($notas->definitiva_periodo =='' ? 0 : $notas->definitiva_periodo,$tipo_calificacion));
                            $desempenos = $desempeno->desempeno($notas->definitiva_periodo =='' ? 0 : $notas->definitiva_periodo,$tipo_calificacion);

                            $pdf->SetFont('Helvetica','B',$size_font);          
                            $pdf->setFillColor(255);
                            $pdf->SetTextColor(0);
                            $pdf->setFillColor($color['r'],$color['g'],$color['b']);
                            $pdf->Cell(8,3,$notas->definitiva_periodo,'LTRB',0,'C',1);
                            $pdf->setFillColor(255);
                            $pdf->SetTextColor(0);    
                        }
                        else
                        {
                            $pdf->Cell(8,3,'-','LTRB',0,'C',1);
                        }

                        ///////////////////////////////////     FIN NOTA DEFINITIVA PERIODO  //////////////////////////////



                    }
                    else  // CALIFICACION POR ASIGNATURA Y NUMEROS
                    {
                        
                        $calificaciones = explode(',', isset($notas->saber) ? $notas->saber : '');

                        $desempeno = new Desempeno();
                        
                        for ($x=0; $x<count($calificaciones);$x++)
                        {
                            $color = ($calificaciones[$x]=='') ? '#cccccc' :  $desempeno->color($calificaciones[$x],$tipo_calificacion);
                            $desempenos = ($calificaciones[$x]=='') ? 'No Evaluado' : $desempeno->desempeno($calificaciones[$x],$tipo_calificacion);   
                            $nota = ($calificaciones[$x]=='') ? 'NE' : $calificaciones[$x]; 

                            
                            $pdf->Cell(8,3,$nota,'LBTR',0,'C',0);
                        }

                         // DEFINITIVA PERIODO POR ASIGNATURAS Y LETRAS
                            
                        $color = $desempeno->hex2rgb($desempeno->color($calificacion->calificaciones->definitiva_periodo,$tipo_calificacion));
                        $desempenos = $desempeno->desempeno($calificacion->calificaciones->definitiva_periodo,$tipo_calificacion);

                        $pdf->SetFont('Helvetica','B',$size_font);          
                        $pdf->setFillColor(255);
                        $pdf->SetTextColor(255);
                        $pdf->setFillColor($color['r'],$color['g'],$color['b']);
                        $pdf->Cell(10,3,$calificacion->calificaciones->definitiva_periodo,'LTRB',0,'C',1);
                        $pdf->setFillColor(255);
                        $pdf->SetTextColor(0);  
                        
                    }
                }   
                

                ////////////////////////////////       FRD   //////////////////////////////// 


                //if ($grupo->sedes->frd == 1)
                if($ver_frd == 1)
                {
                    if ($calificacionxcompetencia == '1')  // CALIFICACION POR ASIGNATURA Y LETRAS
                    {

                    }
                    else
                    {
                        /*foreach ($competencias as $competencia) 
                        {
                            $pdf->Cell(5,3,'A','LBTR',0,'C',1);
                        }*/

                        foreach ($competencias as $competencia) 
                        {
                            $frd = Calificacionfrd::find()
                                        ->where(['estudiante' => $estudiante->id])
                                        ->andWhere(['grupo' => $grupo])
                                        ->andWhere(['asignatura' => $asignatura->id])
                                        ->andWhere(['periodo' => $periodo])
                                        ->andWhere(['competencia' => $competencia->id])
                                        ->one();
                            
                            if(isset($frd))
                            {
                                $pdf->Cell(5,3,$frd->frd,'LBTR',0,'C',1);   
                            }
                            else
                            {
                                $pdf->Cell(5,3,'','LBTR',0,'C',1);   
                            }                            
                        }

                    }
                    
                }    
                

                $pdf->SetFont('Helvetica','',$size_font);          
                $pdf->setFillColor(255);
                $pdf->SetTextColor(0);
                $pdf->Cell(30,3,isset($notas) ? $notas->observacion_general : '','LBTR',0,'J',1);
                $pdf->Cell(10,3,isset($notas) ? $notas->observacion_especifica != '' ? 'Si' : 'No' : '','LBTR',0,'C',1);

                if ($grupo->sedes->fallas == 1)
                {
                    $fallas = Asistencia::find()->where(['estudiante' => $estudiante->id])->andWhere(['grupo' => $grupo, 'asignatura' => $asignatura->id, 'periodo' => $periodo])->sum('fallas');
                
                    //$pdf->Cell(15,5,$fallas,'LBTR',0,'C',1);
                    $pdf->Cell(5,3,''.$fallas,'LBTR',0,'C',1);    
                }    
                else
                {
                    $pdf->Cell(5,3,''.isset($notas) ? $notas->fallas : '','LBTR',0,'C',1);
                }    
                

                //$pdf->Cell(12,5,$saber = isset($notas->definitiva_saber) ? $notas->definitiva_saber : '','LBTR',0,'C',1);

            

                // CALIFICACION DEL SER

                if($num_calificaciones_ser != 0)
                {
                    if($tipo_calificacion=='1') // CALIFICACION DEL SER EN LETRAS
                    { 
                        if ($calificacionxcompetencia == '1')  // CALIFICACION DEL SER POR ASIGNATURA Y LETRAS
                        {
                            $calificacion = Calificacioncalificaciones::find()
                                    ->where(['estudiante' => $estudiante->id])
                                    ->andWhere(['grupo' => $grupo])
                                    ->andWhere(['asignatura' => $asignatura])
                                    ->andWhere(['periodo' => $periodo])
                                    ->andWhere(['tipo' => 'ser'])
                                    ->one();

                            if(isset($calificacion))
                            {
                                $desempeno = new Desempeno();
                                $color = $desempeno->hex2rgb($desempeno->color($calificacion->calificacion,$tipo_calificacion));
                                $desempenos = $desempeno->desempeno($calificacion->calificacion,$tipo_calificacion);

                                $pdf->SetFont('Helvetica','B',$size_font);          
                                $pdf->setFillColor(255);
                                $pdf->SetTextColor(255);
                                $pdf->setFillColor($color['r'],$color['g'],$color['b']);
                                $pdf->Cell(5,3,$calificacion->calificacion,'LTRB',0,'C',1);
                                $pdf->setFillColor(255);
                                $pdf->SetTextColor(0);    
                            }
                            else
                            {
                                $pdf->Cell(5,3,'','LTRB',0,'C',1);
                            }    
                        }
                        else  // CALIFICACION DEL SER POR COMPETENCIAS Y LETRAS
                        {
                            foreach ($competencias as $competencia) {

                                $nota = Calificacioncalificaciones::find()
                                        ->where(['estudiante' => $estudiante->id])
                                        ->andWhere(['grupo' => $grupo])
                                        ->andWhere(['asignatura' => $asignatura])
                                        ->andWhere(['periodo' => $periodo])
                                        ->andWhere(['competencia' => $competencia->id])
                                        ->andWhere(['tipo' => 'ser'])
                                        ->one();

                                if(isset($nota))
                                {
                                    $desempeno = new Desempeno();
                                    $color = $desempeno->hex2rgb($desempeno->color($nota->saber,$tipo_calificacion));
                                    $desempenos = $desempeno->desempeno($nota->saber,$tipo_calificacion);

                                    $pdf->SetFont('Helvetica','B',$size_font);          
                                    $pdf->setFillColor(255);
                                    $pdf->SetTextColor(255);
                                    $pdf->setFillColor($color['r'],$color['g'],$color['b']);
                                    $pdf->Cell(5,3,$nota->saber,'LTRB',0,'C',1);
                                    $pdf->setFillColor(255);
                                    $pdf->SetTextColor(0);    
                                }
                                else
                                {
                                    $pdf->Cell(5,3,'','LTRB',0,'C',1);
                                }    
                                
                    
                            }
                        }    
                        
                    } 
                    else  // CALIFICACION DEL SER EN NUMEROS
                    {
                        if ($calificacionxcompetencia == '2')  // CALIFICACION POR COMPETENCIAS Y NUMEROS
                        {
                            
                            if($num_calificaciones_ser > 0)
                            {
                                /*
                                if(count($notas) > 0)
                                {
                                    //echo "1";
                                    $notas2 = explode(",", $notas->ser);
                                    $promedio=array_sum($notas2)/count($notas2); 
                                    $desempeno = new Desempeno();
                                    $color = $desempeno->color($promedio);
                                    $desempenos = $desempeno->desempeno($promedio);
                                    //$nota = $desempeno->nota($promedio);
                                    $nota = round($promedio,1);
                                }
                                else
                                {
                                    //echo "2";
                                    $desempeno = new Desempeno();
                                    $color = $desempeno->color('0');
                                    $desempenos = $desempeno->desempeno('0');
                                    //$nota = $desempeno->nota('0');
                                    $nota = 'NE';
                                } 
                                */
                            }    
                              
                        }
                        else  // CALIFICACION POR ASIGNATURA Y NUMEROS
                        {
                            
                            $calificaciones = explode(',', isset($notas->ser) ? $notas->ser : '');

                            $desempeno = new Desempeno();
                            
                            for ($x=0; $x<count($calificaciones);$x++)
                            {
                                $color = ($calificaciones[$x]=='') ? '#cccccc' :  $desempeno->color($calificaciones[$x],$tipo_calificacion);
                                $desempenos = ($calificaciones[$x]=='') ? 'No Evaluado' : $desempeno->desempeno($calificaciones[$x],$tipo_calificacion);   
                                $nota = ($calificaciones[$x]=='') ? 'NE' : $calificaciones[$x]; 

                                
                                $pdf->Cell(8,3,$nota,'LBTR',0,'C',0);
                            }

                            $pdf->setFillColor(230);
                            $pdf->Cell(12,3, isset($notas->definitiva_ser) ? $notas->definitiva_ser : '·','LBTR',0,'C',1);
                            $pdf->setFillColor(180);
                            $pdf->Cell(15,3, isset($notas->definitiva_periodo) ? $notas->definitiva_periodo : '-','LBTR',0,'C',1);
                            
                        }

                    }
                }
                
                $pdf->Ln(3);
            

        }

        $size_font = $size_font + 1;

        $pdf->SetFont('Century Gothic','',$size_font);
        $pdf->Cell(180,6,Yii::t('app', 'En constancia de entrega y publicación del informe valorativo y en constancia firmamos.'),0,0);
        $pdf->Ln(25);
        $pdf->SetFont('Century Gothic','B',$size_font);
/*
        $y = $pdf->y;
        $x = $pdf->x;

        
        if($docente_firma != '' or $docente_firma != NULL )
        {
            $pdf->Image(\Yii::getAlias('@webroot/uploads/'.$docente_firma),$x+30,$y,50);    
        }    
        
        
        $pdf->Image(\Yii::getAlias('@webroot/uploads/'.$grupo->sedes->rector_firma),$x+105,$y,50);
        
        $pdf->setY($pdf->y-15);
        */
        $pdf->Cell(25);
        $pdf->Cell(60,5,$docente_nombre,'T',0,'C',0);

        $pdf->Cell(15);
        $pdf->Cell(60,5,$grupo->sedes->rector_nombre,'T',0,'C',0);
        $pdf->Ln(3);
        $pdf->SetFont('Century Gothic','',$size_font);
        $pdf->Cell(25);
        $pdf->Cell(60,5,Yii::t('app', 'Docente'),'',0,'C',0);
        $pdf->Cell(15);
        $pdf->Cell(60,5,Yii::t('app', 'Rector(a)'),'',0,'C',0);

        
        $pdf->Output("R501-Reporte-Valorativo-Docente-Grupo(".date("d-m-Y_H-i").").pdf",'D');

    }

}