<?php

namespace backend\controllers;

use Yii;
use backend\models\Academico;
use backend\models\Carga;
use backend\models\Tercero;
use backend\models\Asistencia;
use backend\models\AsistenciaSearch;
use backend\models\Grupo;
use backend\models\Asignatura;
use backend\models\Periodo;
use backend\models\TipoInasistencia;
use backend\models\Calificacion;
use backend\models\Desempeno;
use backend\models\Competencia;
use backend\models\Sede;
use backend\models\Compromisosacudiente;
use backend\models\Calificacioncompromisos;
use backend\models\LanzadorForm;


use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\helpers\ArrayHelper;
use yii\data\ActiveDataProvider;
use yii\base\Model;
use yii\helpers\Html;
use yii\web\Response;
use yii\widgets\ActiveForm;

use Mpdf\Mpdf;

class Reporte502Controller extends Controller
{

    public function actionIndex($sede = NULL) // Reporte de Toda la Carga Académica Docente
    {

        if($sede == NULL)
        {    
            $model = new LanzadorForm(['scenario'=>'sede']);

            $model->reporte = Yii::t('app', 'R502-Reporte');
            $model->observaciones = Yii::t('app', 'R502-Observaciones');

            //'Reporte de Carga Académica Docente'
            //'Exporta la carga académica de todos los docentes.; este reporte se genera en formato PDF.'

            if (Yii::$app->request->isAjax && $model->load(Yii::$app->request->post())) {
                Yii::$app->response->format = Response::FORMAT_JSON;
                return ActiveForm::validate($model);
            }

            if ($model->load(Yii::$app->request->post())) {

                $id_tercero = $model->tercero;
            }
            else
            {
                if (Yii::$app->request->isAjax) 
                {
                    return $this->renderAjax('/publica/lanzador', [
                            'model' => $model,
                            'sede' => false,
                            'tercero' => true,
                            'tipo_tercero' => '2',
                            'grado' => false,
                            'grupo' => false,
                            'asignatura' => false,
                            'periodo' => false,
                            'competencia' => false,
                            'columnas' => false,
                            'ver_estandar' => false,
                            'ver_competencia' => false,
                            'ver_niveles' => false,
                            'ver_desempenos' => false,
                            'ver_frd' => false,
                            'ver_fecha' => true,
                            'ver_letrasonumeros' => false,
                        ]);

                    exit;
                }
                else
                {
                    return $this->render('/publica/lanzador', [
                            'model' => $model,
                            'sede' => false,
                            'tercero' => true,
                            'tipo_tercero' => '2',
                            'grado' => false,
                            'grupo' => false,
                            'asignatura' => false,
                            'periodo' => false,
                            'competencia' => false,
                            'columnas' => false,
                            'ver_estandar' => false,
                            'ver_competencia' => false,
                            'ver_niveles' => false,
                            'ver_desempenos' => false,
                            'ver_frd' => false,
                            'ver_fecha' => true,
                            'ver_letrasonumeros' => false,
                        ]);

                    exit;
                }

            }    
        }
        else
        {
            $id_tercero = Yii::$app->request->get('tercero');
        }

        date_default_timezone_set('America/Bogota');
        setlocale(LC_TIME,"es_ES");

        

        $sede = Sede::find()->where(['principal' => '1'])->andWhere(['eliminado_por' => '0'])->one();

        $pdf = new Mpdf(['mode' => 'utf-8',
                         'format' => 'LETTER',
                         'default_font_size' => 0,
                         'default_font' => '',
                         'margin_left' => 15,
                         'margin_right' => 15,
                         'margin_top' => 35,
                         'margin_bottom' => 25,
                         //'margin_header' => 9,
                         //'margin_footer' => 9,
                         'orientation' => 'P']);  
        

        if ($sede->pdf_marcadeagua == 'T' OR $sede->pdf_marcadeagua == 'B')
        {
            $pdf->SetWatermarkText($sede->pdf_marcadeagua_contenido);
            $pdf->showWatermarkText = true;
            $pdf->watermarkTextAlpha = 0.1;
        }

        if ($sede->pdf_marcadeagua == 'I')
        {
            $pdf->SetWatermarkImage($sede->pdf_marcadeagua_contenido);
            $pdf->showWatermarkImage = true;
            $pdf->watermarkImageAlpha = 0.1;
        }

        $pdf->setHeader($sede->pdf_header);
        $pdf->setFooter($sede->pdf_footer);
        
        $pdf->AliasNbPages();

        $i = 1;    

        
        if($id_tercero == "")
        {
            $terceros = Tercero::find()
                        ->where(['tipo_tercero' => 2])
                        ->andWhere(['estado' => 5])
                        ->andWhere(['eliminado_por' => 0])
                        ->orderBy(['primer_apellido' => SORT_ASC, 'segundo_apellido' => SORT_ASC])
                        ->all();    
        }
        else
        {
            $terceros = Tercero::find()
                        ->where(['id' => $id_tercero])
                        ->andWhere(['tipo_tercero' => 2])
                        ->andWhere(['estado' => 5])
                        ->andWhere(['eliminado_por' => 0])
                        ->orderBy(['primer_apellido' => SORT_ASC, 'segundo_apellido' => SORT_ASC])
                        ->all();    
        }
        


        $pdf->AddPage(0,'Letter');

        $pdf->SetFillColor(255);
        $pdf->SetTextColor(0);
        $pdf->SetDrawColor(0,0,0);
    
        /*
        $fecha = strftime("%A, %d de %B de %Y");

        $fecha = Yii::$app->formatter->asDate('now', 'long');

        $pdf->setX(140);
        $pdf->SetFont('helvetica','',8);
        $pdf->Cell(60,5,$fecha,0,0,'R');

        $pdf->Ln(5);
        */
        $pdf->SetFont('Helvetica','B',10);   
        $pdf->Cell(190,10,mb_strtoupper(Yii::t('app', 'INFORME DE CARGA ACADÉMICA DOCENTE CONSOLIDADO')),0,0,'C');

        $pdf->Ln(15);

        foreach ($terceros as $tercero) 
        {

            $pdf->SetFont('Helvetica','B',8);
            $pdf->Cell(15,5,mb_strtoupper(Yii::t('app', 'R502-Docente')),0,0); 
            $pdf->SetFont('Helvetica','',8);

            $nombre = mb_strtoupper($tercero->nombreinverso);

            $pdf->Bookmark($nombre, 0);
            $pdf->Cell(65,5,$nombre,0,0);
            
            $pdf->SetFont('Helvetica','B',8);
            $pdf->Cell(8,5,mb_strtoupper(Yii::t('app', 'CC')),0,0);
            $pdf->SetFont('Helvetica','',8);
            $pdf->Cell(25,5,$tercero->identificacion,0,0);

            $pdf->SetFont('Helvetica','B',8);
            $pdf->Cell(35,5,mb_strtoupper(Yii::t('app', 'R502-Director')),0,0);
            $pdf->SetFont('Helvetica','',8);

            $grupos_director = '';

            foreach ($tercero->director as $grupo) {
                $grupos_director .= $grupo->grupo.' ';
            }

            $pdf->Cell(25,5,mb_strtoupper($grupos_director),0,0);

            $cargas = Carga::find()->where(['docente' => $tercero->id])->andWhere(['estado' => '1'])->andWhere(['eliminado_por' => 0])->orderBy(['asignatura' => SORT_ASC, 'grupo' => SORT_ASC])->all();  
        
            $pdf->Ln(8);
            $pdf->SetFont('Helvetica','B',8);
            $pdf->setFillColor(230);

            if(count($cargas) == '0')
            {
                $pdf->Cell(185,5,Yii::t('app', 'Sin Carga Académica'),0,0,'C',1);
            }   
            else
            {
                $pdf->Cell(5,5,mb_strtoupper(Yii::t('app', '#')),1,0,'C',1);
                $pdf->Cell(70,5,mb_strtoupper(Yii::t('app', 'Asignatura')),1,0,'C',1);
                $pdf->Cell(10,5,mb_strtoupper(Yii::t('app', 'IH')),'LBTR',0,'C',1);
                $pdf->Cell(20,5,mb_strtoupper(Yii::t('app', 'Grupo')),'LBTR',0,'C',1);
                $pdf->Cell(20,5,mb_strtoupper(Yii::t('app', 'Jornada')),'LBTR',0,'C',1);
                $pdf->Cell(60,5,mb_strtoupper(Yii::t('app', 'Sede')),'LBTR',0,'C',1);    
            } 

            $pdf->setFillColor(255);
            $pdf->Ln(5);
            $pdf->SetFont('Helvetica','',8);    
  

            
            $i = 1;
            foreach ($cargas as $carga) 
            {
                $pdf->Cell(5,5,$i,1,0,'C',0);
                $i++;
                $pdf->Cell(70,5,mb_strtoupper($carga->asignaturas->asignatura),1,0,'J',0);  
                $pdf->Cell(10,5,mb_strtoupper($carga->asignaturas->intensidad),1,0,'C',0); 
                $pdf->Cell(20,5,mb_strtoupper($carga->grupos->grupo),1,0,'C',0); 
                $pdf->Cell(20,5,mb_strtoupper($carga->grupos->jornadas->jornada),1,0,'C',0); 
                $pdf->Cell(60,5,mb_strtoupper($carga->grupos->sedes->sede),1,0,'C',0); 

            
                
                $pdf->Ln(5);
                
            }

            $pdf->Ln(3);
            $pdf->SetDrawColor(220,220,220);
            $pdf->Cell(185,1,'','T',0,'C',0);
            $pdf->SetDrawColor(0,0,0);

            $pdf->Ln(2);
        }    
            

            $pdf->SetFont('Helvetica','',8);
            $pdf->Ln(8);
            $fecha = Yii::$app->formatter->asDate('now', 'long');
            $pdf->Cell(180,6,Yii::t('app', 'En constancia de entrega y publicación de la carga académica del personal docente se firma el día ').$fecha.'.',0,0);
            
            $pdf->Ln(30);
            $pdf->SetFont('Helvetica','B',8);
/*
            $y = $pdf->y;
            $x = $pdf->x;
            
            $pdf->Image(\Yii::getAlias('@webroot/uploads/'.$sede->rector_firma),$x+50,$y,50);
            
            $pdf->setY($pdf->y-15);
*/
            $pdf->Cell(60);
            $pdf->Cell(60,5,mb_strtoupper($sede->rector_nombre),'T',0,'C',0);

            $pdf->Ln(3);
            $pdf->SetFont('Helvetica','',8);
            $pdf->Cell(60);
            
            $pdf->Cell(60,5,Yii::t('app', 'RECTOR(A)'),'',0,'C',0);
            $pdf->Ln(1); 


        

        $pdf->Output("R502-Reporte-Carga-Docente-Condensado(".date("d-m-Y_H-i").").pdf",'D');
    }

  

}
