<?php

namespace backend\controllers;

use Yii;
use backend\models\Academico;
use backend\models\Carga;
use backend\models\Tercero;
use backend\models\Asistencia;
use backend\models\AsistenciaSearch;
use backend\models\Grupo;
use backend\models\Asignatura;
use backend\models\Periodo;
use backend\models\TipoInasistencia;
use backend\models\Calificacion;
use backend\models\Desempeno;
use backend\models\Competencia;
use backend\models\Sede;
use backend\models\Compromisosacudiente;
use backend\models\Calificacioncompromisos;
use backend\models\LanzadorForm;


use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\helpers\ArrayHelper;
use yii\data\ActiveDataProvider;
use yii\base\Model;
use yii\helpers\Html;
use yii\web\Response;
use yii\widgets\ActiveForm;

use Mpdf\Mpdf;

class Reporte503Controller extends Controller
{

    public function actionIndex($sede = NULL) // Reporte de Carga Académica Condensado por Grupo.
    {

        if($sede == NULL)
        {    
            $model = new LanzadorForm(['scenario'=>'sede']);

            $model->reporte = Yii::t('app', 'R503-Reporte');
            $model->observaciones = Yii::t('app', 'R503-Observaciones');

            //$model->reporte = 'Reporte de Carga Académica por Grupo';
            //$model->observaciones = 'Exporta la carga académica de todos los grupos.; este reporte se genera en formato PDF.';

            if (Yii::$app->request->isAjax && $model->load(Yii::$app->request->post())) {
                Yii::$app->response->format = Response::FORMAT_JSON;
                return ActiveForm::validate($model);
            }

            if ($model->load(Yii::$app->request->post())) {

                $sede = $model->sede;
                $grado = $model->grado;
                $grupo = $model->grupo;
                $periodo = $model->periodo;

            }
            else
            {
                if (Yii::$app->request->isAjax) 
                {
                    return $this->renderAjax('/publica/lanzador', [
                            'model' => $model,
                            'sede' => true,
                            'tercero' => false,
                            'grado' => true,
                            'grupo' => true,
                            'asignatura' => false,
                            'periodo' => false,
                            'competencia' => false,
                            'columnas' => false,
                            'ver_estandar' => false,
                            'ver_competencia' => false,
                            'ver_niveles' => false,
                            'ver_desempenos' => false,
                            'ver_frd' => false,
                            'ver_fecha' => true,
                            'ver_letrasonumeros' => false,
                        ]);

                    exit;
                }
                else
                {
                    return $this->render('/publica/lanzador', [
                            'model' => $model,
                            'sede' => true,
                            'tercero' => false,
                            'grado' => true,
                            'grupo' => true,
                            'asignatura' => false,
                            'periodo' => false,
                            'competencia' => false,
                            'columnas' => false,
                            'ver_estandar' => false,
                            'ver_competencia' => false,
                            'ver_niveles' => false,
                            'ver_desempenos' => false,
                            'ver_frd' => false,
                            'ver_fecha' => true,
                            'ver_letrasonumeros' => false,
                        ]);

                    exit;
                }
            }    
        }
        else
        {
            $sede = Yii::$app->request->get('sede');
            $grado = Yii::$app->request->get('grado');
            $grupo = Yii::$app->request->get('grupo');
            $periodo = Yii::$app->request->get('periodo');
        }

        date_default_timezone_set('America/Bogota');
        setlocale(LC_TIME,"es_ES");

        
        $sede = Sede::findOne($sede);

        //$sede = Sede::find()->where(['principal' => '1'])->andWhere(['eliminado_por' => '0'])->one();

        $pdf = new Mpdf(['mode' => 'utf-8',
                         'format' => 'LETTER',
                         'default_font_size' => 0,
                         'default_font' => '',
                         'margin_left' => 15,
                         'margin_right' => 15,
                         'margin_top' => 35,
                         'margin_bottom' => 25,
                         //'margin_header' => 9,
                         //'margin_footer' => 9,
                         'orientation' => 'P']);  
        

        if ($sede->pdf_marcadeagua == 'T' OR $sede->pdf_marcadeagua == 'B')
        {
            $pdf->SetWatermarkText($sede->pdf_marcadeagua_contenido);
            $pdf->showWatermarkText = true;
            $pdf->watermarkTextAlpha = 0.1;
        }

        if ($sede->pdf_marcadeagua == 'I')
        {
            $pdf->SetWatermarkImage($sede->pdf_marcadeagua_contenido);
            $pdf->showWatermarkImage = true;
            $pdf->watermarkImageAlpha = 0.1;
        }

        $pdf->setHeader($sede->pdf_header);
        $pdf->setFooter($sede->pdf_footer);
        
        $pdf->AliasNbPages();

        $i = 1;    

        
        
        if ($grado =='' && $grupo =='')
        {
            $grupos = Grupo::find()
                        ->where(['estado' => 1])
                        ->andWhere(['sede' => $sede->id])
                        ->andWhere(['eliminado_por' => 0])
                        ->orderBy(['grado' => SORT_ASC, 'grupo' => SORT_ASC])
                        ->all();
    
        }

        if ($grado != '' && $grupo =='')
        {
            $grupos = Grupo::find()
                        ->where(['grado' => $grado])
                        ->andWhere(['estado' => 1])
                        ->andWhere(['sede' => $sede->id])
                        ->andWhere(['eliminado_por' => 0])
                        ->orderBy(['grado' => SORT_ASC, 'grupo' => SORT_ASC])
                        ->all();
            
        }

        if ($grupo != '')
        {
            $grupos = Grupo::find()
                        ->where(['id' => $grupo])
                        ->andWhere(['estado' => 1])
                        ->andWhere(['sede' => $sede->id])
                        ->andWhere(['eliminado_por' => 0])
                        ->orderBy(['grado' => SORT_ASC, 'grupo' => SORT_ASC]);


            //echo "<br>".$grupos->createCommand()->getRawSql(); // Mostrar SQL   

            $grupos = Grupo::find()
                        ->where(['id' => $grupo])
                        ->andWhere(['estado' => 1])
                        ->andWhere(['sede' => $sede->id])
                        ->andWhere(['eliminado_por' => 0])
                        ->orderBy(['grado' => SORT_ASC, 'grupo' => SORT_ASC])
                        ->all();

            
        }
        
        //$grupos = Grupo::find()->all();                        


        $pdf->AddPage(0,'Letter');

        $pdf->SetFillColor(255);
        $pdf->SetTextColor(0);
        $pdf->SetDrawColor(0,0,0);
    
        /*
        $fecha = strftime("%A, %d de %B de %Y");

        $fecha = Yii::$app->formatter->asDate('now', 'long');

        $pdf->setX(140);
        $pdf->SetFont('helvetica','',8);
        $pdf->Cell(60,5,$fecha,0,0,'R');

        $pdf->Ln(5);
        */
        $pdf->SetFont('Helvetica','B',10);   
        $pdf->Cell(190,10,mb_strtoupper(Yii::t('app', 'INFORME DE CARGA ACADÉMICA POR GRUPO CONSOLIDADO')),0,0,'C');

        $pdf->Ln(15);

        foreach ($grupos as $grupo) 
        {

            $pdf->SetFont('Helvetica','B',8);
            $pdf->Cell(12,5,mb_strtoupper(Yii::t('app', 'Sede')),0,0);
            $pdf->SetFont('Helvetica','',8);    
            $pdf->Cell(60,5,mb_strtoupper($grupo->sedes->sede),0,0);


            $pdf->SetFont('Helvetica','B',8);
            $pdf->Cell(12,5,mb_strtoupper(Yii::t('app', 'Grado')),0,0);
            $pdf->SetFont('Helvetica','',8);
            $pdf->Cell(22,5,mb_strtoupper($grupo->grados->grado),0,0);

            $pdf->SetFont('Helvetica','B',8);
            $pdf->Cell(12,5,mb_strtoupper(Yii::t('app', 'Grupo')),0,0); 
            $pdf->SetFont('Helvetica','',8);

            $nombre = mb_strtoupper($grupo->grupo);

            $pdf->Bookmark(mb_strtoupper(Yii::t('app', 'Grupo').' - '.$nombre), 0);
            $pdf->Cell(22,5,$nombre,0,0);
            
            $pdf->SetFont('Helvetica','B',8);
            $pdf->Cell(17,5,mb_strtoupper(Yii::t('app', 'Jornada')),0,0);
            $pdf->SetFont('Helvetica','',8);    
            $pdf->Cell(30,5,mb_strtoupper($grupo->jornadas->jornada),0,0);              
            
            $pdf->Ln(5);


            $pdf->SetFont('Helvetica','B',8);
            $pdf->Cell(30,5,mb_strtoupper(Yii::t('app', 'Director(a)')),0,0);
            $pdf->SetFont('Helvetica','',8);


            $director = $grupo->director == NULL ? Yii::t('app', 'Sin Asignar') : $grupo->directores->nombre;
            $pdf->Cell(60,5,mb_strtoupper($director),0,0);

            
            $pdf->SetFont('Helvetica','B',8);
            $pdf->Cell(25,5,mb_strtoupper(Yii::t('app', 'Metodología')),0,0);
            $pdf->SetFont('Helvetica','',8);    
            $pdf->Cell(30,5,mb_strtoupper($grupo->metodologias->metodologia),0,0);

            $pdf->SetFont('Helvetica','B',8);
            $pdf->Cell(22,5,mb_strtoupper(Yii::t('app', 'Modalidad')),0,0);
            $pdf->SetFont('Helvetica','',8);    
            $pdf->Cell(50,5,mb_strtoupper($grupo->modalidades->modalidad),0,0);  

            $pdf->Ln(5);

            $pdf->SetFont('Helvetica','B',8);
            $pdf->Cell(22,5,mb_strtoupper(Yii::t('app', 'Especialidad')),0,0);
            $pdf->SetFont('Helvetica','',8);    
            $pdf->Cell(25,5,mb_strtoupper($grupo->especialidades->especialidad),0,0);
/*
            $pdf->SetFont('Helvetica','B',8);
            $pdf->Cell(12,5,'Grupo:',0,0);
            $pdf->SetFont('Helvetica','',8);    
            $pdf->Cell(10,5,$grupo->grupo,0,0);
            
            $pdf->SetFont('Helvetica','B',8);
            $pdf->Cell(13,5,'Periodo:',0,0);
            $pdf->SetFont('Helvetica','',8);    
            $pdf->Cell(8,5,$periodo,0,0);

            $pdf->SetFont('Helvetica','B',8);
            $pdf->Cell(10,5,'Año:',0,0);
            $pdf->SetFont('Helvetica','',8);    
            $pdf->Cell(8,5,date('Y'),0,0);
*/

            $cargas = Carga::find()->where(['grupo' => $grupo->id])->andWhere(['estado' => '1', 'eliminado_por' => '0'])->all();  
        
            $pdf->Ln(8);
            $pdf->SetFont('Helvetica','B',8);
            $pdf->setFillColor(230);

            if(count($cargas) == '0')
            {
                $pdf->Cell(185,5,Yii::t('app', 'Sin Asignaturas Asignadas'),0,0,'C',1);
            }   
            else
            {
                
                $pdf->Cell(135,5,'', 0,0,'C',0);   
                $pdf->Cell(20,5,mb_strtoupper(Yii::t('app', 'SABER')),'LBTR',0,'C',1);
                $pdf->Cell(20,5,mb_strtoupper(Yii::t('app', 'SER')),'LBTR',0,'C',1);
                $pdf->Cell(10,5,mb_strtoupper(Yii::t('app', 'AREA')),'LBTR',0,'C',1);

                $pdf->Ln(5);

                $pdf->Cell(5,5,mb_strtoupper(Yii::t('app', '#')),1,0,'C',1);
                $pdf->Cell(60,5,mb_strtoupper(Yii::t('app', 'Asignatura')),1,0,'C',1);
                $pdf->Cell(10,5,mb_strtoupper(Yii::t('app', 'IH')),'LBTR',0,'C',1);
                $pdf->Cell(60,5,mb_strtoupper(Yii::t('app', 'Docente')),'LBTR',0,'C',1);
                $pdf->Cell(10,5,mb_strtoupper(Yii::t('app', 'C')),'LBTR',0,'C',1);
                $pdf->Cell(10,5,mb_strtoupper(Yii::t('app', '%')),'LBTR',0,'C',1);
                $pdf->Cell(10,5,mb_strtoupper(Yii::t('app', 'C')),'LBTR',0,'C',1);
                $pdf->Cell(10,5,mb_strtoupper(Yii::t('app', '%')),'LBTR',0,'C',1);
                $pdf->Cell(10,5,mb_strtoupper(Yii::t('app', '%')),'LBTR',0,'C',1);
            } 
  
            $pdf->setFillColor(255);
            $pdf->Ln(5);
            $pdf->SetFont('Helvetica','',8);    
  
            $i = 1;
            foreach ($cargas as $carga) 
            {
                $pdf->Cell(5,5,$i,1,0,'C',0);
                $i++;
                $pdf->Cell(60,5,mb_strtoupper($carga->asignaturas->asignatura),1,0,'J',0);  
                $pdf->Cell(10,5,mb_strtoupper($carga->asignaturas->intensidad),1,0,'C',0); 
                $pdf->Cell(60,5,mb_strtoupper($carga->docentes->nombre),1,0,'J',0); 
                $pdf->Cell(10,5,$carga->asignaturas->num_calificaciones_saber,1,0,'C',0); 
                $pdf->Cell(10,5,$carga->asignaturas->por_calificaciones_saber,1,0,'C',0); 
                $pdf->Cell(10,5,$carga->asignaturas->num_calificaciones_ser,1,0,'C',0); 
                $pdf->Cell(10,5,$carga->asignaturas->por_calificaciones_ser,1,0,'C',0); 
                $pdf->Cell(10,5,$carga->asignaturas->por_asig_area,1,0,'C',0); 


                $pdf->Ln(5);
                
            }

            $pdf->Ln(3);
            $pdf->SetDrawColor(220,220,220);
            $pdf->Cell(185,1,'','T',0,'C',0);
            $pdf->SetDrawColor(0,0,0);

            $pdf->Ln(2);
        }    
            

            $pdf->SetFont('Helvetica','',8);
            $pdf->Ln(8);
            $fecha = Yii::$app->formatter->asDate('now', 'long');
            $pdf->Cell(180,6,Yii::t('app', 'En constancia de entrega y publicación de la carga académica del personal docente se firma el día '.$fecha.'.'),0,0);
            
            $pdf->Ln(30);
            $pdf->SetFont('Helvetica','B',8);
/*
            $y = $pdf->y;
            $x = $pdf->x;
            
            $pdf->Image(\Yii::getAlias('@webroot/uploads/'.$sede->rector_firma),$x+50,$y,50);
            
            $pdf->setY($pdf->y-15);
*/
            $pdf->Cell(60);
            $pdf->Cell(60,5,mb_strtoupper($sede->rector_nombre),'T',0,'C',0);

            $pdf->Ln(3);
            $pdf->SetFont('Helvetica','',8);
            $pdf->Cell(60);
            
            $pdf->Cell(60,5,Yii::t('app', 'RECTOR(A)'),'',0,'C',0);
            $pdf->Ln(1); 


        

        $pdf->Output("R503-Reporte-Carga-Grupo-Condensado(".date("d-m-Y_H-i").").pdf",'D');
    }

  

}
