<?php

namespace backend\controllers;

use Yii;
use backend\models\Academico;
use backend\models\Carga;
use backend\models\Tercero;
use backend\models\Asistencia;
use backend\models\AsistenciaSearch;
use backend\models\Grupo;
use backend\models\Asignatura;
use backend\models\Periodo;
use backend\models\TipoInasistencia;
use backend\models\Calificacion;
use backend\models\Desempeno;
use backend\models\Competencia;
use backend\models\Sede;
use backend\models\Compromisosacudiente;
use backend\models\Calificacioncompromisos;
use backend\models\LanzadorForm;
use backend\models\LanzadorDocenteForm;
use backend\models\Calificacioncalificaciones;

use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\helpers\ArrayHelper;
use yii\data\ActiveDataProvider;
use yii\base\Model;
use yii\helpers\Html;
use yii\web\Response;
use yii\widgets\ActiveForm;

use Mpdf\Mpdf;

class Reporte505Controller extends Controller
{

    public function actionIndex($tercero = NULL) // Reporte Valorativo Condensado (Boletín de Calificaciones) por Grupo
    {

        if($tercero == NULL)
        {    
            $model = new LanzadorDocenteForm(['scenario'=>'tercero']);

            $model->reporte = Yii::t('app', 'R505-Reporte');
            $model->observaciones = Yii::t('app', 'R505-Observaciones');
            
            if (Yii::$app->request->isAjax && $model->load(Yii::$app->request->post())) {
                Yii::$app->response->format = Response::FORMAT_JSON;
                return ActiveForm::validate($model);
            }

            if ($model->load(Yii::$app->request->post())) {

                $id_tercero = $model->tercero;

                if($model->carga != '')
                { 
                    $cargas = Carga::find()
                        ->joinWith(['asignaturas','grupos','grupos.grados'])
                        ->where(['carga.id' => $model->carga])
                        ->orderBy(['grado.id' => SORT_ASC, 'grupo.grupo' => SORT_ASC, 'asignatura.asignatura' => SORT_ASC])
                        ->all();
                }
                else
                {
                    $cargas = Carga::find()
                    ->joinWith(['asignaturas','grupos','grupos.grados'])
                    ->where(['carga.docente' => $id_tercero])
                    ->orderBy(['grado.id' => SORT_ASC, 'grupo.grupo' => SORT_ASC, 'asignatura.asignatura' => SORT_ASC])
                    ->all();
                } 

                $ver_parametros = $model->ver_parametros;
                $ver_colores = $model->ver_colores;
                $size_font = $model->fuente;
                $alto = $model->alto;
                
            }
            else
            {
                if (Yii::$app->request->isAjax) 
                {
                    return $this->renderAjax('/publica/lanzador_docente', [
                            'model' => $model,
                            'sede' => false,
                            'tercero' => true,
                            'grado' => true,
                            'grupo' => true,
                            'asignatura' => true,
                            'periodo' => false,
                            'competencia' => false,
                            'columnas' => false,
                            'ver_estandar' => false,
                            'ver_competencia' => false,
                            'ver_niveles' => false,
                            'ver_desempenos' => false,
                            'ver_frd' => false,
                            'ver_fecha' => false,
                            'ver_letrasonumeros' => false,
                            'ver_parametros' => true,
                        ]);

                    exit;
                }
                else
                {
                    return $this->render('/publica/lanzador_docente', [
                            'model' => $model,
                            'sede' => false,
                            'tercero' => true,
                            'grado' => true,
                            'grupo' => true,
                            'asignatura' => true,
                            'periodo' => false,
                            'competencia' => false,
                            'columnas' => false,
                            'ver_estandar' => false,
                            'ver_competencia' => false,
                            'ver_niveles' => false,
                            'ver_desempenos' => false,
                            'ver_frd' => false,
                            'ver_fecha' => false,
                            'ver_letrasonumeros' => false,
                            'ver_parametros' => true,
                        ]);

                    exit;
                }

            }    
        }
        else
        {
            $id_tercero = Yii::$app->request->get('tercero');
            
            $cargas = Carga::find()
                    ->joinWith(['asignaturas','grupos','grupos.grados'])
                    ->where(['carga.docente' => $id_tercero])
                    ->orderBy(['grado.id' => SORT_ASC, 'grupo.grupo' => SORT_ASC, 'asignatura.asignatura' => SORT_ASC])
                    ->all();

            $size_font = 7;
            $ver_colores = 1;
            $alto = 4;
            
        }


        $pdf = new Mpdf(['mode' => 'utf-8',
                         'format' => 'LETTER',
                         'default_font_size' => 0,
                         'default_font' => '',
                         'margin_left' => 15,
                         'margin_right' => 15,
                         'margin_top' => 32,
                         'margin_bottom' => 16,
                         'margin_header' => 9,
                         'margin_footer' => 9,
                         'orientation' => 'P']);  

    foreach ($cargas as $carga) 
    {
        $grupo = Grupo::find()->where(['id' => $carga->grupo])->one();
        $sede = Sede::FindOne($grupo->sede);
        $asignatura = Asignatura::FindOne($carga->asignatura);

        if(isset($grupo->director))
        {
            $director_nombre = $grupo->directores->nombre;
            $director_firma = $grupo->directores->firma != NULL ? $grupo->directores->firma : '';
        }
        else
        {
            $director_nombre = Yii::t('app', 'R505-Director(a) de Grupo');
            $director_firma = '';
        }
        
        if ($sede->pdf_marcadeagua == 'T' OR $sede->pdf_marcadeagua == 'B')
        {
            $pdf->SetWatermarkText($sede->pdf_marcadeagua_contenido);
            $pdf->showWatermarkText = true;
            $pdf->watermarkTextAlpha = 0.1;
        }

        if ($sede->pdf_marcadeagua == 'I')
        {
            $pdf->SetWatermarkImage($sede->pdf_marcadeagua_contenido);
            $pdf->showWatermarkImage = true;
            $pdf->watermarkImageAlpha = 0.1;
        }

        $pdf->setHeader($sede->pdf_header);
        $pdf->setFooter($sede->pdf_footer);
        
        $pdf->AliasNbPages();

            if($grupo->grados->calificacionxcompetencia == 1)
            {
                $num_calificaciones_saber = 1;
            }   
            else
            {
                $competencias = Competencia::find()->where(['grado' => $grupo->grado])->where(['asignatura' => $asignatura->id])->count();

                $num_calificaciones_saber = ($competencias > 0) ? $competencias : 10;
            } 

            $num_calificaciones_ser = $asignatura->num_calificaciones_ser;

            $pdf->AddPage(0,'Letter');

            $pdf->SetFillColor(255);
            $pdf->SetTextColor(0);
            $pdf->SetDrawColor(0,0,0);   
            
            $pdf->SetFont('Helvetica','B',$size_font + 2);   
            $pdf->Cell(185,$alto + 2,Yii::t('app', 'R505-SABANA DE NOTAS'),0,0,'C',0);

            $pdf->Ln($alto + 2);        
            
            $pdf->SetFont('Helvetica','B',$size_font);
            $pdf->Cell(10,$alto + 2,Yii::t('app', 'Sede'),0,0);
            $pdf->SetFont('Helvetica','',$size_font);    
            $pdf->Cell(45,$alto + 2,$grupo->sedes->sede,0,0);

            $pdf->SetFont('Helvetica','B',$size_font);
            $pdf->Cell(10,$alto + 2,Yii::t('app', 'Grupo'),0,0);
            $pdf->SetFont('Helvetica','',$size_font);    
            $pdf->Cell(15,$alto + 2,$grupo->grupo,0,0);

            $pdf->SetFont('Helvetica','B',$size_font);
            $pdf->Cell(12,$alto + 2,Yii::t('app', 'Jornada'),0,0);
            $pdf->SetFont('Helvetica','',$size_font);    
            $pdf->Cell(15,$alto + 2,$grupo->jornadas->jornada,0,0);  

            $pdf->SetFont('Helvetica','B',$size_font);
            $pdf->Cell(15,$alto + 2,Yii::t('app', 'Asignatura'),0,0);
            $pdf->SetFont('Helvetica','',$size_font);    
            $pdf->Cell(20,$alto + 2,mb_strtoupper($asignatura->asignatura),0,0); 

            //$carga = Carga::find()->where(['asignatura' => $asignatura->id])->andWhere(['grupo' => $grupo->id])->one();

            $pdf->SetFont('Helvetica','B',$size_font);
            $pdf->Cell(12,$alto + 2,Yii::t('app', 'Docente'),0,0);
            $pdf->SetFont('Helvetica','',$size_font);    
            $pdf->Cell(50,$alto + 2,mb_strtoupper(isset($carga) ? isset($carga->docente) ? $carga->docentes->nombre : 'Sin Definir' : 'Sin Carga'),0,0); 
            
            $pdf->SetFont('Helvetica','B',$size_font);
            $pdf->Cell(8,$alto + 2,Yii::t('app', 'Año'),0,0);
            $pdf->SetFont('Helvetica','',$size_font);    
            $pdf->Cell(8,$alto + 2,date('Y'),0,0);

            $pdf->Ln($alto + 4);


            $pdf->setFillColor(230);
            $pdf->SetFont('Helvetica','B',$size_font - 2);
            
            $pdf->Cell(5,$alto * 2,Yii::t('app', '#'),1,0,'J',1);
            $pdf->Cell(50,$alto * 2,mb_strtoupper(Yii::t('app', 'Estudiante')),1,0,'C',1);
            
            $pdf->Cell(10 * $num_calificaciones_saber,$alto,mb_strtoupper(Yii::t('app', 'Saber')),1,0,'C',1);
            
            if($num_calificaciones_ser > 0)
            {
                $pdf->Cell(10 * $num_calificaciones_saber,$alto,mb_strtoupper(Yii::t('app', 'Ser')),1,0,'C',1);
            }

            $pdf->Cell(10,$alto * 2,mb_strtoupper(Yii::t('app', 'DEF')),1,0,'C',1); 
            $pdf->Cell(10,$alto * 2,mb_strtoupper(Yii::t('app', 'NIV')),1,0,'C',1); 
            $pdf->Cell(10,$alto * 2,mb_strtoupper(Yii::t('app', 'FALLAS')),1,0,'C',1); 
            $pdf->Cell(0,$alto,'',0,1,'C',0); 

            $pdf->Cell(55,$alto,'',0,0,'C',0);

            for ($x=1; $x <= $num_calificaciones_saber; $x++)
            {
                $pdf->Cell(10,$alto,$x,1,0,'C',1); 
            }

            if($num_calificaciones_ser > 0)
            {    
                for ($x=1; $x <= $num_calificaciones_ser; $x++)
                {
                    $pdf->Cell(10,$alto,$x,1,0,'C',1); 
                }    
            }
            
            $pdf->Ln($alto);
            
            $estudiantes = Academico::find()->select(['tercero.id', 'academico.estudiante', 'academico.grupo','academico.especialidad'])->joinWith(['estudiantes'])->where(['<', 'tercero.estado', 3])->andWhere(['academico.grupo' => $grupo->id])->orderBy(['primer_apellido' => SORT_ASC, 'segundo_apellido' => SORT_ASC, 'primer_nombre' => SORT_ASC])->all();  
            
            $x=1;
 
            foreach ($estudiantes as $estudiante) 
            {
                
                $pdf->setFillColor(255);
                $pdf->SetFont('Helvetica','',$size_font-2);  

                $nombre = mb_strtoupper($estudiante->estudiantes->nombreinverso);

                $pdf->Cell(5,$alto,$x,1,0,'J',0);
                $pdf->Cell(50,$alto,$nombre,1,0,'J',0);
                
                $x++;
                
                for ($i=0; $i < $num_calificaciones_saber ; $i++) 
                { 
                    $pdf->Cell(10,$alto,'','LBTR',0,'C',0);
                }

                if($num_calificaciones_ser > 0)
                {    
                    for ($i=0; $i < $num_calificaciones_ser ; $i++) 
                    { 
                        $pdf->Cell(10,$alto,'','LBTR',0,'C',0);
                    }
                }

                $pdf->setFillColor($ver_colores == 1 ? 230 : 255);
                $pdf->Cell(10,$alto,'',1,0,'C',1);
                $pdf->Cell(10,$alto,'',1,0,'C',1);
                $pdf->Cell(10,$alto,'',1,0,'C',1);
                
                $pdf->Ln($alto);
                    
            }
            
            $pdf->Ln(30);
            $pdf->SetFont('Helvetica','B',8);

            $y = $pdf->y;
            $x = $pdf->x;
            
            $pdf->Image(\Yii::getAlias('@webroot/uploads/'.$sede->rector_firma),$x+65,$y,50);
            
            $pdf->setY($pdf->y-15);

            $pdf->Cell(60);
            $pdf->Cell(60,5,$sede->rector_nombre,'T',0,'C',0);

            //$pdf->Cell(60,5,mb_strtoupper(isset($carga) ? isset($carga->docente) ? $carga->docentes->nombre : 'Sin Definir' : 'Sin Carga'),'T',0,'C',0);

            $pdf->Ln(3);
            $pdf->SetFont('Helvetica','',8);
            $pdf->Cell(60);
            
            $pdf->Cell(60,5,Yii::t('app', 'Rector(a)'),'',0,'C',0);
            $pdf->Ln(1);

        }

        $pdf->Output("R505-Auxiliar-Notas-Asignatura(".date("d-m-Y_H-i").").pdf",'D');
    }  

}
