<?php

namespace backend\controllers;

use Yii;
use yii\web\Controller;
use yii\web\Response;
use yii\widgets\ActiveForm;


use backend\models\Grado;
use backend\models\Estandar;
use backend\models\Asignatura;
use backend\models\Competencia;
use backend\models\Nivel;
use backend\models\Frd;
use backend\models\LanzadorForm;


use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Style\Alignment;
use PhpOffice\PhpSpreadsheet\Style\Border;
use PhpOffice\PhpSpreadsheet\Style\Fill;
use PhpOffice\PhpSpreadsheet\Style\Style;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpSpreadsheet\Helper\Sample;
use PhpOffice\PhpSpreadsheet\IOFactory;
use PhpOffice\PhpSpreadsheet\Worksheet\PageSetup;


class Reporte507Controller extends Controller
{

    public function actionIndex($grado = NULL, $asignatura = NULL) // Reporte de Lista de Alumnos por Asignatura y Grupo
    {
        if($grado == NULL && $asignatura == NULL)
        {    
            $model = new LanzadorForm(['scenario'=>'sede']);

            $model->reporte = Yii::t('app', 'R507-Reporte');
            $model->observaciones = Yii::t('app', 'R507-Observaciones');

            if (Yii::$app->request->isAjax && $model->load(Yii::$app->request->post())) {
                Yii::$app->response->format = Response::FORMAT_JSON;
                return ActiveForm::validate($model);
            }

            if ($model->load(Yii::$app->request->post())) {

                $sede = $model->sede;
                $id_grado = $model->grado;
                $id_asignatura = $model->asignatura;
                $periodo = $model->periodo;
                
            }
            else
            {
                if (Yii::$app->request->isAjax) 
                {
                    return $this->renderAjax('/publica/lanzador', [
                            'model' => $model,
                            'sede' => true,
                            'tercero' => false,
                            'grado' => true,
                            'grupo' => false,
                            'asignatura' => true,
                            'periodo' => true,
                            'competencia' => false,
                            'columnas' => false,
                            'ver_estandar' => false,
                            'ver_competencia' => false,
                            'ver_niveles' => false,
                            'ver_desempenos' => false,
                            'ver_frd' => false,
                            'ver_fecha' => false,
                            'ver_letrasonumeros' => false,
                        ]);

                    exit;
                }
                else
                {
                    return $this->render('/publica/lanzador', [
                            'model' => $model,
                            'sede' => true,
                            'tercero' => false,
                            'grado' => true,
                            'grupo' => false,
                            'asignatura' => true,
                            'periodo' => true,
                            'competencia' => false,
                            'columnas' => false,
                            'ver_estandar' => false,
                            'ver_competencia' => false,
                            'ver_niveles' => false,
                            'ver_desempenos' => false,
                            'ver_frd' => false,
                            'ver_fecha' => false,
                            'ver_letrasonumeros' => false,
                        ]);

                    exit;
                }
            }    
        }
        else
        {
            $sede = Yii::$app->request->get('sede');
            $id_grado = Yii::$app->request->get('grado');
            $id_asignatura = Yii::$app->request->get('asignatura');
            $periodo = Yii::$app->request->get('periodo');
        }    

        date_default_timezone_set('America/Bogota');

        /// MARGENES HOJA
        $top = '1';
        $right = '0.5';
        $left = '0.5';
        $bottom = '1';

        $Excel = new Spreadsheet();

        $Excel->getProperties()
        ->setCreator("Sonic")
        ->setLastModifiedBy("Sonic")
        ->setTitle("Reporte 507 - Listado de Estandares, Competencias, Niveles y FRD")
        ->setDescription("Documento generado por Sonic")
        ->setCategory("Listados"); 



        $this->render('/reporte/_headerandfooter_excel_landscape', ['Excel' => $Excel]);    

        $Excel->setActiveSheetIndex(0);

        $Excel->getActiveSheet()->getPageSetup()->setOrientation(PageSetup::ORIENTATION_LANDSCAPE);
        $Excel->getActiveSheet()->getPageSetup()->setPaperSize(PageSetup::PAPERSIZE_FOLIO);
        $Excel->getActiveSheet()->getPageSetup()->setHorizontalCentered(true);
        $Excel->getActiveSheet()->getPageMargins()->setTop($top);
        $Excel->getActiveSheet()->getPageMargins()->setRight($right);
        $Excel->getActiveSheet()->getPageMargins()->setLeft($left);
        $Excel->getActiveSheet()->getPageMargins()->setBottom($bottom);
        
        $Excel->getActiveSheet()->setTitle('Listado');

        $style = array(
            'alignment' => array(
                'horizontal' => Alignment::HORIZONTAL_CENTER,
            )
        );

        
        $Excel->getActiveSheet()->mergeCells('A1:H1');
        $Excel->getActiveSheet()->setCellValue('A1', mb_strtoupper(Yii::t('app', 'Listado de Estandares, Competencias, Niveles y FRDs')));
        $Excel->getActiveSheet()->getStyle('A1')->applyFromArray($style);
        $Excel->getActiveSheet()->getStyle('A1')->getFont()->setBold(true);

        

        if(!$id_grado)
        {
            //$Excel->getActiveSheet()->setCellValue('I2', '#178');
            $grados = Grado::find()->Where(['eliminado_por' => '0'])->orderBy(['id' => SORT_ASC])->all();
            //$grados = Grado::find()->Where(['estado' => '1'])->orderBy(['id' => SORT_ASC])->all();
            //echo "<br>L176  :".$estudiantes->createCommand()->getRawSql(); // Mostrar SQL 
        }
        else
        {
            //$Excel->getActiveSheet()->setCellValue('I2', '#184');
            //$grados = Grado::find()->Where(['id' => $id_grado])->andWhere(['estado' => '1'])->orderBy(['id' => SORT_ASC])->all();  
            $grados = Grado::find()->Where(['id' => $id_grado])->andWhere(['eliminado_por' => '0'])->orderBy(['id' => SORT_ASC])->all();  
        }

        
        $i = 4;
        $x = 1;

        $grado_anterior = 0;  

        $Excel->getActiveSheet()->setCellValue('A'.$i, mb_strtoupper(Yii::t('app', '#')));
        $Excel->getActiveSheet()->setCellValue('B'.$i, mb_strtoupper(Yii::t('app', 'Grado')));
        $Excel->getActiveSheet()->setCellValue('C'.$i, mb_strtoupper(Yii::t('app', 'Asignatura')));
        $Excel->getActiveSheet()->setCellValue('D'.$i, mb_strtoupper(Yii::t('app', 'Periodo')));
        $Excel->getActiveSheet()->setCellValue('E'.$i, mb_strtoupper(Yii::t('app', 'Estándar')));
        $Excel->getActiveSheet()->setCellValue('F'.$i, mb_strtoupper(Yii::t('app', 'Competencia')));
        $Excel->getActiveSheet()->setCellValue('G'.$i, mb_strtoupper(Yii::t('app', 'Niveles de Desempeño')));
        $Excel->getActiveSheet()->setCellValue('H'.$i, mb_strtoupper(Yii::t('app', 'Fortalezas, Recomendaciones y Debilidades')));  


        $Excel->getActiveSheet()->getStyle('A'.$i.':H'.$i)->getBorders()->getAllBorders()->setBorderStyle(Border::BORDER_THIN);

        $Excel->getActiveSheet()->getStyle('A'.$i.':'.$Excel->getActiveSheet()->getHighestColumn().$i)->applyFromArray(
            array(
                'font'  => array(
                    'bold'  => true,
                    'size'  => 12,
                    'name'  => 'Calibri'
                ),
                'fill' => array(
                    'fillType' => Fill::FILL_SOLID,
                    'color' => array('rgb' => 'BBBBBB')
                ),
                'alignment' => array(
                  'horizontal' => Alignment::HORIZONTAL_CENTER,
                )
              )
        );

        $Excel->getActiveSheet()->setAutoFilter('A'.$i.':'.$Excel->getActiveSheet()->getHighestColumn().$i);
        
        $i++;

        foreach ($grados as $grado) 
        {
            if(!$id_asignatura)
            {
                //$asignaturas = Asignatura::find()->Where(['grado' => $grado->id])->andWhere(['estado' => '1'])->orderBy(['id' => SORT_ASC])->all();  
                $asignaturas = Asignatura::find()->Where(['grado' => $grado->id])->andWhere(['eliminado_por' => '0'])->orderBy(['id' => SORT_ASC])->all();  
            }
            else
            {
                //$asignaturas = Asignatura::find()->Where(['id' => $id_asignatura])->andWhere(['grado' => $grado->id])->andWhere(['estado' => '1'])->orderBy(['id' => SORT_ASC])->all();   
                $asignaturas = Asignatura::find()->Where(['id' => $id_asignatura])->andWhere(['grado' => $grado->id])->andWhere(['eliminado_por' => '0'])->orderBy(['id' => SORT_ASC])->all();   
            }

            $periodo_ini = $periodo != '' ? $periodo : '1';
            $periodo_fin = $periodo != '' ? $periodo : '4';


            for ($p=$periodo_ini; $p <= $periodo_fin; $p++) 
            { 
                foreach ($asignaturas as $asignatura) 
                {

                    if($x == 1)
                    {
                        $g = ($id_grado != '') ? mb_strtoupper(Yii::t('app', 'Grado').' '.$grado->grado) : mb_strtoupper(Yii::t('app', 'Todos los Grados'));
                        $a = ($id_asignatura != '') ? mb_strtoupper(Yii::t('app', 'Asignatura').' '.$asignatura->asignatura) : mb_strtoupper(Yii::t('app', 'Todas las Asignaturas'));
                        $per = ($periodo != '') ? mb_strtoupper(Yii::t('app', 'Periodo').' '.$periodo) : mb_strtoupper(Yii::t('app', 'Todos los Periodos'));
                        
                        $Excel->getActiveSheet()->mergeCells('A2:H2');
                        $Excel->getActiveSheet()->setCellValue('A2', $g.' - '.$a.' - '.$per);

                        $Excel->getActiveSheet()->getStyle('A2')->applyFromArray($style);
                        $Excel->getActiveSheet()->getStyle('A2')->getFont()->setBold(true);
                    }

                    $estandares = Estandar::find()->Where(['grado' => $grado->id])->andWhere(['asignatura' => $asignatura->id])->andWhere(['periodo' => $p])->andWhere(['eliminado_por' => '0'])->orderBy(['id' => SORT_ASC])->all();  
                    //$estandares = Estandar::find()->Where(['grado' => $grado->id])->andWhere(['asignatura' => $asignatura->id])->andWhere(['periodo' => $p])->andWhere(['estado' => '1'])->orderBy(['id' => SORT_ASC])->all();  

                    foreach ($estandares as $estandar) 
                    {
                        $competencias = Competencia::find()->Where(['estandar' => $estandar->id])->andWhere(['grado' => $grado->id])->andWhere(['asignatura' => $asignatura->id])->andWhere(['periodo' => $p])->andWhere(['eliminado_por' => '0'])->orderBy(['id' => SORT_ASC])->all();  
                        //$competencias = Competencia::find()->Where(['estandar' => $estandar->id])->andWhere(['grado' => $grado->id])->andWhere(['asignatura' => $asignatura->id])->andWhere(['periodo' => $p])->andWhere(['estado' => '1'])->orderBy(['id' => SORT_ASC])->all();  


                        foreach ($competencias as $competencia) 
                        {
                            $Excel->getActiveSheet()->setCellValue('A'.$i, $x);  
                            $Excel->getActiveSheet()->setCellValue('B'.$i, mb_strtoupper($grado->grado));
                            $Excel->getActiveSheet()->setCellValue('C'.$i, mb_strtoupper($asignatura->asignatura));
                            $Excel->getActiveSheet()->setCellValue('D'.$i, mb_strtoupper(Yii::t('app', 'Periodo').' '.$p));
                            $Excel->getActiveSheet()->setCellValue('E'.$i, mb_strtoupper($estandar->estandar));
                            $Excel->getActiveSheet()->setCellValue('F'.$i, mb_strtoupper($competencia->competencia));

                            //$niveles = Nivel::find()->Where(['competencia' => $competencia->id])->andWhere(['estado' => '1'])->orderBy(['desempeno' => SORT_DESC])->all();  
                            $niveles = Nivel::find()->Where(['competencia' => $competencia->id])->andWhere(['eliminado_por' => '0'])->orderBy(['desempeno' => SORT_DESC])->all();  

                            $data_niveles = '';
                            $data_frds = '';

                            $n = 1;
                            foreach ($niveles as $nivel) 
                            {
                                $data_niveles .= '('.$nivel->desempenos->desempeno.') '.$nivel->nivel.PHP_EOL;

                                $frds = Frd::find()->Where(['nivel' => $nivel->id])->andWhere(['competencia' => $competencia->id])->andWhere(['nivel' => $nivel->id])->andWhere(['eliminado_por' => '0'])->orderBy(['frd_tipo' => SORT_ASC])->all();  
                                //$frds = Frd::find()->Where(['nivel' => $nivel->id])->andWhere(['competencia' => $competencia->id])->andWhere(['nivel' => $nivel->id])->andWhere(['estado' => '1'])->orderBy(['frd_tipo' => SORT_ASC])->all();  

                                $f = 1;
                                foreach ($frds as $frd) 
                                {   
                                    $data_frds .= '('.$nivel->desempenos->desempeno.') ('.$frd->tipos->tipo.') '.$frd->descripcion.PHP_EOL;
                                    $f++;
                                }

                                $n++;
                            }

                            $Excel->getActiveSheet()->setCellValue('G'.$i, mb_strtoupper($data_niveles));
                            $Excel->getActiveSheet()->setCellValue('H'.$i, mb_strtoupper($data_frds));

                            $Excel->getActiveSheet()->getStyle('A'.$i.':H'.$i)->getBorders()->getAllBorders()->setBorderStyle(Border::BORDER_THIN);

                            $i++;
                            $x++;
                        }
                    }
                }
            }

            

        }

        
        $Excel->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);
        $Excel->getActiveSheet()->getColumnDimension('A')->setWidth(4);
        $Excel->getActiveSheet()->getStyle('B4:B'.$i)->getFont()->setBold(true);
        
        foreach (range('A', $Excel->getActiveSheet()->getHighestDataColumn()) as $col) 
        {
            $Excel->getActiveSheet()->getColumnDimension($col)->setAutoSize(true);
        } 

        $Excel->getActiveSheet()->getStyle('A4:H'.$i)->getAlignment()->setWrapText(true); 
        $Excel->getActiveSheet()->getStyle('A4:H'.$i)->getAlignment()->setVertical(\PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_TOP);
        
        $Excel->setActiveSheetIndex('0');

        if(!isset($grado))
        {
            $filename = "R507-Caracterizacion-Competencias(".date("d-m-Y_H-i").").xlsx";
        }    
        else
        {
            $filename = "R507-Caracterizacion-Competencias-Grado(".date("d-m-Y_H-i").").xlsx";
        } 

        

        // Redirect output to a client’s web browser (Xlsx)
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment;filename="' . $filename . '"');
        header('Cache-Control: max-age=0');

         
        // If you're serving to IE over SSL, then the following may be needed
        header('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
        header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT'); // always modified
        header('Cache-Control: cache, must-revalidate'); // HTTP/1.1
        header('Pragma: public'); // HTTP/1.0

        $writer = IOFactory::createWriter($Excel, 'Xlsx');
        $writer->save('php://output');
        exit;


 
    }

}
