<?php

namespace backend\controllers;

use Yii;
use backend\models\Academico;
use backend\models\Carga;
use backend\models\Tercero;
use backend\models\Asistencia;
use backend\models\AsistenciaSearch;
use backend\models\Grupo;
use backend\models\Asignatura;
use backend\models\Periodo;
use backend\models\TipoInasistencia;
use backend\models\Calificacion;
use backend\models\Desempeno;
use backend\models\Competencia;
use backend\models\Sede;
use backend\models\Compromisosacudiente;
use backend\models\Calificacioncompromisos;
use backend\models\LanzadorForm;
use backend\models\Calificacioncalificaciones;

use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\helpers\ArrayHelper;
use yii\data\ActiveDataProvider;
use yii\base\Model;
use yii\helpers\Html;
use yii\web\Response;
use yii\widgets\ActiveForm;

use Mpdf\Mpdf;

class Reporte701Controller extends Controller
{

    public function actionIndex($grupo = NULL, $asignatura = NULL) // Reporte Valorativo Condensado (Boletín de Calificaciones) por Grupo
    {
        if($grupo == NULL && $asignatura == NULL)
        {    
            $model = new LanzadorForm(['scenario'=>'grupo-periodo']);

            $model->reporte = Yii::t('app', 'R701-Reporte');
            $model->observaciones = Yii::t('app', 'R701-Observaciones');
            
            if (Yii::$app->request->isAjax && $model->load(Yii::$app->request->post())) {
                Yii::$app->response->format = Response::FORMAT_JSON;
                return ActiveForm::validate($model);
            }

            if ($model->load(Yii::$app->request->post())) {

                $grado = $model->grado;
                $grupo = $model->grupo;
                $periodo = $model->periodo;
                $ver_fecha = $model->ver_fecha;
                $ver_letrasonumeros = $model->ver_letrasonumeros;
                $ver_parametros = $model->ver_parametros;
                $ver_colores = $model->ver_colores;
                $size_font = $model->fuente;
                $alto = $model->alto;
                
            }
            else
            {
                if (Yii::$app->request->isAjax) 
                {
                     return $this->renderAjax('/publica/lanzador', [
                            'model' => $model,
                            'sede' => true,
                            'tercero' => false,
                            'grado' => true,
                            'grupo' => true,
                            'asignatura' => false,
                            'periodo' => true,
                            'competencia' => false,
                            'columnas' => false,
                            'ver_estandar' => false,
                            'ver_competencia' => false,
                            'ver_niveles' => false,
                            'ver_desempenos' => false,
                            'ver_frd' => false,
                            'ver_fecha' => true,
                            'ver_letrasonumeros' => true,
                            'ver_emoticons' => false,
                            'ver_parametros' => true,
                        ]);

                    exit;   
                } else {
                    return $this->render('/publica/lanzador', [
                            'model' => $model,
                            'sede' => true,
                            'tercero' => false,
                            'grado' => true,
                            'grupo' => true,
                            'asignatura' => false,
                            'periodo' => true,
                            'competencia' => false,
                            'columnas' => false,
                            'ver_estandar' => false,
                            'ver_competencia' => false,
                            'ver_niveles' => false,
                            'ver_desempenos' => false,
                            'ver_frd' => false,
                            'ver_fecha' => true,
                            'ver_letrasonumeros' => true,
                            'ver_emoticons' => false,
                            'ver_parametros' => true,
                        ]);
                }

                
            }    
        }
        else
        {
            $grado = Yii::$app->request->get('grado');
            $grupo = Yii::$app->request->get('grupo');
            $periodo = Yii::$app->request->get('periodo');

            $ver_fecha = Yii::$app->request->get('ver_fecha');
            $ver_letrasonumeros = Yii::$app->request->get('ver_letrasonumeros');
            $ver_parametros = Yii::$app->request->get('ver_parametros');
            $ver_colores = Yii::$app->request->get('ver_colores');
            $size_font = Yii::$app->request->get('fuente');
            $alto = Yii::$app->request->get('alto');
            
        }

        date_default_timezone_set('America/Bogota');
        setlocale(LC_TIME,"es_ES");

        $grupo = Grupo::find()->where(['id' => $grupo])->one();

        if(isset($grupo->director))
        {
            $director_nombre = $grupo->directores->nombre;
            $director_firma = $grupo->directores->firma != NULL ? $grupo->directores->firma : '';
        }
        else
        {
            $director_nombre = Yii::t('app', 'R701-Director(a) de Grupo');
            //'Director(a) de Grupo'
            $director_firma = '';
        }
        
        $sede = Sede::FindOne($grupo->sede);

        $pdf = new Mpdf(['mode' => 'utf-8',
                         'format' => 'LETTER',
                         'default_font_size' => 0,
                         'default_font' => '',
                         'margin_left' => 15,
                         'margin_right' => 15,
                         'margin_top' => 35,
                         'margin_bottom' => 16,
                         'margin_header' => 9,
                         'margin_footer' => 9,
                         'orientation' => 'P']);  
        

        if ($sede->pdf_marcadeagua == 'T' OR $sede->pdf_marcadeagua == 'B')
        {
            $pdf->SetWatermarkText($sede->pdf_marcadeagua_contenido);
            $pdf->showWatermarkText = true;
            $pdf->watermarkTextAlpha = 0.1;
        }

        if ($sede->pdf_marcadeagua == 'I')
        {
            $pdf->SetWatermarkImage($sede->pdf_marcadeagua_contenido);
            $pdf->showWatermarkImage = true;
            $pdf->watermarkImageAlpha = 0.1;
        }

        $pdf->setHeader($sede->pdf_header);
        $pdf->setFooter($sede->pdf_footer);
        
        $pdf->AliasNbPages();

        $i = 1;    

        $compromisos = Compromisosacudiente::find()->select(['compromiso'])->asArray()->all();

        $compromiso = [];

        foreach ($compromisos as $compromiso1) {
            $compromiso[] = $compromiso1['compromiso'];
        }
        /*
            echo "<pre>";
            print_r($compromisos);
            echo "</pre>";
        */
        $estudiantes = Academico::find()->select(['tercero.id', 'academico.estudiante', 'academico.grupo','academico.especialidad'])->joinWith(['estudiantes'])->where(['<', 'tercero.estado', 3])->andWhere(['academico.grupo' => $grupo->id])->orderBy('primer_apellido')->all();  
        
        foreach ($estudiantes as $estudiante) 
        {

            $pdf->AddPage(0,'Letter');

            $pdf->SetFillColor(255);
            $pdf->SetTextColor(0);
            $pdf->SetDrawColor(0,0,0);
        
            $fecha = strftime("%A, %d de %B de %Y");

            $pdf->setX(140);
            $pdf->SetFont('helvetica','',$size_font);
            $pdf->Cell(60,$alto,$fecha,0,0,'R');

            $pdf->Ln(5);
            $pdf->SetFont('Helvetica','B',12);   
            $pdf->Cell(190,10,Yii::t('app', 'R701-INFORME VALORATIVO CONSOLIDADO'),0,0,'C');

            $pdf->Ln(10);

            $pdf->SetFont('Helvetica','B',$size_font);
            $pdf->Cell(18,$alto,Yii::t('app', 'Estudiante'),0,0); 
            $pdf->SetFont('Helvetica','',$size_font);

            $nombre = mb_strtoupper($estudiante->estudiantes->nombreinverso);

            $pdf->Bookmark($nombre, 0);
            $pdf->Cell(65,$alto,$nombre,0,0);
            
            $pdf->SetFont('Helvetica','B',$size_font);
            $pdf->Cell(23,$alto,Yii::t('app', 'Identificación'),0,0);
            $pdf->SetFont('Helvetica','',$size_font);
            $pdf->Cell(25,$alto,$estudiante->estudiantes->identificacion,0,0);
            
            
            $pdf->SetFont('Helvetica','B',$size_font);
            $pdf->Cell(20,$alto,Yii::t('app', 'Especialidad'),0,0);
            $pdf->SetFont('Helvetica','',$size_font);
            $pdf->Cell(50,$alto,$estudiante->especialidades->especialidad,0,0);
            
            
            $pdf->Ln(5);
            
            $pdf->SetFont('Helvetica','B',$size_font);
            $pdf->Cell(15,$alto,Yii::t('app', 'Sede'),0,0);
            $pdf->SetFont('Helvetica','',$size_font);    
            $pdf->Cell(55,$alto,$grupo->sedes->sede,0,0);

            $pdf->SetFont('Helvetica','B',$size_font);
            $pdf->Cell(15,$alto,Yii::t('app', 'Jornada'),0,0);
            $pdf->SetFont('Helvetica','',$size_font);    
            $pdf->Cell(20,$alto,$grupo->jornadas->jornada,0,0);  

            $pdf->SetFont('Helvetica','B',$size_font);
            $pdf->Cell(12,$alto,Yii::t('app', 'Grupo'),0,0);
            $pdf->SetFont('Helvetica','',$size_font);    
            $pdf->Cell(25,$alto,$grupo->grupo,0,0);
            
            $pdf->SetFont('Helvetica','B',$size_font);
            $pdf->Cell(13,$alto,Yii::t('app', 'Periodo'),0,0);
            $pdf->SetFont('Helvetica','',$size_font);    
            $pdf->Cell(8,$alto,$periodo,0,0);

            $pdf->SetFont('Helvetica','B',$size_font);
            $pdf->Cell(10,$alto,Yii::t('app', 'Año'),0,0);
            $pdf->SetFont('Helvetica','',$size_font);    
            $pdf->Cell(8,$alto,date('Y'),0,0);

            $pdf->Ln(10);
            

            $tipo_calificacion = $grupo->grados->tipo_calificacion;
            $calificacionxcompetencia = $grupo->grados->calificacionxcompetencia;

            $pdf->setFillColor(255);
            $pdf->SetFont('Helvetica','',$size_font);    
  

            if($estudiante->especialidad == '1')
            {
                $asignaturas = Asignatura::find()
                                ->where(['grado' => $grupo->grados->id])
                                ->andWhere(['especialidad' => '1'])
                                ->all();
            }
            else
            {
                $asignaturas = Asignatura::find()
                                ->where(['grado' => $grupo->grados->id])
                                ->andWhere(['especialidad' => '1'])
                                ->orWhere(['especialidad' => $estudiante->especialidad])
                                ->all();
            }    

            $i = 1;
            
            foreach ($asignaturas as $asignatura) 
            {
/*

                $pdf->Cell(4,$alto,Yii::t('app', '#'),1,0,'C',1);
                $pdf->Cell(65,$alto,Yii::t('app', 'Asignatura'),1,0,'C',1);


                $pdf->Cell(7,$alto,Yii::t('app', 'IH'),'LBTR',0,'C',1);

                for($p=1;$p<=$periodo;$p++)
                {
                    $pdf->Cell(23,$alto,Yii::t('app', 'Periodo').' '.$p,1,0,'C',1);
                
                }

                $pdf->Ln(5);
*/

                $pdf->Cell(4,$alto,$i,1,0,'C',0);
                
                $i++;

                //$pdf->Cell(60,$alto,Yii::t('app', 'Asignatura'),1,0,'C',1);

                $pdf->SetFont('Helvetica','B',$size_font);
                $pdf->Cell(50,$alto,mb_strtoupper($asignatura->asignatura),1,0,'J',0); 
                $pdf->SetFont('Helvetica','',$size_font);
                $pdf->Cell(5,$alto,Yii::t('app', 'IH'),'LBTR',0,'C',1);
            
                $pdf->Cell(5,$alto,mb_strtoupper($asignatura->intensidad),1,0,'C',0); 

            
                            
                for($p=$periodo;$p<=$periodo;$p++)
                {   
                    
                    $calificacion = Calificacion::find()
                                ->where(['estudiante' => $estudiante->id])
                                ->andWhere(['grupo' => $grupo->id])
                                ->andWhere(['asignatura' => $asignatura->id])
                                ->andWhere(['periodo' => $p])
                                ->one();

                    if($grupo->sedes->fallas == 1)
                    {

                        $fallas = Asistencia::find()
                                  ->where(['estudiante' => $estudiante->id])
                                  ->andWhere(['grupo' => $grupo->id])
                                  ->andWhere(['asignatura' => $asignatura->id])
                                  ->andWhere(['periodo' => $p])
                                  ->sum('fallas');

                        $pdf->Cell(10,$alto,Yii::t('app', 'Fallas'),1,0,'C',1);          
                        $fallas = $fallas == 0 ? '' : $fallas;
                        $pdf->Cell(5,$alto,$fallas,1,0,'C',1);
                    }
                    else 
                    {
                        $pdf->Cell(10,$alto,Yii::t('app', 'Fallas'),1,0,'C',1);          
                        $fallas = isset($calificacion->fallas) ? $calificacion->fallas : '';
                        $pdf->Cell(5,$alto,$fallas,1,0,'C',1);
                    }   

                    

                    if($tipo_calificacion=='1') // LETRAS
                    {   
                        if ($calificacionxcompetencia == '2')  // CALIFICACION POR COMPETENCIAS Y LETRAS
                        {
                            $notas = Calificacioncalificaciones::find()
                                ->where(['calificacion_id' => $calificacion->id])
                                ->andWhere(['estudiante' => $estudiante->id])
                                ->andWhere(['grupo' => $grupo->id])
                                ->andWhere(['asignatura' => $asignatura->id])
                                ->andWhere(['periodo' => $p])
                                ->andWhere(['competencia' => $competencia->id])
                                ->all();

                            if(count($notas) > 0)
                            {
                                //echo "1";
                                foreach ($notas as $nota) 
                                {
                                    
                                    $pdf->Cell(5,$alto,'C'.$c,'LBT',0,'C',1);

                                    $desempeno = new Desempeno();

                                    $color = $desempeno->hex2rgb($desempeno->color($nota->saber,$tipo_calificacion));
                                    $desempenos = $desempeno->desempeno($nota->saber,$tipo_calificacion);
                                    
                                    $pdf->setFillColor($color['r'],$color['g'],$color['b']);
                                    $pdf->Cell(5,$alto,$nota->saber == '' ? '': $nota->saber,'LBT',0,'C',1);
                                    $pdf->setFillColor(255);

                                    //$pdf->Cell(18 ,$alto,$notas->saber,'BTR',0,'C',0);    
                                }
                                
                                
                            }
                            else
                            {
                                
                                $pdf->Cell(5,$alto,'C'.$c,'LBT',0,'C',1);

                                $desempeno = new Desempeno();

                                $color = $desempeno->hex2rgb($desempeno->color('NE',$tipo_calificacion));
                                $desempenos = $desempeno->desempeno('NE',$tipo_calificacion);
                                
                                $pdf->setFillColor($color['r'],$color['g'],$color['b']);
                                $pdf->Cell(5,$alto,'NE','LBT',0,'C',1);
                                $pdf->setFillColor(255);


                            }   
                        }
                        else  // CALIFICACION POR ASIGNATURA Y LETRAS
                        {
                            //echo $notas->createCommand()->getRawSql();

                            $definitiva = (double)isset($calificacion->definitiva_periodo) ? $calificacion->definitiva_periodo : 'NE';
                            
                            $desempeno = new Desempeno();
                        
                            $desempenos = $desempeno->desempeno($definitiva,$tipo_calificacion);   
                            
                            if($ver_colores == 1)
                            {
                                $color = $desempeno->hex2rgb($desempeno->color($definitiva,$tipo_calificacion));
                                $pdf->setFillColor($color['r'],$color['g'],$color['b']);
                            }

                            $pdf->Cell(5,$alto,$definitiva,1,0,'C',1);
                            $pdf->setFillColor(255);
                            $pdf->Cell(18 ,$alto,$desempenos,1,0,'C',0);

                        }
                    } 
                    else  // NUMEROS
                    {
                        if ($calificacionxcompetencia == '2')  // CALIFICACION POR COMPETENCIAS Y NUMEROS
                        {
                            $competencias = Competencia::find()
                            ->where(['grado' => $grupo->grados->id])
                            ->andWhere(['asignatura' => $asignatura->id])
                            ->andWhere(['periodo' => $p])
                            ->all();

                            $c = 1;

                            foreach ($competencias as $competencia) 
                            {    


                                $pdf->Cell(5,$alto,Yii::t('app', 'C').$c,'LBTR',0,'C',1);

                                $nota = Calificacioncalificaciones::find()
                                    ->where(['tipo' => 'saber'])
                                    ->andWhere(['estudiante' => $estudiante->id])
                                    ->andWhere(['grupo' => $grupo->id])
                                    ->andWhere(['asignatura' => $asignatura->id])
                                    ->andWhere(['periodo' => $p])
                                    ->andWhere(['competencia' => $competencia->id])
                                    ->one();
                                
                                if(isset($nota->calificacion))
                                {
                                    $desempeno = new Desempeno();
                                    
                                    if($ver_colores == 1)
                                    {
                                        $color = $desempeno->hex2rgb($desempeno->color($nota->calificacion,$tipo_calificacion));
                                        $pdf->setFillColor($color['r'],$color['g'],$color['b']);
                                    }

                                    if($ver_letrasonumeros == 1)
                                    {
                                        $desempenos = $desempeno->nota($nota->calificacion,$tipo_calificacion);
                                        $pdf->Cell(5,$alto,$desempenos,'LBTR',0,'C',1);
                                    }
                                    else
                                    {
                                        $pdf->Cell(5,$alto,$nota->calificacion == 0 ? '': round($nota->calificacion,1),'LBTR',0,'C',1); 
                                    }    
                                    
                                    $pdf->setFillColor(255);    
                                }
                                else
                                {
                                    
                                    $desempeno = new Desempeno();
                                    $color = $desempeno->hex2rgb($desempeno->color(0,$tipo_calificacion));
                                    $desempenos = $desempeno->nota(0,$tipo_calificacion);   
                                    
                                    $pdf->setFillColor($color['r'],$color['g'],$color['b']);
                                    $pdf->Cell(5,$alto,'','LBTR',0,'C',1);
                                    $pdf->setFillColor(255); 
                                }

                                $c++;  
                            }   
                        }
                        else  // CALIFICACION POR ASIGNATURA Y NUMEROS
                        {

                            $definitiva = (double)isset($notas->definitiva_periodo) ? $notas->definitiva_periodo : 0;
                            
                            $desempeno = new Desempeno();
                            
                            if($ver_colores == 1)
                            {
                                $color = $desempeno->hex2rgb($desempeno->color($definitiva,$tipo_calificacion));
                                $pdf->setFillColor($color['r'],$color['g'],$color['b']);
                            }
                            
                            $desempenos = $desempeno->desempeno($definitiva,$tipo_calificacion);   
                         
                            $pdf->Cell(5,$alto,$definitiva == 0 ? '': $definitiva,'LBT',0,'C',1);
                            $pdf->setFillColor(255);
                            $pdf->Cell(18 ,$alto,$desempenos,'BTR',0,'C',0);

                        }
                    } 


                    ///   CALIFICACION DEFINITIVA

                    if($tipo_calificacion != '1') // NUMEROS
                    {     
                        $pdf->Cell(10,$alto,mb_strtoupper(Yii::t('app', 'Def')),'LBTR',0,'C',1);

                        if(isset($calificacion))
                        {


                            $desempeno = new Desempeno();
                            
                            if($ver_colores == 1)
                            {
                                $color = $desempeno->hex2rgb($desempeno->color($calificacion->definitiva_periodo,$tipo_calificacion));
                                $pdf->setFillColor($color['r'],$color['g'],$color['b']);
                            }

                            if($ver_letrasonumeros == 1)
                            {
                                $desempenos = $desempeno->nota($calificacion->definitiva_periodo,$tipo_calificacion);
                                $pdf->Cell(10,$alto, $desempenos,'LBTR',0,'C',1);
                            }
                            else
                            {
                                $pdf->Cell(10, $alto, $calificacion->definitiva_periodo == '0' ? $calificacion->definitiva_periodo : $calificacion->definitiva_periodo,'LBTR',0,'C',1); 
                            }    
                            
                            $pdf->setFillColor(255); 
                        }
                        else
                        {
                            $desempeno = new Desempeno();
                            
                            if($ver_colores == 1)
                            {
                                $color = $desempeno->hex2rgb($desempeno->color(0,$tipo_calificacion));
                                $pdf->setFillColor($color['r'],$color['g'],$color['b']);
                            }

                            $desempenos = $desempeno->nota(0,$tipo_calificacion);   
                            
                            $pdf->Cell(10,$alto,'','LBTR',0,'C',1);
                            $pdf->setFillColor(255);
                        }    

                    }
                    

                } // FIN FOR 
                $pdf->Ln($alto);
                
            }

            $pdf->Ln(3);

            $niveles = Desempeno::find()->where(['tipo_calificacion' => $tipo_calificacion])->andWhere(['estado' => 1])->all();    
                
            foreach ($niveles as $nivel) 
            {
                $desempeno = new Desempeno();

                if($ver_colores == 1)
                {
                    $color = $desempeno->hex2rgb($nivel->color);
                    $pdf->setFillColor($color['r'],$color['g'],$color['b']);
                }

                $pdf->Cell(5,$alto,$nivel->nota,'LBTR',0,'C',1);
                $pdf->setFillColor(255);

                $pdf->Cell(18 ,$alto,$nivel->desempeno,'LBTR',0,'C',0);    
            }


            if($grupo->sedes->compromiso_acudiente == 1)
            {    
                $pdf->Ln(5);
                $pdf->SetFont('Helvetica','B',$size_font);   
                $pdf->Cell(190,10,Yii::t('app', 'Compromisos del Acudiente'),0,0,'C');
                $pdf->SetFont('Helvetica','',$size_font);    

                $pdf->Ln(10);
                
                    
                for($p=1;$p<=$periodo;$p++)
                {   

                    $calificacion = Calificacioncompromisos::find()
                            ->select(['valoracion'])
                            ->where(['estudiante' => $estudiante->id])
                            ->andWhere(['grupo' => $grupo->id])
                            ->andWhere(['periodo' => $p])
                            ->one();
        
                    if($calificacion)
                    {   
                        $calificaciones = explode(",", $calificacion->valoracion); 
                    }    
                    else
                    {
                        $calificaciones = [];
                        for ($y=0;$y < count($compromisos);$y++)
                        {
                            $calificaciones[] =[];
                        }                            
                    }    

                    
                    if($tipo_calificacion=='1') // LETRAS
                    {   
                        
                    } 
                    else  // NUMEROS
                    {
                        if ($calificacionxcompetencia == '2')  // CALIFICACION POR COMPETENCIAS Y NUMEROS
                        {
                            if(count($notas) > 0)
                            {
                                
                            }
                            else
                            {
                                
                            }   
                        }
                        else  // CALIFICACION POR ASIGNATURA Y NUMEROS
                        {

                            for ($y=0;$y < count($compromisos);$y++)
                            {    
                                if($p==1)
                                {   
                                    $pdf->SetFont('Helvetica','B',$size_font); 
                                    $pos_x = 15;
                                    $pdf->Cell(188,$alto,$compromiso[$y],1,1,'J',0);    

                                }

                                if($p ==2 and $y==0)
                                {
                                    $pos_x = 62;
                                    $pos_y = $pdf->y - 60;
                                    //$pdf->setX($pos_x);
                                    $pdf->setY($pos_y); 
                                }    
                                
                                if($p ==3 and $y==0)
                                {
                                    $pos_x = 109;
                                    $pos_y = $pdf->y - 60;
                                    
                                    $pdf->setX($pos_x);
                                    $pdf->setY($pos_y); 
                                }
                                
                                if($p ==4 and $y==0)
                                {
                                    $pos_x = 156;
                                    $pos_y = $pdf->y - 60;

                                    $pdf->setX($pos_x);
                                    $pdf->setY($pos_y); 
                                }
                                

                                if($p !=1 and $y!=0)
                                {
                                   $pdf->Ln(5); 
                                }    

                                $pdf->SetFont('Helvetica','',$size_font); 
                                $pdf->setX($pos_x);
                                $pdf->setFillColor(230);
                                $pdf->Cell(20,$alto,'Periodo '.$p,1,0,'C',1); 

                                $definitiva = $calificaciones[$y] != NULL ? $calificaciones[$y] : '0';
                                
                                $desempeno = new Desempeno();
                                
                                $color = $desempeno->hex2rgb($desempeno->color($definitiva,$tipo_calificacion));
                                $desempenos = $desempeno->desempeno($definitiva,$tipo_calificacion);   
                                    
                                $pdf->setFillColor($color['r'],$color['g'],$color['b']);
                                
                                $pdf->Cell(7,$alto,$definitiva == 0 ? '' : $definitiva,'LBT',0,'C',1);
                                $pdf->setFillColor(255);
                                

                                $pdf->Cell(20 ,$alto,$desempenos,'BTR',0,'C',0);
                                $pdf->Ln(8);
                            }   
                        }
                    } 
                } 

            }    
            $pdf->Ln(8);

            $pdf->SetFont('Helvetica','',$size_font);
            //$pdf->Ln(8);
            //$pdf->Cell(180,6,"En constancia de entrega y publicación del informe valorativo y en constancia firmamos. ",0,0);
            
            $pdf->SetFont('Helvetica','B',$size_font);

            $y = $pdf->y;
            $x = $pdf->x;

            if($director_firma != '' or $director_firma != NULL )
            {
                $pdf->Image(\Yii::getAlias('@webroot/uploads/'.$director_firma),$x+30,$y,50);    
            }    
            
            
            $pdf->Image(\Yii::getAlias('@webroot/uploads/'.$grupo->sedes->rector_firma),$x+105,$y,50);
            
            $pdf->setY($pdf->y-15);
            $pdf->Cell(30);
            $pdf->Cell(60,$alto,$director_nombre,'T',0,'C',0);

            $pdf->Cell(15);
            $pdf->Cell(60,$alto,$sede->rector_nombre,'T',0,'C',0);

            $pdf->Ln(3);
            $pdf->SetFont('Helvetica','',$size_font);
            $pdf->Cell(25);
            $pdf->Cell(60,$alto,Yii::t('app', 'Director(a)'),'',0,'C',0);
            $pdf->Cell(15);
            $pdf->Cell(60,$alto,Yii::t('app', 'Rector(a)'),'',0,'C',0);
            $pdf->Ln(1); 


        }

        $pdf->Output("R701-Reporte-Valorativo-Condensado-Grupo(".date("d-m-Y_H-i").").pdf",'D');
    }

  

}
