<?php

namespace backend\controllers;

use Yii;
use backend\models\Academico;
use backend\models\Carga;
use backend\models\Tercero;
use backend\models\Asistencia;
use backend\models\AsistenciaSearch;
use backend\models\Grupo;
use backend\models\Asignatura;
use backend\models\Periodo;
use backend\models\TipoInasistencia;
use backend\models\Calificacion;
use backend\models\Desempeno;
use backend\models\Nivel;
use backend\models\Frd;
use backend\models\Competencia;
use backend\models\Planmejoramiento;
use backend\models\Sede;
use backend\models\Compromisosacudiente;
use backend\models\Calificacioncalificaciones;
use backend\models\Comportamientocalificaciones;
use backend\models\Calificacioncompromisos;
use backend\models\Calificacionfrd;
use backend\models\Observaciongeneral;
use backend\models\Comportamiento;
use backend\models\LanzadorForm;


use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\helpers\ArrayHelper;
use yii\data\ActiveDataProvider;
use yii\base\Model;
use yii\helpers\Html;
use yii\web\Response;
use yii\widgets\ActiveForm;

use Mpdf\Mpdf;

class Reporte703Controller extends Controller
{

    public function actionIndex($tercero = NULL, $ver_estandar = 1,$ver_competencia = 1, $ver_niveles = 1, $ver_desempenos = 1, $ver_frd = 1, $ver_fecha = 1, $ver_letrasonumeros = 1, $ver_emoticons = 0) // Reporte Valorativo Condensado (Boletín de Calificaciones) por Grupo
    {
        $size_font = 7;

        if($tercero == NULL)
        {    
            $model = new LanzadorForm(['scenario'=>'grupo-periodo']);

            //$model->reporte = 'Reporte de Valorativo por Grupo';
            //$model->observaciones = 'Exporta el informe valorativo de los estudiantes por grupos.; este reporte se genera en formato PDF.';
            $model->reporte = Yii::t('app', 'R703-Reporte');
            $model->observaciones = Yii::t('app', 'R703-Observaciones');

            if (Yii::$app->request->isAjax && $model->load(Yii::$app->request->post())) {
                Yii::$app->response->format = Response::FORMAT_JSON;
                return ActiveForm::validate($model);
            }

            if ($model->load(Yii::$app->request->post())) {

                $id_tercero = $model->tercero;
                $grado = $model->grado;
                $grupo = $model->grupo;
                $periodo = $model->periodo;

                $ver_estandar = $model->ver_estandar;
                $ver_competencia = $model->ver_competencia;
                $ver_niveles = $model->ver_niveles;
                $ver_desempenos = $model->ver_desempenos;
                $ver_frd = $model->ver_frd;
                $ver_fecha = $model->ver_fecha;
                $ver_letrasonumeros = $model->ver_letrasonumeros;

                $ver_emoticons = $model->ver_emoticons;
                $ver_parametros = $model->ver_parametros;
                $ver_colores = $model->ver_colores;
                $size_font = $model->fuente;
                $alto = $model->alto;

                
            }
            else
            {
                if (Yii::$app->request->isAjax) 
                {
                    return $this->renderAjax('/publica/lanzador', [
                            'model' => $model,
                            'sede' => true,
                            'tercero' => true,
                            'grado' => true,
                            'grupo' => true,
                            'asignatura' => false,
                            'periodo' => true,
                            'competencia' => false,
                            'columnas' => false,
                            'ver_estandar' => true,
                            'ver_competencia' => true,
                            'ver_niveles' => true,
                            'ver_desempenos' => true,
                            'ver_frd' => true,
                            'ver_fecha' => false,
                            'ver_letrasonumeros' => true,
                            'ver_emoticons' => true,
                            'ver_parametros' => true,
                        ]);

                    //exit;
                }
                else
                {
                    return $this->render('/publica/lanzador', [
                            'model' => $model,
                            'sede' => true,
                            'tercero' => true,
                            'grado' => true,
                            'grupo' => true,
                            'asignatura' => false,
                            'periodo' => true,
                            'competencia' => false,
                            'columnas' => false,
                            'ver_estandar' => true,
                            'ver_competencia' => true,
                            'ver_niveles' => true,
                            'ver_desempenos' => true,
                            'ver_frd' => true,
                            'ver_fecha' => false,
                            'ver_letrasonumeros' => true,
                            'ver_emoticons' => true,
                            'ver_parametros' => true,
                        ]);

                    //exit;
                }
            }    
        }
        else
        {
            $id_tercero = Yii::$app->request->get('tercero');
            
            $periodo = new Periodo();
            //$periodo = '1';
            $periodo = $periodo->actual->id;

            //$grado = Yii::$app->request->get('grado');
            //$grupo = Yii::$app->request->get('grupo');
            //$periodo = Yii::$app->request->get('periodo');

            /*$ver_fecha = Yii::$app->request->get('ver_fecha');
            $ver_letrasonumeros = Yii::$app->request->get('ver_letrasonumeros');
            $ver_parametros = Yii::$app->request->get('ver_parametros');
            $ver_colores = Yii::$app->request->get('ver_colores');
            $size_font = 7;
            $alto = 4;*/

            $ver_estandar = '1';
            $ver_competencia = '1';
            $ver_niveles = '1';
            $ver_desempenos = '1';
            $ver_frd = '1';
            $ver_fecha = '0';
            $ver_letrasonumeros = '1';
            $ver_parametros = '0';
            $ver_colores = '1';
            $size_font = 7;
            $alto = 4;
            
        }

        date_default_timezone_set('America/Bogota');
        setlocale(LC_TIME,"es_ES");

        if($id_tercero != '')
        { 
            $tercero = Tercero::find()->where(['id' => $id_tercero])->one();

            if (($tercero) === null)
            {
                throw new NotFoundHttpException('No existe el tercero');
            }

            if (($tercero->bloqueo == '1') && (Yii::$app->session->get('__tipo') == '1'))
            {
                throw new NotFoundHttpException('La descarga de boletín está bloqueada para el estudiante por parte del director del grupo.');
            }  

            if (($estudiantes = Academico::find()
                            ->select(['tercero.id', 'academico.estudiante', 'academico.grupo','academico.especialidad'])
                            ->joinWith(['estudiantes'])
                            //->where(['<', 'tercero.estado', 3])
                            ->andWhere(['academico.estudiante' => $tercero->id])
                            ->orderBy('primer_apellido')
                            ->all()) === null)
            {
                throw new NotFoundHttpException('No estudiante no tiene registro académico.');
            }  
            else
            {
                foreach ($estudiantes as $tercero) {
                    $grupo = Grupo::find()->where(['id' => $tercero->grupo])->one();
                }    
            }    
        }
        else
        {
            $grupo = Grupo::find()->where(['id' => $grupo])->one();
            //$sede = Sede::FindOne($grupo->sede);
            $estudiantes = Academico::find()
                            ->select(['tercero.id', 'academico.estudiante', 'academico.grupo','academico.especialidad'])
                            ->joinWith(['estudiantes'])
                            ->where(['<', 'tercero.estado', 3])
                            ->andWhere(['academico.grupo' => $grupo->id])
                            ->orderBy(['primer_apellido' => SORT_ASC, 'segundo_apellido' => SORT_ASC])
                            ->all();  
        }    

        if (($grupo->sedes->bloquear_boletin == '1') && (Yii::$app->session->get('__tipo') == '1'))
        {
            throw new NotFoundHttpException('La descarga de boletín está bloqueada por la sede para todos los estudiantes.');
        }

        if(isset($grupo->director))
        {
            $director_nombre = $grupo->directores->nombre;
            $director_firma = $grupo->directores->firma != NULL ? $grupo->directores->firma : '';
        }
        else
        {
            $director_nombre = Yii::t('app', 'R703-Director(a) de Grupo');
            //'Director(a) de Grupo'
            $director_firma = '';
        }
            
        $pdf = new Mpdf(['mode' => 'utf-8',
                         'format' => 'LETTER',
                         'default_font_size' => 0,
                         'default_font' => '',
                         'margin_left' => 15,
                         'margin_right' => 15,
                         'margin_top' => 30,
                         'margin_bottom' => 20,
                         'margin_header' => 5,
                         'margin_footer' => 8,
                         'orientation' => 'P']);  
        
        //$pdf->StarProgressBarOutput(2);


        if ($grupo->sedes->pdf_marcadeagua == 'T' OR $grupo->sedes->pdf_marcadeagua == 'B')
        {
            $pdf->SetWatermarkText($sede->pdf_marcadeagua_contenido);
            $pdf->showWatermarkText = true;
            $pdf->watermarkTextAlpha = 0.1;
        }

        if ($grupo->sedes->pdf_marcadeagua == 'I')
        {
            $pdf->SetWatermarkImage($grupo->sedes->pdf_marcadeagua_contenido);
            $pdf->showWatermarkImage = true;
            $pdf->watermarkImageAlpha = 0.05;
        }

        $pdf->setHeader($grupo->sedes->pdf_header);
        $pdf->setFooter($grupo->sedes->pdf_footer);
        
        $pdf->AliasNbPages();

        $i = 1;    

        $compromisos = Compromisosacudiente::find()->select(['compromiso'])->asArray()->all();

        $compromiso = [];

        foreach ($compromisos as $compromiso1) {
            $compromiso[] = $compromiso1['compromiso'];
        }
        
        foreach ($estudiantes as $estudiante) 
        {

            $pdf->AddPage(0,'Letter');

            $pdf->SetFillColor(255);
            $pdf->SetTextColor(0);
            $pdf->SetDrawColor(0,0,0);
        
            if($ver_fecha == 1)
            {
                $fecha = strftime("%A, %d de %B de %Y");

                $pdf->setX(140);
                $pdf->SetFont('helvetica','',$size_font);
                $pdf->Cell(60,5,$fecha,0,0,'R');
                $pdf->Ln(5);
            }    

            $pdf->SetFont('Helvetica','B',10);   
            $pdf->Cell(190,10,Yii::t('app', 'R703-INFORME VALORATIVO'),0,0,'C');

            $pdf->Ln(8);

            $pdf->SetFont('Helvetica','B',$size_font);
            $pdf->Cell(18,5,Yii::t('app', 'Estudiante'),0,0); 
            $pdf->SetFont('Helvetica','',$size_font);

            $nombre = mb_strtoupper($estudiante->estudiantes->nombreinverso);
            //echo "<br><br>Estudiante : ".$nombre;
            $pdf->Bookmark($nombre, 0);
            $pdf->Cell(65,5,$nombre,0,0);
            
            $pdf->SetFont('Helvetica','B',$size_font);
            $pdf->Cell(23,5,Yii::t('app', 'Identificación'),0,0);
            $pdf->SetFont('Helvetica','',$size_font);
            $pdf->Cell(25,5,$estudiante->estudiantes->identificacion,0,0);
            
            
            $pdf->SetFont('Helvetica','B',$size_font);
            $pdf->Cell(20,5,Yii::t('app', 'Especialidad'),0,0);
            $pdf->SetFont('Helvetica','',$size_font);
            $pdf->Cell(50,5,$estudiante->especialidades->especialidad,0,0);
            
            
            $pdf->Ln(4);
            
            $pdf->SetFont('Helvetica','B',$size_font);
            $pdf->Cell(10,5,Yii::t('app', 'Sede'),0,0);
            $pdf->SetFont('Helvetica','',$size_font);    
            $pdf->Cell(50,5,$grupo->sedes->sede,0,0);

            $pdf->SetFont('Helvetica','B',$size_font);
            $pdf->Cell(12,5,Yii::t('app', 'Jornada'),0,0);
            $pdf->SetFont('Helvetica','',$size_font);    
            $pdf->Cell(20,5,$grupo->jornadas->jornada,0,0);  

            $pdf->SetFont('Helvetica','B',$size_font);
            $pdf->Cell(10,5,Yii::t('app', 'Grupo'),0,0);
            $pdf->SetFont('Helvetica','',$size_font);    
            $pdf->Cell(20,5,$grupo->grupo,0,0);
            
            $pdf->SetFont('Helvetica','B',$size_font);
            $pdf->Cell(13,5,Yii::t('app', 'Periodo'),0,0);
            $pdf->SetFont('Helvetica','',$size_font);    
            $pdf->Cell(8,5,$periodo,0,0);

            $pdf->SetFont('Helvetica','B',$size_font);
            $pdf->Cell(10,5,Yii::t('app', 'Año'),0,0);
            $pdf->SetFont('Helvetica','',$size_font);    
            $pdf->Cell(8,5,$grupo->sedes->vigencia,0,0);

            $pdf->Ln(5);
            
            $tipo_calificacion = $grupo->grados->tipo_calificacion;
            $calificacionxcompetencia = $grupo->grados->calificacionxcompetencia;

            

            if($estudiante->especialidad == '1')
            {   //echo "<br> Sin Especialidad";
                $asignaturas = Asignatura::find()
                                ->joinWith('areas')    
                                ->where(['grado' => $grupo->grados->id])
                                ->andWhere(['especialidad' => '1'])
                                ->andWhere(['asignatura.eliminado_por' => '0'])
                                ->orderBy(['area.area' => SORT_ASC])
                                ->all();
            }
            else
            {   //echo "<br> Con Especialidad";
                $asignaturas = Asignatura::find()
                                ->joinWith('areas')
                                ->where(['grado' => $grupo->grados->id])
                                ->andWhere(['especialidad' => '1'])
                                ->orWhere(['especialidad' => $estudiante->especialidad])
                                ->andWhere(['asignatura.eliminado_por' => '0'])
                                ->orderBy(['area' => SORT_ASC])
                                ->all();
            }    

            $i = 1;

            $cod_area_anterior = '';
            
            foreach ($asignaturas as $asignatura) 
            {

                $pdf->setFillColor(230);
                $pdf->SetFont('Helvetica','B',$size_font);

                $cod_area_nuevo = $asignatura->areas->id;

                if($cod_area_anterior != $cod_area_nuevo)
                { 
                    //$pdf->Ln(2);
                    //$pdf->setFillColor(255);
                    $pdf->Cell(188,5,mb_strtoupper(Yii::t('app', 'Área').' - '.$asignatura->areas->area),'LBTR',0,'C',1);
                    $cod_area_anterior = $asignatura->areas->id;
                    $pdf->Ln(5);
                }
                
                $pdf->Cell(18,5,mb_strtoupper(Yii::t('app', 'Asignatura')),1,0,'C',1);
                
                $pdf->setFillColor(255);
                $pdf->SetFont('Helvetica','',$size_font);    
      
                $pdf->Cell(50,5,mb_strtoupper($asignatura->asignatura),1,0,'',0);  

                $carga = Carga::find()
                                ->where(['grupo' => $grupo->id])
                                ->andWhere(['asignatura' => $asignatura->id])
                                ->andWhere(['eliminado_por' => '0'])
                                ->one();
                
                $docente = (isset($carga)) ? $carga->docentes->nombre : 'xxx';

                $pdf->SetFont('Helvetica','B',$size_font);
                $pdf->setFillColor(230);
                $pdf->Cell(13,5,mb_strtoupper(Yii::t('app', 'Docente')),1,0,'C',1);
                $pdf->SetFont('Helvetica','',$size_font);
                $pdf->setFillColor(255);                            
                $pdf->Cell(50,5,mb_strtoupper($docente),1,0,'J',0);  

                $pdf->SetFont('Helvetica','B',$size_font);
                $pdf->setFillColor(230);
                $pdf->Cell(5,5,mb_strtoupper(Yii::t('app', 'IH')),'LBTR',0,'C',1);
                $pdf->SetFont('Helvetica','',$size_font);
                $pdf->setFillColor(255);
                $pdf->Cell(5,5,$asignatura->intensidad,1,0,'C',0);

                $calificacion = Calificacion::find()
                                ->where(['estudiante' => $estudiante->id])
                                ->andWhere(['grupo' => $grupo->id])
                                ->andWhere(['asignatura' => $asignatura->id])
                                ->andWhere(['periodo' => $periodo])
                                ->one();


                if ($grupo->sedes->fallas == 1)
                {
                    $fallas = Asistencia::find()
                                ->select(['fallas'])
                                ->where(['estudiante' => $estudiante->id])
                                ->andWhere(['grupo' => $grupo->id])
                                ->andWhere(['asignatura' => $asignatura->id])
                                ->andWhere(['periodo' => $periodo])
                                ->sum('fallas');
                }
                else
                {
                    $fallas = isset($calificacion) ? $calificacion->fallas : '';
                    //$fallas =0;
                }

                $pdf->SetFont('Helvetica','B',$size_font);
                $pdf->setFillColor(230);
                $pdf->Cell(5,5,mb_strtoupper(Yii::t('app', 'F')),1,0,'C',1);
                $pdf->SetFont('Helvetica','',$size_font);
                $pdf->setFillColor(255);
                $pdf->Cell(5,5,$fallas,1,0,'C',0);  


                ///////   DEFINITIVA DE LA ASIGNATURA   ////////////

                $pdf->SetFont('Helvetica','B',$size_font);
                $pdf->Cell(17,5,mb_strtoupper(Yii::t('app', 'Definitiva')),'LTRB',0,'C',1);

                $desempeno = new Desempeno();
                        
                //$pdf->setFillColor(255);
                //$pdf->SetTextColor(0);                          

                ////////////////////

                if($ver_emoticons == 0) // VER EMOTICONS - NO
                {
                    if($ver_colores == 1)
                    {
                        $color = $desempeno->hex2rgb($desempeno->color(isset($calificacion) ? $calificacion->definitiva_final_periodo : 0,$tipo_calificacion));
                        $pdf->setFillColor($color['r'],$color['g'],$color['b']);
                    }

                    if($ver_letrasonumeros == 0) // NOTA O DESEMPEÑO EN NUMERO
                    {
                        $desempenos = $desempeno->desempeno(isset($calificacion) ? $calificacion->definitiva_final_periodo : 0,$tipo_calificacion);
                        
                        $pdf->SetFont('Helvetica','B',$size_font);          
                        $pdf->SetTextColor(0);
                        $pdf->Cell(20,5,isset($calificacion) ? $calificacion->definitiva_final_periodo : 0,'LTRB',0,'C',1);
                        

                    }
                    else // NOTA O DESEMPEÑO EN LETRAS
                    {
                        //$desempenos = $desempeno->nota(isset($calificacion) ? (float)$calificacion->definitiva_final_periodo : 0,$tipo_calificacion);
                        $desempenos = $desempeno->desempeno(isset($calificacion) ? $calificacion->definitiva_final_periodo : 0,$tipo_calificacion);
                        
                        $pdf->SetFont('Helvetica','B',$size_font);          
                        $pdf->SetTextColor(0);
                        $pdf->Cell(20,5,$desempenos,'LTRB',0,'C',1);
                        //$pdf->Cell(20,5,isset($calificacion) ? $calificacion->definitiva_final_periodo : 0,'LTRB',0,'C',1);
                    }
                }
                else  // VER EMOTICONS - SI
                {
                    if($tipo_calificacion == 1) // LETRAS
                    {
                        $desempenos = isset($calificacion) ? $calificacion->definitiva_final_periodo : '';
                        
                        if($ver_colores == 1)
                        {
                            $color = $desempeno->hex2rgb($desempeno->color(isset($calificacion) ? $calificacion->definitiva_final_periodo : 'NE',$tipo_calificacion));
                            $pdf->setFillColor($color['r'],$color['g'],$color['b']);
                        }

                        $emoticons = $desempeno->emoticons(isset($calificacion) ? $calificacion->definitiva_final_periodo : 'NE',$tipo_calificacion);
                        
                        
                        $pdf->Cell(15,5,$desempenos,'LTRB',0,'C',1);
                    }
                    else // NUMEROS
                    {
                        if($ver_letrasonumeros == 0) // NOTA O DESEMPEÑO EN NUMERO
                        {
                            $desempenos = isset($calificacion) ? $calificacion->definitiva_final_periodo : '';
                            
                            if($ver_colores == 1)
                            {
                                $color = $desempeno->hex2rgb($desempeno->color(isset($calificacion) ? $calificacion->definitiva_final_periodo : 0,$tipo_calificacion));
                                $pdf->setFillColor($color['r'],$color['g'],$color['b']);
                            }

                            $emoticons = $desempeno->emoticons(isset($calificacion) ? (float)$calificacion->definitiva_final_periodo : 0,$tipo_calificacion);
                            
                            
                            $pdf->Cell(15,5,$desempenos,'LTRB',0,'C',1);
                        }
                        else
                        {
                            $desempenos = $desempeno->desempeno(isset($calificacion) ? $calificacion->definitiva_final_periodo : 0,$tipo_calificacion);
                            
                            if($ver_colores == 1)
                            {
                                $color = $desempeno->hex2rgb($desempeno->color(isset($calificacion) ? $calificacion->definitiva_final_periodo : 0,$tipo_calificacion));
                                $pdf->setFillColor($color['r'],$color['g'],$color['b']);
                            }

                            $emoticons = $desempeno->emoticons(isset($calificacion) ? (float)$calificacion->definitiva_final_periodo : 0,$tipo_calificacion);
                            
                            
                            $pdf->Cell(15,5,$desempenos,'LTRB',0,'C',1);
                        }
                    }

                    //$pdf->setFillColor($color['r'],$color['g'],$color['b']);
                    //$pdf->Cell(15,5,$desempenos,'LTRB',0,'C',1);

                    $x = $pdf->x+0.3;
                    $y = $pdf->y+0.3;

                    $pdf->Cell(5,5,'','LBTR',0,'C',0); 

                    $pdf->Image(Yii::getAlias('@web/images/smile/'.$emoticons),$x,$y,4.5);
                    $pdf->Ln(-5); 
                }  

                //////////////////////////
                    
                $pdf->Ln(5);

                $pdf->SetFont('Helvetica','B',$size_font-2);
                
                if($ver_colores == 1)
                {
                    $pdf->setFillColor(230);
                }
                
                $pdf->Cell(28,3,mb_strtoupper(Yii::t('app', 'Histórico')),1,0,'C',1);

                for ($i=1; $i <=4 ; $i++) 
                { 
                    $pdf->SetFont('Helvetica','B',$size_font-2);
                    $pdf->setFillColor(230);
                    $pdf->Cell(5,3,mb_strtoupper(Yii::t('app', 'P').$i),1,0,'C',1);
                    

                    $historico = Calificacion::find()
                                ->where(['estudiante' => $estudiante->id])
                                ->andWhere(['grupo' => $grupo->id])
                                ->andWhere(['asignatura' => $asignatura->id])
                                ->andWhere(['periodo' => $i])
                                ->one();

                    
                    if(isset($historico))
                    {
                        $desempeno = new Desempeno();
                        
                        if($ver_colores == 1)
                        {
                            $color = $desempeno->hex2rgb($desempeno->color($historico->definitiva_final_periodo,$tipo_calificacion));
                        }
                        
                        if($ver_letrasonumeros == 0)
                        {
                            $nota = $historico->definitiva_final_periodo;
                            $desempenos = $desempeno->desempeno($historico->definitiva_final_periodo,$tipo_calificacion);
                        }
                        else
                        {
                            $nota = $desempeno->nota($historico->definitiva_final_periodo,$tipo_calificacion);
                            $desempenos = $desempeno->desempeno($historico->definitiva_final_periodo,$tipo_calificacion);  
                        }   

                        
                    }
                    else
                    {
                        if($ver_letrasonumeros == 0) // NOTA O DESEMPEÑO EN LETRAS
                        {
                            $desempeno = new Desempeno();

                            if($ver_colores == 1)
                            {
                                $color = $desempeno->hex2rgb($desempeno->color(0,$tipo_calificacion));
                                $pdf->SetTextColor(255);
                                $pdf->setFillColor($color['r'],$color['g'],$color['b']);
                            }

                            $nota = '';
                            $desempenos = '';
                        }
                        else // NOTA O DESEMPEÑO EN NUMEROS
                        {
                            $desempeno = new Desempeno();
                            
                            if($ver_colores == 1)
                            {
                                $color = $desempeno->hex2rgb($desempeno->color(0,$tipo_calificacion));
                                $pdf->SetTextColor(255);
                                $pdf->setFillColor($color['r'],$color['g'],$color['b']);
                            }

                            $nota = $desempeno->nota(0,$tipo_calificacion);
                            $desempenos = '';
                        } 
                    }    

                    $pdf->SetFont('Helvetica','B',$size_font-2);          
                    
                    $pdf->Cell(10,3,$nota,'LTRB',0,'C',1);
                    $pdf->setFillColor(255);
                    $pdf->SetTextColor(0);  
                    $pdf->Cell(25,3,$desempenos,'LTRB',0,'C',1);     
                }
                $pdf->Ln(3);

                /*
                for($p=1;$p<=$periodo;$p++)
                {   
                    $pdf->SetFont('Helvetica','B',$size_font);
                    $pdf->Cell(5,5,Yii::t('app', 'P').$p,1,0,'C',1);
                    $pdf->SetFont('Helvetica','',$size_font);

                    $notas = Calificacion::find()
                                ->where(['estudiante' => $estudiante->id])
                                ->andWhere(['grupo' => $grupo->id, 'asignatura' => $asignatura->id, 'periodo' => $p])
                                ->one();
                    
                    if($tipo_calificacion=='1') // LETRAS
                    {   
                        
                    } 
                    else  // NUMEROS
                    {
                        if ($calificacionxcompetencia == '2')  // CALIFICACION POR COMPETENCIAS Y NUMEROS
                        {
                            if(count($notas) > 0)
                            {
                                //echo "1";
                                $notas2 = explode(",", $notas->saber);
                                $promedio=array_sum($notas2)/count($notas2); 
                                $desempeno = new Desempeno();
                                $color = $desempeno->color($promedio,$tipo_calificacion);
                                $desempenos = $desempeno->desempeno($promedio,$tipo_calificacion);
                                //$nota = $desempeno->nota($promedio);
                                $nota = round($promedio,1);
                            }
                            else
                            {
                                //echo "2";
                                $desempeno = new Desempeno();
                                $color = $desempeno->color('0',$tipo_calificacion);
                                $desempenos = $desempeno->desempeno('0',$tipo_calificacion);
                                //$nota = $desempeno->nota('0');
                                $nota = 'NE';
                            }   
                        }
                        else  // CALIFICACION POR ASIGNATURA Y NUMEROS
                        {

                            $definitiva = (double)isset($notas->definitiva_final_periodo) ? $notas->definitiva_final_periodo : 0;
                            
                            $desempeno = new Desempeno();
                            
                            
                                $color = $desempeno->hex2rgb($desempeno->color($definitiva,$tipo_calificacion));

                                $desempenos = $desempeno->desempeno($definitiva,$tipo_calificacion);
                                $desempenos_id = $desempeno->desempenoid($definitiva,$tipo_calificacion);   
                                //$nota = ($notas->definitiva_final_periodo=='') ? 'NE' : $notas->definitiva_final_periodo; 

                                
                                $pdf->setFillColor($color['r'],$color['g'],$color['b']);
                                $pdf->Cell(6,5,$definitiva == 0 ? '': $definitiva,'LBT',0,'C',1);
                                $pdf->setFillColor(255);
                                $pdf->Cell(20,5,$desempenos,'BTR',0,'C',0);

                        }
                    }   
                } // FIN FOR 
                
                $pdf->Ln(5);
                */

                $competencias = Competencia::find()
                                ->where(['grado' => $grupo->grados->id])
                                ->andWhere(['asignatura' => $asignatura->id])
                                ->andWhere(['periodo' => $periodo])
                                ->andWhere(['eliminado_por' => '0'])
                                ->orderBy(['estandar' => SORT_ASC])
                                ->all();
                
                if (count($competencias) > 0)
                {
                    if($ver_competencia == 1)
                    {  
                        if($ver_estandar == 0)
                        {
                            $pdf->setFillColor(230);
                            $pdf->SetFont('Helvetica','B',$size_font);          
                            $pdf->Cell(188,4,mb_strtoupper(Yii::t('app', 'Competencia')),'LTRB',0,'L',1);
                            $pdf->Ln(4);
                        } 

                        $cod_estandar_nuevo = '';
                        $cod_estandar_viejo = '';

                        foreach ($competencias as $competencia) 
                        {
                            if($ver_estandar == 1)
                            {
                                $cod_estandar_nuevo = $competencia->estandar;

                                if($cod_estandar_nuevo != $cod_estandar_viejo)
                                {

                                     

                                    $pdf->setFillColor(230);
                                    $pdf->SetFont('Helvetica','B',$size_font);          
                                    
                                    //$pdf->Cell(188,4,Yii::t('app', 'Estandar'),'LTR',0,'L',0);
                                    //$pdf->Ln(5);
                                    
                                    //$pdf->SetFont('Helvetica','',$size_font);          
                                    //$pdf->setFillColor(255);
                                    //$pdf->Cell(169,5,ucfirst(strtolower($competencia->estandares->estandar)),'LTRB',0,'L',1);

                                    //$estandar = ucfirst(strtolower($competencia->estandares->estandar));

                                    $pdf->MultiCell(188,4, mb_strtoupper(Yii::t('app', 'Estandar').': '.$competencia->estandares->estandar), 'LRB', '',1);

                                    /*if($ver_competencia == 1)
                                    {
                                        $pdf->setFillColor(230);
                                        $pdf->SetFont('Helvetica','B',$size_font);          
                                        $pdf->Cell(188,5,Yii::t('app', 'Competencia'),'LTRB',0,'L',1);
                                        $pdf->Ln(5);
                                    }*/

                                    //$pdf->MultiCell(188, 4,$competencia->estandares->estandar, 'LTRB', 'J',0);                                    
                                    //$pdf->Ln(5);
                                }  
                                $cod_estandar_viejo = $competencia->estandar;  
                            } 
                            


                            

                            //$pdf->setFillColor(230);
                            //$pdf->SetFont('Helvetica','B',$size_font);          
                            //$pdf->Cell(183,5,Yii::t('app', 'Competencia'),'LT',0,'L',);
                            //$pdf->Cell(18,5,Yii::t('app', 'Calificación'),'LTR',0,'C',1);
                            
                            $nota = Calificacioncalificaciones::find()
                                        ->where(['estudiante' => $estudiante->estudiante])
                                        ->andWhere(['grupo' => $grupo->id])
                                        ->andWhere(['asignatura' => $asignatura->id])
                                        ->andWhere(['periodo' => $periodo])
                                        ->andWhere(['competencia' => $competencia->id])
                                        ->andWhere(['tipo' => 'saber'])
                                        ->one();
                            
                            //echo "<br>".$nota->createCommand()->getRawSql();
                            
                            $desempeno = new Desempeno();
                                
                        
                            

                            if($ver_emoticons == 0) // VER EMOTICONS - NO
                            {
                                if($ver_colores == 1)
                                {
                                    $color = $desempeno->hex2rgb($desempeno->color(isset($nota) ? (float)$nota->calificacion : 0,$tipo_calificacion));
                                    $pdf->SetTextColor(0);
                                    $pdf->setFillColor($color['r'],$color['g'],$color['b']);
                                }

                                if($ver_letrasonumeros == 0) // NOTA O DESEMPEÑO EN NUMERO
                                {
                                    $desempenos = isset($nota) ? round($nota->calificacion,1) : '';
                                    $desempenos = ($desempenos == 0) ? '' : $desempenos;

                                }
                                else // NOTA O DESEMPEÑO EN LETRAS
                                {
                                    $desempenos = $desempeno->nota(isset($nota) ? (float)$nota->calificacion : 0,$tipo_calificacion);
                                }
                            }
                            else
                            {
                               if($tipo_calificacion == 1)
                               {
                                    $desempenos = $desempeno->emoticons(isset($nota) ? (float)$nota->calificacion : 0,$tipo_calificacion);
                               }
                               else
                               {
                                    $desempenos = $desempeno->emoticons(isset($nota) ? (float)$nota->calificacion : 0,$tipo_calificacion);
                               } 
                            }   

                            $pdf->SetFont('Helvetica','',$size_font);          
                            
                            //$y_inicial = $pdf->y;

                            //$pdf->MultiCell(183,4, mb_strtoupper($competencia->competencia), 'LRB', 'J',0);
                            
                            //$y_final = $pdf->y;

                            //$y_total = $y_final - $y_inicial;

                            //$pdf->setXY(198,$y_inicial);



///// SE ANULÓ LA CALIFICACION DE LA COMPETENCIA QUE TOCA CORREGUIR POR LA GABRIELA

                            //$pdf->Cell(183,4,substr(mb_strtoupper(ltrim($competencia->competencia)),0,130),'LBTR',0,'L',0);
                            
                            //$pdf->Cell(188,4,substr(mb_strtoupper(ltrim($competencia->competencia)),0,130),'LBTR',0,'L',0);

                            $pdf->MultiCell(188,4, mb_strtoupper($competencia->competencia), 'LBTR', '',0);

                            $pdf->SetFont('Helvetica','B',$size_font);          
                            
                            
                            if($ver_emoticons == 0) // VER EMOTICONS - NO
                            {
///// SE ANULÓ LA CALIFICACION DE LA COMPETENCIA QUE TOCA CORREGUIR POR LA GABRIELA                                
                                //$pdf->Cell(5,4,$desempenos,'LBTR',0,'C',1);
                            }
                            else
                            {
                                
                                $x = $pdf->x+0.6;
                                $y = $pdf->y+0.2;

///// SE ANULÓ LA CALIFICACION DE LA COMPETENCIA QUE TOCA CORREGUIR POR LA GABRIELA
                                //$pdf->Cell(5,4,'','LBTR',0,'C',0); 

                                //$pdf->Image(Yii::getAlias('@web/images/smile/'.$desempenos),$x,$y,3.8);
                                $pdf->Ln(-4);

                                //$pdf->Cell(5,4,$pdf->Image(Yii::getAlias('@webroot/images/smile/'.$desempenos),$x,$y,5,5),'LBTR',0,'C',1); 
                                
                            }

                            
                            $pdf->setFillColor(255);
                            $pdf->SetTextColor(0);
                            //$pdf->Ln();


                            if($ver_niveles == 1)
                            {

                                $desempenos = $desempeno->desempenoid(isset($calificacion) ? $calificacion->definitiva_final_periodo : '',$tipo_calificacion);
                                
                                //$desempenos = isset($calificacion) ? $calificacion->definitiva_final_periodo : 0,$tipo_calificacion;
                                
                                /*$niveles = Nivel::find()
                                        ->Where(['competencia' => $competencia->id])
                                        ->andWhere(['desempeno' => $desempenos])
                                        ->andWhere(['eliminado_por' => '0']);

                                
                                $pdf->Cell(180,4,$niveles->createCommand()->getRawSql(),'LTR',0,'L',0);
                                $pdf->Ln();*/

                                $niveles = Nivel::find()
                                        ->Where(['competencia' => $competencia->id])
                                        ->andWhere(['desempeno' => $desempenos])
                                        ->andWhere(['eliminado_por' => '0'])
                                        ->all();


                                if (count($niveles) > 0)
                                {
                                    $pdf->SetFont('Helvetica','B',$size_font);          
                                    $pdf->Cell(188,4,Yii::t('app', 'Niveles de Desempeño'),'LTR',0,'L',0);
                                    $pdf->Ln(4);
                                    $pdf->SetFont('Helvetica','',$size_font);          

                                    foreach ($niveles as $nivel) 
                                    {

                                        if($ver_colores == 1)
                                        {
                                            $color = $desempeno->hex2rgb($nivel->desempenos->color);
                                            $pdf->SetTextColor(0);
                                            $pdf->setFillColor($color['r'],$color['g'],$color['b']);
                                        }

                                        if($ver_emoticons == 0) // VER EMOTICONS - NO
                                        {
                                            $pdf->Cell(5,4,$nivel->desempenos->nota,'LBTR',0,'C',1);
                                        }
                                        else
                                        {
                                            
                                            $x = $pdf->x+0.6;
                                            $y = $pdf->y+0.2;

                                            $pdf->Cell(5,4,'','LBTR',0,'C',0); 

                                            $pdf->Image(Yii::getAlias('@web/images/smile/'.$nivel->desempenos->nota),$x,$y,3.8);
                                            $pdf->Ln(-4);

                                            //$pdf->Cell(5,4,$pdf->Image(Yii::getAlias('@webroot/images/smile/'.$desempenos),$x,$y,5,5),'LBTR',0,'C',1); 
                                            
                                        }
                                        
                                        $pdf->MultiCell(183, 4,$nivel->nivel, 'LR', '',0);
                                            

                                        if($ver_frd == 1)
                                        {
                                                
                                            if ($grupo->sedes->frd == 1)  // FRD AUTOMATICOS DEPENDIENDO DEL DESEMPEÑO DE LAS CALIFICACIONES
                                            {
                                                $frds = frd::find()
                                                        ->where(['competencia' => $competencia->id])
                                                        ->andWhere(['nivel' => $nivel->id])
                                                        ->andWhere(['eliminado_por' => '0'])
                                                        ->orderBy(['frd_tipo' => SORT_ASC])
                                                        ->all();

                                                if(count($frds) > 0)
                                                {
                                                    
                                                    $pdf->Cell(5,4,'','L',0,'C',0);    
                                                    $pdf->SetFont('Helvetica','B',$size_font);          
                                                    $pdf->Cell(183,4,Yii::t('app', 'Fortalezas, Recomendaciones y Debilidades'),'R',0,'L',0);
                                                    $pdf->Ln(4);
                                                        
                                                    foreach ($frds as $frd) 
                                                    {
                                                    
                                                        $pdf->Cell(5,4,'','L',0,'C',0);
                                                        $pdf->SetFont('Helvetica','B',$size_font);          
                                                        $pdf->Cell(23,4,$frd->tipos->tipo,'',0,'L',0);
                                                        
                                                        $pdf->SetFont('Helvetica','',$size_font);          
                                                        $pdf->MultiCell(160, 4,mb_strtoupper($frd->descripcion), 'R', '',0);                                    
                                                    }
                                                }
                                            }    
                                        }
                                    }
                                }
                            }

                    //------------------------------------------------------------------------------------


                            /////////////////////////////////////////////////////////////////////////////////////////////  
                            //
                            //    MOSTRAR FRD MANUALES NO POR DESEMPEÑO POR ESO VA POR FUERA 
                            //    DEL CONDICIONAL DE DESEMPEÑOS
                            //
                            /////////////////////////////////////////////////////////////////////////////////////////////                            

                            if($ver_frd == 1)
                            {
                                if ($grupo->sedes->frd == 0)  // FRD MANUALES ALMACENADOS EN CALIFICACIONES
                                {
                                    
                                    $frds = Calificacionfrd::find()
                                            ->where(['estudiante' => $estudiante->id])
                                            ->andWhere(['asignatura' => $asignatura->id])
                                            ->andWhere(['periodo' => $periodo])
                                            ->andWhere(['competencia' => $competencia->id])
                                            ->andWhere(['estado' => '1'])
                                            ->orderBy(['id' => SORT_ASC])
                                            ->all();
                                    

                                    if(count($frds) > 0)
                                    {
                                        //$pdf->SetFont('Helvetica','B',$size_font);          
                                        //$pdf->Cell(188,4,Yii::t('app', 'Fortalezas, Recomendaciones y Debilidades'),'LTR',0,'L',0);
                                        //$pdf->Ln(4);
                                    
                                        foreach ($frds as $frd) 
                                        {
                                            $pdf->setFillColor(230);
                                            $pdf->SetFont('Helvetica','B',$size_font);          
                                            $pdf->Cell(25,4,mb_strtoupper($frd->frds->tipos->tipo),'LTRB',0,'L',1);
                                            $pdf->setFillColor(255);
                                            $pdf->SetFont('Helvetica','',$size_font);
                                            $pdf->Cell(163,4,mb_strtoupper($frd->frds->descripcion),'LTRB',1,'L',0);
                                            //$pdf->MultiCell(158, 4,ucfirst(strtolower($frd->frds->descripcion)), 'R', 'J',0);
                                        }
                                    }
                                }
                            }


                            /////////////////////////////////////  FIN DE LOS FRD MANUALES   ///////////////////////////////////////////////// 

                            /*

                            $planes = Planmejoramiento::find()
                                    ->where(['grado' => $grupo->grados->id])
                                    ->andWhere(['asignatura' => $asignatura->id])
                                    ->andWhere(['grupo' => $grupo->id])
                                    ->andWhere(['periodo' => $periodo])
                                    ->andWhere(['competencia' => $competencia->id])
                                    ->all();
                            
                            if (count($planes) > 0)
                            {

                                foreach ($planes as $plan) 
                                {
                                    $pdf->SetFont('Helvetica','B',$size_font);          
                                    $pdf->Cell(30,4,mb_strtoupper(Yii::t('app', 'Plan de Mejoramiento')),'L',0,'L',0);
                                    //$pdf->Ln(4);
                                    $pdf->SetFont('Helvetica','',$size_font);          
                                    $pdf->MultiCell(158, 4,mb_strtoupper($plan->tematica), 'R', 'J',0);
                                }
                            } 
                            */       
                        }
                    }
                }

                //$pdf->MultiCell(188, 4,'id:'.$calificacion->id, 1, 'J',0);

                
                if(isset($calificacion))
                {
                    
                    if ($calificacion->observacion_general != '' or $calificacion->observacion_especifica != '')
                    {
                        $observaciones = explode(',', $calificacion->observacion_general);

                        $pdf->setFillColor(230);
                        $pdf->SetFont('Helvetica','B',$size_font);          
                        $pdf->Cell(188,4,mb_strtoupper(Yii::t('app', 'Observaciones')),'LTRB',0,'L',1);
                        $pdf->Ln(4);
                        $pdf->SetFont('Helvetica','',$size_font);          

                        $bloque = '';
                        foreach ($observaciones as $observacion) 
                        {
                            $general = Observaciongeneral::find()->where(['id' => $observacion])->one();

                            if($general != NULL)
                                $bloque .= '· '.mb_strtoupper($general->observacion).'. ';
                        }

                        if($calificacion->observacion_especifica != '')
                        {
                            $bloque .= '- '.mb_strtoupper($calificacion->observacion_especifica).'. ';
                        }   
                        if($bloque != '')
                        {
                            $pdf->MultiCell(188, 4, $bloque, 'LTRB', '',0);
                        }    
                    } 
                }    
                
            }

//////////////////////////   OBSERVACIONES GENERALES    //////////////////////////////////


            
            $comportamiento = Comportamiento::find()
                                ->where(['estudiante' => $estudiante->id])
                                ->andWhere(['grupo' => $grupo->id])
                                ->andWhere(['periodo' => $periodo])
                                ->one();

            //if(isset($comportamiento))
            //{    


                ///////////////////////  INICIO DE LA CALIFICACION DEL COMPORTAMIENTO  ////////////////////

                //$pdf->Ln(5);
                $pdf->setFillColor(255);
                $pdf->SetFont('Helvetica','',$size_font);    
      

                ///////   DEFINITIVA DEL COMPORTAMIENTO   ////////////

                $pdf->SetFont('Helvetica','B',$size_font);
                $pdf->Cell(168,5,mb_strtoupper(Yii::t('app', 'Comportamiento del Estudiante')),'LTRB',0,'C',1);

                $desempeno = new Desempeno();
                        
                //$pdf->setFillColor(255);
                //$pdf->SetTextColor(0);                          

                ////////////////////

                if($ver_emoticons == 0) // VER EMOTICONS - NO
                {
                    if($ver_colores == 1)
                    {
                        $color = $desempeno->hex2rgb($desempeno->color(isset($comportamiento) ? $comportamiento->definitiva : 0,$tipo_calificacion));
                        $pdf->setFillColor($color['r'],$color['g'],$color['b']);
                    }

                    if($ver_letrasonumeros == 0) // NOTA O DESEMPEÑO EN NUMERO
                    {
                        $desempenos = $desempeno->desempeno(isset($comportamiento) ? $comportamiento->definitiva : 0,$tipo_calificacion);
                        
                        $pdf->SetFont('Helvetica','B',$size_font);          
                        $pdf->SetTextColor(0);
                        $pdf->Cell(20,5,isset($comportamiento) ? $comportamiento->definitiva : 0,'LTRB',0,'C',1);
                        

                    }
                    else // NOTA O DESEMPEÑO EN LETRAS
                    {
                        //$desempenos = $desempeno->nota(isset($comportamiento) ? (float)$comportamiento->definitiva : 0,$tipo_calificacion);
                        $desempenos = $desempeno->desempeno(isset($comportamiento) ? $comportamiento->definitiva : 0,$tipo_calificacion);
                        
                        $pdf->SetFont('Helvetica','B',$size_font);          
                        $pdf->SetTextColor(0);
                        $pdf->Cell(20,5,$desempenos,'LTRB',0,'C',1);
                        //$pdf->Cell(20,5,isset($comportamiento) ? $comportamiento->definitiva : 0,'LTRB',0,'C',1);
                    }
                }
                else  // VER EMOTICONS - SI
                {
                    if($tipo_calificacion == 1) // LETRAS
                    {
                        $desempenos = isset($comportamiento) ? $comportamiento->definitiva : '';
                        
                        if($ver_colores == 1)
                        {
                            $color = $desempeno->hex2rgb($desempeno->color(isset($comportamiento) ? $comportamiento->definitiva : 'NE',$tipo_calificacion));
                            $pdf->setFillColor($color['r'],$color['g'],$color['b']);
                        }

                        $emoticons = $desempeno->emoticons(isset($comportamiento) ? $comportamiento->definitiva : 'NE',$tipo_calificacion);
                        
                        
                        $pdf->Cell(15,5,$desempenos,'LTRB',0,'C',1);
                    }
                    else // NUMEROS
                    {
                        if($ver_letrasonumeros == 0) // NOTA O DESEMPEÑO EN NUMERO
                        {
                            $desempenos = isset($comportamiento) ? $comportamiento->definitiva : '';
                            
                            if($ver_colores == 1)
                            {
                                $color = $desempeno->hex2rgb($desempeno->color(isset($comportamiento) ? $comportamiento->definitiva : 0,$tipo_calificacion));
                                $pdf->setFillColor($color['r'],$color['g'],$color['b']);
                            }

                            $emoticons = $desempeno->emoticons(isset($comportamiento) ? (float)$comportamiento->definitiva : 0,$tipo_calificacion);
                            
                            
                            $pdf->Cell(15,5,$desempenos,'LTRB',0,'C',1);
                        }
                        else
                        {
                            $desempenos = $desempeno->desempeno(isset($comportamiento) ? $comportamiento->definitiva : 0,$tipo_calificacion);
                            
                            if($ver_colores == 1)
                            {
                                $color = $desempeno->hex2rgb($desempeno->color(isset($comportamiento) ? $comportamiento->definitiva : 0,$tipo_calificacion));
                                $pdf->setFillColor($color['r'],$color['g'],$color['b']);
                            }

                            $emoticons = $desempeno->emoticons(isset($comportamiento) ? (float)$comportamiento->definitiva : 0,$tipo_calificacion);
                            
                            
                            $pdf->Cell(15,5,$desempenos,'LTRB',0,'C',1);
                        }
                    }

                    //$pdf->setFillColor($color['r'],$color['g'],$color['b']);
                    //$pdf->Cell(15,5,$desempenos,'LTRB',0,'C',1);

                    $x = $pdf->x+0.3;
                    $y = $pdf->y+0.3;

                    $pdf->Cell(5,5,'','LBTR',0,'C',0); 

                    $pdf->Image(Yii::getAlias('@web/images/smile/'.$emoticons),$x,$y,4.5);
                    $pdf->Ln(-5); 
                }



                //////////////////////////
                    
                $pdf->Ln(5);

                $pdf->SetFont('Helvetica','B',$size_font-2);
                
                if($ver_colores == 1)
                {
                    $pdf->setFillColor(230);
                }
                
                $pdf->Cell(28,3,mb_strtoupper(Yii::t('app', 'Histórico')),1,0,'C',1);

                for ($i=1; $i <=4 ; $i++) 
                { 
                    $pdf->SetFont('Helvetica','B',$size_font-2);
                    $pdf->setFillColor(230);
                    $pdf->Cell(5,3,mb_strtoupper(Yii::t('app', 'P').$i),1,0,'C',1);
                    

                    $historico_comportamiento = Comportamiento::find()
                                ->where(['estudiante' => $estudiante->id])
                                ->andWhere(['grupo' => $grupo->id])
                                ->andWhere(['periodo' => $i])
                                ->one();

                    
                    if(isset($historico_comportamiento))
                    {
                        $desempeno = new Desempeno();
                        
                        if($ver_colores == 1)
                        {
                            $color = $desempeno->hex2rgb($desempeno->color($historico_comportamiento->definitiva,$tipo_calificacion));
                        }
                        
                        if($ver_letrasonumeros == 0)
                        {
                            $nota = $historico_comportamiento->definitiva;
                            $desempenos = $desempeno->desempeno($historico_comportamiento->definitiva,$tipo_calificacion);
                        }
                        else
                        {
                            $nota = $desempeno->nota($historico_comportamiento->definitiva,$tipo_calificacion);
                            $desempenos = $desempeno->desempeno($historico_comportamiento->definitiva,$tipo_calificacion);  
                        }   

                        
                    }
                    else
                    {
                        if($ver_letrasonumeros == 0) // NOTA O DESEMPEÑO EN LETRAS
                        {
                            $desempeno = new Desempeno();

                            if($ver_colores == 1)
                            {
                                $color = $desempeno->hex2rgb($desempeno->color(0,$tipo_calificacion));
                                $pdf->SetTextColor(255);
                                $pdf->setFillColor($color['r'],$color['g'],$color['b']);
                            }

                            $nota = '';
                            $desempenos = '';
                        }
                        else // NOTA O DESEMPEÑO EN NUMEROS
                        {
                            $desempeno = new Desempeno();
                            
                            if($ver_colores == 1)
                            {
                                $color = $desempeno->hex2rgb($desempeno->color(0,$tipo_calificacion));
                                $pdf->SetTextColor(255);
                                $pdf->setFillColor($color['r'],$color['g'],$color['b']);
                            }

                            $nota = $desempeno->nota(0,$tipo_calificacion);
                            $desempenos = '';
                        } 
                    }    

                    $pdf->SetFont('Helvetica','B',$size_font-2);          
                    
                    $pdf->Cell(10,3,$nota,'LTRB',0,'C',1);
                    $pdf->setFillColor(255);
                    $pdf->SetTextColor(0);  
                    $pdf->Cell(25,3,$desempenos,'LTRB',0,'C',1);     
                }
                $pdf->Ln(3);
                ///////////////////////  FIN DE LA CALIFICACION DEL COMPORTAMIENTO  ////////////////////                


                //if ($comportamiento->observacion_general != '' or $comportamiento->observacion_especifica != '')
                //{

                    //$pdf->Ln(5);
                    $pdf->setFillColor(230);
                    $pdf->SetFont('Helvetica','B',$size_font);          
                    $pdf->Cell(188,4,mb_strtoupper(Yii::t('app', 'Observaciones Generales y Específicas')),'LTRB',0,'L',1);
                    
                    $bloque = '';

                    if(isset($comportamiento))
                    {
                        if($comportamiento->observacion_general != '')
                        {
                            $observaciones = explode(',', $comportamiento->observacion_general);    

                            foreach ($observaciones as $observacion) 
                            {
                                $general = Observaciongeneral::find()->where(['id' => $observacion])->one();

                                if($general != NULL)
                                {
                                    $bloque .= '· '.mb_strtoupper($general->observacion).' ';
                                }
                            }
                        }

                        
                        if($comportamiento->observacion_especifica != '')
                        {
                            $bloque .= '· '.mb_strtoupper($comportamiento->observacion_especifica).' ';
                        } 
                    }

                    if($bloque != '')
                    {
                        $pdf->Ln(4);
                        $pdf->SetFont('Helvetica','',$size_font);          
                        $pdf->MultiCell(188, 4,$bloque, 'LTRB', '',0);
                        //$pdf->Ln(4);
                    }    
                //}                

            //}    

            
//////////////////////////////////////////// COMPROMISOS DEL ACUDIENTE /////////////////////////


            $calificacioncompromisos = Calificacioncompromisos::find()
                    ->select(['valoracion'])
                    ->where(['estudiante' => $estudiante->id])
                    ->andWhere(['grupo' => $grupo->id])
                    ->andWhere(['periodo' => $periodo])
                    ->one();
        
            if(isset($calificacioncompromisos))
            {    


///////////////////////  INICIO DE LA CALIFICACION DEL COMPORTAMIENTO ACUDIENTE ////////////////////

                //$pdf->Ln(5);
                $pdf->setFillColor(255);
                $pdf->SetFont('Helvetica','',$size_font);    
      

                ///////   DEFINITIVA DEL COMPORTAMIENTO   ////////////

                $compromiso = Compromisosacudiente::find()->where(['eliminado_por' => '0'])->one();

                $pdf->SetFont('Helvetica','B',$size_font);
                //$pdf->Cell(168,5,mb_strtoupper(Yii::t('app', 'Comportamiento del Acudiente')),'LTRB',0,'C',1);
                $pdf->Cell(168,5,mb_strtoupper($compromiso->compromiso),'LTRB',0,'C',1);

                $desempeno = new Desempeno();
                        
                //$pdf->setFillColor(255);
                //$pdf->SetTextColor(0);                          

                ////////////////////

                if($ver_emoticons == 0) // VER EMOTICONS - NO
                {
                    if($ver_colores == 1)
                    {
                        $color = $desempeno->hex2rgb($desempeno->color(isset($calificacioncompromisos) ? $calificacioncompromisos->valoracion : 0,$tipo_calificacion));
                        $pdf->setFillColor($color['r'],$color['g'],$color['b']);
                    }

                    if($ver_letrasonumeros == 0) // NOTA O DESEMPEÑO EN NUMERO
                    {
                        $desempenos = $desempeno->desempeno(isset($calificacioncompromisos) ? $calificacioncompromisos->valoracion : 0,$tipo_calificacion);
                        
                        $pdf->SetFont('Helvetica','B',$size_font);          
                        $pdf->SetTextColor(0);
                        $pdf->Cell(20,5,isset($calificacioncompromisos) ? $calificacioncompromisos->valoracion : 0,'LTRB',0,'C',1);
                        

                    }
                    else // NOTA O DESEMPEÑO EN LETRAS
                    {
                        //$desempenos = $desempeno->nota(isset($comportamiento) ? (float)$comportamiento->definitiva : 0,$tipo_calificacion);
                        $desempenos = $desempeno->desempeno(isset($calificacioncompromisos) ? $calificacioncompromisos->valoracion : 0,$tipo_calificacion);
                        
                        $pdf->SetFont('Helvetica','B',$size_font);          
                        $pdf->SetTextColor(0);
                        $pdf->Cell(20,5,$desempenos,'LTRB',0,'C',1);
                        //$pdf->Cell(20,5,isset($comportamiento) ? $comportamiento->definitiva : 0,'LTRB',0,'C',1);
                    }
                }
                else  // VER EMOTICONS - SI
                {
                    if($tipo_calificacion == 1) // LETRAS
                    {
                        $desempenos = isset($calificacioncompromisos) ? $calificacioncompromisos->valoracion : '';
                        
                        if($ver_colores == 1)
                        {
                            $color = $desempeno->hex2rgb($desempeno->color(isset($calificacioncompromisos) ? $calificacioncompromisos->valoracion : 'NE',$tipo_calificacion));
                            $pdf->setFillColor($color['r'],$color['g'],$color['b']);
                        }

                        $emoticons = $desempeno->emoticons(isset($calificacioncompromisos) ? $calificacioncompromisos->valoracion : 'NE',$tipo_calificacion);
                        
                        
                        $pdf->Cell(15,5,$desempenos,'LTRB',0,'C',1);
                    }
                    else // NUMEROS
                    {
                        if($ver_letrasonumeros == 0) // NOTA O DESEMPEÑO EN NUMERO
                        {
                            $desempenos = isset($calificacioncompromisos) ? $calificacioncompromisos->valoracion : '';
                            
                            if($ver_colores == 1)
                            {
                                $color = $desempeno->hex2rgb($desempeno->color(isset($calificacioncompromisos) ? $calificacioncompromisos->valoracion : 0,$tipo_calificacion));
                                $pdf->setFillColor($color['r'],$color['g'],$color['b']);
                            }

                            $emoticons = $desempeno->emoticons(isset($calificacioncompromisos) ? (float)$calificacioncompromisos->valoracion : 0,$tipo_calificacion);
                            
                            
                            $pdf->Cell(15,5,$desempenos,'LTRB',0,'C',1);
                        }
                        else
                        {
                            $desempenos = $desempeno->desempeno(isset($calificacioncompromisos) ? $calificacioncompromisos->valoracion : 0,$tipo_calificacion);
                            
                            if($ver_colores == 1)
                            {
                                $color = $desempeno->hex2rgb($desempeno->color(isset($calificacioncompromisos) ? $calificacioncompromisos->valoracion : 0,$tipo_calificacion));
                                $pdf->setFillColor($color['r'],$color['g'],$color['b']);
                            }

                            $emoticons = $desempeno->emoticons(isset($calificacioncompromisos) ? (float)$calificacioncompromisos->valoracion : 0,$tipo_calificacion);
                            
                            
                            $pdf->Cell(15,5,$desempenos,'LTRB',0,'C',1);
                        }
                    }

                    //$pdf->setFillColor($color['r'],$color['g'],$color['b']);
                    //$pdf->Cell(15,5,$desempenos,'LTRB',0,'C',1);

                    $x = $pdf->x+0.3;
                    $y = $pdf->y+0.3;

                    $pdf->Cell(5,5,'','LBTR',0,'C',0); 

                    $pdf->Image(Yii::getAlias('@web/images/smile/'.$emoticons),$x,$y,4.5);
                    $pdf->Ln(-5); 
                }



                //////////////////////////
                    
                $pdf->Ln(5);

                $pdf->SetFont('Helvetica','B',$size_font-2);
                
                if($ver_colores == 1)
                {
                    $pdf->setFillColor(230);
                }
                
                $pdf->Cell(28,3,mb_strtoupper(Yii::t('app', 'Histórico')),1,0,'C',1);

                for ($i=1; $i <=4 ; $i++) 
                { 
                    $pdf->SetFont('Helvetica','B',$size_font-2);
                    $pdf->setFillColor(230);
                    $pdf->Cell(5,3,mb_strtoupper(Yii::t('app', 'P').$i),1,0,'C',1);
                    

                    $historico_comportamiento = Calificacioncompromisos::find()
                        ->where(['estudiante' => $estudiante->id])
                        ->andWhere(['grupo' => $grupo->id])
                        ->andWhere(['periodo' => $i])
                        ->one();


                    
                    if(isset($historico_comportamiento))
                    {
                        $desempeno = new Desempeno();
                        
                        if($ver_colores == 1)
                        {
                            $color = $desempeno->hex2rgb($desempeno->color($historico_comportamiento->valoracion,$tipo_calificacion));
                        }
                        
                        if($ver_letrasonumeros == 0)
                        {
                            $nota = $historico_comportamiento->definitiva;
                            $desempenos = $desempeno->desempeno($historico_comportamiento->valoracion,$tipo_calificacion);
                        }
                        else
                        {
                            $nota = $desempeno->nota($historico_comportamiento->valoracion,$tipo_calificacion);
                            $desempenos = $desempeno->desempeno($historico_comportamiento->valoracion,$tipo_calificacion);  
                        }   

                        
                    }
                    else
                    {
                        if($ver_letrasonumeros == 0) // NOTA O DESEMPEÑO EN LETRAS
                        {
                            $desempeno = new Desempeno();

                            if($ver_colores == 1)
                            {
                                $color = $desempeno->hex2rgb($desempeno->color(0,$tipo_calificacion));
                                $pdf->SetTextColor(255);
                                $pdf->setFillColor($color['r'],$color['g'],$color['b']);
                            }

                            $nota = '';
                            $desempenos = '';
                        }
                        else // NOTA O DESEMPEÑO EN NUMEROS
                        {
                            $desempeno = new Desempeno();
                            
                            if($ver_colores == 1)
                            {
                                $color = $desempeno->hex2rgb($desempeno->color(0,$tipo_calificacion));
                                $pdf->SetTextColor(255);
                                $pdf->setFillColor($color['r'],$color['g'],$color['b']);
                            }

                            $nota = $desempeno->nota(0,$tipo_calificacion);
                            $desempenos = '';
                        } 
                    }    

                    $pdf->SetFont('Helvetica','B',$size_font-2);          
                    
                    $pdf->Cell(10,3,$nota,'LTRB',0,'C',1);
                    $pdf->setFillColor(255);
                    $pdf->SetTextColor(0);  
                    $pdf->Cell(25,3,$desempenos,'LTRB',0,'C',1);     
                }
                $pdf->Ln(3);
                ///////////////////////  FIN DE LA CALIFICACION DEL COMPORTAMIENTO ACUDIENTE  ////////////////////                
               

            }                


            $pdf->Ln(3);

            $pdf->SetFont('Helvetica','',$size_font-2);

            $niveles = Desempeno::find()->where(['tipo_calificacion' => $tipo_calificacion])->andWhere(['estado' => 1])->all();    
                
            foreach ($niveles as $nivel) 
            {
                $desempeno = new Desempeno();

                if($ver_colores == 1)
                {
                    $color = $desempeno->hex2rgb($nivel->color);
                    $pdf->setFillColor($color['r'],$color['g'],$color['b']);
                }
                
                
                $pdf->Cell(5,3,$nivel->nota,'LBT',0,'C',1);
                $pdf->setFillColor(255);

                $pdf->Cell(12 ,3,mb_strtoupper($nivel->desempeno),'BTR',0,'C',0);    
            }


            $pdf->Ln(8);

            $pdf->SetFont('Helvetica','',$size_font);
            //$pdf->Ln(8);
            //$pdf->Cell(180,6,"En constancia de entrega y publicación del informe valorativo y en constancia firmamos. ",0,0);
            
            $pdf->SetFont('Helvetica','B',$size_font);

            $y = $pdf->y;
            $x = $pdf->x;

            if($director_firma != '' or $director_firma != NULL )
            {
                $pdf->Image(\Yii::getAlias('@webroot/uploads/'.$director_firma),$x+30,$y,50);    
            }    
            
            
            $pdf->Image(\Yii::getAlias('@web/uploads/'.$grupo->sedes->rector_firma),$x+105,$y,50);
            
            $pdf->setY($pdf->y-15);
            $pdf->Cell(30);
            $pdf->Cell(60,5,$director_nombre,'T',0,'C',0);

            $pdf->Cell(15);
            $pdf->Cell(60,5,$grupo->sedes->rector_nombre,'T',0,'C',0);

            $pdf->Ln(3);
            $pdf->SetFont('Helvetica','',$size_font);
            $pdf->Cell(25);
            $pdf->Cell(60,5,Yii::t('app', 'Director(a)'),'',0,'C',0);
            $pdf->Cell(15);
            $pdf->Cell(60,5,Yii::t('app', 'Rector(a)'),'',0,'C',0);
            $pdf->Ln(1); 


        }

        $pdf->Output("R703-Reporte-Valorativo-Estudiante(".date("d-m-Y_H-i").").pdf",'D');
    }

  

}
