<?php

namespace backend\controllers;

use Yii;
use backend\models\Academico;
use backend\models\Carga;
use backend\models\Tercero;
use backend\models\Asistencia;
use backend\models\Comportamiento;
use backend\models\AsistenciaSearch;
use backend\models\Grupo;
use backend\models\Asignatura;
use backend\models\Periodo;
use backend\models\TipoInasistencia;
use backend\models\Calificacion;
use backend\models\Desempeno;
use backend\models\Competencia;
use backend\models\Sede;
use backend\models\Compromisosacudiente;
use backend\models\Calificacioncompromisos;
use backend\models\LanzadorForm;
use backend\models\Calificacioncalificaciones;
use backend\models\Promedio;

use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\helpers\ArrayHelper;
use yii\data\ActiveDataProvider;
use yii\base\Model;
use yii\helpers\Html;
use yii\web\Response;
use yii\widgets\ActiveForm;

use Mpdf\Mpdf;

class Reporte704Controller extends Controller
{

    public function actionIndex($grupo = NULL, $asignatura = NULL) // Reporte Valorativo Condensado (Boletín de Calificaciones) por Grupo
    {

        if($grupo == NULL && $asignatura == NULL)
        {    
            $model = new LanzadorForm(['scenario'=>'grupo-periodo']);

            $model->reporte = Yii::t('app', 'R704-Reporte');
            $model->observaciones = Yii::t('app', 'R704-Observaciones');
            
            if (Yii::$app->request->isAjax && $model->load(Yii::$app->request->post())) {
                Yii::$app->response->format = Response::FORMAT_JSON;
                return ActiveForm::validate($model);
            }

            if ($model->load(Yii::$app->request->post())) {

                $grado = $model->grado;
                $grupo = $model->grupo;
                $periodo = $model->periodo;
                $ver_fecha = $model->ver_fecha;
                $ver_letrasonumeros = $model->ver_letrasonumeros;
                $ver_parametros = $model->ver_parametros;
                $ver_colores = $model->ver_colores;
                $size_font = $model->fuente;
                $alto = $model->alto;
                
            }
            else
            {
                if (Yii::$app->request->isAjax) 
                {
                    return $this->renderAjax('/publica/lanzador', [
                            'model' => $model,
                            'sede' => true,
                            'tercero' => false,
                            'grado' => true,
                            'grupo' => true,
                            'asignatura' => false,
                            'periodo' => true,
                            'competencia' => false,
                            'columnas' => false,
                            'ver_estandar' => false,
                            'ver_competencia' => false,
                            'ver_niveles' => false,
                            'ver_desempenos' => false,
                            'ver_frd' => false,
                            'ver_fecha' => true,
                            'ver_letrasonumeros' => true,
                            'ver_parametros' => true,
                        ]);

                    exit;
                }
                else
                {
                    return $this->render('/publica/lanzador', [
                            'model' => $model,
                            'sede' => true,
                            'tercero' => false,
                            'grado' => true,
                            'grupo' => true,
                            'asignatura' => false,
                            'periodo' => true,
                            'competencia' => false,
                            'columnas' => false,
                            'ver_estandar' => false,
                            'ver_competencia' => false,
                            'ver_niveles' => false,
                            'ver_desempenos' => false,
                            'ver_frd' => false,
                            'ver_fecha' => true,
                            'ver_letrasonumeros' => true,
                            'ver_parametros' => true,
                        ]);

                    exit;
                }

            }    
        }
        else
        {
            $grado = Yii::$app->request->get('grado');
            $grupo = Yii::$app->request->get('grupo');
            $periodo = Yii::$app->request->get('periodo');
            $size_font = 7;
            $ver_colores = 1;
            $size_font = 7;
            $alto = 3;
            
        }

        if($periodo == 5)
        {
            list($condicionpromocion) = Yii::$app->createController('condicionpromocion');
            $condicionpromocion->actionComprobar($grupo);
            
        }
        

        date_default_timezone_set('America/Bogota');
        setlocale(LC_TIME,"es_ES");

        $grupo = Grupo::find()->where(['id' => $grupo])->one();

        $tipo_calificacion = $grupo->grados->tipo_calificacion;

        $calificacionxcompetencia = $grupo->grados->calificacionxcompetencia;

        if(isset($grupo->director))
        {
            $director_nombre = $grupo->directores->nombre;
            $director_firma = $grupo->directores->firma != NULL ? $grupo->directores->firma : '';
        }
        else
        {
            $director_nombre = Yii::t('app', 'R704-Director(a) de Grupo');
            //'Director(a) de Grupo'
            $director_firma = '';
        }
        
        $sede = Sede::FindOne($grupo->sede);



        $pdf = new Mpdf(['mode' => 'utf-8',
                         'format' => 'LETTER',
                         'default_font_size' => 0,
                         'default_font' => '',
                         'margin_left' => 15,
                         'margin_right' => 15,
                         'margin_top' => 32,
                         'margin_bottom' => 16,
                         'margin_header' => 9,
                         'margin_footer' => 9,
                         'orientation' => 'L']);  
        

        if ($sede->pdf_marcadeagua == 'T' OR $sede->pdf_marcadeagua == 'B')
        {
            $pdf->SetWatermarkText($sede->pdf_marcadeagua_contenido);
            $pdf->showWatermarkText = true;
            $pdf->watermarkTextAlpha = 0.1;
        }

        if ($sede->pdf_marcadeagua == 'I')
        {
            $pdf->SetWatermarkImage($sede->pdf_marcadeagua_contenido);
            $pdf->showWatermarkImage = true;
            $pdf->watermarkImageAlpha = 0.1;
        }

        $pdf->setHeader($sede->pdf_header);
        $pdf->setFooter($sede->pdf_footer);
        
        $pdf->AliasNbPages();

        $pdf->AddPage(0,'Letter');

        $pdf->SetFillColor(255);
        $pdf->SetTextColor(0);
        $pdf->SetDrawColor(0,0,0);
    
        if($ver_fecha == 1)
        {
            $fecha = strftime("%A, %d de %B de %Y");
            $pdf->setX(200);
            $pdf->SetFont('helvetica','',$size_font);
            $pdf->Cell(60,$alto + 2,$fecha,0,0,'R');
            $pdf->Ln($alto + 2);    
        }    
        
        $pdf->SetFont('Helvetica','B',$size_font + 2);   
        $pdf->Cell(250,$alto + 2,Yii::t('app', 'R704-SABANA DE NOTAS'),0,0,'C',0);

        $pdf->Ln($alto + 2);        
        
        $pdf->SetFont('Helvetica','B',$size_font);
        $pdf->Cell(15,$alto + 2,Yii::t('app', 'Sede'),0,0);
        $pdf->SetFont('Helvetica','',$size_font);    
        $pdf->Cell(55,$alto + 2,$grupo->sedes->sede,0,0);

        $pdf->SetFont('Helvetica','B',$size_font);
        $pdf->Cell(15,$alto + 2,Yii::t('app', 'Jornada'),0,0);
        $pdf->SetFont('Helvetica','',$size_font);    
        $pdf->Cell(20,$alto + 2,$grupo->jornadas->jornada,0,0);  

        $pdf->SetFont('Helvetica','B',$size_font);
        $pdf->Cell(12,$alto + 2,Yii::t('app', 'Grupo'),0,0);
        $pdf->SetFont('Helvetica','',$size_font);    
        $pdf->Cell(25,$alto + 2,$grupo->grupo,0,0);

        $pdf->SetFont('Helvetica','B',$size_font);
        $pdf->Cell(13,$alto + 2,Yii::t('app', 'Periodo'),0,0);
        $pdf->SetFont('Helvetica','',$size_font);    
        $pdf->Cell(8,$alto + 2,$periodo,0,0);
        
        
        $pdf->SetFont('Helvetica','B',$size_font);
        $pdf->Cell(10,$alto + 2,Yii::t('app', 'Año'),0,0);
        $pdf->SetFont('Helvetica','',$size_font);    
        $pdf->Cell(8,$alto + 2,date('Y'),0,0);

        $pdf->Ln($alto + 2);
        $pdf->setFillColor(230);
        $pdf->SetFont('Helvetica','B',$size_font - 2);
        $pdf->Cell(5,$alto + 2,Yii::t('app', '#'),1,0,'J',1);
        $pdf->Cell(50,$alto + 2,mb_strtoupper(Yii::t('app', 'Estudiante')),1,0,'C',1);

        $asignaturas = Asignatura::find()->where(['grado' => $grupo->grados->id])->andWhere(['eliminado_por' => '0'])->all();

            
        foreach ($asignaturas as $asignatura) 
        {
            $pdf->SetFont('Helvetica','B',$size_font - 2);
            $pdf->Cell(8,$alto + 2,mb_strtoupper(substr($asignatura->codigo,0,5)),1,0,'C',1); 
        }

        $pdf->SetFont('Helvetica','B',$size_font - 2);
        $pdf->Cell(8,$alto + 2,mb_strtoupper('COMPO'),1,0,'C',1); 

        if($tipo_calificacion != 1) // MUESTRA SI EL TIPO DE CALIFICACION ES NUMERICO - 1 = LETRAS 2,3 = NUMEROS
        {
            $pdf->Cell(8,$alto + 2,mb_strtoupper(Yii::t('app', 'PROM')),1,0,'C',1);
            $pdf->Cell(8,$alto + 2,mb_strtoupper(Yii::t('app', 'PUESTO')),1,0,'C',1); 
        }

        $pdf->Cell(8,$alto + 2,mb_strtoupper(Yii::t('app', 'G')),1,0,'C',1); 
        $pdf->Cell(8,$alto + 2,mb_strtoupper(Yii::t('app', 'P')),1,0,'C',1); 

        if($periodo == 5)
        {
            $pdf->Cell(14,$alto + 2,mb_strtoupper(Yii::t('app', 'Promovido')),1,0,'C',1); 
        }

        $pdf->Ln($alto + 2);
        
        $estudiantes = Academico::find()->select(['tercero.id', 'academico.estudiante', 'academico.grupo','academico.especialidad', 'academico.aprobo'])->joinWith(['estudiantes'])->where(['<', 'tercero.estado', 3])->andWhere(['academico.grupo' => $grupo->id])->andWhere(['tercero.eliminado_por' => 0])->andWhere(['academico.eliminado_por' => 0])->orderBy('primer_apellido')->all();  
        
        $x=1;

        foreach ($estudiantes as $estudiante) 
        {
            $perdidas = 0;
            $ganadas = 0;

            $pdf->setFillColor(255);
            $pdf->SetFont('Helvetica','',$size_font-2);  

            $nombre = mb_strtoupper($estudiante->estudiantes->nombreinverso);

            $pdf->Cell(5,$alto,$x,1,0,'J',0);
            $pdf->Cell(50,$alto,$nombre,1,0,'J',0);
            $x++;
            foreach ($asignaturas as $asignatura) 
            {
            
                $calificacion = Calificacion::find()
                        ->where(['estudiante' => $estudiante->id])
                        ->andWhere(['grupo' => $grupo->id])
                        ->andWhere(['asignatura' => $asignatura->id])
                        ->andWhere(['periodo' => $periodo])
                        ->one();

            //$pdf->Cell(10,$alto + 2,mb_strtoupper(Yii::t('app', 'Def')),'LBTR',0,'C',1);

                if(isset($calificacion))
                {


                    $desempeno = new Desempeno();
                    
                    $color = $desempeno->hex2rgb($desempeno->color($calificacion->definitiva_final_periodo,$tipo_calificacion));
                    
                    if($ver_colores == 1)
                    {
                        $pdf->setFillColor($color['r'],$color['g'],$color['b']);    
                    }    
                    

                    

                    if($tipo_calificacion == 1) // TIPO DE CALIFICACION LETRAS
                    {   
                        $nota = ($calificacion->definitiva_final_periodo == '') ? 'NE' : $calificacion->definitiva_final_periodo;

                        $perdido = Desempeno::find()->where(['nota' => $nota])->andWhere(['tipo_calificacion' => $tipo_calificacion])->one();
                        
                        if($perdido->perdido == 1)
                        {
                            $perdidas = $perdidas + 1;
                        }    
                        else
                        {
                            $ganadas = $ganadas + 1;
                        }
                    }
                    else
                    {
                        $perdido = Desempeno::find()->where(['nota' => $calificacion->definitiva_final_periodo])->andWhere(['tipo_calificacion' => $tipo_calificacion])->one();
                    }

                    
                    if($ver_letrasonumeros == 1) // LETRAS
                    {
                        $desempenos = $desempeno->nota($calificacion->definitiva_final_periodo, $tipo_calificacion);
                        $pdf->Cell(8,$alto,$desempenos,'LBTR',0,'C',1);
                        //$desempenos = $desempeno->nota($calificacion->definitiva_final_periodo,$tipo_calificacion);
                        //$pdf->Cell(8,$alto + 2,$desempenos,'LBTR',0,'C',0);
                    }
                    else // NUMEROS
                    { 
                        $pdf->Cell(8,$alto,$calificacion->definitiva_final_periodo == 0 ? '': $calificacion->definitiva_final_periodo,'LBTR',0,'C',1); 
                        //$desempenos = $desempeno->nota($calificacion->definitiva_final_periodo,$tipo_calificacion);
                        //$pdf->Cell(8,$alto + 2,$desempenos,'LBTR',0,'C',0);
                    }    
                    
                    $pdf->setFillColor(255); 
                }
                else
                {
                    $desempeno = new Desempeno();
                    $color = $desempeno->hex2rgb($desempeno->color(0,$tipo_calificacion));
                    $desempenos = $desempeno->nota(0,$tipo_calificacion);   
                    
                    if($ver_colores == 1)
                    {
                        $pdf->setFillColor($color['r'],$color['g'],$color['b']);    
                    }    
                    
                    $pdf->Cell(8,$alto,'','LBTR',0,'C',1);
                    $pdf->setFillColor(255);

                    $perdidas = $perdidas + 1;
                }    
            }



/////////////   CALIFICACION DE COMPORTAMIENTO   ////////////////////

                
                $comportamiento = Comportamiento::find()
                        ->where(['estudiante' => $estudiante->id])
                        ->andWhere(['grupo' => $grupo->id])
                        ->andWhere(['periodo' => $periodo])
                        ->one();

            //$pdf->Cell(10,$alto + 2,mb_strtoupper(Yii::t('app', 'Def')),'LBTR',0,'C',1);

                if(isset($comportamiento))
                {


                    $desempeno = new Desempeno();
                    
                    $color = $desempeno->hex2rgb($desempeno->color($comportamiento->definitiva,$tipo_calificacion));
                    
                    
                    if($ver_colores == 1)
                    {
                        $pdf->setFillColor($color['r'],$color['g'],$color['b']);    
                    }    
                    

                    

                    if($tipo_calificacion == 1) // TIPO DE CALIFICACION LETRAS
                    {   
                        $nota = ($comportamiento->definitiva == '') ? 'NE' : $comportamiento->definitiva;

                        //$desempenos = $desempeno->nota($comportamiento->definitiva, $tipo_calificacion);
                        //$pdf->Cell(8,$alto,$comportamiento->definitiva."-".$desempenos,'LBTR',0,'C',1);

                        //$perdido = Desempeno::find()->where(['nota' => $nota])->andWhere(['tipo_calificacion' => $tipo_calificacion])->one();
                        
                        /*if($perdido->perdido == 1)
                        {
                            $perdidas = $perdidas + 1;
                        }    
                        else
                        {
                            $ganadas = $ganadas + 1;
                        }*/
                    }
                    else
                    {
                        //$perdido = Desempeno::find()->where(['nota' => $comportamiento->definitiva])->andWhere(['tipo_calificacion' => $tipo_calificacion])->one();
                    }

                    
                    if($ver_letrasonumeros == 1) // LETRAS
                    {
                        $desempenos = $desempeno->nota($comportamiento->definitiva, $tipo_calificacion);
                        $pdf->Cell(8,$alto,$desempenos,'LBTR',0,'C',1);
                        //$desempenos = $desempeno->nota($comportamiento->definitiva_final_periodo,$tipo_calificacion);
                        //$pdf->Cell(8,$alto + 2,$desempenos,'LBTR',0,'C',0);
                    }
                    else // NUMEROS
                    { 
                        $pdf->Cell(8,$alto,$comportamiento->definitiva == 0 ? '': $comportamiento->definitiva,'LBTR',0,'C',1); 
                        //$desempenos = $desempeno->nota($comportamiento->definitiva_final_periodo,$tipo_calificacion);
                        //$pdf->Cell(8,$alto + 2,$desempenos,'LBTR',0,'C',0);
                    }    
                    
                    $pdf->setFillColor(255); 
                }
                else
                {
                    $desempeno = new Desempeno();
                    $color = $desempeno->hex2rgb($desempeno->color(0,$tipo_calificacion));
                    $desempenos = $desempeno->nota(0,$tipo_calificacion);   
                    
                    if($ver_colores == 1)
                    {
                        $pdf->setFillColor($color['r'],$color['g'],$color['b']);    
                    }    
                    
                    $pdf->Cell(8,$alto,'','LBTR',0,'C',1);
                    $pdf->setFillColor(255);

                    //$perdidas = $perdidas + 1;
                }




////////////////////////////////////////////////////////////////////



            if($tipo_calificacion != 1) // MUESTRA SI EL TIPO DE CALIFICACION ES NUMERICO - 1 = LETRAS 2,3 = NUMEROS
            {
                $promedio = Promedio::find()
                            ->where(['estudiante' => $estudiante->id])
                            ->andWhere(['grupo' => $grupo->id])
                            ->andWhere(['periodo' => $periodo])
                            ->one();

                $desempeno = new Desempeno();
                $color = $desempeno->hex2rgb($desempeno->color(0,$tipo_calificacion));
                
                if($ver_colores == 1)
                {
                    $pdf->setFillColor($color['r'],$color['g'],$color['b']);    
                }    
                
                $pdf->Cell(8,$alto,$promedio->promedio_estudiante,1,0,'C',1);

                $pdf->setFillColor(255); 
                $pdf->Cell(8,$alto,$promedio->puesto_grupo,1,0,'C',0); 
            }

            $pdf->Cell(8,$alto,$ganadas,1,0,'C',0); 
            $pdf->Cell(8,$alto,$perdidas,1,0,'C',0);

            if($periodo == 5)
            {
                $pdf->Cell(14,$alto,($estudiante->aprobo == '1') ? Yii::t('app', 'Aprobado') : Yii::t('app', 'Reprobado'),1,0,'C',0); 
            }

            $pdf->Ln($alto);
                
        }

        $pdf->Output("R704-Sabana-Notas-Grupo(".date("d-m-Y_H-i").").pdf",'D');
    }  

}
