<?php

namespace backend\controllers;

use Yii;
use backend\models\Academico;
use backend\models\Carga;
use backend\models\Tercero;
use backend\models\Asistencia;
use backend\models\AsistenciaSearch;
use backend\models\Grupo;
use backend\models\Asignatura;
use backend\models\Periodo;
use backend\models\TipoInasistencia;
use backend\models\Calificacion;
use backend\models\Desempeno;
use backend\models\Competencia;
use backend\models\Sede;
use backend\models\Compromisosacudiente;
use backend\models\Calificacioncompromisos;
use backend\models\LanzadorForm;
use backend\models\Calificacioncalificaciones;

use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\helpers\ArrayHelper;
use yii\data\ActiveDataProvider;
use yii\base\Model;
use yii\helpers\Html;
use yii\web\Response;
use yii\widgets\ActiveForm;

use Mpdf\Mpdf;

class Reporte705Controller extends Controller
{

    public function actionIndex($grupo = NULL, $asignatura = NULL) // Reporte Valorativo Condensado (Boletín de Calificaciones) por Grupo
    {

        if($grupo == NULL && $asignatura == NULL)
        {    
            $model = new LanzadorForm(['scenario'=>'grupo']);

            $model->reporte = Yii::t('app', 'R705-Reporte');
            $model->observaciones = Yii::t('app', 'R705-Observaciones');
            
            if (Yii::$app->request->isAjax && $model->load(Yii::$app->request->post())) {
                Yii::$app->response->format = Response::FORMAT_JSON;
                return ActiveForm::validate($model);
            }

            if ($model->load(Yii::$app->request->post())) {

                $grado = $model->grado;
                $grupo = $model->grupo;
                $periodo = $model->periodo;
                $ver_fecha = $model->ver_fecha;
                $ver_letrasonumeros = $model->ver_letrasonumeros;
                $ver_parametros = $model->ver_parametros;
                $ver_colores = $model->ver_colores;
                $size_font = $model->fuente;
                $alto = $model->alto;
                
            }
            else
            {
                if (Yii::$app->request->isAjax) 
                {
                    return $this->renderAjax('/publica/lanzador', [
                            'model' => $model,
                            'sede' => true,
                            'tercero' => false,
                            'grado' => true,
                            'grupo' => true,
                            'asignatura' => false,
                            'periodo' => false,
                            'competencia' => false,
                            'columnas' => false,
                            'ver_estandar' => false,
                            'ver_competencia' => false,
                            'ver_niveles' => false,
                            'ver_desempenos' => false,
                            'ver_frd' => false,
                            'ver_fecha' => true,
                            'ver_letrasonumeros' => true,
                            'ver_parametros' => true,
                        ]);

                    exit;
                }
                else
                {
                    return $this->render('/publica/lanzador', [
                            'model' => $model,
                            'sede' => true,
                            'tercero' => false,
                            'grado' => true,
                            'grupo' => true,
                            'asignatura' => false,
                            'periodo' => false,
                            'competencia' => false,
                            'columnas' => false,
                            'ver_estandar' => false,
                            'ver_competencia' => false,
                            'ver_niveles' => false,
                            'ver_desempenos' => false,
                            'ver_frd' => false,
                            'ver_fecha' => true,
                            'ver_letrasonumeros' => true,
                            'ver_parametros' => true,
                        ]);

                    exit;
                }

            }    
        }
        else
        {
            $grado = Yii::$app->request->get('grado');
            $grupo = Yii::$app->request->get('grupo');
            $periodo = Yii::$app->request->get('periodo');
            $size_font = 7;
            $ver_colores = 1;
            $size_font = 7;
            $alto = 3;
            
        }

        $periodo_actual = new Periodo();
        $periodo_actual = $periodo_actual->actual->id;

        date_default_timezone_set('America/Bogota');
        setlocale(LC_TIME,"es_ES");

        $grupo = Grupo::find()->where(['id' => $grupo])->one();

        if(isset($grupo->director))
        {
            $director_nombre = $grupo->directores->nombre;
            $director_firma = $grupo->directores->firma != NULL ? $grupo->directores->firma : '';
        }
        else
        {
            $director_nombre = Yii::t('app', 'R705-Director(a) de Grupo');
            //'Director(a) de Grupo'
            $director_firma = '';
        }
        
        $sede = Sede::FindOne($grupo->sede);
        $asignaturas = Asignatura::find()->where(['grado' => $grupo->grados->id])->all();


        $pdf = new Mpdf(['mode' => 'utf-8',
                         'format' => count($asignaturas) > 10 ? 'FOLIO' : 'LETTER',
                         'default_font_size' => 0,
                         'default_font' => '',
                         'margin_left' => 15,
                         'margin_right' => 15,
                         'margin_top' => 33,
                         'margin_bottom' => 20,
                         'margin_header' => 9,
                         'margin_footer' => 9,
                         'orientation' => count($asignaturas) > 10 ? 'L' : 'P' ]);  
        

        if ($sede->pdf_marcadeagua == 'T' OR $sede->pdf_marcadeagua == 'B')
        {
            $pdf->SetWatermarkText($sede->pdf_marcadeagua_contenido);
            $pdf->showWatermarkText = true;
            $pdf->watermarkTextAlpha = 0.1;
        }

        if ($sede->pdf_marcadeagua == 'I')
        {
            $pdf->SetWatermarkImage($sede->pdf_marcadeagua_contenido);
            $pdf->showWatermarkImage = true;
            $pdf->watermarkImageAlpha = 0.1;
        }

        $pdf->setHeader($sede->pdf_header);
        $pdf->setFooter($sede->pdf_footer);
        
        $pdf->AliasNbPages();

        $pdf->AddPage();

        $pdf->SetFillColor(255);
        $pdf->SetTextColor(0);
        $pdf->SetDrawColor(0,0,0);

        $pdf->SetFont('Helvetica','B',$size_font + 2);   
        $pdf->Cell(count($asignaturas) > 10 ? 250 : 190,$alto + 2,Yii::t('app', 'R705-SABANA DE NOTAS'),0,0,'C',0);

        $pdf->Ln($alto + 2);        
        
        $pdf->SetFont('Helvetica','B',$size_font);
        $pdf->Cell(15,$alto + 2,Yii::t('app', 'Sede'),0,0);
        $pdf->SetFont('Helvetica','',$size_font);    
        $pdf->Cell(55,$alto + 2,$grupo->sedes->sede,0,0);

        $pdf->SetFont('Helvetica','B',$size_font);
        $pdf->Cell(15,$alto + 2,Yii::t('app', 'Jornada'),0,0);
        $pdf->SetFont('Helvetica','',$size_font);    
        $pdf->Cell(20,$alto + 2,$grupo->jornadas->jornada,0,0);  

        $pdf->SetFont('Helvetica','B',$size_font);
        $pdf->Cell(12,$alto + 2,Yii::t('app', 'Grupo'),0,0);
        $pdf->SetFont('Helvetica','',$size_font);    
        $pdf->Cell(25,$alto + 2,$grupo->grupo,0,0);
        
        
        if($ver_fecha == 1)
        {
            $fecha = strftime("%A, %d de %B de %Y");
            $pdf->SetFont('Helvetica','B',$size_font);
            $pdf->Cell(10,$alto + 2,Yii::t('app', 'Fecha'),0,0);
            $pdf->SetFont('Helvetica','',$size_font);    
            $pdf->Cell(8,$alto + 2,$fecha,0,0);

        }    

        $pdf->Ln($alto + 2);
        
        $pdf->WriteHTML('<table cellspacing="0" cellpadding="0" style="padding:0px; margin:0px; border-collapse: collapse; border: 0px solid #000; font-family: Helvetica; font-size:'.$size_font.'px;">');
        $pdf->WriteHTML('<thead>');
        $pdf->WriteHTML('<tr>');
        $pdf->WriteHTML('<th width="10px" style="padding:5px; border: 1px solid #000; background-color:#eee; text-align:center;">'.Yii::t('app', '#').'</th>');
        $pdf->WriteHTML('<th width="100px" style="padding:5px; border: 1px solid #000; background-color:#eee; text-align:center;">'.mb_strtoupper(Yii::t('app', 'Estudiante')).'</th>');
            
        foreach ($asignaturas as $asignatura) 
        {
            //echo "<br>".$asignatura->codigo;

            $pdf->WriteHTML('<th width="10px" style="border: 1px solid #000; background-color:#eee; text-align:center; word-wrap: break-word;">'.Html::encode(mb_strtoupper(substr($asignatura->codigo,0,5))).'</th>');
        }

        $pdf->WriteHTML('<th width="10px" style="padding:5px; border: 1px solid #000; background-color:#eee; text-align:center;">'.mb_strtoupper(Yii::t('app', 'G')).'</th>');
        $pdf->WriteHTML('<th width="10px" style="padding:5px; border: 1px solid #000; background-color:#eee; text-align:center;">'.mb_strtoupper(Yii::t('app', 'P')).'</th>');
        $pdf->WriteHTML('</tr>');
        $pdf->WriteHTML('</thead>');
        $pdf->WriteHTML('<tbody>');

        $estudiantes = Academico::find()->select(['tercero.id', 'academico.estudiante', 'academico.grupo','academico.especialidad'])->joinWith(['estudiantes'])->where(['<', 'tercero.estado', 3])->andWhere(['academico.grupo' => $grupo->id])->orderBy('primer_apellido')->all();  
        
        $tipo_calificacion = $grupo->grados->tipo_calificacion;
        $calificacionxcompetencia = $grupo->grados->calificacionxcompetencia;

        //echo "<br>".$tipo_calificacion.' - '.$calificacionxcompetencia;


        $x=1;

        foreach ($estudiantes as $estudiante) 
        {
            $perdidas = 0;
            $ganadas = 0;

            

            $nombre = mb_strtoupper($estudiante->estudiantes->nombreinverso);

            //echo "<br>Nombre: ".$nombre;

            //$pdf->WriteHTML($nombre);


            $pdf->WriteHTML('<tr>');
            $pdf->WriteHTML('<td style="text-align:center; border: 1px solid #000;">'.$x.'</td>');
            $pdf->WriteHTML('<td style="padding: 0 2px 0 2px; border: 1px solid #000;">'.$nombre.'</td>');
            

            
            $x++;
            foreach ($asignaturas as $asignatura) 
            {   
                $pdf->WriteHTML('<td width="30px" style="border: 1px solid #000; word-wrap: break-word;">');
                $pdf->WriteHTML('<table cellspacing="0" cellpadding="0" style="padding:0px; margin:0px; border-collapse: collapse; border: 0px solid #f00; font-family: Helvetica; font-size:'.$size_font.'px;">');
                $pdf->WriteHTML('<tr>');

                for ($p=1; $p <= 4; $p++) 
                { 
                    
                   /* $calificacion = Calificacion::find()
                            ->where(['estudiante' => $estudiante->id])
                            ->andWhere(['grupo' => $grupo->id])
                            ->andWhere(['asignatura' => $asignatura->id])
                            ->andWhere(['periodo' => $p]);
                

                   //echo '<br>'.$calificacion->createCommand()->getRawSql();*/


                    $calificacion = Calificacion::find()
                            ->where(['estudiante' => $estudiante->id])
                            ->andWhere(['grupo' => $grupo->id])
                            ->andWhere(['asignatura' => $asignatura->id])
                            ->andWhere(['periodo' => $p])
                            ->one();

                    if($p == 3)
                    {
                        // echo " P3 ";
                        $pdf->WriteHTML('</tr><tr>');
                    }    

                    if(isset($calificacion))
                    {
                        
                        $color = "#fff;";

                        if($ver_colores == 1)
                        {
                            $desempeno = new Desempeno();
                            $color = $desempeno->color($calificacion->definitiva_final_periodo,$tipo_calificacion);
                        }    
                        
                        if($tipo_calificacion != 1)
                        {
                            if($calificacion->definitiva_final_periodo < 3 && $p <= $periodo_actual) 
                            {
                                $perdidas = $perdidas + 1;
                            }    
                            else
                            {
                                $ganadas = $ganadas + 1;
                            }   
                        }
                        else
                        {
                            if($calificacion->definitiva_final_periodo)
                            {

                                
                                $perdido = Desempeno::find()->where(['nota' => $calificacion->definitiva_final_periodo])->andWhere(['tipo_calificacion' => $tipo_calificacion])->one();
                                

                                if($perdido->perdido == 1)
                                {
                                    $perdidas = $perdidas + 1;
                                }    
                                else
                                {
                                    $ganadas = $ganadas + 1;
                                }
                            
                            }
                            else
                            {
                                echo "Sin Definitiva ".$calificacion->id;
                                 
                                $calificacion123 = Calificacion::find()
                                    ->where(['estudiante' => $estudiante->id])
                                    ->andWhere(['grupo' => $grupo->id])
                                    ->andWhere(['asignatura' => $asignatura->id])
                                    ->andWhere(['periodo' => $p]);
                

                                echo " - ".$calificacion123->createCommand()->getRawSql().$calificacion->definitiva_final_periodo."<BR>";

                            }

                        }
                        
                        if($ver_letrasonumeros == 1) // LETRAS
                        {
                            $desempeno = new Desempeno();
                            $desempenos = $desempeno->nota($calificacion->definitiva_final_periodo,$tipo_calificacion);

                            //echo "<br> Letras - Desempeño: ".$desempenos." - ".$color;
                            
                            switch ($p) 
                            {
                                case '1':
                                    $pdf->WriteHTML('<td width="15px" style="width:15px; text-align:center; border-right: 1px solid #000; background-color:'.$color.'">'.$desempenos.'</td>');
                                    break;

                                case '2':
                                    $pdf->WriteHTML('<td width="15px" style="width:15px; text-align:center; border: none; background-color:'.$color.'">'.$desempenos.'</td>');
                                    break;

                                case '3':
                                    $pdf->WriteHTML('<td width="15px" style="width:15px; text-align:center; border-top: 1px solid #000; background-color:'.$color.'">'.$desempenos.'</td>');
                                    break;

                                case '4':
                                    $pdf->WriteHTML('<td width="15px" style="width:15px; text-align:center; border-top: 1px solid #000; border-left: 1px solid #000; background-color:'.$color.'">'.$desempenos.'</td>');
                                    break;            
                                
                                default:
                                    $pdf->WriteHTML('<td width="15px" style="width:15px; text-align:center; border: none; background-color:'.$color.'">'.$desempenos.'</td>');
                                    break;
                            }
                        }
                        else // NUMEROS
                        { 
                            $desempenos = $calificacion->definitiva_final_periodo == 0 ? '': $calificacion->definitiva_final_periodo;
                            
                            // echo "<br> Números - Desempeño: ".$desempenos." - ".$color;

                            switch ($p) 
                            {
                                case '1':
                                    $pdf->WriteHTML('<td width="15px" style="text-align:center; border-right: 1px solid #000; background-color:'.$color.' word-wrap: break-word;">'.$desempenos.'</td>');
                                    break;

                                case '2':
                                    $pdf->WriteHTML('<td style="width:15px; text-align:center; border: none; background-color:'.$color.' word-wrap: break-word;">'.$desempenos.'</td>');
                                    break;

                                case '3':
                                    $pdf->WriteHTML('<td style="width:15px; text-align:center; border-top: 1px solid #000; background-color:'.$color.' word-wrap: break-word;">'.$desempenos.'</td>');
                                    break;

                                case '4':
                                    $pdf->WriteHTML('<td style="width:15px; text-align:center; border-top: 1px solid #000; border-left: 1px solid #000; background-color:'.$color.' word-wrap: break-word;">'.$desempenos.'</td>');
                                    break;            
                                
                                default:
                                    $pdf->WriteHTML('<td style="width:15px; text-align:center; border: none; background-color:'.$color.' word-wrap: break-word;">'.$desempenos.'</td>');
                                    break;
                            }
                        }    
                    }
                    else
                    {
                        if($tipo_calificacion == 1)
                        {

                            $desempeno = new Desempeno();
                            $color = $desempeno->hex2rgb($desempeno->color(0,$tipo_calificacion));
                            $desempenos = $desempeno->nota('NE',$tipo_calificacion);   
                            
                            $color = "#fff;";

                            if($ver_colores == 1)
                            {
                                $desempeno = new Desempeno();
                                $color = $desempeno->color(0,$tipo_calificacion);
                            }   
                            
                            switch ($p) 
                                {
                                    case '1':
                                        $pdf->WriteHTML('<td width="15px" style="padding:2px; text-align:center; border-right: 1px solid #000; word-wrap: break-word;">&nbsp;</td>');
                                        break;

                                    case '2':
                                        $pdf->WriteHTML('<td width="15px" style="padding:2px; text-align:center; border: none; word-wrap: break-word;">&nbsp;</td>');
                                        break;

                                    case '3':
                                        $pdf->WriteHTML('<td width="15px" style="padding:2px; text-align:center; border-top: 1px solid #000; word-wrap: break-word;">&nbsp;</td>');
                                        break;

                                    case '4':
                                        $pdf->WriteHTML('<td width="15px" style="padding:2px; text-align:center; border-top: 1px solid #000; border-left: 1px solid #000; word-wrap: break-word;">&nbsp;</td>');
                                        break;            
                                    
                                    default:
                                        $pdf->WriteHTML('<td width="15px" style="padding:2px; text-align:center; border: none; word-wrap: break-word;">&nbsp;</td>');
                                        break;
                                }                                

                            if ($p <= $periodo_actual)
                            {
                                //$perdidas = $perdidas + 1;    
                            }  
                        }

                        if($tipo_calificacion != 1)
                        {

                            $desempeno = new Desempeno();
                            $color = $desempeno->hex2rgb($desempeno->color(0,$tipo_calificacion));
                            $desempenos = $desempeno->nota(0,$tipo_calificacion);   
                            
                            $color = "#fff;";

                            if($ver_colores == 1)
                            {
                                $desempeno = new Desempeno();
                                $color = $desempeno->color(0,$tipo_calificacion);
                            }   
                            
                            switch ($p) 
                                {
                                    case '1':
                                        $pdf->WriteHTML('<td width="15px" style="padding:2px; text-align:center; border-right: 1px solid #000; word-wrap: break-word;">&nbsp;</td>');
                                        break;

                                    case '2':
                                        $pdf->WriteHTML('<td width="15px" style="padding:2px; text-align:center; border: none; word-wrap: break-word;">&nbsp;</td>');
                                        break;

                                    case '3':
                                        $pdf->WriteHTML('<td width="15px" style="padding:2px; text-align:center; border-top: 1px solid #000; word-wrap: break-word;">&nbsp;</td>');
                                        break;

                                    case '4':
                                        $pdf->WriteHTML('<td width="15px" style="padding:2px; text-align:center; border-top: 1px solid #000; border-left: 1px solid #000; word-wrap: break-word;">&nbsp;</td>');
                                        break;            
                                    
                                    default:
                                        $pdf->WriteHTML('<td width="15px" style="padding:2px; text-align:center; border: none; word-wrap: break-word;">&nbsp;</td>');
                                        break;
                                }

                            if ($p <= $periodo_actual)
                            {
                                $perdidas = $perdidas + 1;    
                            }  
                        }  
                    }    
                }
            
                $pdf->WriteHTML('</tr>');
                $pdf->WriteHTML('</table>');
                $pdf->WriteHTML('</td>');
            }
            

            $pdf->WriteHTML('<td width="10px" style="padding:2px; text-align:center; border: 1px solid #000; word-wrap: break-word;">'.$ganadas.'</td>');
            $pdf->WriteHTML('<td width="10px" style="padding:2px; text-align:center; border: 1px solid #000; word-wrap: break-word;">'.$perdidas.'</td>');
            $pdf->WriteHTML('</tr>');
            
                
        }

        $pdf->WriteHTML('</tbody>');
        $pdf->WriteHTML('</table>');

        $pdf->Ln(3);

        $niveles = Desempeno::find()->where(['tipo_calificacion' => $tipo_calificacion])->andWhere(['estado' => 1])->all();    
            
        foreach ($niveles as $nivel) 
        {
            $pdf->SetFont('Helvetica','',5);

            $desempeno = new Desempeno();
            $color = $desempeno->hex2rgb($nivel->color);
            $pdf->setFillColor($color['r'],$color['g'],$color['b']);

            $pdf->Cell(5,4,$nivel->nota,'LBT',0,'C',1);
            $pdf->setFillColor(255);
            $pdf->SetFont('Helvetica','',5);
            $pdf->Cell(12,4,$nivel->desempeno,'BTR',0,'C',0);    
            
            //echo "<br> Nivel de Desempeño: ".$nivel->desempeno;
        }

        $pdf->Cell(5);

        $pdf->SetFont('Helvetica','',4);
        $pdf->Cell(5,2,'P1','LBTR',0,'C',1);
        $pdf->Cell(5,2,'P2','LBTR',0,'C',1);
        $pdf->Ln();
        $pdf->Cell(90);
        $pdf->Cell(5,2,'P3','LBTR',0,'C',1);
        $pdf->Cell(5,2,'P4','LBTR',0,'C',1);

        $pdf->Output("R705-Sabana-Notas-Grupo-Acumulado(".date("d-m-Y_H-i").").pdf",'D');
    }  

}
