<?php

namespace backend\controllers;

use Yii;
use backend\models\Academico;
use backend\models\Carga;
use backend\models\Tercero;
use backend\models\Asistencia;
use backend\models\AsistenciaSearch;
use backend\models\Grupo;
use backend\models\Asignatura;
use backend\models\Periodo;
use backend\models\TipoInasistencia;
use backend\models\Calificacion;
use backend\models\Desempeno;
use backend\models\Competencia;
use backend\models\Sede;
use backend\models\Compromisosacudiente;
use backend\models\Calificacioncompromisos;
use backend\models\LanzadorForm;
use backend\models\Calificacioncalificaciones;

use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\helpers\ArrayHelper;
use yii\data\ActiveDataProvider;
use yii\base\Model;
use yii\helpers\Html;
use yii\web\Response;
use yii\widgets\ActiveForm;

use Mpdf\Mpdf;

class Reporte706Controller extends Controller
{

    public function actionIndex($grupo = NULL) // Reporte Valorativo Condensado (Boletín de Calificaciones) por Grupo
    {

        if($grupo == NULL)
        {    
            $model = new LanzadorForm(['scenario'=>'grupo']);

            $model->reporte = Yii::t('app', 'R706-Reporte');
            $model->observaciones = Yii::t('app', 'R706-Observaciones');
            
            if (Yii::$app->request->isAjax && $model->load(Yii::$app->request->post())) {
                Yii::$app->response->format = Response::FORMAT_JSON;
                return ActiveForm::validate($model);
            }

            if ($model->load(Yii::$app->request->post())) {

                $grado = $model->grado;
                $grupo = $model->grupo;
                $id_tercero = $model->tercero;
                $ver_fecha = $model->ver_fecha;
                $ver_letrasonumeros = $model->ver_letrasonumeros;
                
            }
            else
            {
                if (Yii::$app->request->isAjax) 
                {
                    return $this->renderAjax('/publica/lanzador', [
                            'model' => $model,
                            'sede' => true,
                            'tercero' => true,
                            'grado' => true,
                            'grupo' => true,
                            'asignatura' => false,
                            'periodo' => false,
                            'competencia' => false,
                            'columnas' => false,
                            'ver_estandar' => false,
                            'ver_competencia' => false,
                            'ver_niveles' => false,
                            'ver_desempenos' => false,
                            'ver_frd' => false,
                            'ver_fecha' => false,
                            'ver_letrasonumeros' => true,
                        ]);

                    exit;
                }
                else
                {
                    return $this->render('/publica/lanzador', [
                            'model' => $model,
                            'sede' => true,
                            'tercero' => false,
                            'grado' => true,
                            'grupo' => true,
                            'asignatura' => false,
                            'periodo' => false,
                            'competencia' => false,
                            'columnas' => false,
                            'ver_estandar' => false,
                            'ver_competencia' => false,
                            'ver_niveles' => false,
                            'ver_desempenos' => false,
                            'ver_frd' => false,
                            'ver_fecha' => false,
                            'ver_letrasonumeros' => true,
                        ]);

                    exit;
                }

            }    
        }
        else
        {
            $grado = Yii::$app->request->get('grado');
            $grupo = Yii::$app->request->get('grupo');            
            $id_tercero = Yii::$app->request->get('tercero');
        }

        date_default_timezone_set('America/Bogota');
        setlocale(LC_TIME,"es_ES");

        $grupo = Grupo::find()->where(['id' => $grupo])->one();

        if(isset($grupo->director))
        {
            $director_nombre = $grupo->directores->nombre;
            $director_firma = $grupo->directores->firma != NULL ? $grupo->directores->firma : '';
        }
        else
        {
            $director_nombre = Yii::t('app', 'R706-Director(a) de Grupo');
            //'Director(a) de Grupo'
            $director_firma = '';
        }
        
        $sede = Sede::FindOne($grupo->sede);

        $pdf = new Mpdf(['mode' => 'utf-8',
                         'format' => 'LETTER',
                         'default_font_size' => 0,
                         'default_font' => '',
                         'margin_left' => 15,
                         'margin_right' => 15,
                         'margin_top' => 35,
                         'margin_bottom' => 16,
                         'margin_header' => 9,
                         'margin_footer' => 9,
                         'orientation' => 'P']);  
        

        if ($sede->pdf_marcadeagua == 'T' OR $sede->pdf_marcadeagua == 'B')
        {
            $pdf->SetWatermarkText($sede->pdf_marcadeagua_contenido);
            $pdf->showWatermarkText = true;
            $pdf->watermarkTextAlpha = 0.1;
        }

        if ($sede->pdf_marcadeagua == 'I')
        {
            $pdf->SetWatermarkImage($sede->pdf_marcadeagua_contenido);
            $pdf->showWatermarkImage = true;
            $pdf->watermarkImageAlpha = 0.1;
        }

        $pdf->setHeader($sede->pdf_header);
        $pdf->setFooter($sede->pdf_footer);
        
        $pdf->AliasNbPages();

        $i = 1;    

        if($id_tercero != '')
        {
            
            if (($tercero = Tercero::find()->where(['id' => $id_tercero])->one()) === null)
            {
                throw new NotFoundHttpException('No existe el tercero');
            }  

            if (($estudiantes = Academico::find()
                            ->select(['tercero.id', 'academico.estudiante', 'academico.grupo','academico.especialidad'])
                            ->joinWith(['estudiantes'])->where(['<', 'tercero.estado', 3])
                            ->andWhere(['academico.estudiante' => $tercero->id])
                            ->orderBy('primer_apellido')
                            ->all()) === null)
            {
                throw new NotFoundHttpException('No estudiante no tiene registro académico.');
            }  
                
        }
        else
        {
            $estudiantes = Academico::find()->select(['tercero.id', 'academico.estudiante', 'academico.grupo','academico.especialidad'])->joinWith(['estudiantes'])->where(['<', 'tercero.estado', 3])->andWhere(['academico.grupo' => $grupo->id])->orderBy('primer_apellido')->all();  
        }           
        
        
        foreach ($estudiantes as $estudiante) 
        {

            $pdf->AddPage(0,'Letter');

            $pdf->Ln(5);

            $pdf->SetFont('Helvetica','',8);   
            $pdf->MultiCell(185, 5, Yii::t('app', 'El suscrito Rector(a) del {institucion} NIT {nit}', [
                'institucion' => $sede->sede,
                'nit' => $sede->nit
            ]), 0,'C',0);

            $pdf->Ln(5);
            $pdf->SetFont('Helvetica','B',12);   
            $pdf->Cell(190,10,Yii::t('app', 'R706-CERTIFICA'),0,0,'C');

            $pdf->Ln(15);

            $pdf->SetFont('Helvetica','',8);
            $pdf->MultiCell(185, 5, Yii::t('app', 'Que el estudiante(a) {estudiante} identificado(a) con {tipo_identificacion} Nº {identificacion} de {municipio} ({departamento}), cursó en la Sede {sede} jornada {jornada} el grado {grado} en el grupo {grupo} de Educación {modalidad} en la Especialidad {especialidad} durante el año electivo {vigencia} y obtuvo las siguientes calificaciones conceptuales que a continuación presentamos.', [
                'estudiante' => $estudiante->estudiantes->nombreinverso,
                'tipo_identificacion' => $estudiante->estudiantes->tipos->tipo,
                'identificacion' => $estudiante->estudiantes->identificacion,
                'municipio' => $estudiante->estudiantes->municipioexpedido->nombre,
                'departamento' => $estudiante->estudiantes->departamentoexpedido->nombre,
                'sede' => $grupo->sedes->sede,
                'jornada' => $grupo->jornadas->jornada,
                'grado' => $grupo->grados->grado,
                'grupo' => $grupo->grupo,
                'modalidad' => $grupo->modalidades->modalidad,
                'especialidad' => $estudiante->especialidades->especialidad,
                'vigencia' => $grupo->sedes->vigencia
            ]), 0,'L',0);


            $pdf->Bookmark(mb_strtoupper($estudiante->estudiantes->nombreinverso), 0);
            
            $pdf->Ln(5);
            

            $tipo_calificacion = $grupo->grados->tipo_calificacion;
            $calificacionxcompetencia = $grupo->grados->calificacionxcompetencia;

            $pdf->setFillColor(230);
            $pdf->SetFont('Helvetica','',8);  

            $pdf->Cell(5,5,Yii::t('app', '#'),1,0,'C',1);
            $pdf->Cell(60,5,Yii::t('app', 'Asignatura'),1,0,'C',1);


            $pdf->Cell(10,5,Yii::t('app', 'IH'),'LBTR',0,'C',1);

            for($p=1;$p<=4;$p++)
            {
                $pdf->Cell(25,5,Yii::t('app', 'Periodo').' '.$p,1,0,'C',1);
            
            }

            $pdf->Ln(5);
  
  

            if($estudiante->especialidad == '1')
            {
                $asignaturas = Asignatura::find()
                                ->where(['grado' => $grupo->grados->id])
                                ->andWhere(['especialidad' => '1'])
                                ->all();
            }
            else
            {
                $asignaturas = Asignatura::find()
                                ->where(['grado' => $grupo->grados->id])
                                ->andWhere(['especialidad' => '1'])
                                ->orWhere(['especialidad' => $estudiante->especialidad])
                                ->all();
            }    

            $i = 1;
            
            foreach ($asignaturas as $asignatura) 
            {


                $pdf->setFillColor(255);
                $pdf->Cell(5,5,$i,1,0,'C',1);
                
                $i++;

                $pdf->SetFont('Helvetica','B',8);
                $pdf->Cell(60,5,mb_strtoupper($asignatura->asignatura),1,0,'J',1); 
                $pdf->SetFont('Helvetica','',8);
                
                $pdf->Cell(10,5,mb_strtoupper($asignatura->intensidad),1,0,'C',1); 

                $pdf->setFillColor(255); 
                            
                for($p=1;$p<=4;$p++)
                {   
                    
                    $calificacion = Calificacion::find()
                                ->where(['estudiante' => $estudiante->id])
                                ->andWhere(['grupo' => $grupo->id])
                                ->andWhere(['asignatura' => $asignatura->id])
                                ->andWhere(['periodo' => $p])
                                ->one();

                    //$pdf->Cell(10,5,mb_strtoupper(Yii::t('app', 'Def')),'LBTR',0,'C',1);

                    if(isset($calificacion))
                    {


                        $desempeno = new Desempeno();
                        
                        $color = $desempeno->hex2rgb($desempeno->color($calificacion->definitiva_final_periodo,$tipo_calificacion));
                        $pdf->setFillColor($color['r'],$color['g'],$color['b']);

                        if($ver_letrasonumeros == 1)
                        {
                            $desempenos = $desempeno->nota($calificacion->definitiva_final_periodo,$tipo_calificacion);
                            $pdf->Cell(10,5,$desempenos,'LBTR',0,'C',1);

                            $desempenos = $desempeno->desempeno($calificacion->definitiva_final_periodo,$tipo_calificacion);
                            $pdf->Cell(15,5,$desempenos,'LBTR',0,'C',0);
                        }
                        else
                        {
                            $pdf->Cell(10,5,$calificacion->definitiva_final_periodo == 0 ? '': $calificacion->definitiva_final_periodo,'LBTR',0,'C',1); 
                            $desempenos = $desempeno->desempeno($calificacion->definitiva_final_periodo,$tipo_calificacion);
                            
                            $pdf->Cell(15,5,$desempenos,'LBTR',0,'C',0);
                        }    
                        
                        $pdf->setFillColor(255); 
                    }
                    else
                    {
                        $desempeno = new Desempeno();
                        $color = $desempeno->hex2rgb($desempeno->color(0,$tipo_calificacion));
                        $desempenos = $desempeno->nota(0,$tipo_calificacion);   
                        
                        $pdf->setFillColor($color['r'],$color['g'],$color['b']);
                        $pdf->Cell(10,5,'','LBTR',0,'C',1);
                        $pdf->Cell(15,5,'','LBTR',0,'C',0);
                        $pdf->setFillColor(255);
                    }    

                    
                    

                } // FIN FOR 
                $pdf->Ln(5);
                
            }

            $pdf->Ln(8);

            $pdf->SetFont('Helvetica','',8);

            $pdf->MultiCell(185, 5, Yii::t('app', 'Se expide a solicitud del interesado en la ciudad de Villavicencio el día {fecha}', [
                'fecha' => Yii::$app->formatter->asDate('now', 'long'),
            ]), 0, 'J',0);
            
            $pdf->SetFont('Helvetica','B',8);

            $y = $pdf->y;
            $x = $pdf->x;

            if($director_firma != '' or $director_firma != NULL )
            {
                $pdf->Image(\Yii::getAlias('@webroot/uploads/'.$director_firma),$x+30,$y,50);    
            }    
            
            
            $pdf->Image(\Yii::getAlias('@webroot/uploads/'.$grupo->sedes->rector_firma),$x+110,$y,50);
            
            $pdf->setY($pdf->y-15);
            $pdf->Cell(30);
            $pdf->Cell(60,5,$director_nombre,'T',0,'C',0);

            $pdf->Cell(15);
            $pdf->Cell(60,5,$sede->rector_nombre,'T',0,'C',0);

            $pdf->Ln(3);
            $pdf->SetFont('Helvetica','',8);
            $pdf->Cell(25);
            $pdf->Cell(60,5,Yii::t('app', 'Director(a)'),'',0,'C',0);
            $pdf->Cell(15);
            $pdf->Cell(60,5,Yii::t('app', 'Rector(a)'),'',0,'C',0);
            $pdf->Ln(1); 


        }

        $pdf->Output("R706-Certificado-Notas(".date("d-m-Y_H-i").").pdf",'D');
    }

  

}
